/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.builtin;

import org.apache.iotdb.db.query.udf.builtin.UDTFAbs;
import org.apache.iotdb.db.query.udf.builtin.UDTFAcos;
import org.apache.iotdb.db.query.udf.builtin.UDTFAsin;
import org.apache.iotdb.db.query.udf.builtin.UDTFAtan;
import org.apache.iotdb.db.query.udf.builtin.UDTFBottomK;
import org.apache.iotdb.db.query.udf.builtin.UDTFCeil;
import org.apache.iotdb.db.query.udf.builtin.UDTFCommonDerivative;
import org.apache.iotdb.db.query.udf.builtin.UDTFCommonValueDifference;
import org.apache.iotdb.db.query.udf.builtin.UDTFContains;
import org.apache.iotdb.db.query.udf.builtin.UDTFCos;
import org.apache.iotdb.db.query.udf.builtin.UDTFDegrees;
import org.apache.iotdb.db.query.udf.builtin.UDTFExp;
import org.apache.iotdb.db.query.udf.builtin.UDTFFloor;
import org.apache.iotdb.db.query.udf.builtin.UDTFLog;
import org.apache.iotdb.db.query.udf.builtin.UDTFLog10;
import org.apache.iotdb.db.query.udf.builtin.UDTFMatches;
import org.apache.iotdb.db.query.udf.builtin.UDTFNonNegativeDerivative;
import org.apache.iotdb.db.query.udf.builtin.UDTFNonNegativeValueDifference;
import org.apache.iotdb.db.query.udf.builtin.UDTFRadians;
import org.apache.iotdb.db.query.udf.builtin.UDTFRound;
import org.apache.iotdb.db.query.udf.builtin.UDTFSign;
import org.apache.iotdb.db.query.udf.builtin.UDTFSin;
import org.apache.iotdb.db.query.udf.builtin.UDTFSqrt;
import org.apache.iotdb.db.query.udf.builtin.UDTFTan;
import org.apache.iotdb.db.query.udf.builtin.UDTFTimeDifference;
import org.apache.iotdb.db.query.udf.builtin.UDTFTopK;

public enum BuiltinFunction {
    SIN("SIN", UDTFSin.class),
    COS("COS", UDTFCos.class),
    TAN("TAN", UDTFTan.class),
    ASIN("ASIN", UDTFAsin.class),
    ACOS("ACOS", UDTFAcos.class),
    ATAN("ATAN", UDTFAtan.class),
    DEGREES("DEGREES", UDTFDegrees.class),
    RADIANS("RADIANS", UDTFRadians.class),
    ABS("ABS", UDTFAbs.class),
    SIGN("SIGN", UDTFSign.class),
    CEIL("CEIL", UDTFCeil.class),
    FLOOR("FLOOR", UDTFFloor.class),
    ROUND("ROUND", UDTFRound.class),
    EXP("EXP", UDTFExp.class),
    LN("LN", UDTFLog.class),
    LOG10("LOG10", UDTFLog10.class),
    SQRT("SQRT", UDTFSqrt.class),
    STRING_CONTAINS("STRING_CONTAINS", UDTFContains.class),
    STRING_MATCHES("STRING_MATCHES", UDTFMatches.class),
    DIFFERENCE("DIFFERENCE", UDTFCommonValueDifference.class),
    NON_NEGATIVE_DIFFERENCE("NON_NEGATIVE_DIFFERENCE", UDTFNonNegativeValueDifference.class),
    TIME_DIFFERENCE("TIME_DIFFERENCE", UDTFTimeDifference.class),
    DERIVATIVE("DERIVATIVE", UDTFCommonDerivative.class),
    NON_NEGATIVE_DERIVATIVE("NON_NEGATIVE_DERIVATIVE", UDTFNonNegativeDerivative.class),
    TOP_K("TOP_K", UDTFTopK.class),
    BOTTOM_K("BOTTOM_K", UDTFBottomK.class);

    private final String functionName;
    private final Class<?> functionClass;
    private final String className;

    private BuiltinFunction(String functionName, Class<?> functionClass) {
        this.functionName = functionName;
        this.functionClass = functionClass;
        this.className = functionClass.getName();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Class<?> getFunctionClass() {
        return this.functionClass;
    }

    public String getClassName() {
        return this.className;
    }
}

