/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import org.apache.iotdb.db.query.aggregation.impl.FirstValueAggrResult;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class FirstValueDescAggrResult
extends FirstValueAggrResult {
    public FirstValueDescAggrResult(TSDataType dataType) {
        super(dataType);
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        Object firstVal = statistics.getFirstValue();
        this.setValue(firstVal);
        this.timestamp = statistics.getStartTime();
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage, long minBound, long maxBound) {
        while (dataInThisPage.hasCurrent() && dataInThisPage.currentTime() < maxBound && dataInThisPage.currentTime() >= minBound) {
            this.setValue(dataInThisPage.currentValue());
            this.timestamp = dataInThisPage.currentTime();
            dataInThisPage.next();
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        Object[] values = dataReader.getValuesInTimestamps(timestamps, length);
        for (int i = length - 1; i >= 0; --i) {
            if (values[i] == null) continue;
            this.setValue(values[i]);
            this.timestamp = timestamps[i];
            return;
        }
    }

    @Override
    public void updateResultUsingValues(long[] timestamps, int length, Object[] values) {
        for (int i = length - 1; i >= 0; --i) {
            if (values[i] == null) continue;
            this.setValue(values[i]);
            this.timestamp = timestamps[i];
            return;
        }
    }

    @Override
    public boolean isAscending() {
        return false;
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }
}

