/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushPlan
extends PhysicalPlan {
    private static final Logger logger = LoggerFactory.getLogger(FlushPlan.class);
    private Map<PartialPath, List<Pair<Long, Boolean>>> storageGroupPartitionIds;
    private Boolean isSeq;
    private boolean isSync;

    public FlushPlan() {
        super(false, Operator.OperatorType.FLUSH);
    }

    public FlushPlan(Boolean isSeq, List<PartialPath> storageGroups) {
        super(false, Operator.OperatorType.FLUSH);
        if (storageGroups == null) {
            this.storageGroupPartitionIds = null;
        } else {
            this.storageGroupPartitionIds = new HashMap<PartialPath, List<Pair<Long, Boolean>>>();
            for (PartialPath path : storageGroups) {
                this.storageGroupPartitionIds.put(path, null);
            }
        }
        this.isSeq = isSeq;
        this.isSync = false;
    }

    public FlushPlan(Boolean isSeq, boolean isSync, Map<PartialPath, List<Pair<Long, Boolean>>> storageGroupPartitionIds) {
        super(false, Operator.OperatorType.FLUSH);
        this.storageGroupPartitionIds = storageGroupPartitionIds;
        this.isSeq = isSeq;
        this.isSync = isSync;
    }

    public Boolean isSeq() {
        return this.isSeq;
    }

    public boolean isSync() {
        return this.isSync;
    }

    @Override
    public List<PartialPath> getPaths() {
        if (this.storageGroupPartitionIds == null) {
            return Collections.emptyList();
        }
        ArrayList<PartialPath> ret = new ArrayList<PartialPath>();
        for (Map.Entry<PartialPath, List<Pair<Long, Boolean>>> entry : this.storageGroupPartitionIds.entrySet()) {
            ret.add(entry.getKey());
        }
        return ret;
    }

    public Map<PartialPath, List<Pair<Long, Boolean>>> getStorageGroupPartitionIds() {
        return this.storageGroupPartitionIds;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.FLUSH.ordinal());
        if (this.isSeq == null) {
            stream.writeByte(2);
        } else {
            stream.writeByte(Boolean.TRUE.equals(this.isSeq) ? 1 : 0);
        }
        stream.writeByte(this.isSync ? 1 : 0);
        this.writeStorageGroupPartitionIds(stream);
    }

    public void writeStorageGroupPartitionIds(DataOutputStream stream) throws IOException {
        if (this.storageGroupPartitionIds == null) {
            stream.write(0);
        } else {
            stream.write(1);
            stream.writeInt(this.storageGroupPartitionIds.size());
            for (Map.Entry<PartialPath, List<Pair<Long, Boolean>>> entry : this.storageGroupPartitionIds.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey().getFullPath(), (OutputStream)stream);
                if (entry.getValue() == null) {
                    stream.write(0);
                    continue;
                }
                stream.write(1);
                ReadWriteIOUtils.write((int)entry.getValue().size(), (OutputStream)stream);
                for (Pair<Long, Boolean> pair : entry.getValue()) {
                    ReadWriteIOUtils.write((long)((Long)pair.left), (OutputStream)stream);
                    ReadWriteIOUtils.write((Boolean)((Boolean)pair.right), (OutputStream)stream);
                }
            }
        }
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.FLUSH.ordinal();
        buffer.put((byte)type);
        if (this.isSeq == null) {
            buffer.put((byte)2);
        } else {
            buffer.put((byte)(Boolean.TRUE.equals(this.isSeq) ? 1 : 0));
        }
        buffer.put((byte)(this.isSync ? 1 : 0));
        this.writeStorageGroupPartitionIds(buffer);
    }

    public void writeStorageGroupPartitionIds(ByteBuffer buffer) {
        if (this.storageGroupPartitionIds == null) {
            buffer.put((byte)0);
        } else {
            buffer.put((byte)1);
            buffer.putInt(this.storageGroupPartitionIds.size());
            for (Map.Entry<PartialPath, List<Pair<Long, Boolean>>> entry : this.storageGroupPartitionIds.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey().getFullPath(), (ByteBuffer)buffer);
                if (entry.getValue() == null) {
                    buffer.put((byte)0);
                    continue;
                }
                buffer.put((byte)1);
                ReadWriteIOUtils.write((int)entry.getValue().size(), (ByteBuffer)buffer);
                for (Pair<Long, Boolean> pair : entry.getValue()) {
                    ReadWriteIOUtils.write((long)((Long)pair.left), (ByteBuffer)buffer);
                    ReadWriteIOUtils.write((Boolean)((Boolean)pair.right), (ByteBuffer)buffer);
                }
            }
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        byte isSeqFlag = buffer.get();
        this.isSeq = isSeqFlag == 2 ? null : Boolean.valueOf(isSeqFlag == 1);
        this.isSync = buffer.get() == 1;
        this.readStorageGroupPartitionIds(buffer);
    }

    private void readStorageGroupPartitionIds(ByteBuffer buffer) {
        byte flag = buffer.get();
        if (flag == 0) {
            this.storageGroupPartitionIds = null;
        } else {
            int storageGroupsMapSize = buffer.getInt();
            this.storageGroupPartitionIds = new HashMap<PartialPath, List<Pair<Long, Boolean>>>(storageGroupsMapSize);
            for (int i = 0; i < storageGroupsMapSize; ++i) {
                PartialPath tmpPath = null;
                try {
                    tmpPath = new PartialPath(ReadWriteIOUtils.readString((ByteBuffer)buffer));
                }
                catch (IllegalPathException e) {
                    logger.error("Illegal path found during FlushPlan serialization:", (Throwable)e);
                }
                flag = buffer.get();
                if (flag == 0) {
                    this.storageGroupPartitionIds.put(tmpPath, null);
                    continue;
                }
                int partitionIdSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
                ArrayList<Pair> partitionIdList = new ArrayList<Pair>(partitionIdSize);
                for (int j = 0; j < partitionIdSize; ++j) {
                    long partitionId = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
                    Boolean partitionIsSeq = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
                    Pair tmpPair = new Pair((Object)partitionId, (Object)partitionIsSeq);
                    partitionIdList.add(tmpPair);
                }
                this.storageGroupPartitionIds.put(tmpPath, partitionIdList);
            }
        }
    }

    public String toString() {
        return "FlushPlan{ storageGroupPartitionIds=" + this.storageGroupPartitionIds + ", isSeq=" + this.isSeq + ", isSync=" + this.isSync + "}";
    }
}

