/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class ChangeTagOffsetPlan
extends PhysicalPlan {
    private PartialPath path;
    private long offset;

    public ChangeTagOffsetPlan() {
        super(false, Operator.OperatorType.CHANGE_TAG_OFFSET);
    }

    public ChangeTagOffsetPlan(PartialPath partialPath, long offset) {
        super(false, Operator.OperatorType.CHANGE_TAG_OFFSET);
        this.path = partialPath;
        this.offset = offset;
    }

    public PartialPath getPath() {
        return this.path;
    }

    public void setPath(PartialPath path) {
        this.path = path;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> ret = new ArrayList<PartialPath>();
        if (this.path != null) {
            ret.add(this.path);
        }
        return ret;
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.CHANGE_TAG_OFFSET.ordinal();
        buffer.put((byte)type);
        this.putString(buffer, this.path.getFullPath());
        buffer.putLong(this.offset);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.write((byte)PhysicalPlan.PhysicalPlanType.CHANGE_TAG_OFFSET.ordinal());
        this.putString(stream, this.path.getFullPath());
        stream.writeLong(this.offset);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.path = new PartialPath(this.readString(buffer));
        this.offset = buffer.getLong();
    }

    public String toString() {
        return "ChangeTagOffset{" + this.path + "," + this.offset + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeTagOffsetPlan that = (ChangeTagOffsetPlan)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.offset);
    }
}

