/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.metadata.PartialPath;

public class GroupByLevelController {
    private final int seriesLimit;
    private int seriesOffset;
    Set<String> limitPaths;
    Set<String> offsetPaths;
    private final int[] levels;
    int prevSize = 0;
    private Map<String, String> groupedPathMap;

    public GroupByLevelController(int seriesLimit, int seriesOffset, int[] levels) {
        this.seriesLimit = seriesLimit;
        this.seriesOffset = seriesOffset;
        this.limitPaths = seriesLimit > 0 ? new HashSet() : null;
        this.offsetPaths = seriesOffset > 0 ? new HashSet() : null;
        this.groupedPathMap = new LinkedHashMap<String, String>();
        this.levels = levels;
    }

    public String getGroupedPath(String rawPath) {
        return this.groupedPathMap.get(rawPath);
    }

    public void control(List<PartialPath> resultColumns, boolean isCountStar, String functionName) {
        Iterator<PartialPath> iterator = resultColumns.iterator();
        for (int i = 0; i < this.prevSize; ++i) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            PartialPath resultColumn = iterator.next();
            String groupedPath = GroupByLevelController.generatePartialPathByLevel(resultColumn, this.levels, isCountStar);
            String rawPath = String.format("%s(%s)", functionName, resultColumn.getFullPath());
            String pathWithFunction = String.format("%s(%s)", functionName, groupedPath);
            if (this.seriesLimit == 0 && this.seriesOffset == 0) {
                this.groupedPathMap.put(rawPath, pathWithFunction);
                continue;
            }
            if (this.seriesOffset > 0 && this.offsetPaths != null) {
                this.offsetPaths.add(pathWithFunction);
                if (this.offsetPaths.size() > this.seriesOffset) continue;
                iterator.remove();
                if (this.offsetPaths.size() != this.seriesOffset) continue;
                this.seriesOffset = 0;
                continue;
            }
            if (this.offsetPaths == null || !this.offsetPaths.contains(pathWithFunction)) {
                this.limitPaths.add(pathWithFunction);
                if (this.seriesLimit > 0 && this.limitPaths.size() > this.seriesLimit) {
                    iterator.remove();
                    this.limitPaths.remove(pathWithFunction);
                    continue;
                }
                this.groupedPathMap.put(rawPath, pathWithFunction);
                continue;
            }
            iterator.remove();
        }
        this.prevSize = resultColumns.size();
    }

    public static String generatePartialPathByLevel(PartialPath originalPath, int[] pathLevels, boolean isCountStar) {
        String[] nodes = originalPath.getNodes();
        HashSet<Integer> levelSet = new HashSet<Integer>();
        for (int level : pathLevels) {
            levelSet.add(level);
        }
        StringBuilder transformedPath = new StringBuilder();
        transformedPath.append(nodes[0]).append(".");
        for (int k = 1; k < nodes.length - 1; ++k) {
            if (levelSet.contains(k)) {
                transformedPath.append(nodes[k]);
            } else {
                transformedPath.append("*");
            }
            transformedPath.append(".");
        }
        if (isCountStar) {
            transformedPath.append("*");
        } else {
            transformedPath.append(nodes[nodes.length - 1]);
        }
        return transformedPath.toString();
    }
}

