/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.compaction.CompactionMergeTaskPoolManager;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.engine.compaction.StorageGroupCompactionTask;
import org.apache.iotdb.db.engine.compaction.TsFileManagement;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.flush.CloseFileListener;
import org.apache.iotdb.db.engine.flush.FlushListener;
import org.apache.iotdb.db.engine.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.engine.merge.manage.MergeManager;
import org.apache.iotdb.db.engine.merge.task.CompactionMergeRecoverTask;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessorInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.upgrade.UpgradeCheckStatus;
import org.apache.iotdb.db.engine.upgrade.UpgradeLog;
import org.apache.iotdb.db.engine.version.SimpleFileVersionController;
import org.apache.iotdb.db.engine.version.VersionController;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.LoadFileException;
import org.apache.iotdb.db.exception.StorageGroupProcessorException;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.OutOfTTLException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsOfOneDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryFileManager;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.CopyOnReadLinkedList;
import org.apache.iotdb.db.utils.FileUtils;
import org.apache.iotdb.db.utils.MmapUtil;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.apache.iotdb.db.writelog.recover.TsFileRecoverPerformer;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageGroupProcessor {
    public static final String MERGING_MODIFICATION_FILE_NAME = "merge.mods";
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final int MERGE_MOD_START_VERSION_NUM = 1;
    private static final Logger logger = LoggerFactory.getLogger(StorageGroupProcessor.class);
    private static final int POS_ALREADY_EXIST = -2;
    private static final int POS_OVERLAP = -3;
    private final boolean enableMemControl = config.isEnableMemControl();
    private final ReadWriteLock insertLock = new ReentrantReadWriteLock();
    private final Object closeStorageGroupCondition = new Object();
    private final ReadWriteLock closeQueryLock = new ReentrantReadWriteLock();
    private final TreeMap<Long, TsFileProcessor> workSequenceTsFileProcessors = new TreeMap();
    private final TreeMap<Long, TsFileProcessor> workUnsequenceTsFileProcessors = new TreeMap();
    private List<TsFileResource> upgradeSeqFileList = new LinkedList<TsFileResource>();
    private CopyOnReadLinkedList<TsFileProcessor> closingSequenceTsFileProcessor = new CopyOnReadLinkedList();
    private List<TsFileResource> upgradeUnseqFileList = new LinkedList<TsFileResource>();
    private CopyOnReadLinkedList<TsFileProcessor> closingUnSequenceTsFileProcessor = new CopyOnReadLinkedList();
    private AtomicInteger upgradeFileCount = new AtomicInteger();
    private Map<Long, Map<String, Long>> latestTimeForEachDevice = new HashMap<Long, Map<String, Long>>();
    private Map<Long, Map<String, Long>> partitionLatestFlushedTimeForEachDevice = new HashMap<Long, Map<String, Long>>();
    private Map<Long, Map<String, Long>> newlyFlushedPartitionLatestFlushedTimeForEachDevice = new HashMap<Long, Map<String, Long>>();
    private Map<String, Long> globalLatestFlushedTimeForEachDevice = new HashMap<String, Long>();
    private String virtualStorageGroupId;
    private String logicalStorageGroupName;
    private File storageGroupSysDir;
    private TsFileManagement tsFileManagement;
    private HashMap<Long, VersionController> timePartitionIdVersionControllerMap = new HashMap();
    private long dataTTL = Long.MAX_VALUE;
    private FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    private TsFileFlushPolicy fileFlushPolicy;
    private Map<Long, Long> partitionMaxFileVersions = new HashMap<Long, Long>();
    private StorageGroupInfo storageGroupInfo = new StorageGroupInfo(this);
    private int deviceNumInLastClosedTsFile = 64;
    private boolean isReady = false;
    private List<CloseFileListener> customCloseFileListeners = Collections.emptyList();
    private List<FlushListener> customFlushListeners = Collections.emptyList();
    private static final int WAL_BUFFER_SIZE = IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2;
    private final Deque<ByteBuffer> walByteBufferPool = new LinkedList<ByteBuffer>();
    private int currentWalPoolSize = 0;
    private long timeWhenPoolNotEmpty = Long.MAX_VALUE;
    private String insertWriteLockHolder = "";
    private volatile boolean compacting = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer[] getWalDirectByteBuffer() {
        ByteBuffer[] res = new ByteBuffer[2];
        Deque<ByteBuffer> deque = this.walByteBufferPool;
        synchronized (deque) {
            long startTime = System.nanoTime();
            int MAX_WAL_BYTEBUFFER_NUM = config.getConcurrentWritingTimePartition() * config.getMaxWalBytebufferNumForEachPartition();
            while (this.walByteBufferPool.isEmpty() && this.currentWalPoolSize + 2 > MAX_WAL_BYTEBUFFER_NUM) {
                try {
                    this.walByteBufferPool.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error("getDirectByteBuffer occurs error while waiting for DirectByteBuffergroup {}-{}", new Object[]{this.logicalStorageGroupName, this.virtualStorageGroupId, e});
                }
                logger.info("Waiting {} ms for wal direct byte buffer.", (Object)((System.nanoTime() - startTime) / 1000000L));
            }
            if (!this.walByteBufferPool.isEmpty()) {
                res[0] = this.walByteBufferPool.pollFirst();
                res[1] = this.walByteBufferPool.pollFirst();
            } else {
                this.currentWalPoolSize += 2;
                res[0] = ByteBuffer.allocateDirect(WAL_BUFFER_SIZE);
                res[1] = ByteBuffer.allocateDirect(WAL_BUFFER_SIZE);
            }
            if (this.walByteBufferPool.isEmpty()) {
                this.timeWhenPoolNotEmpty = Long.MAX_VALUE;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWalBuffer(ByteBuffer[] byteBuffers) {
        for (ByteBuffer byteBuffer : byteBuffers) {
            byteBuffer.clear();
        }
        Deque<ByteBuffer> deque = this.walByteBufferPool;
        synchronized (deque) {
            if (this.walByteBufferPool.isEmpty()) {
                this.timeWhenPoolNotEmpty = System.nanoTime();
            }
            this.walByteBufferPool.addLast(byteBuffers[0]);
            this.walByteBufferPool.addLast(byteBuffers[1]);
            this.walByteBufferPool.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimTask() {
        Deque<ByteBuffer> deque = this.walByteBufferPool;
        synchronized (deque) {
            int expectedSize = (this.workSequenceTsFileProcessors.size() + this.workUnsequenceTsFileProcessors.size()) * 2;
            long poolNotEmptyIntervalInMS = (System.nanoTime() - this.timeWhenPoolNotEmpty) / 1000000L;
            while (expectedSize < this.currentWalPoolSize && !this.walByteBufferPool.isEmpty() && poolNotEmptyIntervalInMS >= config.getWalPoolTrimIntervalInMS()) {
                MmapUtil.clean((MappedByteBuffer)this.walByteBufferPool.removeLast());
                MmapUtil.clean((MappedByteBuffer)this.walByteBufferPool.removeLast());
                this.currentWalPoolSize -= 2;
            }
        }
    }

    public StorageGroupProcessor(String systemDir, String virtualStorageGroupId, TsFileFlushPolicy fileFlushPolicy, String logicalStorageGroupName) throws StorageGroupProcessorException {
        this.virtualStorageGroupId = virtualStorageGroupId;
        this.logicalStorageGroupName = logicalStorageGroupName;
        this.fileFlushPolicy = fileFlushPolicy;
        this.storageGroupSysDir = SystemFileFactory.INSTANCE.getFile(systemDir, virtualStorageGroupId);
        if (this.storageGroupSysDir.mkdirs()) {
            logger.info("Storage Group system Directory {} doesn't exist, create it", (Object)this.storageGroupSysDir.getPath());
        } else if (!this.storageGroupSysDir.exists()) {
            logger.error("create Storage Group system Directory {} failed", (Object)this.storageGroupSysDir.getPath());
        }
        this.tsFileManagement = IoTDBDescriptor.getInstance().getConfig().getCompactionStrategy().getTsFileManagement(logicalStorageGroupName, virtualStorageGroupId, this.storageGroupSysDir.getAbsolutePath());
        ScheduledExecutorService executorService = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor(String.format("WAL-trimTask-%s/%s", logicalStorageGroupName, virtualStorageGroupId));
        executorService.scheduleWithFixedDelay(this::trimTask, config.getWalPoolTrimIntervalInMS(), config.getWalPoolTrimIntervalInMS(), TimeUnit.MILLISECONDS);
        this.recover();
    }

    public String getLogicalStorageGroupName() {
        return this.logicalStorageGroupName;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void setReady(boolean ready) {
        this.isReady = ready;
    }

    private Map<Long, List<TsFileResource>> splitResourcesByPartition(List<TsFileResource> resources) {
        HashMap<Long, List<TsFileResource>> ret = new HashMap<Long, List<TsFileResource>>();
        for (TsFileResource resource : resources) {
            ret.computeIfAbsent(resource.getTimePartition(), l -> new ArrayList()).add(resource);
        }
        return ret;
    }

    private void recover() throws StorageGroupProcessorException {
        logger.info("recover Storage Group  {}", (Object)(this.logicalStorageGroupName + "-" + this.virtualStorageGroupId));
        try {
            long partitionNum;
            this.tsFileManagement.new TsFileManagement.CompactionRecoverTask().call();
            Pair<List<TsFileResource>, List<TsFileResource>> seqTsFilesPair = this.getAllFiles(DirectoryManager.getInstance().getAllSequenceFileFolders());
            List tmpSeqTsFiles = (List)seqTsFilesPair.left;
            List oldSeqTsFiles = (List)seqTsFilesPair.right;
            this.upgradeSeqFileList.addAll(oldSeqTsFiles);
            Pair<List<TsFileResource>, List<TsFileResource>> unseqTsFilesPair = this.getAllFiles(DirectoryManager.getInstance().getAllUnSequenceFileFolders());
            List tmpUnseqTsFiles = (List)unseqTsFilesPair.left;
            List oldUnseqTsFiles = (List)unseqTsFilesPair.right;
            this.upgradeUnseqFileList.addAll(oldUnseqTsFiles);
            if (this.upgradeSeqFileList.size() + this.upgradeUnseqFileList.size() != 0) {
                this.upgradeFileCount.set(this.upgradeSeqFileList.size() + this.upgradeUnseqFileList.size());
            }
            Map<Long, List<TsFileResource>> partitionTmpSeqTsFiles = this.splitResourcesByPartition(tmpSeqTsFiles);
            Map<Long, List<TsFileResource>> partitionTmpUnseqTsFiles = this.splitResourcesByPartition(tmpUnseqTsFiles);
            for (List<TsFileResource> list : partitionTmpSeqTsFiles.values()) {
                this.recoverTsFiles(list, true);
            }
            for (List<TsFileResource> list : partitionTmpUnseqTsFiles.values()) {
                this.recoverTsFiles(list, false);
            }
            for (TsFileResource tsFileResource : this.tsFileManagement.getTsFileList(true)) {
                partitionNum = tsFileResource.getTimePartition();
                this.updatePartitionFileVersion(partitionNum, tsFileResource.getVersion());
            }
            for (TsFileResource tsFileResource : this.tsFileManagement.getTsFileList(false)) {
                partitionNum = tsFileResource.getTimePartition();
                this.updatePartitionFileVersion(partitionNum, tsFileResource.getVersion());
            }
            for (TsFileResource tsFileResource : this.upgradeSeqFileList) {
                partitionNum = tsFileResource.getTimePartition();
                this.updatePartitionFileVersion(partitionNum, tsFileResource.getVersion());
            }
            for (TsFileResource tsFileResource : this.upgradeUnseqFileList) {
                partitionNum = tsFileResource.getTimePartition();
                this.updatePartitionFileVersion(partitionNum, tsFileResource.getVersion());
            }
            this.updateLatestFlushedTime();
            List<TsFileResource> seqTsFileResources = this.tsFileManagement.getTsFileList(true);
            for (TsFileResource resource : seqTsFileResources) {
                long timePartitionId = resource.getTimePartition();
                HashMap<String, Long> endTimeMap = new HashMap<String, Long>();
                for (String deviceId : resource.getDevices()) {
                    long endTime = resource.getEndTime(deviceId);
                    endTimeMap.put(deviceId, endTime);
                }
                this.latestTimeForEachDevice.computeIfAbsent(timePartitionId, l -> new HashMap()).putAll(endTimeMap);
                this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap()).putAll(endTimeMap);
                this.globalLatestFlushedTimeForEachDevice.putAll(endTimeMap);
            }
            String string = this.logicalStorageGroupName + "-" + this.virtualStorageGroupId + "-" + System.currentTimeMillis();
            File mergingMods = SystemFileFactory.INSTANCE.getFile(this.storageGroupSysDir, MERGING_MODIFICATION_FILE_NAME);
            if (mergingMods.exists()) {
                this.tsFileManagement.mergingModification = new ModificationFile(mergingMods.getPath());
            }
            CompactionMergeRecoverTask recoverTask = new CompactionMergeRecoverTask(this.tsFileManagement, new ArrayList<TsFileResource>(this.tsFileManagement.getTsFileList(true)), this.tsFileManagement.getTsFileList(false), this.storageGroupSysDir.getPath(), this.tsFileManagement::mergeEndAction, string, IoTDBDescriptor.getInstance().getConfig().isForceFullMerge(), this.logicalStorageGroupName, this::closeCompactionRecoverCallBack);
            new Thread(recoverTask).start();
            logger.info("submit a compaction merge recover task");
        }
        catch (IOException e) {
            throw new StorageGroupProcessorException(e);
        }
    }

    private void updatePartitionFileVersion(long partitionNum, long fileVersion) {
        long oldVersion = this.partitionMaxFileVersions.getOrDefault(partitionNum, 0L);
        if (fileVersion > oldVersion) {
            this.partitionMaxFileVersions.put(partitionNum, fileVersion);
        }
    }

    private void updateLatestFlushedTime() throws IOException {
        SimpleFileVersionController versionController = new SimpleFileVersionController(this.storageGroupSysDir.getPath());
        long currentVersion = versionController.currVersion();
        for (TsFileResource resource : this.upgradeSeqFileList) {
            for (String deviceId : resource.getDevices()) {
                long endTime = resource.getEndTime(deviceId);
                long endTimePartitionId = StorageEngine.getTimePartition(endTime);
                this.latestTimeForEachDevice.computeIfAbsent(endTimePartitionId, l -> new HashMap()).put(deviceId, endTime);
                this.globalLatestFlushedTimeForEachDevice.put(deviceId, endTime);
                for (long partitionId = StorageEngine.getTimePartition(resource.getStartTime(deviceId)); partitionId <= endTimePartitionId; ++partitionId) {
                    File versionFile;
                    this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(partitionId, l -> new HashMap()).put(deviceId, endTime);
                    if (this.timePartitionIdVersionControllerMap.containsKey(partitionId)) continue;
                    File directory = SystemFileFactory.INSTANCE.getFile(this.storageGroupSysDir, String.valueOf(partitionId));
                    if (!directory.exists()) {
                        directory.mkdirs();
                    }
                    if (!(versionFile = SystemFileFactory.INSTANCE.getFile(directory, "Version-" + currentVersion)).createNewFile()) {
                        logger.warn("Version file {} has already been created ", (Object)versionFile);
                    }
                    this.timePartitionIdVersionControllerMap.put(partitionId, new SimpleFileVersionController(this.storageGroupSysDir.getPath(), partitionId));
                }
            }
        }
    }

    private Pair<List<TsFileResource>, List<TsFileResource>> getAllFiles(List<String> folders) throws IOException {
        ArrayList tsFiles = new ArrayList();
        ArrayList upgradeFiles = new ArrayList();
        for (String baseDir : folders) {
            File fileFolder = this.fsFactory.getFile(baseDir + File.separator + this.logicalStorageGroupName, this.virtualStorageGroupId);
            if (!fileFolder.exists()) continue;
            this.continueFailedRenames(fileFolder, ".temp");
            File[] subFiles = fileFolder.listFiles();
            if (subFiles == null) continue;
            for (File partitionFolder : subFiles) {
                if (!partitionFolder.isDirectory()) {
                    logger.warn("{} is not a directory.", (Object)partitionFolder.getAbsolutePath());
                    continue;
                }
                if (!partitionFolder.getName().equals("upgrade")) {
                    this.continueFailedRenames(partitionFolder, ".temp");
                    Collections.addAll(tsFiles, this.fsFactory.listFilesBySuffix(partitionFolder.getAbsolutePath(), ".tsfile"));
                    continue;
                }
                Collections.addAll(upgradeFiles, this.fsFactory.listFilesBySuffix(partitionFolder.getAbsolutePath(), ".tsfile"));
            }
        }
        tsFiles.sort(this::compareFileName);
        ArrayList ret = new ArrayList();
        tsFiles.forEach(f -> ret.add(new TsFileResource((File)f)));
        upgradeFiles.sort(this::compareFileName);
        ArrayList<TsFileResource> upgradeRet = new ArrayList<TsFileResource>();
        for (File f2 : upgradeFiles) {
            TsFileResource fileResource = new TsFileResource(f2);
            fileResource.setClosed(true);
            fileResource.deserializeFromOldFile();
            upgradeRet.add(fileResource);
        }
        return new Pair(ret, upgradeRet);
    }

    private void continueFailedRenames(File fileFolder, String suffix) {
        File[] files = this.fsFactory.listFilesBySuffix(fileFolder.getAbsolutePath(), suffix);
        if (files != null) {
            for (File tempResource : files) {
                File originResource = this.fsFactory.getFile(tempResource.getPath().replace(suffix, ""));
                if (originResource.exists()) {
                    tempResource.delete();
                    continue;
                }
                tempResource.renameTo(originResource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverTsFiles(List<TsFileResource> tsFiles, boolean isSeq) throws IOException {
        boolean needsCheckTsFile = true;
        for (int i = tsFiles.size() - 1; i >= 0; --i) {
            TsFileResource tsFileResource = tsFiles.get(i);
            long timePartitionId = tsFileResource.getTimePartition();
            TsFileRecoverPerformer recoverPerformer = new TsFileRecoverPerformer(this.logicalStorageGroupName + File.separator + this.virtualStorageGroupId + "-", tsFileResource, isSeq, needsCheckTsFile);
            try (RestorableTsFileIOWriter writer = null;){
                if (TsFileResource.getMergeLevel(tsFileResource.getTsFile().getName()) > 0) {
                    writer = recoverPerformer.recover(false, this::getWalDirectByteBuffer, this::releaseWalBuffer);
                    tsFileResource.setClosed(true);
                    this.tsFileManagement.add(tsFileResource, isSeq);
                    continue;
                }
                writer = recoverPerformer.recover(true, this::getWalDirectByteBuffer, this::releaseWalBuffer);
                if (writer == null || !writer.hasCrashed()) {
                    needsCheckTsFile = false;
                }
            }
            if (i != tsFiles.size() - 1 || writer == null || !writer.canWrite()) {
                tsFileResource.setClosed(true);
            } else if (writer.canWrite()) {
                TsFileProcessor tsFileProcessor;
                if (isSeq) {
                    tsFileProcessor = new TsFileProcessor(this.virtualStorageGroupId, this.storageGroupInfo, tsFileResource, this::closeUnsealedTsFileProcessorCallBack, this::updateLatestFlushTimeCallback, true, writer);
                    if (this.enableMemControl) {
                        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.storageGroupInfo);
                        tsFileProcessor.setTsFileProcessorInfo(tsFileProcessorInfo);
                        this.storageGroupInfo.initTsFileProcessorInfo(tsFileProcessor);
                    }
                    this.workSequenceTsFileProcessors.put(timePartitionId, tsFileProcessor);
                } else {
                    tsFileProcessor = new TsFileProcessor(this.virtualStorageGroupId, this.storageGroupInfo, tsFileResource, this::closeUnsealedTsFileProcessorCallBack, this::unsequenceFlushCallback, false, writer);
                    if (this.enableMemControl) {
                        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.storageGroupInfo);
                        tsFileProcessor.setTsFileProcessorInfo(tsFileProcessorInfo);
                        this.storageGroupInfo.initTsFileProcessorInfo(tsFileProcessor);
                    }
                    this.workUnsequenceTsFileProcessors.put(timePartitionId, tsFileProcessor);
                }
                tsFileResource.setProcessor(tsFileProcessor);
                tsFileResource.removeResourceFile();
                tsFileProcessor.setTimeRangeId(timePartitionId);
                writer.makeMetadataVisible();
                if (this.enableMemControl) {
                    long chunkMetadataSize = 0L;
                    for (Map metaMap : writer.getMetadatasForQuery().values()) {
                        for (List metadatas : metaMap.values()) {
                            for (ChunkMetadata chunkMetadata : metadatas) {
                                chunkMetadataSize += chunkMetadata.calculateRamSize();
                            }
                        }
                    }
                    tsFileProcessor.getTsFileProcessorInfo().addTSPMemCost(chunkMetadataSize);
                }
            }
            this.tsFileManagement.add(tsFileResource, isSeq);
        }
    }

    private int compareFileName(File o1, File o2) {
        long ver2;
        String[] items1 = o1.getName().replace(".tsfile", "").split("-");
        String[] items2 = o2.getName().replace(".tsfile", "").split("-");
        long ver1 = Long.parseLong(items1[0]);
        int cmp = Long.compare(ver1, ver2 = Long.parseLong(items2[0]));
        if (cmp == 0) {
            return Long.compare(Long.parseLong(items1[1]), Long.parseLong(items2[1]));
        }
        return cmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(InsertRowPlan insertRowPlan) throws WriteProcessException {
        if (!this.isAlive(insertRowPlan.getTime())) {
            throw new OutOfTTLException(insertRowPlan.getTime(), System.currentTimeMillis() - this.dataTTL);
        }
        this.writeLock("InsertRow");
        try {
            boolean isSequence;
            long timePartitionId = StorageEngine.getTimePartition(insertRowPlan.getTime());
            this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap());
            boolean bl = isSequence = insertRowPlan.getTime() > this.partitionLatestFlushedTimeForEachDevice.get(timePartitionId).getOrDefault(insertRowPlan.getDeviceId().getFullPath(), Long.MIN_VALUE);
            if (!isSequence && IoTDBDescriptor.getInstance().getConfig().isEnableDiscardOutOfOrderData()) {
                return;
            }
            this.latestTimeForEachDevice.computeIfAbsent(timePartitionId, l -> new HashMap());
            this.insertToTsFileProcessor(insertRowPlan, isSequence, timePartitionId);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTablet(InsertTabletPlan insertTabletPlan) throws BatchProcessException {
        this.writeLock("insertTablet");
        try {
            long currTime;
            int loc;
            Object[] results = new TSStatus[insertTabletPlan.getRowCount()];
            Arrays.fill(results, RpcUtils.SUCCESS_STATUS);
            boolean noFailure = true;
            for (loc = 0; loc < insertTabletPlan.getRowCount() && !this.isAlive(currTime = insertTabletPlan.getTimes()[loc]); ++loc) {
                results[loc] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OUT_OF_TTL_ERROR, (String)("time " + currTime + " in current line is out of TTL: " + this.dataTTL));
                noFailure = false;
            }
            if (loc == insertTabletPlan.getRowCount()) {
                throw new BatchProcessException((TSStatus[])results);
            }
            int before = loc;
            long beforeTimePartition = StorageEngine.getTimePartition(insertTabletPlan.getTimes()[before]);
            long lastFlushTime = this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(beforeTimePartition, id -> new HashMap()).computeIfAbsent(insertTabletPlan.getDeviceId().getFullPath(), id -> Long.MIN_VALUE);
            boolean isSequence = false;
            while (loc < insertTabletPlan.getRowCount()) {
                long time = insertTabletPlan.getTimes()[loc];
                long curTimePartition = StorageEngine.getTimePartition(time);
                if (curTimePartition != beforeTimePartition) {
                    if (isSequence || !IoTDBDescriptor.getInstance().getConfig().isEnableDiscardOutOfOrderData()) {
                        noFailure = this.insertTabletToTsFileProcessor(insertTabletPlan, before, loc, isSequence, (TSStatus[])results, beforeTimePartition) && noFailure;
                    }
                    before = loc;
                    beforeTimePartition = curTimePartition;
                    lastFlushTime = this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(beforeTimePartition, id -> new HashMap()).computeIfAbsent(insertTabletPlan.getDeviceId().getFullPath(), id -> Long.MIN_VALUE);
                    isSequence = false;
                    continue;
                }
                if (!isSequence && time > lastFlushTime) {
                    if (!IoTDBDescriptor.getInstance().getConfig().isEnableDiscardOutOfOrderData()) {
                        noFailure = this.insertTabletToTsFileProcessor(insertTabletPlan, before, loc, false, (TSStatus[])results, beforeTimePartition) && noFailure;
                    }
                    before = loc;
                    isSequence = true;
                }
                ++loc;
            }
            if (before < loc && (isSequence || !IoTDBDescriptor.getInstance().getConfig().isEnableDiscardOutOfOrderData())) {
                noFailure = this.insertTabletToTsFileProcessor(insertTabletPlan, before, loc, isSequence, (TSStatus[])results, beforeTimePartition) && noFailure;
            }
            long globalLatestFlushedTime = this.globalLatestFlushedTimeForEachDevice.getOrDefault(insertTabletPlan.getDeviceId().getFullPath(), Long.MIN_VALUE);
            this.tryToUpdateBatchInsertLastCache(insertTabletPlan, globalLatestFlushedTime);
            if (!noFailure) {
                throw new BatchProcessException((TSStatus[])results);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private boolean isAlive(long time) {
        return this.dataTTL == Long.MAX_VALUE || System.currentTimeMillis() - time <= this.dataTTL;
    }

    private boolean insertTabletToTsFileProcessor(InsertTabletPlan insertTabletPlan, int start, int end, boolean sequence, TSStatus[] results, long timePartitionId) {
        if (start >= end) {
            return true;
        }
        TsFileProcessor tsFileProcessor = this.getOrCreateTsFileProcessor(timePartitionId, sequence);
        if (tsFileProcessor == null) {
            for (int i = start; i < end; ++i) {
                results[i] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("can not create TsFileProcessor, timePartitionId: " + timePartitionId));
            }
            return false;
        }
        try {
            tsFileProcessor.insertTablet(insertTabletPlan, start, end, results);
        }
        catch (WriteProcessRejectException e) {
            logger.warn("insert to TsFileProcessor rejected, {}", (Object)e.getMessage());
            return false;
        }
        catch (WriteProcessException e) {
            logger.error("insert to TsFileProcessor error ", (Throwable)e);
            return false;
        }
        this.latestTimeForEachDevice.computeIfAbsent(timePartitionId, t -> new HashMap());
        if (sequence && this.latestTimeForEachDevice.get(timePartitionId).getOrDefault(insertTabletPlan.getDeviceId().getFullPath(), Long.MIN_VALUE) < insertTabletPlan.getTimes()[end - 1]) {
            this.latestTimeForEachDevice.get(timePartitionId).put(insertTabletPlan.getDeviceId().getFullPath(), insertTabletPlan.getTimes()[end - 1]);
        }
        if (tsFileProcessor.shouldFlush()) {
            this.fileFlushPolicy.apply(this, tsFileProcessor, sequence);
        }
        return true;
    }

    private void tryToUpdateBatchInsertLastCache(InsertTabletPlan plan, Long latestFlushedTime) {
        if (!IoTDBDescriptor.getInstance().getConfig().isLastCacheEnabled()) {
            return;
        }
        MeasurementMNode[] mNodes = plan.getMeasurementMNodes();
        for (int i = 0; i < mNodes.length; ++i) {
            if (plan.getColumns()[i] == null) continue;
            if (mNodes[i] != null) {
                IoTDB.metaManager.updateLastCache(null, plan.composeLastTimeValuePair(i), true, latestFlushedTime, mNodes[i]);
                continue;
            }
            IoTDB.metaManager.updateLastCache(plan.getDeviceId().concatNode(plan.getMeasurements()[i]), plan.composeLastTimeValuePair(i), true, latestFlushedTime, null);
        }
    }

    private void insertToTsFileProcessor(InsertRowPlan insertRowPlan, boolean sequence, long timePartitionId) throws WriteProcessException {
        TsFileProcessor tsFileProcessor = this.getOrCreateTsFileProcessor(timePartitionId, sequence);
        if (tsFileProcessor == null) {
            return;
        }
        tsFileProcessor.insert(insertRowPlan);
        if (this.latestTimeForEachDevice.get(timePartitionId).getOrDefault(insertRowPlan.getDeviceId().getFullPath(), Long.MIN_VALUE) < insertRowPlan.getTime()) {
            this.latestTimeForEachDevice.get(timePartitionId).put(insertRowPlan.getDeviceId().getFullPath(), insertRowPlan.getTime());
        }
        long globalLatestFlushTime = this.globalLatestFlushedTimeForEachDevice.getOrDefault(insertRowPlan.getDeviceId().getFullPath(), Long.MIN_VALUE);
        this.tryToUpdateInsertLastCache(insertRowPlan, globalLatestFlushTime);
        if (tsFileProcessor.shouldFlush()) {
            this.fileFlushPolicy.apply(this, tsFileProcessor, sequence);
        }
    }

    private void tryToUpdateInsertLastCache(InsertRowPlan plan, Long latestFlushedTime) {
        if (!IoTDBDescriptor.getInstance().getConfig().isLastCacheEnabled()) {
            return;
        }
        MeasurementMNode[] mNodes = plan.getMeasurementMNodes();
        for (int i = 0; i < mNodes.length; ++i) {
            if (plan.getValues()[i] == null) continue;
            if (mNodes[i] != null) {
                IoTDB.metaManager.updateLastCache(null, plan.composeTimeValuePair(i), true, latestFlushedTime, mNodes[i]);
                continue;
            }
            IoTDB.metaManager.updateLastCache(plan.getDeviceId().concatNode(plan.getMeasurements()[i]), plan.composeTimeValuePair(i), true, latestFlushedTime, null);
        }
    }

    public void submitAFlushTaskWhenShouldFlush(TsFileProcessor tsFileProcessor) {
        this.writeLock("submitAFlushTaskWhenShouldFlush");
        try {
            if (tsFileProcessor.shouldFlush()) {
                this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private TsFileProcessor getOrCreateTsFileProcessor(long timeRangeId, boolean sequence) {
        TsFileProcessor tsFileProcessor = null;
        try {
            tsFileProcessor = sequence ? this.getOrCreateTsFileProcessorIntern(timeRangeId, this.workSequenceTsFileProcessors, true) : this.getOrCreateTsFileProcessorIntern(timeRangeId, this.workUnsequenceTsFileProcessors, false);
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("disk space is insufficient when creating TsFile processor, change system mode to read-only", (Throwable)e);
            IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
        }
        catch (IOException e) {
            logger.error("meet IOException when creating TsFileProcessor, change system mode to read-only", (Throwable)e);
            IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
        }
        return tsFileProcessor;
    }

    private TsFileProcessor getOrCreateTsFileProcessorIntern(long timeRangeId, TreeMap<Long, TsFileProcessor> tsFileProcessorTreeMap, boolean sequence) throws IOException, DiskSpaceInsufficientException {
        TsFileProcessor res = tsFileProcessorTreeMap.get(timeRangeId);
        if (null == res) {
            res = this.newTsFileProcessor(sequence, timeRangeId);
            tsFileProcessorTreeMap.put(timeRangeId, res);
            this.tsFileManagement.add(res.getTsFileResource(), sequence);
        }
        return res;
    }

    private TsFileProcessor newTsFileProcessor(boolean sequence, long timePartitionId) throws IOException, DiskSpaceInsufficientException {
        DirectoryManager directoryManager = DirectoryManager.getInstance();
        String baseDir = sequence ? directoryManager.getNextFolderForSequenceFile() : directoryManager.getNextFolderForUnSequenceFile();
        this.fsFactory.getFile(baseDir + File.separator + this.logicalStorageGroupName, this.virtualStorageGroupId).mkdirs();
        String filePath = baseDir + File.separator + this.logicalStorageGroupName + File.separator + this.virtualStorageGroupId + File.separator + timePartitionId + File.separator + this.getNewTsFileName(timePartitionId);
        return this.getTsFileProcessor(sequence, filePath, timePartitionId);
    }

    private TsFileProcessor getTsFileProcessor(boolean sequence, String filePath, long timePartitionId) throws IOException {
        TsFileProcessor tsFileProcessor = sequence ? new TsFileProcessor(this.logicalStorageGroupName + File.separator + this.virtualStorageGroupId, this.fsFactory.getFileWithParent(filePath), this.storageGroupInfo, this::closeUnsealedTsFileProcessorCallBack, this::updateLatestFlushTimeCallback, true, this.deviceNumInLastClosedTsFile) : new TsFileProcessor(this.logicalStorageGroupName + File.separator + this.virtualStorageGroupId, this.fsFactory.getFileWithParent(filePath), this.storageGroupInfo, this::closeUnsealedTsFileProcessorCallBack, this::unsequenceFlushCallback, false, this.deviceNumInLastClosedTsFile);
        if (this.enableMemControl) {
            TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.storageGroupInfo);
            tsFileProcessor.setTsFileProcessorInfo(tsFileProcessorInfo);
            this.storageGroupInfo.initTsFileProcessorInfo(tsFileProcessor);
        }
        tsFileProcessor.addCloseFileListeners(this.customCloseFileListeners);
        tsFileProcessor.addFlushListeners(this.customFlushListeners);
        tsFileProcessor.setTimeRangeId(timePartitionId);
        return tsFileProcessor;
    }

    private String getNewTsFileName(long timePartitionId) {
        long version = this.partitionMaxFileVersions.getOrDefault(timePartitionId, 0L) + 1L;
        this.partitionMaxFileVersions.put(timePartitionId, version);
        return this.getNewTsFileName(System.currentTimeMillis(), version, 0, 0);
    }

    private String getNewTsFileName(long time, long version, int mergeCnt, int unSeqMergeCnt) {
        return TsFileResource.getNewTsFileName(time, version, mergeCnt, unSeqMergeCnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCloseOneTsFileProcessor(boolean sequence, TsFileProcessor tsFileProcessor) {
        Object object = this.closeStorageGroupCondition;
        synchronized (object) {
            try {
                this.asyncCloseOneTsFileProcessor(sequence, tsFileProcessor);
                long startTime = System.currentTimeMillis();
                while (this.closingSequenceTsFileProcessor.contains(tsFileProcessor) || this.closingUnSequenceTsFileProcessor.contains(tsFileProcessor)) {
                    this.closeStorageGroupCondition.wait(60000L);
                    if (System.currentTimeMillis() - startTime <= 60000L) continue;
                    logger.warn("{} has spent {}s to wait for closing one tsfile.", (Object)(this.logicalStorageGroupName + "-" + this.virtualStorageGroupId), (Object)((System.currentTimeMillis() - startTime) / 1000L));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("syncCloseOneTsFileProcessor error occurs while waiting for closing the storage group {}", (Object)(this.logicalStorageGroupName + "-" + this.virtualStorageGroupId), (Object)e);
            }
        }
    }

    public void asyncCloseOneTsFileProcessor(boolean sequence, TsFileProcessor tsFileProcessor) {
        if (this.closingSequenceTsFileProcessor.contains(tsFileProcessor) || this.closingUnSequenceTsFileProcessor.contains(tsFileProcessor) || tsFileProcessor.alreadyMarkedClosing()) {
            return;
        }
        logger.info("Async close tsfile: {}", (Object)tsFileProcessor.getTsFileResource().getTsFile().getAbsolutePath());
        if (sequence) {
            this.closingSequenceTsFileProcessor.add(tsFileProcessor);
            this.updateEndTimeMap(tsFileProcessor);
            tsFileProcessor.asyncClose();
            this.workSequenceTsFileProcessors.remove(tsFileProcessor.getTimeRangeId());
            if (!this.workUnsequenceTsFileProcessors.containsKey(tsFileProcessor.getTimeRangeId())) {
                this.timePartitionIdVersionControllerMap.remove(tsFileProcessor.getTimeRangeId());
            }
            logger.info("close a sequence tsfile processor {}", (Object)(this.logicalStorageGroupName + "-" + this.virtualStorageGroupId));
        } else {
            this.closingUnSequenceTsFileProcessor.add(tsFileProcessor);
            tsFileProcessor.asyncClose();
            this.workUnsequenceTsFileProcessors.remove(tsFileProcessor.getTimeRangeId());
            if (!this.workSequenceTsFileProcessors.containsKey(tsFileProcessor.getTimeRangeId())) {
                this.timePartitionIdVersionControllerMap.remove(tsFileProcessor.getTimeRangeId());
            }
        }
    }

    public void deleteFolder(String systemDir) {
        logger.info("{} will close all files for deleting data folder {}", (Object)(this.logicalStorageGroupName + "-" + this.virtualStorageGroupId), (Object)systemDir);
        this.writeLock("deleteFolder");
        try {
            File storageGroupFolder = SystemFileFactory.INSTANCE.getFile(systemDir, this.virtualStorageGroupId);
            if (storageGroupFolder.exists()) {
                FileUtils.deleteDirectory(storageGroupFolder);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public void closeAllResources() {
        for (TsFileResource tsFileResource : this.tsFileManagement.getTsFileList(false)) {
            try {
                tsFileResource.close();
            }
            catch (IOException e) {
                logger.error("Cannot close a TsFileResource {}", (Object)tsFileResource, (Object)e);
            }
        }
        for (TsFileResource tsFileResource : this.tsFileManagement.getTsFileList(true)) {
            try {
                tsFileResource.close();
            }
            catch (IOException e) {
                logger.error("Cannot close a TsFileResource {}", (Object)tsFileResource, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWalDirectByteBufferPool() {
        Deque<ByteBuffer> deque = this.walByteBufferPool;
        synchronized (deque) {
            while (!this.walByteBufferPool.isEmpty()) {
                MmapUtil.clean((MappedByteBuffer)this.walByteBufferPool.removeFirst());
                --this.currentWalPoolSize;
            }
        }
    }

    public void syncDeleteDataFiles() {
        logger.info("{} will close all files for deleting data files", (Object)(this.logicalStorageGroupName + "-" + this.virtualStorageGroupId));
        this.writeLock("syncDeleteDataFiles");
        try {
            this.syncCloseAllWorkingTsFileProcessors();
            if (this.tsFileManagement.mergingModification != null) {
                this.tsFileManagement.mergingModification.close();
            }
            this.closeAllResources();
            List<String> folder = DirectoryManager.getInstance().getAllSequenceFileFolders();
            folder.addAll(DirectoryManager.getInstance().getAllUnSequenceFileFolders());
            this.deleteAllSGFolders(folder);
            this.workSequenceTsFileProcessors.clear();
            this.workUnsequenceTsFileProcessors.clear();
            this.tsFileManagement.clear();
            this.partitionLatestFlushedTimeForEachDevice.clear();
            this.globalLatestFlushedTimeForEachDevice.clear();
            this.latestTimeForEachDevice.clear();
        }
        catch (IOException e) {
            logger.error("Cannot close the mergingMod file {}", (Object)this.tsFileManagement.mergingModification.getFilePath(), (Object)e);
        }
        finally {
            this.writeUnlock();
        }
    }

    private void deleteAllSGFolders(List<String> folder) {
        for (String tsfilePath : folder) {
            File storageGroupFolder = this.fsFactory.getFile(tsfilePath, this.logicalStorageGroupName + File.separator + this.virtualStorageGroupId);
            if (!storageGroupFolder.exists()) continue;
            FileUtils.deleteDirectory(storageGroupFolder);
        }
    }

    public synchronized void checkFilesTTL() {
        if (this.dataTTL == Long.MAX_VALUE) {
            logger.debug("{}: TTL not set, ignore the check", (Object)(this.logicalStorageGroupName + "-" + this.virtualStorageGroupId));
            return;
        }
        long timeLowerBound = System.currentTimeMillis() - this.dataTTL;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: TTL removing files before {}", (Object)(this.logicalStorageGroupName + "-" + this.virtualStorageGroupId), (Object)new Date(timeLowerBound));
        }
        ArrayList<TsFileResource> seqFiles = new ArrayList<TsFileResource>(this.tsFileManagement.getTsFileList(true));
        ArrayList<TsFileResource> unseqFiles = new ArrayList<TsFileResource>(this.tsFileManagement.getTsFileList(false));
        for (TsFileResource tsFileResource : seqFiles) {
            this.checkFileTTL(tsFileResource, timeLowerBound, true);
        }
        for (TsFileResource tsFileResource : unseqFiles) {
            this.checkFileTTL(tsFileResource, timeLowerBound, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileTTL(TsFileResource resource, long timeLowerBound, boolean isSeq) {
        block8: {
            if (!resource.isClosed() || !resource.isDeleted() && resource.stillLives(timeLowerBound)) {
                return;
            }
            this.writeLock("checkFileTTL");
            try {
                resource.setDeleted(true);
                if (!resource.tryWriteLock()) break block8;
                try {
                    resource.remove();
                    if (logger.isInfoEnabled()) {
                        logger.info("Removed a file {} before {} by ttl ({}ms)", new Object[]{resource.getTsFilePath(), new Date(timeLowerBound), this.dataTTL});
                    }
                    this.tsFileManagement.remove(resource, isSeq);
                }
                finally {
                    resource.writeUnlock();
                }
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timedFlushSeqMemTable() {
        this.writeLock("timedFlushSeqMemTable");
        try {
            ArrayList<TsFileProcessor> tsFileProcessors = new ArrayList<TsFileProcessor>(this.workSequenceTsFileProcessors.values());
            long timeLowerBound = System.currentTimeMillis() - config.getSeqMemtableFlushInterval();
            for (TsFileProcessor tsFileProcessor : tsFileProcessors) {
                if (tsFileProcessor.getWorkMemTableCreatedTime() >= timeLowerBound) continue;
                logger.info("Exceed sequence memtable flush interval, so flush working memtable of time partition {} in storage group {}[{}]", new Object[]{tsFileProcessor.getTimeRangeId(), this.logicalStorageGroupName, this.virtualStorageGroupId});
                this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timedFlushUnseqMemTable() {
        this.writeLock("timedFlushUnseqMemTable");
        try {
            ArrayList<TsFileProcessor> tsFileProcessors = new ArrayList<TsFileProcessor>(this.workUnsequenceTsFileProcessors.values());
            long timeLowerBound = System.currentTimeMillis() - config.getUnseqMemtableFlushInterval();
            for (TsFileProcessor tsFileProcessor : tsFileProcessors) {
                if (tsFileProcessor.getWorkMemTableCreatedTime() >= timeLowerBound) continue;
                logger.info("Exceed unsequence memtable flush interval, so flush working memtable of time partition {} in storage group {}[{}]", new Object[]{tsFileProcessor.getTimeRangeId(), this.logicalStorageGroupName, this.virtualStorageGroupId});
                this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timedCloseTsFileProcessor() {
        this.writeLock("timedCloseTsFileProcessor");
        try {
            ArrayList<TsFileProcessor> seqTsFileProcessors = new ArrayList<TsFileProcessor>(this.workSequenceTsFileProcessors.values());
            long timeLowerBound = System.currentTimeMillis() - config.getCloseTsFileIntervalAfterFlushing();
            for (TsFileProcessor tsFileProcessor : seqTsFileProcessors) {
                if (tsFileProcessor.getWorkMemTableCreatedTime() != Long.MAX_VALUE || tsFileProcessor.getLastWorkMemtableFlushTime() >= timeLowerBound) continue;
                logger.info("Exceed tsfile close interval, so close TsFileProcessor of time partition {} in storage group {}[{}]", new Object[]{tsFileProcessor.getTimeRangeId(), this.logicalStorageGroupName, this.virtualStorageGroupId});
                this.asyncCloseOneTsFileProcessor(true, tsFileProcessor);
            }
            ArrayList<TsFileProcessor> unSeqTsFileProcessors = new ArrayList<TsFileProcessor>(this.workUnsequenceTsFileProcessors.values());
            timeLowerBound = System.currentTimeMillis() - config.getCloseTsFileIntervalAfterFlushing();
            for (TsFileProcessor tsFileProcessor : unSeqTsFileProcessors) {
                if (tsFileProcessor.getWorkMemTableCreatedTime() != Long.MAX_VALUE || tsFileProcessor.getLastWorkMemtableFlushTime() >= timeLowerBound) continue;
                logger.info("Exceed tsfile close interval, so close TsFileProcessor of time partition {} in storage group {}[{}]", new Object[]{tsFileProcessor.getTimeRangeId(), this.logicalStorageGroupName, this.virtualStorageGroupId});
                this.asyncCloseOneTsFileProcessor(false, tsFileProcessor);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCloseAllWorkingTsFileProcessors() {
        Object object = this.closeStorageGroupCondition;
        synchronized (object) {
            try {
                this.asyncCloseAllWorkingTsFileProcessors();
                long startTime = System.currentTimeMillis();
                while (!this.closingSequenceTsFileProcessor.isEmpty() || !this.closingUnSequenceTsFileProcessor.isEmpty()) {
                    this.closeStorageGroupCondition.wait(60000L);
                    if (System.currentTimeMillis() - startTime <= 60000L) continue;
                    logger.warn("{} has spent {}s to wait for closing all TsFiles.", (Object)(this.logicalStorageGroupName + "-" + this.virtualStorageGroupId), (Object)((System.currentTimeMillis() - startTime) / 1000L));
                }
            }
            catch (InterruptedException e) {
                logger.error("CloseFileNodeCondition error occurs while waiting for closing the storage group {}", (Object)(this.logicalStorageGroupName + "-" + this.virtualStorageGroupId), (Object)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public void asyncCloseAllWorkingTsFileProcessors() {
        this.writeLock("asyncCloseAllWorkingTsFileProcessors");
        try {
            logger.info("async force close all files in storage group: {}", (Object)(this.logicalStorageGroupName + "-" + this.virtualStorageGroupId));
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workSequenceTsFileProcessors.values())) {
                this.asyncCloseOneTsFileProcessor(true, tsFileProcessor);
            }
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workUnsequenceTsFileProcessors.values())) {
                this.asyncCloseOneTsFileProcessor(false, tsFileProcessor);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public void forceCloseAllWorkingTsFileProcessors() throws TsFileProcessorException {
        this.writeLock("forceCloseAllWorkingTsFileProcessors");
        try {
            logger.info("force close all processors in storage group: {}", (Object)(this.logicalStorageGroupName + "-" + this.virtualStorageGroupId));
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workSequenceTsFileProcessors.values())) {
                tsFileProcessor.putMemTableBackAndClose();
            }
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workUnsequenceTsFileProcessors.values())) {
                tsFileProcessor.putMemTableBackAndClose();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public QueryDataSource query(List<PartialPath> pathList, QueryContext context, QueryFileManager filePathsManager, Filter timeFilter) throws QueryProcessException {
        this.readLock();
        try {
            List<TsFileResource> seqResources = this.getFileResourceListForQuery(this.tsFileManagement.getTsFileList(true), this.upgradeSeqFileList, pathList, context, timeFilter, true);
            List<TsFileResource> unseqResources = this.getFileResourceListForQuery(this.tsFileManagement.getTsFileList(false), this.upgradeUnseqFileList, pathList, context, timeFilter, false);
            QueryDataSource dataSource = new QueryDataSource(seqResources, unseqResources);
            if (filePathsManager != null) {
                filePathsManager.addUsedFilesForQuery(context.getQueryId(), dataSource);
            }
            dataSource.setDataTTL(this.dataTTL);
            QueryDataSource queryDataSource = dataSource;
            return queryDataSource;
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    public void readLock() {
        this.insertLock.readLock().lock();
        this.tsFileManagement.readLock();
    }

    public void readUnlock() {
        this.tsFileManagement.readUnLock();
        this.insertLock.readLock().unlock();
    }

    public void writeLock(String holder) {
        this.insertLock.writeLock().lock();
        this.insertWriteLockHolder = holder;
    }

    public void writeUnlock() {
        this.insertWriteLockHolder = "";
        this.insertLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TsFileResource> getFileResourceListForQuery(Collection<TsFileResource> tsFileResources, List<TsFileResource> upgradeTsFileResources, List<PartialPath> pathList, QueryContext context, Filter timeFilter, boolean isSeq) throws MetadataException {
        if (context.isDebug()) {
            DEBUG_LOGGER.info("Path: {}, get tsfile list: {} isSeq: {} timefilter: {}", new Object[]{pathList, tsFileResources, isSeq, timeFilter == null ? "null" : timeFilter});
        }
        ArrayList<TsFileResource> tsfileResourcesForQuery = new ArrayList<TsFileResource>();
        long timeLowerBound = this.dataTTL != Long.MAX_VALUE ? System.currentTimeMillis() - this.dataTTL : Long.MIN_VALUE;
        context.setQueryTimeLowerBound(timeLowerBound);
        for (TsFileResource tsFileResource : upgradeTsFileResources) {
            if (!tsFileResource.isSatisfied(timeFilter, isSeq, this.dataTTL, context.isDebug())) continue;
            this.closeQueryLock.readLock().lock();
            try {
                tsfileResourcesForQuery.add(tsFileResource);
            }
            finally {
                this.closeQueryLock.readLock().unlock();
            }
        }
        for (TsFileResource tsFileResource : tsFileResources) {
            if (!tsFileResource.isSatisfied(timeFilter, isSeq, this.dataTTL, context.isDebug())) continue;
            this.closeQueryLock.readLock().lock();
            try {
                if (tsFileResource.isClosed()) {
                    tsfileResourcesForQuery.add(tsFileResource);
                    continue;
                }
                tsFileResource.getProcessor().query(pathList, context, tsfileResourcesForQuery);
            }
            catch (IOException e) {
                throw new MetadataException(e);
            }
            finally {
                this.closeQueryLock.readLock().unlock();
            }
        }
        return tsfileResourcesForQuery;
    }

    public void delete(PartialPath path, long startTime, long endTime, long planIndex) throws IOException {
        if (this.upgradeFileCount.get() != 0) {
            throw new IOException("Delete failed. Please do not delete until the old files upgraded.");
        }
        this.writeLock("delete");
        ArrayList<ModificationFile> updatedModFiles = new ArrayList<ModificationFile>();
        try {
            Set<PartialPath> devicePaths = IoTDB.metaManager.getDevices(path.getDevicePath());
            for (PartialPath device : devicePaths) {
                this.tryToDeleteLastCache(device, path, startTime, endTime);
            }
            this.logDeletion(startTime, endTime, path);
            Deletion deletion = new Deletion(path, 1L, startTime, endTime);
            if (this.tsFileManagement.mergingModification != null) {
                this.tsFileManagement.mergingModification.write(deletion);
                updatedModFiles.add(this.tsFileManagement.mergingModification);
            }
            this.deleteDataInFiles(this.tsFileManagement.getTsFileList(true), deletion, devicePaths, updatedModFiles, planIndex);
            this.deleteDataInFiles(this.tsFileManagement.getTsFileList(false), deletion, devicePaths, updatedModFiles, planIndex);
        }
        catch (Exception e) {
            for (ModificationFile modFile : updatedModFiles) {
                modFile.abort();
                modFile.close();
            }
            throw new IOException(e);
        }
        finally {
            this.writeUnlock();
        }
    }

    private void logDeletion(long startTime, long endTime, PartialPath path) throws IOException {
        long timePartitionStartId = StorageEngine.getTimePartition(startTime);
        long timePartitionEndId = StorageEngine.getTimePartition(endTime);
        if (IoTDBDescriptor.getInstance().getConfig().isEnableWal()) {
            DeletePlan deletionPlan = new DeletePlan(startTime, endTime, path);
            for (Map.Entry<Long, TsFileProcessor> entry : this.workSequenceTsFileProcessors.entrySet()) {
                if (timePartitionStartId > entry.getKey() || entry.getKey() > timePartitionEndId) continue;
                entry.getValue().getLogNode().write(deletionPlan);
            }
            for (Map.Entry<Long, TsFileProcessor> entry : this.workUnsequenceTsFileProcessors.entrySet()) {
                if (timePartitionStartId > entry.getKey() || entry.getKey() > timePartitionEndId) continue;
                entry.getValue().getLogNode().write(deletionPlan);
            }
        }
    }

    private boolean canSkipDelete(TsFileResource tsFileResource, Set<PartialPath> devicePaths, long deleteStart, long deleteEnd) {
        for (PartialPath device : devicePaths) {
            String deviceId = device.getFullPath();
            long endTime = tsFileResource.getEndTime(deviceId);
            if (endTime == Long.MIN_VALUE) {
                return false;
            }
            if (!tsFileResource.getDevices().contains(deviceId) || deleteEnd < tsFileResource.getStartTime(deviceId) || deleteStart > endTime) continue;
            return false;
        }
        return true;
    }

    private void deleteDataInFiles(Collection<TsFileResource> tsFileResourceList, Deletion deletion, Set<PartialPath> devicePaths, List<ModificationFile> updatedModFiles, long planIndex) throws IOException {
        for (TsFileResource tsFileResource : tsFileResourceList) {
            if (this.canSkipDelete(tsFileResource, devicePaths, deletion.getStartTime(), deletion.getEndTime())) continue;
            deletion.setFileOffset(tsFileResource.getTsFileSize());
            tsFileResource.getModFile().write(deletion);
            tsFileResource.getModFile().close();
            logger.debug("[Deletion] Deletion with path:{}, time:{}-{} written into mods file:{}.", new Object[]{deletion.getPath(), deletion.getStartTime(), deletion.getEndTime(), tsFileResource.getModFile().getFilePath()});
            tsFileResource.updatePlanIndexes(planIndex);
            if (!tsFileResource.isClosed()) {
                TsFileProcessor tsfileProcessor = tsFileResource.getProcessor();
                tsfileProcessor.deleteDataInMemory(deletion, devicePaths);
            }
            updatedModFiles.add(tsFileResource.getModFile());
        }
    }

    private void tryToDeleteLastCache(PartialPath deviceId, PartialPath originalPath, long startTime, long endTime) throws WriteProcessException {
        if (!IoTDBDescriptor.getInstance().getConfig().isLastCacheEnabled()) {
            return;
        }
        try {
            MNode node = IoTDB.metaManager.getDeviceNode(deviceId);
            for (MNode measurementNode : node.getChildren().values()) {
                TimeValuePair lastPair;
                if (measurementNode == null || !originalPath.matchFullPath(measurementNode.getPartialPath()) || (lastPair = ((MeasurementMNode)measurementNode).getCachedLast()) == null || startTime > lastPair.getTimestamp() || lastPair.getTimestamp() > endTime) continue;
                ((MeasurementMNode)measurementNode).resetCache();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("[tryToDeleteLastCache] Last cache for path: {} is set to null", (Object)measurementNode.getFullPath());
            }
        }
        catch (MetadataException e) {
            throw new WriteProcessException(e);
        }
    }

    private void updateEndTimeMap(TsFileProcessor tsFileProcessor) {
        TsFileResource resource = tsFileProcessor.getTsFileResource();
        for (String deviceId : resource.getDevices()) {
            resource.updateEndTime(deviceId, this.latestTimeForEachDevice.get(tsFileProcessor.getTimeRangeId()).get(deviceId));
        }
    }

    private boolean unsequenceFlushCallback(TsFileProcessor processor) {
        return true;
    }

    private boolean updateLatestFlushTimeCallback(TsFileProcessor processor) {
        Map<String, Long> curPartitionDeviceLatestTime = this.latestTimeForEachDevice.get(processor.getTimeRangeId());
        if (curPartitionDeviceLatestTime == null) {
            logger.warn("Partition: {} does't have latest time for each device. No valid record is written into memtable. Flushing tsfile is: {}", (Object)processor.getTimeRangeId(), (Object)processor.getTsFileResource().getTsFile());
            return false;
        }
        for (Map.Entry<String, Long> entry : curPartitionDeviceLatestTime.entrySet()) {
            this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(processor.getTimeRangeId(), id -> new HashMap()).put(entry.getKey(), entry.getValue());
            this.updateNewlyFlushedPartitionLatestFlushedTimeForEachDevice(processor.getTimeRangeId(), entry.getKey(), entry.getValue());
            if (this.globalLatestFlushedTimeForEachDevice.getOrDefault(entry.getKey(), Long.MIN_VALUE) >= entry.getValue()) continue;
            this.globalLatestFlushedTimeForEachDevice.put(entry.getKey(), entry.getValue());
        }
        return true;
    }

    private boolean updateLatestFlushTimeToPartition(long partitionId, long latestFlushTime) {
        Map<String, Long> curPartitionDeviceLatestTime = this.latestTimeForEachDevice.get(partitionId);
        if (curPartitionDeviceLatestTime == null) {
            logger.warn("Partition: {} does't have latest time for each device. No valid record is written into memtable.  latest flush time is: {}", (Object)partitionId, (Object)latestFlushTime);
            return false;
        }
        for (Map.Entry<String, Long> entry : curPartitionDeviceLatestTime.entrySet()) {
            entry.setValue(latestFlushTime);
            this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(partitionId, id -> new HashMap()).put(entry.getKey(), entry.getValue());
            this.newlyFlushedPartitionLatestFlushedTimeForEachDevice.computeIfAbsent(partitionId, id -> new HashMap()).put(entry.getKey(), entry.getValue());
            if (this.globalLatestFlushedTimeForEachDevice.getOrDefault(entry.getKey(), Long.MIN_VALUE) >= entry.getValue()) continue;
            this.globalLatestFlushedTimeForEachDevice.put(entry.getKey(), entry.getValue());
        }
        return true;
    }

    public void updateNewlyFlushedPartitionLatestFlushedTimeForEachDevice(long partitionId, String deviceId, long time) {
        this.newlyFlushedPartitionLatestFlushedTimeForEachDevice.computeIfAbsent(partitionId, id -> new HashMap()).compute(deviceId, (k, v) -> v == null ? time : Math.max(v, time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeUnsealedTsFileProcessorCallBack(TsFileProcessor tsFileProcessor) throws TsFileProcessorException {
        this.closeQueryLock.writeLock().lock();
        try {
            tsFileProcessor.close();
            this.deviceNumInLastClosedTsFile = tsFileProcessor.getTsFileResource().getDevices().size();
        }
        finally {
            this.closeQueryLock.writeLock().unlock();
        }
        if (this.closingSequenceTsFileProcessor.contains(tsFileProcessor)) {
            this.closingSequenceTsFileProcessor.remove(tsFileProcessor);
        } else {
            this.closingUnSequenceTsFileProcessor.remove(tsFileProcessor);
        }
        Object object = this.closeStorageGroupCondition;
        synchronized (object) {
            this.closeStorageGroupCondition.notifyAll();
        }
        logger.info("signal closing storage group condition in {}", (Object)(this.logicalStorageGroupName + "-" + this.virtualStorageGroupId));
    }

    private void syncCompactOnePartition(long timePartition, boolean fullMerge) {
        try {
            this.tsFileManagement.forkCurrentFileList(timePartition);
            this.tsFileManagement.setForceFullMerge(fullMerge);
            TsFileManagement tsFileManagement = this.tsFileManagement;
            Objects.requireNonNull(tsFileManagement);
            tsFileManagement.new TsFileManagement.CompactionMergeTask(this::closeCompactionMergeCallBack, timePartition).call();
        }
        catch (IOException e) {
            this.closeCompactionMergeCallBack(false, timePartition);
            logger.error("{}-{} compaction submit task failed", (Object)this.logicalStorageGroupName, (Object)this.virtualStorageGroupId);
        }
    }

    private void closeCompactionRecoverCallBack(boolean isMerging, long timePartition) {
        if (IoTDBDescriptor.getInstance().getConfig().getCompactionStrategy() == CompactionStrategy.NO_COMPACTION || !this.tsFileManagement.canMerge) {
            return;
        }
        CompactionMergeTaskPoolManager.getInstance().clearCompactionStatus(this.logicalStorageGroupName);
        logger.info("{}-{} recover finished, submit scheduled compaction task", (Object)this.logicalStorageGroupName, (Object)this.virtualStorageGroupId);
        CompactionMergeTaskPoolManager.getInstance().init(this::merge);
    }

    private void closeCompactionMergeCallBack(boolean isMerge, long timePartitionId) {
    }

    public int countUpgradeFiles() {
        return this.upgradeFileCount.get();
    }

    public void upgrade() {
        for (TsFileResource seqTsFileResource : this.upgradeSeqFileList) {
            seqTsFileResource.setSeq(true);
            seqTsFileResource.setUpgradeTsFileResourceCallBack(this::upgradeTsFileResourceCallBack);
            seqTsFileResource.doUpgrade();
        }
        for (TsFileResource unseqTsFileResource : this.upgradeUnseqFileList) {
            unseqTsFileResource.setSeq(false);
            unseqTsFileResource.setUpgradeTsFileResourceCallBack(this::upgradeTsFileResourceCallBack);
            unseqTsFileResource.doUpgrade();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeTsFileResourceCallBack(TsFileResource tsFileResource) {
        List<TsFileResource> upgradedResources = tsFileResource.getUpgradedResources();
        for (TsFileResource tsFileResource2 : upgradedResources) {
            long partitionId = tsFileResource2.getTimePartition();
            tsFileResource2.getDevices().forEach(device -> this.updateNewlyFlushedPartitionLatestFlushedTimeForEachDevice(partitionId, (String)device, resource.getEndTime((String)device)));
        }
        this.upgradeFileCount.getAndAdd(-1);
        if (this.upgradeFileCount.get() == 0) {
            this.writeLock("upgradeTsFileResourceCallBack");
            try {
                this.loadUpgradedResources(this.upgradeSeqFileList, true);
                this.loadUpgradedResources(this.upgradeUnseqFileList, false);
            }
            finally {
                this.writeUnlock();
            }
            for (Map.Entry entry : this.newlyFlushedPartitionLatestFlushedTimeForEachDevice.entrySet()) {
                long timePartitionId = (Long)entry.getKey();
                Map latestFlushTimeForPartition = this.partitionLatestFlushedTimeForEachDevice.getOrDefault(timePartitionId, new HashMap());
                for (Map.Entry endTimeMap : ((Map)entry.getValue()).entrySet()) {
                    String device2 = (String)endTimeMap.getKey();
                    long endTime = (Long)endTimeMap.getValue();
                    if (latestFlushTimeForPartition.getOrDefault(device2, Long.MIN_VALUE) >= endTime) continue;
                    this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap()).put(device2, endTime);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUpgradedResources(List<TsFileResource> resources, boolean isseq) {
        if (resources.isEmpty()) {
            return;
        }
        for (TsFileResource resource : resources) {
            resource.writeLock();
            try {
                UpgradeUtils.moveUpgradedFiles(resource);
                this.tsFileManagement.addAll(resource.getUpgradedResources(), isseq);
                resource.delete();
                Files.deleteIfExists(this.fsFactory.getFile(resource.getTsFile().toPath() + ".mods").toPath());
                UpgradeLog.writeUpgradeLogFile(resource.getTsFile().getAbsolutePath() + "," + (Object)((Object)UpgradeCheckStatus.UPGRADE_SUCCESS));
            }
            catch (IOException e) {
                logger.error("Unable to load {}, caused by ", (Object)resource, (Object)e);
            }
            finally {
                resource.writeUnlock();
            }
        }
        if (resources.get(0).getTsFile().getParentFile().isDirectory() && resources.get(0).getTsFile().getParentFile().listFiles().length == 0) {
            try {
                Files.delete(resources.get(0).getTsFile().getParentFile().toPath());
            }
            catch (IOException e) {
                logger.error("Delete upgrade folder {} failed, caused by ", (Object)resources.get(0).getTsFile().getParentFile(), (Object)e);
            }
        }
        resources.clear();
    }

    public void merge() {
        if (!this.tsFileManagement.recovered || this.compacting || !this.tsFileManagement.canMerge) {
            return;
        }
        try {
            if (config.getCompactionStrategy() == CompactionStrategy.LEVEL_COMPACTION) {
                this.compacting = true;
                new CompactionAllPartitionTask(this.logicalStorageGroupName).call();
            }
        }
        finally {
            this.compacting = false;
        }
    }

    public void loadNewTsFileForSync(TsFileResource newTsFileResource) throws LoadFileException {
        File tsfileToBeInserted = newTsFileResource.getTsFile();
        long newFilePartitionId = newTsFileResource.getTimePartitionWithCheck();
        this.writeLock("loadNewTsFileForSync");
        try {
            if (this.loadTsFileByType(LoadTsFileType.LOAD_SEQUENCE, tsfileToBeInserted, newTsFileResource, newFilePartitionId)) {
                this.updateLatestTimeMap(newTsFileResource);
            }
            this.resetLastCacheWhenLoadingTsfile(newTsFileResource);
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("Failed to append the tsfile {} to storage group processor {} because the disk space is insufficient.", (Object)tsfileToBeInserted.getAbsolutePath(), (Object)tsfileToBeInserted.getParentFile().getName());
            IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
            throw new LoadFileException(e);
        }
        catch (IOException | WriteProcessException | IllegalPathException e) {
            logger.error("Failed to reset last cache when loading file {}", (Object)newTsFileResource.getTsFilePath());
            throw new LoadFileException(e);
        }
        finally {
            this.writeUnlock();
        }
    }

    private void resetLastCacheWhenLoadingTsfile(TsFileResource newTsFileResource) throws IllegalPathException, WriteProcessException {
        for (String device : newTsFileResource.getDevices()) {
            this.tryToDeleteLastCacheByDevice(new PartialPath(device));
        }
    }

    private void tryToDeleteLastCacheByDevice(PartialPath deviceId) throws WriteProcessException {
        if (!IoTDBDescriptor.getInstance().getConfig().isLastCacheEnabled()) {
            return;
        }
        try {
            MNode node = IoTDB.metaManager.getDeviceNode(deviceId);
            for (MNode measurementNode : node.getChildren().values()) {
                if (measurementNode == null) continue;
                ((MeasurementMNode)measurementNode).resetCache();
                logger.debug("[tryToDeleteLastCacheByDevice] Last cache for path: {} is set to null", (Object)measurementNode.getFullPath());
            }
        }
        catch (MetadataException e) {
            throw new WriteProcessException(e);
        }
    }

    public void loadNewTsFile(TsFileResource newTsFileResource) throws LoadFileException {
        File tsfileToBeInserted = newTsFileResource.getTsFile();
        long newFilePartitionId = newTsFileResource.getTimePartitionWithCheck();
        this.writeLock("loadNewTsFile");
        try {
            List<TsFileResource> sequenceList = this.tsFileManagement.getTsFileListByTimePartition(true, newFilePartitionId);
            int insertPos = this.findInsertionPosition(newTsFileResource, sequenceList);
            LoadTsFileType tsFileType = this.getLoadingTsFileType(insertPos, sequenceList);
            String renameInfo = tsFileType == LoadTsFileType.LOAD_SEQUENCE ? "sequence" : "unsequence";
            newTsFileResource.setSeq(tsFileType == LoadTsFileType.LOAD_SEQUENCE);
            String newFileName = this.getLoadingTsFileName(tsFileType, insertPos, newTsFileResource, sequenceList);
            if (!newFileName.equals(tsfileToBeInserted.getName())) {
                logger.info("TsFile {} must be renamed to {} for loading into the " + renameInfo + " list.", (Object)tsfileToBeInserted.getName(), (Object)newFileName);
                newTsFileResource.setFile(this.fsFactory.getFile(tsfileToBeInserted.getParentFile(), newFileName));
            }
            this.loadTsFileByType(tsFileType, tsfileToBeInserted, newTsFileResource, newFilePartitionId);
            this.resetLastCacheWhenLoadingTsfile(newTsFileResource);
            this.updateLatestTimeMap(newTsFileResource);
            long partitionNum = newTsFileResource.getTimePartition();
            this.updatePartitionFileVersion(partitionNum, newTsFileResource.getVersion());
            logger.info("TsFile {} is successfully loaded in {} list.", (Object)newFileName, (Object)renameInfo);
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("Failed to append the tsfile {} to storage group processor {} because the disk space is insufficient.", (Object)tsfileToBeInserted.getAbsolutePath(), (Object)tsfileToBeInserted.getParentFile().getName());
            IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
            throw new LoadFileException(e);
        }
        catch (WriteProcessException | IllegalPathException e) {
            logger.error("Failed to reset last cache when loading file {}", (Object)newTsFileResource.getTsFilePath());
            throw new LoadFileException(e);
        }
        catch (IOException e) {
            logger.error("Failed to add tsfile {} to tsfile management", (Object)tsfileToBeInserted.getAbsolutePath());
            throw new LoadFileException(e);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void setPartitionFileVersionToMax(long partition, long version) {
        this.partitionMaxFileVersions.compute(partition, (prt, oldVer) -> this.computeMaxVersion((Long)oldVer, version));
    }

    private long computeMaxVersion(Long oldVersion, Long newVersion) {
        if (oldVersion == null) {
            return newVersion;
        }
        return Math.max(oldVersion, newVersion);
    }

    private Long getTsFileResourceEstablishTime(TsFileResource tsFileResource) {
        String tsFileName = tsFileResource.getTsFile().getName();
        return Long.parseLong(tsFileName.split("-")[0]);
    }

    private LoadTsFileType getLoadingTsFileType(int insertPos, List<TsFileResource> sequenceList) {
        if (insertPos == -3) {
            return LoadTsFileType.LOAD_UNSEQUENCE;
        }
        if (insertPos == sequenceList.size() - 1) {
            return LoadTsFileType.LOAD_SEQUENCE;
        }
        long preTime = insertPos == -1 ? 0L : this.getTsFileResourceEstablishTime(sequenceList.get(insertPos));
        long subsequenceTime = this.getTsFileResourceEstablishTime(sequenceList.get(insertPos + 1));
        return preTime == subsequenceTime ? LoadTsFileType.LOAD_UNSEQUENCE : LoadTsFileType.LOAD_SEQUENCE;
    }

    private int findInsertionPosition(TsFileResource newTsFileResource, List<TsFileResource> sequenceList) {
        int insertPos = -1;
        int i = 0;
        while (i < sequenceList.size()) {
            TsFileResource localFile = sequenceList.get(i);
            if (!localFile.isClosed() && localFile.getProcessor() != null) {
                this.syncCloseOneTsFileProcessor(true, localFile.getProcessor());
            }
            int fileComparison = this.compareTsFileDevices(newTsFileResource, localFile);
            switch (fileComparison) {
                case 0: {
                    return -3;
                }
                case -1: {
                    return i - 1;
                }
            }
            insertPos = i++;
        }
        return insertPos;
    }

    private int compareTsFileDevices(TsFileResource fileA, TsFileResource fileB) {
        boolean hasPre = false;
        boolean hasSubsequence = false;
        Set<String> fileADevices = fileA.getDevices();
        Set<String> fileBDevices = fileB.getDevices();
        for (String device : fileADevices) {
            if (!fileBDevices.contains(device)) continue;
            long startTimeA = fileA.getStartTime(device);
            long endTimeA = fileA.getEndTime(device);
            long startTimeB = fileB.getStartTime(device);
            long endTimeB = fileB.getEndTime(device);
            if (startTimeA > endTimeB) {
                hasPre = true;
                continue;
            }
            if (startTimeB > endTimeA) {
                hasSubsequence = true;
                continue;
            }
            return 0;
        }
        if (hasPre && hasSubsequence) {
            return 0;
        }
        if (!hasPre && hasSubsequence) {
            return -1;
        }
        return 1;
    }

    public void removeFullyOverlapFiles(TsFileResource resource) {
        this.writeLock("removeFullyOverlapFiles");
        try {
            Iterator<TsFileResource> iterator = this.tsFileManagement.getIterator(true);
            this.removeFullyOverlapFiles(resource, iterator, true);
            iterator = this.tsFileManagement.getIterator(false);
            this.removeFullyOverlapFiles(resource, iterator, false);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFullyOverlapFiles(TsFileResource newTsFile, Iterator<TsFileResource> iterator, boolean isSeq) {
        while (iterator.hasNext()) {
            TsFileResource existingTsFile = iterator.next();
            if (!newTsFile.isPlanRangeCovers(existingTsFile) || newTsFile.getTsFile().equals(existingTsFile.getTsFile()) || !existingTsFile.tryWriteLock()) continue;
            logger.info("{} is covered by {}: [{}, {}], [{}, {}], remove it", new Object[]{existingTsFile, newTsFile, existingTsFile.minPlanIndex, existingTsFile.maxPlanIndex, newTsFile.minPlanIndex, newTsFile.maxPlanIndex});
            try {
                this.removeFullyOverlapFile(existingTsFile, iterator, isSeq);
            }
            catch (Exception e) {
                logger.error("Something gets wrong while removing FullyOverlapFiles: {}", (Object)existingTsFile.getTsFile().getAbsolutePath(), (Object)e);
            }
            finally {
                existingTsFile.writeUnlock();
            }
        }
    }

    private void removeFullyOverlapFile(TsFileResource tsFileResource, Iterator<TsFileResource> iterator, boolean isSeq) {
        logger.info("Removing a covered file {}, closed: {}", (Object)tsFileResource, (Object)tsFileResource.isClosed());
        if (!tsFileResource.isClosed()) {
            try {
                long timePartition = tsFileResource.getTimePartition();
                TreeMap<Long, TsFileProcessor> fileProcessorMap = isSeq ? this.workSequenceTsFileProcessors : this.workUnsequenceTsFileProcessors;
                TsFileProcessor tsFileProcessor = (TsFileProcessor)fileProcessorMap.get(timePartition);
                if (tsFileProcessor != null && tsFileProcessor.getTsFileResource() == tsFileResource) {
                    tsFileProcessor.syncClose();
                    fileProcessorMap.remove(timePartition);
                }
            }
            catch (Exception e) {
                logger.error("Cannot close {}", (Object)tsFileResource, (Object)e);
            }
        }
        this.tsFileManagement.remove(tsFileResource, isSeq);
        iterator.remove();
        tsFileResource.remove();
    }

    private String getLoadingTsFileName(LoadTsFileType tsFileType, int insertIndex, TsFileResource newTsFileResource, List<TsFileResource> sequenceList) {
        long timePartitionId = newTsFileResource.getTimePartition();
        if (tsFileType == LoadTsFileType.LOAD_UNSEQUENCE || insertIndex == sequenceList.size() - 1) {
            return this.getNewTsFileName(System.currentTimeMillis(), this.getAndSetNewVersion(timePartitionId, newTsFileResource), 0, 0);
        }
        long preTime = insertIndex == -1 ? 0L : this.getTsFileResourceEstablishTime(sequenceList.get(insertIndex));
        long subsequenceTime = this.getTsFileResourceEstablishTime(sequenceList.get(insertIndex + 1));
        long meanTime = preTime + (subsequenceTime - preTime >> 1);
        return this.getNewTsFileName(meanTime, this.getAndSetNewVersion(timePartitionId, newTsFileResource), 0, 0);
    }

    private long getAndSetNewVersion(long timePartitionId, TsFileResource tsFileResource) {
        long version = this.partitionMaxFileVersions.getOrDefault(timePartitionId, -1L) + 1L;
        this.partitionMaxFileVersions.put(timePartitionId, version);
        tsFileResource.setVersion(version);
        return version;
    }

    private void updateLatestTimeMap(TsFileResource newTsFileResource) {
        for (String device : newTsFileResource.getDevices()) {
            Map latestFlushTimeForPartition;
            long endTime = newTsFileResource.getEndTime(device);
            long timePartitionId = StorageEngine.getTimePartition(endTime);
            if (!this.latestTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap()).containsKey(device) || this.latestTimeForEachDevice.get(timePartitionId).get(device) < endTime) {
                this.latestTimeForEachDevice.get(timePartitionId).put(device, endTime);
            }
            if ((latestFlushTimeForPartition = (Map)this.partitionLatestFlushedTimeForEachDevice.getOrDefault(timePartitionId, new HashMap())).getOrDefault(device, Long.MIN_VALUE) < endTime) {
                this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap()).put(device, endTime);
            }
            if (this.globalLatestFlushedTimeForEachDevice.getOrDefault(device, Long.MIN_VALUE) >= endTime) continue;
            this.globalLatestFlushedTimeForEachDevice.put(device, endTime);
        }
    }

    private boolean loadTsFileByType(LoadTsFileType type, File tsFileToLoad, TsFileResource tsFileResource, long filePartitionId) throws LoadFileException, DiskSpaceInsufficientException, IOException {
        File targetFile;
        switch (type) {
            case LOAD_UNSEQUENCE: {
                targetFile = this.fsFactory.getFile(DirectoryManager.getInstance().getNextFolderForUnSequenceFile(), this.logicalStorageGroupName + File.separatorChar + this.virtualStorageGroupId + File.separatorChar + filePartitionId + File.separator + tsFileResource.getTsFile().getName());
                tsFileResource.setFile(targetFile);
                if (this.tsFileManagement.contains(tsFileResource, false)) {
                    logger.error("The file {} has already been loaded in unsequence list", (Object)tsFileResource);
                    return false;
                }
                this.tsFileManagement.add(tsFileResource, false);
                logger.info("Load tsfile in unsequence list, move file from {} to {}", (Object)tsFileToLoad.getAbsolutePath(), (Object)targetFile.getAbsolutePath());
                break;
            }
            case LOAD_SEQUENCE: {
                targetFile = this.fsFactory.getFile(DirectoryManager.getInstance().getNextFolderForSequenceFile(), this.logicalStorageGroupName + File.separatorChar + this.virtualStorageGroupId + File.separatorChar + filePartitionId + File.separator + tsFileResource.getTsFile().getName());
                tsFileResource.setFile(targetFile);
                if (this.tsFileManagement.contains(tsFileResource, true)) {
                    logger.error("The file {} has already been loaded in sequence list", (Object)tsFileResource);
                    return false;
                }
                this.tsFileManagement.add(tsFileResource, true);
                logger.info("Load tsfile in sequence list, move file from {} to {}", (Object)tsFileToLoad.getAbsolutePath(), (Object)targetFile.getAbsolutePath());
                break;
            }
            default: {
                throw new LoadFileException(String.format("Unsupported type of loading tsfile : %s", new Object[]{type}));
            }
        }
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        try {
            org.apache.commons.io.FileUtils.moveFile((File)tsFileToLoad, (File)targetFile);
        }
        catch (IOException e) {
            logger.error("File renaming failed when loading tsfile. Origin: {}, Target: {}", new Object[]{tsFileToLoad.getAbsolutePath(), targetFile.getAbsolutePath(), e});
            throw new LoadFileException(String.format("File renaming failed when loading tsfile. Origin: %s, Target: %s, because %s", tsFileToLoad.getAbsolutePath(), targetFile.getAbsolutePath(), e.getMessage()));
        }
        File resourceFileToLoad = this.fsFactory.getFile(tsFileToLoad.getAbsolutePath() + ".resource");
        File targetResourceFile = this.fsFactory.getFile(targetFile.getAbsolutePath() + ".resource");
        try {
            org.apache.commons.io.FileUtils.moveFile((File)resourceFileToLoad, (File)targetResourceFile);
        }
        catch (IOException e) {
            logger.error("File renaming failed when loading .resource file. Origin: {}, Target: {}", new Object[]{resourceFileToLoad.getAbsolutePath(), targetResourceFile.getAbsolutePath(), e});
            throw new LoadFileException(String.format("File renaming failed when loading .resource file. Origin: %s, Target: %s, because %s", resourceFileToLoad.getAbsolutePath(), targetResourceFile.getAbsolutePath(), e.getMessage()));
        }
        File modFileToLoad = this.fsFactory.getFile(tsFileToLoad.getAbsolutePath() + ".mods");
        if (modFileToLoad.exists()) {
            File targetModFile = this.fsFactory.getFile(targetFile.getAbsolutePath() + ".mods");
            try {
                Files.deleteIfExists(targetFile.toPath());
            }
            catch (IOException e) {
                logger.warn("Cannot delete localModFile {}", (Object)targetModFile, (Object)e);
            }
            try {
                org.apache.commons.io.FileUtils.moveFile((File)modFileToLoad, (File)targetModFile);
            }
            catch (IOException e) {
                logger.error("File renaming failed when loading .mod file. Origin: {}, Target: {}", new Object[]{resourceFileToLoad.getAbsolutePath(), targetModFile.getAbsolutePath(), e});
                throw new LoadFileException(String.format("File renaming failed when loading .mod file. Origin: %s, Target: %s, because %s", resourceFileToLoad.getAbsolutePath(), targetModFile.getAbsolutePath(), e.getMessage()));
            }
            finally {
                tsFileResource.setModFile(null);
            }
        }
        this.updatePartitionFileVersion(filePartitionId, tsFileResource.getVersion());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTsfile(File tsfieToBeDeleted) {
        TsFileResource tsFileResourceToBeDeleted;
        block9: {
            this.writeLock("deleteTsfile");
            tsFileResourceToBeDeleted = null;
            try {
                Iterator<TsFileResource> sequenceIterator = this.tsFileManagement.getIterator(true);
                while (sequenceIterator.hasNext()) {
                    TsFileResource sequenceResource = sequenceIterator.next();
                    if (!sequenceResource.getTsFile().getName().equals(tsfieToBeDeleted.getName())) continue;
                    tsFileResourceToBeDeleted = sequenceResource;
                    this.tsFileManagement.remove(tsFileResourceToBeDeleted, true);
                    break;
                }
                if (tsFileResourceToBeDeleted != null) break block9;
                Iterator<TsFileResource> unsequenceIterator = this.tsFileManagement.getIterator(false);
                while (unsequenceIterator.hasNext()) {
                    TsFileResource unsequenceResource = unsequenceIterator.next();
                    if (!unsequenceResource.getTsFile().getName().equals(tsfieToBeDeleted.getName())) continue;
                    tsFileResourceToBeDeleted = unsequenceResource;
                    this.tsFileManagement.remove(tsFileResourceToBeDeleted, false);
                    break;
                }
            }
            finally {
                this.writeUnlock();
            }
        }
        if (tsFileResourceToBeDeleted == null) {
            return false;
        }
        tsFileResourceToBeDeleted.writeLock();
        try {
            tsFileResourceToBeDeleted.remove();
            logger.info("Delete tsfile {} successfully.", (Object)tsFileResourceToBeDeleted.getTsFile());
        }
        finally {
            tsFileResourceToBeDeleted.writeUnlock();
        }
        return true;
    }

    public Collection<TsFileProcessor> getWorkSequenceTsFileProcessors() {
        return this.workSequenceTsFileProcessors.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveTsfile(File fileToBeMoved, File targetDir) {
        TsFileResource tsFileResourceToBeMoved;
        block9: {
            this.writeLock("moveTsfile");
            tsFileResourceToBeMoved = null;
            try {
                Iterator<TsFileResource> sequenceIterator = this.tsFileManagement.getIterator(true);
                while (sequenceIterator.hasNext()) {
                    TsFileResource sequenceResource = sequenceIterator.next();
                    if (!sequenceResource.getTsFile().getName().equals(fileToBeMoved.getName())) continue;
                    tsFileResourceToBeMoved = sequenceResource;
                    this.tsFileManagement.remove(tsFileResourceToBeMoved, true);
                    break;
                }
                if (tsFileResourceToBeMoved != null) break block9;
                Iterator<TsFileResource> unsequenceIterator = this.tsFileManagement.getIterator(false);
                while (unsequenceIterator.hasNext()) {
                    TsFileResource unsequenceResource = unsequenceIterator.next();
                    if (!unsequenceResource.getTsFile().getName().equals(fileToBeMoved.getName())) continue;
                    tsFileResourceToBeMoved = unsequenceResource;
                    this.tsFileManagement.remove(tsFileResourceToBeMoved, false);
                    break;
                }
            }
            finally {
                this.writeUnlock();
            }
        }
        if (tsFileResourceToBeMoved == null) {
            return false;
        }
        tsFileResourceToBeMoved.writeLock();
        try {
            tsFileResourceToBeMoved.moveTo(targetDir);
            logger.info("Move tsfile {} to target dir {} successfully.", (Object)tsFileResourceToBeMoved.getTsFile(), (Object)targetDir.getPath());
        }
        finally {
            tsFileResourceToBeMoved.writeUnlock();
        }
        return true;
    }

    public Collection<TsFileProcessor> getWorkUnsequenceTsFileProcessors() {
        return this.workUnsequenceTsFileProcessors.values();
    }

    public void setDataTTL(long dataTTL) {
        this.dataTTL = dataTTL;
        this.checkFilesTTL();
    }

    public List<TsFileResource> getSequenceFileTreeSet() {
        return this.tsFileManagement.getTsFileList(true);
    }

    public List<TsFileResource> getUnSequenceFileList() {
        return this.tsFileManagement.getTsFileList(false);
    }

    public String getVirtualStorageGroupId() {
        return this.virtualStorageGroupId;
    }

    public String getStorageGroupPath() {
        return this.logicalStorageGroupName + File.separator + this.virtualStorageGroupId;
    }

    public StorageGroupInfo getStorageGroupInfo() {
        return this.storageGroupInfo;
    }

    public boolean isFileAlreadyExist(TsFileResource tsFileResource, long partitionNum) {
        return this.isFileAlreadyExistInWorking(tsFileResource, partitionNum, this.getWorkSequenceTsFileProcessors()) || this.isFileAlreadyExistInWorking(tsFileResource, partitionNum, this.getWorkUnsequenceTsFileProcessors()) || this.isFileAlreadyExistInClosed(tsFileResource, partitionNum, this.getSequenceFileTreeSet()) || this.isFileAlreadyExistInClosed(tsFileResource, partitionNum, this.getUnSequenceFileList());
    }

    private boolean isFileAlreadyExistInClosed(TsFileResource tsFileResource, long partitionNum, Collection<TsFileResource> existingFiles) {
        for (TsFileResource resource : existingFiles) {
            if (resource.getTimePartition() != partitionNum || resource.getMaxPlanIndex() < tsFileResource.getMaxPlanIndex()) continue;
            logger.info("{} is covered by a closed file {}: [{}, {}] [{}, {}]", new Object[]{tsFileResource, resource, tsFileResource.minPlanIndex, tsFileResource.maxPlanIndex, resource.minPlanIndex, resource.maxPlanIndex});
            return true;
        }
        return false;
    }

    private boolean isFileAlreadyExistInWorking(TsFileResource tsFileResource, long partitionNum, Collection<TsFileProcessor> workingProcessors) {
        for (TsFileProcessor workingProcesssor : workingProcessors) {
            boolean isCovered;
            if (workingProcesssor.getTimeRangeId() != partitionNum) continue;
            TsFileResource workResource = workingProcesssor.getTsFileResource();
            boolean bl = isCovered = workResource.getMaxPlanIndex() >= tsFileResource.getMaxPlanIndex();
            if (isCovered) {
                logger.info("{} is covered by a working file {}: [{}, {}] [{}, {}]", new Object[]{tsFileResource, workResource, tsFileResource.minPlanIndex, tsFileResource.maxPlanIndex, workResource.minPlanIndex, workResource.maxPlanIndex});
            }
            return isCovered;
        }
        return false;
    }

    public void removePartitions(TimePartitionFilter filter) {
        this.writeLock("removePartitions");
        try {
            CompactionMergeTaskPoolManager.getInstance().abortCompaction(this.logicalStorageGroupName);
            MergeManager.getINSTANCE().abortMerge(this.logicalStorageGroupName);
            this.removePartitions(filter, this.workSequenceTsFileProcessors.entrySet());
            this.removePartitions(filter, this.workUnsequenceTsFileProcessors.entrySet());
            this.removePartitions(filter, this.tsFileManagement.getIterator(true), true);
            this.removePartitions(filter, this.tsFileManagement.getIterator(false), false);
        }
        finally {
            this.writeUnlock();
        }
    }

    private void removePartitions(TimePartitionFilter filter, Set<Map.Entry<Long, TsFileProcessor>> processorEntrys) {
        Iterator<Map.Entry<Long, TsFileProcessor>> iterator = processorEntrys.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, TsFileProcessor> longTsFileProcessorEntry = iterator.next();
            long partitionId = longTsFileProcessorEntry.getKey();
            TsFileProcessor processor = longTsFileProcessorEntry.getValue();
            if (!filter.satisfy(this.logicalStorageGroupName, partitionId)) continue;
            processor.syncClose();
            iterator.remove();
            this.updateLatestFlushTimeToPartition(partitionId, Long.MIN_VALUE);
            logger.debug("{} is removed during deleting partitions", (Object)processor.getTsFileResource().getTsFilePath());
        }
    }

    private void removePartitions(TimePartitionFilter filter, Iterator<TsFileResource> iterator, boolean sequence) {
        while (iterator.hasNext()) {
            TsFileResource tsFileResource = iterator.next();
            if (!filter.satisfy(this.logicalStorageGroupName, tsFileResource.getTimePartition())) continue;
            tsFileResource.remove();
            this.tsFileManagement.remove(tsFileResource, sequence);
            this.updateLatestFlushTimeToPartition(tsFileResource.getTimePartition(), Long.MIN_VALUE);
            logger.debug("{} is removed during deleting partitions", (Object)tsFileResource.getTsFilePath());
        }
    }

    public TsFileManagement getTsFileManagement() {
        return this.tsFileManagement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(InsertRowsOfOneDevicePlan insertRowsOfOneDevicePlan) throws WriteProcessException {
        this.writeLock("InsertRowsOfOneDevice");
        try {
            boolean isSequence = false;
            InsertRowPlan[] rowPlans = insertRowsOfOneDevicePlan.getRowPlans();
            int rowPlansLength = rowPlans.length;
            for (int i = 0; i < rowPlansLength; ++i) {
                InsertRowPlan plan = rowPlans[i];
                if (!this.isAlive(plan.getTime()) || insertRowsOfOneDevicePlan.isExecuted(i)) continue;
                long timePartitionId = StorageEngine.getTimePartition(plan.getTime());
                this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap());
                if (!isSequence) {
                    boolean bl = isSequence = plan.getTime() > this.partitionLatestFlushedTimeForEachDevice.get(timePartitionId).getOrDefault(plan.getDeviceId().getFullPath(), Long.MIN_VALUE);
                }
                if (!isSequence && IoTDBDescriptor.getInstance().getConfig().isEnableDiscardOutOfOrderData()) {
                    return;
                }
                this.latestTimeForEachDevice.computeIfAbsent(timePartitionId, l -> new HashMap());
                this.insertToTsFileProcessor(plan, isSequence, timePartitionId);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public long getPartitionMaxFileVersions(long partitionId) {
        return this.partitionMaxFileVersions.getOrDefault(partitionId, -1L);
    }

    public void setCustomCloseFileListeners(List<CloseFileListener> customCloseFileListeners) {
        this.customCloseFileListeners = customCloseFileListeners;
    }

    public void setCustomFlushListeners(List<FlushListener> customFlushListeners) {
        this.customFlushListeners = customFlushListeners;
    }

    public String getInsertWriteLockHolder() {
        return this.insertWriteLockHolder;
    }

    @FunctionalInterface
    public static interface TimePartitionFilter {
        public boolean satisfy(String var1, long var2);
    }

    @FunctionalInterface
    public static interface CloseCompactionMergeCallBack {
        public void call(boolean var1, long var2);
    }

    @FunctionalInterface
    public static interface UpgradeTsFileResourceCallBack {
        public void call(TsFileResource var1);
    }

    @FunctionalInterface
    public static interface UpdateEndTimeCallBack {
        public boolean call(TsFileProcessor var1);
    }

    @FunctionalInterface
    public static interface CloseTsFileCallBack {
        public void call(TsFileProcessor var1) throws TsFileProcessorException, IOException;
    }

    private static enum LoadTsFileType {
        LOAD_SEQUENCE,
        LOAD_UNSEQUENCE;

    }

    public class CompactionOnePartitionTask
    extends StorageGroupCompactionTask {
        private long partition;

        CompactionOnePartitionTask(String storageGroupName, long partition) {
            super(storageGroupName);
            this.partition = partition;
        }

        @Override
        public Void call() {
            StorageGroupProcessor.this.syncCompactOnePartition(this.partition, IoTDBDescriptor.getInstance().getConfig().isForceFullMerge());
            this.clearCompactionStatus();
            return null;
        }
    }

    public class CompactionAllPartitionTask
    extends StorageGroupCompactionTask {
        CompactionAllPartitionTask(String storageGroupName) {
            super(storageGroupName);
        }

        @Override
        public Void call() {
            Iterator iterator = StorageGroupProcessor.this.partitionLatestFlushedTimeForEachDevice.keySet().iterator();
            while (iterator.hasNext()) {
                long timePartitionId = (Long)iterator.next();
                StorageGroupProcessor.this.syncCompactOnePartition(timePartitionId, IoTDBDescriptor.getInstance().getConfig().isForceFullMerge());
            }
            this.clearCompactionStatus();
            return null;
        }
    }
}

