/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics.client;

import java.util.regex.Pattern;

public interface Sanitizer {
    public static final Sanitizer NO_OP = new Sanitizer(){

        @Override
        public String apply(String name) {
            return name;
        }
    };
    public static final Sanitizer LAST_PASS = new Sanitizer(){
        private final Pattern disallowedCharacters = Pattern.compile("([^A-Za-z0-9.:\\-_]|[\\[\\]]|\\s)");
        private final int lengthLimit = 256;

        @Override
        public String apply(String name) {
            if (name == null) {
                return null;
            }
            String sanitized = this.disallowedCharacters.matcher(name).replaceAll("");
            if (sanitized.length() > 256) {
                return sanitized.substring(sanitized.length() - 256, sanitized.length());
            }
            return sanitized;
        }
    };

    public String apply(String var1);
}

