/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.datastructure.primitive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.udf.datastructure.Cache;
import org.apache.iotdb.db.query.udf.datastructure.primitive.IntList;
import org.apache.iotdb.db.query.udf.datastructure.primitive.SerializableIntList;

public class ElasticSerializableIntList
implements IntList {
    protected long queryId;
    protected int internalIntListCapacity;
    protected LRUCache cache;
    protected List<SerializableIntList> intLists;
    protected int size;

    public ElasticSerializableIntList(long queryId, float memoryLimitInMB, int cacheSize) throws QueryProcessException {
        this.queryId = queryId;
        int allocatableCapacity = SerializableIntList.calculateCapacity(memoryLimitInMB);
        this.internalIntListCapacity = allocatableCapacity / cacheSize;
        if (this.internalIntListCapacity == 0) {
            cacheSize = 1;
            this.internalIntListCapacity = allocatableCapacity;
        }
        this.cache = new LRUCache(cacheSize);
        this.intLists = new ArrayList<SerializableIntList>();
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int get(int index) throws IOException {
        return this.cache.get(index / this.internalIntListCapacity).get(index % this.internalIntListCapacity);
    }

    @Override
    public void put(int value) throws IOException {
        this.checkExpansion();
        this.cache.get(this.size / this.internalIntListCapacity).put(value);
        ++this.size;
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.intLists.clear();
        this.size = 0;
    }

    private void checkExpansion() {
        if (this.size % this.internalIntListCapacity == 0) {
            this.intLists.add(SerializableIntList.newSerializableIntList(this.queryId));
        }
    }

    private class LRUCache
    extends Cache {
        LRUCache(int capacity) {
            super(capacity);
        }

        SerializableIntList get(int targetIndex) throws IOException {
            if (!this.removeFirstOccurrence(targetIndex)) {
                if (this.cacheCapacity <= this.cacheSize) {
                    int lastIndex = this.removeLast();
                    ElasticSerializableIntList.this.intLists.get(lastIndex).serialize();
                }
                ElasticSerializableIntList.this.intLists.get(targetIndex).deserialize();
            }
            this.addFirst(targetIndex);
            return ElasticSerializableIntList.this.intLists.get(targetIndex);
        }
    }
}

