/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.builtin;

import java.io.IOException;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.udf.api.UDTF;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.collector.PointCollector;
import org.apache.iotdb.db.query.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.db.query.udf.api.exception.UDFException;
import org.apache.iotdb.db.query.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Pair;

public abstract class UDTFSelectK
implements UDTF {
    protected int k;
    protected TSDataType dataType;
    protected PriorityQueue<Pair<Long, Integer>> intPQ;
    protected PriorityQueue<Pair<Long, Long>> longPQ;
    protected PriorityQueue<Pair<Long, Float>> floatPQ;
    protected PriorityQueue<Pair<Long, Double>> doublePQ;
    protected PriorityQueue<Pair<Long, String>> stringPQ;

    @Override
    public void validate(UDFParameterValidator validator) throws UDFException {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE, TSDataType.TEXT).validateRequiredAttribute("k").validate(k -> 0 < (Integer)k && (Integer)k <= 1000, "k has to be greater than 0 and less than or equal to 1000.", (Object)validator.getParameters().getInt("k"));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws MetadataException, UDFInputSeriesDataTypeNotValidException {
        this.k = parameters.getInt("k");
        this.dataType = parameters.getDataType(0);
        this.constructPQ();
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(this.dataType);
    }

    protected abstract void constructPQ() throws UDFInputSeriesDataTypeNotValidException;

    @Override
    public void transform(Row row, PointCollector collector) throws UDFInputSeriesDataTypeNotValidException {
        switch (this.dataType) {
            case INT32: {
                this.transformInt(row.getTime(), row.getInt(0));
                break;
            }
            case INT64: {
                this.transformLong(row.getTime(), row.getLong(0));
                break;
            }
            case FLOAT: {
                this.transformFloat(row.getTime(), row.getFloat(0));
                break;
            }
            case DOUBLE: {
                this.transformDouble(row.getTime(), row.getDouble(0));
                break;
            }
            case TEXT: {
                this.transformString(row.getTime(), row.getString(0));
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, this.dataType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE, TSDataType.TEXT);
            }
        }
    }

    protected abstract void transformInt(long var1, int var3);

    protected abstract void transformLong(long var1, long var3);

    protected abstract void transformFloat(long var1, float var3);

    protected abstract void transformDouble(long var1, double var3);

    protected abstract void transformString(long var1, String var3);

    @Override
    public void terminate(PointCollector collector) throws UDFInputSeriesDataTypeNotValidException, IOException, QueryProcessException {
        switch (this.dataType) {
            case INT32: {
                for (Pair pair : this.intPQ.stream().sorted(Comparator.comparing(p -> (Long)p.left)).collect(Collectors.toList())) {
                    collector.putInt((Long)pair.left, (Integer)pair.right);
                }
                break;
            }
            case INT64: {
                for (Pair pair : this.longPQ.stream().sorted(Comparator.comparing(p -> (Long)p.left)).collect(Collectors.toList())) {
                    collector.putLong((Long)pair.left, (Long)pair.right);
                }
                break;
            }
            case FLOAT: {
                for (Pair pair : this.floatPQ.stream().sorted(Comparator.comparing(p -> (Long)p.left)).collect(Collectors.toList())) {
                    collector.putFloat((Long)pair.left, ((Float)pair.right).floatValue());
                }
                break;
            }
            case DOUBLE: {
                for (Pair pair : this.doublePQ.stream().sorted(Comparator.comparing(p -> (Long)p.left)).collect(Collectors.toList())) {
                    collector.putDouble((Long)pair.left, (Double)pair.right);
                }
                break;
            }
            case TEXT: {
                for (Pair pair : this.stringPQ.stream().sorted(Comparator.comparing(p -> (Long)p.left)).collect(Collectors.toList())) {
                    collector.putString((Long)pair.left, (String)pair.right);
                }
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, this.dataType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE, TSDataType.TEXT);
            }
        }
    }
}

