/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.api.customizer.config;

import java.time.ZoneId;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.udf.api.customizer.config.UDFConfigurations;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class UDTFConfigurations
extends UDFConfigurations {
    protected final ZoneId zoneId;
    protected AccessStrategy accessStrategy;

    public UDTFConfigurations(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public UDTFConfigurations setOutputDataType(TSDataType outputDataType) {
        this.outputDataType = outputDataType;
        return this;
    }

    public AccessStrategy getAccessStrategy() {
        return this.accessStrategy;
    }

    public UDTFConfigurations setAccessStrategy(AccessStrategy accessStrategy) {
        this.accessStrategy = accessStrategy;
        if (accessStrategy instanceof SlidingTimeWindowAccessStrategy && ((SlidingTimeWindowAccessStrategy)accessStrategy).getZoneId() == null) {
            ((SlidingTimeWindowAccessStrategy)accessStrategy).setZoneId(this.zoneId);
        }
        return this;
    }

    @Override
    public void check() throws QueryProcessException {
        super.check();
        if (this.accessStrategy == null) {
            throw new QueryProcessException("Access strategy is not set.");
        }
        this.accessStrategy.check();
    }
}

