/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileLock;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.engine.storagegroup.timeindex.ITimeIndex;
import org.apache.iotdb.db.engine.storagegroup.timeindex.TimeIndexLevel;
import org.apache.iotdb.db.engine.upgrade.UpgradeTask;
import org.apache.iotdb.db.exception.PartitionViolationException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.service.UpgradeSevice;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileResource.class);
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private File file;
    public static final String RESOURCE_SUFFIX = ".resource";
    static final String TEMP_SUFFIX = ".temp";
    public static final byte VERSION_NUMBER = 1;
    private byte timeIndexType;
    protected ITimeIndex timeIndex;
    private ModificationFile modFile;
    private volatile boolean closed = false;
    private volatile boolean deleted = false;
    private volatile boolean isMerging = false;
    protected TsFileLock tsFileLock = new TsFileLock();
    private final Random random = new Random();
    private FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    private List<TsFileResource> upgradedResources;
    private StorageGroupProcessor.UpgradeTsFileResourceCallBack upgradeTsFileResourceCallBack;
    private boolean isSeq;
    protected long maxPlanIndex = Long.MIN_VALUE;
    protected long minPlanIndex = Long.MAX_VALUE;
    private long version = 0L;
    private Map<PartialPath, List<ChunkMetadata>> pathToChunkMetadataListMap;
    private Map<PartialPath, List<ReadOnlyMemChunk>> pathToReadOnlyMemChunkMap;
    private Map<PartialPath, TimeseriesMetadata> pathToTimeSeriesMetadataMap;
    private TsFileResource originTsFileResource;
    private TsFileProcessor processor;

    public TsFileResource() {
    }

    public TsFileResource(TsFileResource other) throws IOException {
        this.file = other.file;
        this.processor = other.processor;
        this.timeIndex = other.timeIndex;
        this.timeIndexType = other.timeIndexType;
        this.modFile = other.modFile;
        this.closed = other.closed;
        this.deleted = other.deleted;
        this.isMerging = other.isMerging;
        this.pathToChunkMetadataListMap = other.pathToChunkMetadataListMap;
        this.pathToReadOnlyMemChunkMap = other.pathToReadOnlyMemChunkMap;
        this.generatePathToTimeSeriesMetadataMap();
        this.tsFileLock = other.tsFileLock;
        this.fsFactory = other.fsFactory;
        this.maxPlanIndex = other.maxPlanIndex;
        this.minPlanIndex = other.minPlanIndex;
        this.version = FilePathUtils.splitAndGetTsFileVersion((String)this.file.getName());
    }

    public TsFileResource(File file) {
        this.file = file;
        this.version = FilePathUtils.splitAndGetTsFileVersion((String)this.file.getName());
        this.timeIndex = CONFIG.getTimeIndexLevel().getTimeIndex();
        this.timeIndexType = (byte)CONFIG.getTimeIndexLevel().ordinal();
    }

    public TsFileResource(File file, TsFileProcessor processor, int deviceNumInLastClosedTsFile) {
        this.file = file;
        this.version = FilePathUtils.splitAndGetTsFileVersion((String)this.file.getName());
        this.timeIndex = CONFIG.getTimeIndexLevel().getTimeIndex(deviceNumInLastClosedTsFile);
        this.timeIndexType = (byte)CONFIG.getTimeIndexLevel().ordinal();
        this.processor = processor;
    }

    public TsFileResource(PartialPath path, List<ReadOnlyMemChunk> readOnlyMemChunk, List<ChunkMetadata> chunkMetadataList, TsFileResource originTsFileResource) throws IOException {
        this.file = originTsFileResource.file;
        this.timeIndex = originTsFileResource.timeIndex;
        this.timeIndexType = originTsFileResource.timeIndexType;
        this.pathToReadOnlyMemChunkMap = new HashMap<PartialPath, List<ReadOnlyMemChunk>>();
        this.pathToReadOnlyMemChunkMap.put(path, readOnlyMemChunk);
        this.pathToChunkMetadataListMap = new HashMap<PartialPath, List<ChunkMetadata>>();
        this.pathToChunkMetadataListMap.put(path, chunkMetadataList);
        this.originTsFileResource = originTsFileResource;
        this.version = originTsFileResource.version;
        this.generatePathToTimeSeriesMetadataMap();
    }

    public TsFileResource(Map<PartialPath, List<ReadOnlyMemChunk>> pathToReadOnlyMemChunkMap, Map<PartialPath, List<ChunkMetadata>> pathToChunkMetadataListMap, TsFileResource originTsFileResource) throws IOException {
        this.file = originTsFileResource.file;
        this.timeIndex = originTsFileResource.timeIndex;
        this.timeIndexType = originTsFileResource.timeIndexType;
        this.pathToReadOnlyMemChunkMap = pathToReadOnlyMemChunkMap;
        this.pathToChunkMetadataListMap = pathToChunkMetadataListMap;
        this.originTsFileResource = originTsFileResource;
        this.version = originTsFileResource.version;
        this.generatePathToTimeSeriesMetadataMap();
    }

    public TsFileResource(File file, Map<String, Integer> deviceToIndex, long[] startTimes, long[] endTimes) {
        this.file = file;
        this.timeIndex = new DeviceTimeIndex(deviceToIndex, startTimes, endTimes);
        this.timeIndexType = 1;
    }

    public synchronized void serialize() throws IOException {
        try (BufferedOutputStream outputStream = this.fsFactory.getBufferedOutputStream(this.file + RESOURCE_SUFFIX + TEMP_SUFFIX);){
            ReadWriteIOUtils.write((byte)1, (OutputStream)outputStream);
            ReadWriteIOUtils.write((byte)this.timeIndexType, (OutputStream)outputStream);
            this.timeIndex.serialize(outputStream);
            ReadWriteIOUtils.write((long)this.maxPlanIndex, (OutputStream)outputStream);
            ReadWriteIOUtils.write((long)this.minPlanIndex, (OutputStream)outputStream);
            if (this.modFile != null && this.modFile.exists()) {
                String modFileName = new File(this.modFile.getFilePath()).getName();
                ReadWriteIOUtils.write((String)modFileName, (OutputStream)outputStream);
            }
        }
        File src = this.fsFactory.getFile(this.file + RESOURCE_SUFFIX + TEMP_SUFFIX);
        File dest = this.fsFactory.getFile(this.file + RESOURCE_SUFFIX);
        this.fsFactory.deleteIfExists(dest);
        this.fsFactory.moveFile(src, dest);
    }

    public void deserialize() throws IOException {
        try (BufferedInputStream inputStream = this.fsFactory.getBufferedInputStream(this.file + RESOURCE_SUFFIX);){
            String modFileName;
            this.readVersionNumber(inputStream);
            this.timeIndexType = ReadWriteIOUtils.readByte((InputStream)inputStream);
            this.timeIndex = TimeIndexLevel.valueOf(this.timeIndexType).getTimeIndex().deserialize(inputStream);
            this.maxPlanIndex = ReadWriteIOUtils.readLong((InputStream)inputStream);
            this.minPlanIndex = ReadWriteIOUtils.readLong((InputStream)inputStream);
            if (((InputStream)inputStream).available() > 0 && (modFileName = ReadWriteIOUtils.readString((InputStream)inputStream)) != null) {
                File modF = new File(this.file.getParentFile(), modFileName);
                this.modFile = new ModificationFile(modF.getPath());
            }
        }
    }

    public void deserializeFromOldFile() throws IOException {
        try (BufferedInputStream inputStream = this.fsFactory.getBufferedInputStream(this.file + RESOURCE_SUFFIX);){
            String modFileName;
            int i;
            int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
            HashMap<String, Integer> deviceMap = new HashMap<String, Integer>();
            long[] startTimesArray = new long[size];
            long[] endTimesArray = new long[size];
            for (i = 0; i < size; ++i) {
                String path = ReadWriteIOUtils.readString((InputStream)inputStream);
                long time = ReadWriteIOUtils.readLong((InputStream)inputStream);
                deviceMap.put(path, i);
                startTimesArray[i] = time;
            }
            size = ReadWriteIOUtils.readInt((InputStream)inputStream);
            for (i = 0; i < size; ++i) {
                long time;
                ReadWriteIOUtils.readString((InputStream)inputStream);
                endTimesArray[i] = time = ReadWriteIOUtils.readLong((InputStream)inputStream);
            }
            this.timeIndexType = 1;
            this.timeIndex = new DeviceTimeIndex(deviceMap, startTimesArray, endTimesArray);
            if (((InputStream)inputStream).available() > 0) {
                int versionSize = ReadWriteIOUtils.readInt((InputStream)inputStream);
                for (int i2 = 0; i2 < versionSize; ++i2) {
                    ReadWriteIOUtils.readLong((InputStream)inputStream);
                }
            }
            if (((InputStream)inputStream).available() > 0 && (modFileName = ReadWriteIOUtils.readString((InputStream)inputStream)) != null) {
                File modF = new File(this.file.getParentFile(), modFileName);
                this.modFile = new ModificationFile(modF.getPath());
            }
        }
    }

    private byte readVersionNumber(InputStream inputStream) throws IOException {
        return ReadWriteIOUtils.readByte((InputStream)inputStream);
    }

    public void updateStartTime(String device, long time) {
        this.timeIndex.updateStartTime(device, time);
    }

    public void putStartTime(String device, long time) {
        this.timeIndex.putStartTime(device, time);
    }

    public void updateEndTime(String device, long time) {
        this.timeIndex.updateEndTime(device, time);
    }

    public void putEndTime(String device, long time) {
        this.timeIndex.putEndTime(device, time);
    }

    public boolean resourceFileExists() {
        return this.fsFactory.getFile(this.file + RESOURCE_SUFFIX).exists();
    }

    public synchronized ModificationFile getModFile() {
        if (this.modFile == null) {
            this.modFile = new ModificationFile(this.file.getPath() + ".mods");
        }
        return this.modFile;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getTsFile() {
        return this.file;
    }

    public String getTsFilePath() {
        return this.file.getPath();
    }

    public long getTsFileSize() {
        return this.file.length();
    }

    public long getStartTime(String deviceId) {
        return this.timeIndex.getStartTime(deviceId);
    }

    public long getEndTime(String deviceId) {
        return this.timeIndex.getEndTime(deviceId);
    }

    public long getOrderTime(String deviceId, boolean ascending) {
        return ascending ? this.getStartTime(deviceId) : this.getEndTime(deviceId);
    }

    public long getFileStartTime() {
        long res = Long.MAX_VALUE;
        for (String deviceId : this.timeIndex.getDevices()) {
            res = Math.min(res, this.timeIndex.getStartTime(deviceId));
        }
        return res;
    }

    public long getFileEndTime() {
        long res = Long.MIN_VALUE;
        for (String deviceId : this.timeIndex.getDevices()) {
            res = Math.max(res, this.timeIndex.getEndTime(deviceId));
        }
        return res;
    }

    public Set<String> getDevices() {
        return this.timeIndex.getDevices();
    }

    public boolean endTimeEmpty() {
        return this.timeIndex.endTimeEmpty();
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void generatePathToTimeSeriesMetadataMap() throws IOException {
        this.pathToTimeSeriesMetadataMap = new HashMap<PartialPath, TimeseriesMetadata>();
        if (this.pathToChunkMetadataListMap == null || this.pathToReadOnlyMemChunkMap == null) {
            return;
        }
        for (PartialPath path : this.pathToChunkMetadataListMap.keySet()) {
            TSDataType dataType;
            TimeseriesMetadata timeSeriesMetadata = new TimeseriesMetadata();
            timeSeriesMetadata.setOffsetOfChunkMetaDataList(-1L);
            timeSeriesMetadata.setDataSizeOfChunkMetaDataList(-1);
            if (this.pathToChunkMetadataListMap.containsKey(path) && !this.pathToChunkMetadataListMap.get(path).isEmpty()) {
                timeSeriesMetadata.setMeasurementId(this.pathToChunkMetadataListMap.get(path).get(0).getMeasurementUid());
                dataType = this.pathToChunkMetadataListMap.get(path).get(0).getDataType();
                timeSeriesMetadata.setTSDataType(dataType);
            } else if (this.pathToReadOnlyMemChunkMap.containsKey(path) && !this.pathToReadOnlyMemChunkMap.get(path).isEmpty()) {
                timeSeriesMetadata.setMeasurementId(this.pathToReadOnlyMemChunkMap.get(path).get(0).getMeasurementUid());
                dataType = this.pathToReadOnlyMemChunkMap.get(path).get(0).getDataType();
                timeSeriesMetadata.setTSDataType(dataType);
            }
            if (timeSeriesMetadata.getTSDataType() != null) {
                Statistics seriesStatistics = Statistics.getStatsByType((TSDataType)timeSeriesMetadata.getTSDataType());
                for (ChunkMetadata chunkMetadata : this.pathToChunkMetadataListMap.get(path)) {
                    seriesStatistics.mergeStatistics(chunkMetadata.getStatistics());
                }
                for (ReadOnlyMemChunk memChunk : this.pathToReadOnlyMemChunkMap.get(path)) {
                    if (memChunk.isEmpty()) continue;
                    seriesStatistics.mergeStatistics(memChunk.getChunkMetaData().getStatistics());
                }
                timeSeriesMetadata.setStatistics(seriesStatistics);
            } else {
                timeSeriesMetadata = null;
            }
            this.pathToTimeSeriesMetadataMap.put(path, timeSeriesMetadata);
        }
    }

    public List<ChunkMetadata> getChunkMetadataList(PartialPath seriesPath) {
        return new ArrayList<ChunkMetadata>((Collection)this.pathToChunkMetadataListMap.get(seriesPath));
    }

    public List<ReadOnlyMemChunk> getReadOnlyMemChunk(PartialPath seriesPath) {
        return this.pathToReadOnlyMemChunkMap.get(seriesPath);
    }

    public TimeseriesMetadata getTimeSeriesMetadata(PartialPath seriesPath) {
        if (this.pathToTimeSeriesMetadataMap.containsKey(seriesPath)) {
            return this.pathToTimeSeriesMetadataMap.get(seriesPath);
        }
        return null;
    }

    public TsFileProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(TsFileProcessor processor) {
        this.processor = processor;
    }

    public void close() throws IOException {
        this.closed = true;
        if (this.modFile != null) {
            this.modFile.close();
            this.modFile = null;
        }
        this.processor = null;
        this.pathToChunkMetadataListMap = null;
        this.pathToReadOnlyMemChunkMap = null;
        this.pathToTimeSeriesMetadataMap = null;
        this.timeIndex.close();
    }

    public void writeLock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.writeLock();
        } else {
            this.originTsFileResource.writeLock();
        }
    }

    public void writeUnlock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.writeUnlock();
        } else {
            this.originTsFileResource.writeUnlock();
        }
    }

    public void readLock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.readLock();
        } else {
            this.originTsFileResource.readLock();
        }
    }

    public void readUnlock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.readUnlock();
        } else {
            this.originTsFileResource.readUnlock();
        }
    }

    public boolean tryWriteLock() {
        return this.tsFileLock.tryWriteLock();
    }

    void doUpgrade() {
        UpgradeSevice.getINSTANCE().submitUpgradeTask(new UpgradeTask(this));
    }

    public void removeModFile() throws IOException {
        this.getModFile().remove();
        this.modFile = null;
    }

    public void remove() {
        try {
            this.fsFactory.deleteIfExists(this.file);
        }
        catch (IOException e) {
            LOGGER.error("TsFile {} cannot be deleted: {}", (Object)this.file, (Object)e.getMessage());
        }
        this.removeResourceFile();
        try {
            this.fsFactory.deleteIfExists(this.fsFactory.getFile(this.file.getPath() + ".mods"));
        }
        catch (IOException e) {
            LOGGER.error("ModificationFile {} cannot be deleted: {}", (Object)this.file, (Object)e.getMessage());
        }
    }

    public void removeResourceFile() {
        try {
            this.fsFactory.deleteIfExists(this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX + TEMP_SUFFIX));
            this.fsFactory.deleteIfExists(this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX));
        }
        catch (IOException e) {
            LOGGER.error("TsFileResource {} cannot be deleted: {}", (Object)this.file, (Object)e.getMessage());
        }
    }

    void moveTo(File targetDir) {
        this.fsFactory.moveFile(this.file, this.fsFactory.getFile(targetDir, this.file.getName()));
        this.fsFactory.moveFile(this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX), this.fsFactory.getFile(targetDir, this.file.getName() + RESOURCE_SUFFIX));
        File originModFile = this.fsFactory.getFile(this.file.getPath() + ".mods");
        if (originModFile.exists()) {
            this.fsFactory.moveFile(originModFile, this.fsFactory.getFile(targetDir, this.file.getName() + ".mods"));
        }
    }

    public String toString() {
        return this.file.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsFileResource that = (TsFileResource)o;
        return Objects.equals(this.file, that.file);
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isMerging() {
        return this.isMerging;
    }

    public void setMerging(boolean merging) {
        this.isMerging = merging;
    }

    public boolean stillLives(long timeLowerBound) {
        return this.timeIndex.stillLives(timeLowerBound);
    }

    public boolean isSatisfied(Filter timeFilter, boolean isSeq, long ttl, boolean debug) {
        long endTime;
        long startTime = this.getFileStartTime();
        long l = endTime = this.closed || !isSeq ? this.getFileEndTime() : Long.MAX_VALUE;
        if (!this.isAlive(endTime, ttl)) {
            if (debug) {
                DEBUG_LOGGER.info("file {} is not satisfied because of ttl!", (Object)this.file);
            }
            return false;
        }
        if (timeFilter != null) {
            boolean res = timeFilter.satisfyStartEndTime(startTime, endTime);
            if (debug && !res) {
                DEBUG_LOGGER.info("Path: file {} is not satisfied because of time filter!", (Object)this.fsFactory);
            }
            return res;
        }
        return true;
    }

    public boolean isSatisfied(String deviceId, Filter timeFilter, TsFileFilter fileFilter, boolean isSeq, long ttl, boolean debug) {
        long endTime;
        if (fileFilter != null && fileFilter.fileNotSatisfy(this)) {
            if (debug) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of fileFilter!", (Object)deviceId, (Object)this.file);
            }
            return false;
        }
        if (!this.getDevices().contains(deviceId)) {
            if (debug) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of no device!", (Object)deviceId, (Object)this.file);
            }
            return false;
        }
        long startTime = this.getStartTime(deviceId);
        long l = endTime = this.closed || !isSeq ? this.getEndTime(deviceId) : Long.MAX_VALUE;
        if (timeFilter != null) {
            boolean res = timeFilter.satisfyStartEndTime(startTime, endTime);
            if (debug && !res) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of time filter!", (Object)deviceId, (Object)this.fsFactory);
            }
            return res;
        }
        return true;
    }

    private boolean isAlive(long time, long dataTTL) {
        return dataTTL == Long.MAX_VALUE || System.currentTimeMillis() - time <= dataTTL;
    }

    public void setUpgradedResources(List<TsFileResource> upgradedResources) {
        this.upgradedResources = upgradedResources;
    }

    public List<TsFileResource> getUpgradedResources() {
        return this.upgradedResources;
    }

    public void setSeq(boolean isSeq) {
        this.isSeq = isSeq;
    }

    public boolean isSeq() {
        return this.isSeq;
    }

    public void setUpgradeTsFileResourceCallBack(StorageGroupProcessor.UpgradeTsFileResourceCallBack upgradeTsFileResourceCallBack) {
        this.upgradeTsFileResourceCallBack = upgradeTsFileResourceCallBack;
    }

    public StorageGroupProcessor.UpgradeTsFileResourceCallBack getUpgradeTsFileResourceCallBack() {
        return this.upgradeTsFileResourceCallBack;
    }

    public long getTimePartition() {
        return this.timeIndex.getTimePartition(this.file.getAbsolutePath());
    }

    public long getTimePartitionWithCheck() throws PartitionViolationException {
        return this.timeIndex.getTimePartitionWithCheck(this.file.toString());
    }

    public boolean isSpanMultiTimePartitions() {
        return this.timeIndex.isSpanMultiTimePartitions();
    }

    public TsFileResource createHardlink() {
        TsFileResource newResource;
        if (!this.file.exists()) {
            return null;
        }
        try {
            newResource = new TsFileResource(this);
        }
        catch (IOException e) {
            LOGGER.error("Cannot create hardlink for {}", (Object)this.file, (Object)e);
            return null;
        }
        while (true) {
            String hardlinkSuffix = "." + System.currentTimeMillis() + "_" + this.random.nextLong();
            File hardlink = new File(this.file.getAbsolutePath() + hardlinkSuffix);
            try {
                Files.createLink(Paths.get(hardlink.getAbsolutePath(), new String[0]), Paths.get(this.file.getAbsolutePath(), new String[0]));
                newResource.setFile(hardlink);
                if (this.modFile == null || !this.modFile.exists()) break;
                newResource.setModFile(this.modFile.createHardlink());
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            catch (IOException e) {
                LOGGER.error("Cannot create hardlink for {}", (Object)this.file, (Object)e);
                return null;
            }
            break;
        }
        return newResource;
    }

    public synchronized void setModFile(ModificationFile modFile) {
        this.modFile = modFile;
    }

    public long calculateRamSize() {
        return this.timeIndex.calculateRamSize();
    }

    public void delete() throws IOException {
        if (this.file.exists()) {
            Files.delete(this.file.toPath());
            Files.delete(FSFactoryProducer.getFSFactory().getFile(this.file.toPath() + RESOURCE_SUFFIX).toPath());
        }
    }

    public long getMaxPlanIndex() {
        return this.maxPlanIndex;
    }

    public long getMinPlanIndex() {
        return this.minPlanIndex;
    }

    public void updatePlanIndexes(long planIndex) {
        if (planIndex == Long.MIN_VALUE || planIndex == Long.MAX_VALUE) {
            return;
        }
        this.maxPlanIndex = Math.max(this.maxPlanIndex, planIndex);
        this.minPlanIndex = Math.min(this.minPlanIndex, planIndex);
        if (this.closed) {
            try {
                this.serialize();
            }
            catch (IOException e) {
                LOGGER.error("Cannot serialize TsFileResource {} when updating plan index {}-{}", new Object[]{this, this.maxPlanIndex, planIndex});
            }
        }
    }

    public void updatePlanIndexes(TsFileResource another) {
        this.maxPlanIndex = Math.max(this.maxPlanIndex, another.maxPlanIndex);
        this.minPlanIndex = Math.min(this.minPlanIndex, another.minPlanIndex);
    }

    public boolean isPlanIndexOverlap(TsFileResource another) {
        return another.maxPlanIndex >= this.minPlanIndex && another.minPlanIndex <= this.maxPlanIndex;
    }

    public boolean isPlanRangeCovers(TsFileResource another) {
        return this.minPlanIndex <= another.minPlanIndex && another.maxPlanIndex <= this.maxPlanIndex;
    }

    public void setMaxPlanIndex(long maxPlanIndex) {
        this.maxPlanIndex = maxPlanIndex;
    }

    public void setMinPlanIndex(long minPlanIndex) {
        this.minPlanIndex = minPlanIndex;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getVersion() {
        return this.version;
    }

    public void setTimeIndex(ITimeIndex timeIndex) {
        this.timeIndex = timeIndex;
    }

    public static String getNewTsFileName(long time, long version, int mergeCnt, int unSeqMergeCnt) {
        return time + "-" + version + "-" + mergeCnt + "-" + unSeqMergeCnt + ".tsfile";
    }

    public static TsFileName getTsFileName(String fileName) throws IOException {
        String[] fileNameParts = fileName.split("\\.")[0].split("-");
        if (fileNameParts.length != 4) {
            throw new IOException("tsfile file name format is incorrect:" + fileName);
        }
        try {
            return new TsFileName(Long.parseLong(fileNameParts[0]), Long.parseLong(fileNameParts[1]), Integer.parseInt(fileNameParts[2]), Integer.parseInt(fileNameParts[3]));
        }
        catch (NumberFormatException e) {
            throw new IOException("tsfile file name format is incorrect:" + fileName);
        }
    }

    public static int getMergeLevel(String fileName) throws IOException {
        TsFileName tsFileName = TsFileResource.getTsFileName(fileName);
        return tsFileName.mergeCnt;
    }

    public static TsFileResource modifyTsFileNameUnseqMergCnt(TsFileResource tsFileResource) throws IOException {
        File tsFile = tsFileResource.getTsFile();
        String path = tsFile.getParent();
        TsFileName tsFileName = TsFileResource.getTsFileName(tsFileResource.getTsFile().getName());
        tsFileName.setUnSeqMergeCnt(tsFileName.getUnSeqMergeCnt() + 1);
        tsFileResource.setFile(new File(path, tsFileName.time + "-" + tsFileName.version + "-" + tsFileName.mergeCnt + "-" + tsFileName.unSeqMergeCnt + ".tsfile"));
        return tsFileResource;
    }

    public static File modifyTsFileNameUnseqMergCnt(File tsFile) throws IOException {
        String path = tsFile.getParent();
        TsFileName tsFileName = TsFileResource.getTsFileName(tsFile.getName());
        tsFileName.setUnSeqMergeCnt(tsFileName.getUnSeqMergeCnt() + 1);
        return new File(path, tsFileName.time + "-" + tsFileName.version + "-" + tsFileName.mergeCnt + "-" + tsFileName.unSeqMergeCnt + ".tsfile");
    }

    public static File modifyTsFileNameMergeCnt(File tsFile) throws IOException {
        String path = tsFile.getParent();
        TsFileName tsFileName = TsFileResource.getTsFileName(tsFile.getName());
        tsFileName.setMergeCnt(tsFileName.getMergeCnt() + 1);
        return new File(path, tsFileName.time + "-" + tsFileName.version + "-" + tsFileName.mergeCnt + "-" + tsFileName.unSeqMergeCnt + ".tsfile");
    }

    public static class TsFileName {
        private long time;
        private long version;
        private int mergeCnt;
        private int unSeqMergeCnt;

        public TsFileName(long time, long version, int mergeCnt, int unSeqMergeCnt) {
            this.time = time;
            this.version = version;
            this.mergeCnt = mergeCnt;
            this.unSeqMergeCnt = unSeqMergeCnt;
        }

        public long getTime() {
            return this.time;
        }

        public long getVersion() {
            return this.version;
        }

        public int getMergeCnt() {
            return this.mergeCnt;
        }

        public int getUnSeqMergeCnt() {
            return this.unSeqMergeCnt;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public void setVersion(long version) {
            this.version = version;
        }

        public void setMergeCnt(int mergeCnt) {
            this.mergeCnt = mergeCnt;
        }

        public void setUnSeqMergeCnt(int unSeqMergeCnt) {
            this.unSeqMergeCnt = unSeqMergeCnt;
        }
    }
}

