/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.SessionDataSet;
import org.apache.iotdb.tool.AbstractCsvTool;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.thrift.annotation.Nullable;

public class ImportCsv
extends AbstractCsvTool {
    private static final String FILE_ARGS = "f";
    private static final String FILE_NAME = "file or folder";
    private static final String FAILED_FILE_ARGS = "fd";
    private static final String FAILED_FILE_NAME = "failed file directory";
    private static final String CSV_SUFFIXS = "csv";
    private static final String TXT_SUFFIXS = "txt";
    private static final String TSFILEDB_CLI_PREFIX = "ImportCsv";
    private static final String ILLEGAL_PATH_ARGUMENT = "Path parameter is null";
    private static String targetPath;
    private static String failedFileDirectory;

    private static Options createOptions() {
        Options options = ImportCsv.createNewOptions();
        Option opFile = Option.builder((String)FILE_ARGS).required().argName(FILE_NAME).hasArg().desc("If input a file path, load a csv file, otherwise load all csv file under this directory (required)").build();
        options.addOption(opFile);
        Option opFailedFile = Option.builder((String)FAILED_FILE_ARGS).argName(FAILED_FILE_NAME).hasArg().desc("Specifying a directory to save failed file, default YOUR_CSV_FILE_PATH (optional)").build();
        options.addOption(opFailedFile);
        Option opHelp = Option.builder((String)"help").longOpt("help").hasArg(false).desc("Display help information").build();
        options.addOption(opHelp);
        Option opTimeZone = Option.builder((String)"tz").argName("timeZone").hasArg().desc("Time Zone eg. +08:00 or -01:00 (optional)").build();
        options.addOption(opTimeZone);
        return options;
    }

    private static void parseSpecialParams(CommandLine commandLine) {
        File file;
        timeZoneID = commandLine.getOptionValue("tz");
        targetPath = commandLine.getOptionValue(FILE_ARGS);
        if (commandLine.getOptionValue(FAILED_FILE_ARGS) != null && !(file = new File(failedFileDirectory = commandLine.getOptionValue(FAILED_FILE_ARGS))).isDirectory()) {
            file.mkdir();
            failedFileDirectory = file.getAbsolutePath() + File.separator;
        }
    }

    public static void main(String[] args) throws IOException, IoTDBConnectionException {
        CommandLine commandLine;
        Options options = ImportCsv.createOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setOptionComparator(null);
        hf.setWidth(92);
        DefaultParser parser = new DefaultParser();
        if (args == null || args.length == 0) {
            System.out.println("Too few params input, please check the following hint.");
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            return;
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println("Parse error: " + e.getMessage());
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            return;
        }
        if (commandLine.hasOption("help")) {
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            return;
        }
        try {
            ImportCsv.parseBasicParams(commandLine);
            String filename = commandLine.getOptionValue(FILE_ARGS);
            if (filename == null) {
                hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
                return;
            }
            ImportCsv.parseSpecialParams(commandLine);
        }
        catch (ArgsErrorException e) {
            System.out.println("Args error: " + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("Encounter an error, because: " + e.getMessage());
        }
        ImportCsv.importFromTargetPath(host, Integer.valueOf(port), username, password, targetPath, timeZoneID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importFromTargetPath(String host, int port, String username, String password, String targetPath, String timeZone) throws IoTDBConnectionException {
        try {
            session = new Session(host, Integer.valueOf(port).intValue(), username, password, false);
            session.open(false);
            timeZoneID = timeZone;
            ImportCsv.setTimeZone();
            File file = new File(targetPath);
            if (file.isFile()) {
                ImportCsv.importFromSingleFile(file);
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files == null) {
                    return;
                }
                for (File subFile : files) {
                    if (!subFile.isFile()) continue;
                    ImportCsv.importFromSingleFile(subFile);
                }
            } else {
                System.out.println("File not found!");
            }
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            System.out.println("Encounter an error when connecting to server, because " + e.getMessage());
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private static void importFromSingleFile(File file) {
        block8: {
            if (file.getName().endsWith(CSV_SUFFIXS) || file.getName().endsWith(TXT_SUFFIXS)) {
                try {
                    CSVParser csvRecords = ImportCsv.readCsvFile(file.getAbsolutePath());
                    List headerNames = csvRecords.getHeaderNames();
                    List records = csvRecords.getRecords();
                    if (headerNames.isEmpty()) {
                        System.out.println("Empty file!");
                        return;
                    }
                    if (!headerNames.contains("Time")) {
                        System.out.println("No headers!");
                        return;
                    }
                    if (records.isEmpty()) {
                        System.out.println("No records!");
                        return;
                    }
                    String failedFilePath = null;
                    failedFilePath = failedFileDirectory == null ? file.getAbsolutePath() + ".failed" : failedFileDirectory + file.getName() + ".failed";
                    if (!headerNames.contains("Device")) {
                        ImportCsv.writeDataAlignedByTime(headerNames, records, failedFilePath);
                        break block8;
                    }
                    ImportCsv.writeDataAlignedByDevice(headerNames, records, failedFilePath);
                }
                catch (IOException e) {
                    System.out.println("CSV file read exception because: " + e.getMessage());
                }
            } else {
                System.out.println("The file name must end with \"csv\" or \"txt\"!");
            }
        }
    }

    private static void writeDataAlignedByTime(List<String> headerNames, List<CSVRecord> records, String failedFilePath) {
        HashMap<String, List<String>> deviceAndMeasurementNames = new HashMap<String, List<String>>();
        HashMap<String, TSDataType> headerTypeMap = new HashMap<String, TSDataType>();
        HashMap<String, String> headerNameMap = new HashMap<String, String>();
        ImportCsv.parseHeaders(headerNames, deviceAndMeasurementNames, headerTypeMap, headerNameMap);
        Set<String> devices = deviceAndMeasurementNames.keySet();
        String devicesStr = StringUtils.join(devices, (String)",");
        try {
            ImportCsv.queryType(devicesStr, headerTypeMap, "Time");
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            e.printStackTrace();
        }
        SimpleDateFormat timeFormatter = ImportCsv.formatterInit(records.get(0).get("Time"));
        ArrayList<List<Object>> failedRecords = new ArrayList<List<Object>>();
        for (Map.Entry<String, List<String>> entry : deviceAndMeasurementNames.entrySet()) {
            String deviceId = entry.getKey();
            ArrayList times = new ArrayList();
            List<String> measurementNames = entry.getValue();
            ArrayList typesList = new ArrayList();
            ArrayList valuesList = new ArrayList();
            ArrayList measurementsList = new ArrayList();
            records.stream().forEach(record -> {
                ArrayList types = new ArrayList();
                ArrayList values = new ArrayList();
                ArrayList measurements = new ArrayList();
                AtomicReference<Boolean> isFail = new AtomicReference<Boolean>(false);
                measurementNames.stream().forEach(measurementName -> {
                    String header = deviceId + "." + measurementName;
                    String value = record.get(header);
                    if (!value.equals("")) {
                        TSDataType type;
                        if (!headerTypeMap.containsKey(headerNameMap.get(header))) {
                            type = ImportCsv.typeInfer(value);
                            if (type != null) {
                                headerTypeMap.put(header, type);
                            } else {
                                System.out.println(String.format("Line '%s', column '%s': '%s' unknown type", records.indexOf(record) + 1, header, value));
                                isFail.set(true);
                            }
                        }
                        if ((type = (TSDataType)headerTypeMap.get(headerNameMap.get(header))) != null) {
                            Object valueTransed = ImportCsv.typeTrans(value, type);
                            if (valueTransed == null) {
                                isFail.set(true);
                                System.out.println(String.format("Line '%s', column '%s': '%s' can't convert to '%s'", records.indexOf(record) + 1, header, value, type));
                            } else {
                                measurements.add(((String)headerNameMap.get(header)).replace(deviceId + '.', ""));
                                types.add(type);
                                values.add(valueTransed);
                            }
                        }
                    }
                });
                if (isFail.get().booleanValue()) {
                    failedRecords.add(record.stream().collect(Collectors.toList()));
                }
                if (!measurements.isEmpty()) {
                    try {
                        if (timeFormatter == null) {
                            try {
                                times.add(Long.valueOf(record.get("Time")));
                            }
                            catch (Exception e) {
                                System.out.println("Meet error when insert csv because the format of time is not supported");
                                System.exit(0);
                            }
                        } else {
                            times.add(timeFormatter.parse(record.get("Time")).getTime());
                        }
                    }
                    catch (java.text.ParseException e) {
                        e.printStackTrace();
                    }
                    typesList.add(types);
                    valuesList.add(values);
                    measurementsList.add(measurements);
                }
            });
            try {
                session.insertRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList);
            }
            catch (IoTDBConnectionException | StatementExecutionException e) {
                System.out.println("Meet error when insert csv because " + e.getMessage());
                System.exit(0);
            }
        }
        if (!failedRecords.isEmpty()) {
            ImportCsv.writeCsvFile(headerNames, failedRecords, failedFilePath);
        }
        System.out.println("Import completely!");
    }

    private static void writeDataAlignedByDevice(List<String> headerNames, List<CSVRecord> records, String failedFilePath) {
        HashMap<String, TSDataType> headerTypeMap = new HashMap<String, TSDataType>();
        HashMap<String, String> headerNameMap = new HashMap<String, String>();
        ImportCsv.parseHeaders(headerNames, null, headerTypeMap, headerNameMap);
        Set devices = records.stream().map(record -> record.get("Device")).collect(Collectors.toSet());
        String devicesStr = StringUtils.join(devices, (String)",");
        try {
            ImportCsv.queryType(devicesStr, headerTypeMap, "Device");
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            e.printStackTrace();
        }
        SimpleDateFormat timeFormatter = ImportCsv.formatterInit(records.get(0).get("Time"));
        Set<String> measurementNames = headerNameMap.keySet();
        ArrayList<List<Object>> failedRecords = new ArrayList<List<Object>>();
        devices.stream().forEach(device -> {
            ArrayList times = new ArrayList();
            ArrayList typesList = new ArrayList();
            ArrayList valuesList = new ArrayList();
            ArrayList measurementsList = new ArrayList();
            records.stream().filter(record -> record.get("Device").equals(device)).forEach(record -> {
                ArrayList types = new ArrayList();
                ArrayList values = new ArrayList();
                ArrayList measurements = new ArrayList();
                AtomicReference<Boolean> isFail = new AtomicReference<Boolean>(false);
                measurementNames.stream().forEach(measurement -> {
                    String value = record.get(measurement);
                    if (!value.equals("")) {
                        TSDataType type;
                        if (!headerTypeMap.containsKey(headerNameMap.get(measurement))) {
                            type = ImportCsv.typeInfer(value);
                            if (type != null) {
                                headerTypeMap.put((String)measurement, type);
                            } else {
                                System.out.println(String.format("Line '%s', column '%s': '%s' unknown type", records.indexOf(record) + 1, measurement, value));
                                isFail.set(true);
                            }
                        }
                        if ((type = (TSDataType)headerTypeMap.get(headerNameMap.get(measurement))) != null) {
                            Object valueTransed = ImportCsv.typeTrans(value, type);
                            if (valueTransed == null) {
                                isFail.set(true);
                                System.out.println(String.format("Line '%s', column '%s': '%s' can't convert to '%s'", records.indexOf(record) + 1, measurement, value, type));
                            } else {
                                values.add(valueTransed);
                                measurements.add((String)headerNameMap.get(measurement));
                                types.add(type);
                            }
                        }
                    }
                });
                if (isFail.get().booleanValue()) {
                    failedRecords.add(record.stream().collect(Collectors.toList()));
                }
                if (!measurements.isEmpty()) {
                    try {
                        if (timeFormatter == null) {
                            try {
                                times.add(Long.valueOf(record.get("Time")));
                            }
                            catch (Exception e) {
                                System.out.println("Meet error when insert csv because the format of time is not supported");
                                System.exit(0);
                            }
                        } else {
                            times.add(timeFormatter.parse(record.get("Time")).getTime());
                        }
                    }
                    catch (java.text.ParseException e) {
                        e.printStackTrace();
                    }
                    typesList.add(types);
                    valuesList.add(values);
                    measurementsList.add(measurements);
                }
            });
            try {
                session.insertRecordsOfOneDevice(device, times, measurementsList, typesList, valuesList);
            }
            catch (IoTDBConnectionException | StatementExecutionException e) {
                System.out.println("Meet error when insert csv because " + e.getMessage());
                System.exit(0);
            }
        });
        if (!failedRecords.isEmpty()) {
            ImportCsv.writeCsvFile(headerNames, failedRecords, failedFilePath);
        }
        System.out.println("Import completely!");
    }

    private static CSVParser readCsvFile(String path) throws IOException {
        return CSVFormat.EXCEL.withFirstRecordAsHeader().withQuote('`').withEscape('\\').withIgnoreEmptyLines().parse((Reader)new InputStreamReader(new FileInputStream(path)));
    }

    private static void parseHeaders(List<String> headerNames, @Nullable HashMap<String, List<String>> deviceAndMeasurementNames, HashMap<String, TSDataType> headerTypeMap, HashMap<String, String> headerNameMap) {
        String regex = "(?<=\\()\\S+(?=\\))";
        Pattern pattern = Pattern.compile(regex);
        for (String headerName : headerNames) {
            if (headerName.equals("Time") || headerName.equals("Device")) continue;
            Matcher matcher = pattern.matcher(headerName);
            if (matcher.find()) {
                String type = matcher.group();
                String headerNameWithoutType = headerName.replace("(" + type + ")", "").replaceAll("\\s+", "");
                headerNameMap.put(headerName, headerNameWithoutType);
                headerTypeMap.put(headerNameWithoutType, ImportCsv.getType(type));
            } else {
                headerNameMap.put(headerName, headerName);
            }
            String[] split = headerName.split("\\.");
            String measurementName = split[split.length - 1];
            String deviceName = headerName.replace("." + measurementName, "");
            if (deviceAndMeasurementNames == null) continue;
            if (!deviceAndMeasurementNames.containsKey(deviceName)) {
                deviceAndMeasurementNames.put(deviceName, new ArrayList());
            }
            deviceAndMeasurementNames.get(deviceName).add(measurementName);
        }
    }

    private static void queryType(String deviceNames, HashMap<String, TSDataType> headerTypeMap, String alignedType) throws IoTDBConnectionException, StatementExecutionException {
        String sql = "select * from " + deviceNames + " limit 1";
        SessionDataSet sessionDataSet = session.executeQueryStatement(sql);
        List columnNames = sessionDataSet.getColumnNames();
        List columnTypes = sessionDataSet.getColumnTypes();
        for (int i = 1; i < columnNames.size(); ++i) {
            if (alignedType == "Time") {
                headerTypeMap.put((String)columnNames.get(i), ImportCsv.getType((String)columnTypes.get(i)));
                continue;
            }
            if (alignedType != "Device") continue;
            String[] split = ((String)columnNames.get(i)).split("\\.");
            String measurement = split[split.length - 1];
            headerTypeMap.put(measurement, ImportCsv.getType((String)columnTypes.get(i)));
        }
    }

    private static SimpleDateFormat formatterInit(String time) {
        try {
            Long.parseLong(time);
            return null;
        }
        catch (Exception exception) {
            for (String timeFormat : STRING_TIME_FORMAT) {
                SimpleDateFormat format = new SimpleDateFormat(timeFormat);
                try {
                    format.parse(time).getTime();
                    System.out.println(timeFormat);
                    return format;
                }
                catch (java.text.ParseException parseException) {
                }
            }
            return null;
        }
    }

    private static TSDataType getType(String typeStr) {
        switch (typeStr) {
            case "TEXT": {
                return TSDataType.TEXT;
            }
            case "BOOLEAN": {
                return TSDataType.BOOLEAN;
            }
            case "INT32": {
                return TSDataType.INT32;
            }
            case "INT64": {
                return TSDataType.INT64;
            }
            case "FLOAT": {
                return TSDataType.FLOAT;
            }
            case "DOUBLE": {
                return TSDataType.DOUBLE;
            }
        }
        return null;
    }

    private static TSDataType typeInfer(String value) {
        if (value.contains("\"")) {
            return TSDataType.TEXT;
        }
        if (value.equals("true") || value.equals("false")) {
            return TSDataType.BOOLEAN;
        }
        if (!value.contains(".")) {
            try {
                Integer.valueOf(value);
                return TSDataType.INT32;
            }
            catch (Exception e) {
                try {
                    Long.valueOf(value);
                    return TSDataType.INT64;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        if (Float.valueOf(value).toString().length() == Double.valueOf(value).toString().length()) {
            return TSDataType.FLOAT;
        }
        return TSDataType.DOUBLE;
    }

    private static Object typeTrans(String value, TSDataType type) {
        try {
            switch (type) {
                case TEXT: {
                    return value.substring(1, value.length() - 1);
                }
                case BOOLEAN: {
                    if (!value.equals("true") && !value.equals("false")) {
                        return null;
                    }
                    return Boolean.valueOf(value);
                }
                case INT32: {
                    return Integer.valueOf(value);
                }
                case INT64: {
                    return Long.valueOf(value);
                }
                case FLOAT: {
                    return Float.valueOf(value);
                }
                case DOUBLE: {
                    return Double.valueOf(value);
                }
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static {
        failedFileDirectory = null;
    }
}

