/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.utils.nodetool.function;

import io.airlift.airline.Command;
import java.util.Map;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.utils.nodetool.ClusterMonitorMBean;
import org.apache.iotdb.cluster.utils.nodetool.Printer;
import org.apache.iotdb.cluster.utils.nodetool.function.NodeToolCmd;

@Command(name="status", description="Print status of all nodes")
public class Status
extends NodeToolCmd {
    @Override
    public void execute(ClusterMonitorMBean proxy) {
        Map<Node, Boolean> statusMap = proxy.getAllNodeStatus();
        if (statusMap == null) {
            Printer.msgPrintln("The cluster is being created.");
            return;
        }
        Printer.msgPrintln(String.format("%-30s  %10s", "Node", "Status"));
        statusMap.forEach((node, status) -> Printer.msgPrintln(String.format("%-30s->%10s", this.nodeToString((Node)node), Boolean.TRUE.equals(status) ? "on" : "off")));
    }
}

