/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.utils;

import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.async.AsyncDataHeartbeatClient;
import org.apache.iotdb.cluster.client.async.AsyncMetaClient;
import org.apache.iotdb.cluster.client.async.AsyncMetaHeartbeatClient;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncDataHeartbeatClient;
import org.apache.iotdb.cluster.client.sync.SyncMetaClient;
import org.apache.iotdb.cluster.client.sync.SyncMetaHeartbeatClient;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;

public class ClientUtils {
    private ClientUtils() {
    }

    public static boolean isHeartbeatClientReady(RaftService.AsyncClient client) {
        if (client instanceof AsyncDataHeartbeatClient) {
            return ((AsyncDataHeartbeatClient)client).isReady();
        }
        return ((AsyncMetaHeartbeatClient)client).isReady();
    }

    public static void putBackSyncHeartbeatClient(RaftService.Client client) {
        if (client instanceof SyncMetaHeartbeatClient) {
            ((SyncMetaHeartbeatClient)client).putBack();
        } else {
            ((SyncDataHeartbeatClient)client).putBack();
        }
    }

    public static void putBackSyncClient(RaftService.Client client) {
        if (client instanceof SyncDataClient) {
            ((SyncDataClient)client).putBack();
        } else if (client instanceof SyncMetaClient) {
            ((SyncMetaClient)client).putBack();
        }
    }

    public static boolean isClientReady(RaftService.AsyncClient client) {
        if (client instanceof AsyncDataClient) {
            return ((AsyncDataClient)client).isReady();
        }
        return ((AsyncMetaClient)client).isReady();
    }
}

