/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.member;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.cluster.client.async.AsyncClientPool;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncClientPool;
import org.apache.iotdb.cluster.config.ClusterConfig;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.exception.LogExecutionException;
import org.apache.iotdb.cluster.exception.UnknownLogTypeException;
import org.apache.iotdb.cluster.log.CommitLogCallback;
import org.apache.iotdb.cluster.log.CommitLogTask;
import org.apache.iotdb.cluster.log.HardState;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.log.LogDispatcher;
import org.apache.iotdb.cluster.log.LogParser;
import org.apache.iotdb.cluster.log.catchup.CatchUpTask;
import org.apache.iotdb.cluster.log.logtypes.PhysicalPlanLog;
import org.apache.iotdb.cluster.log.manage.RaftLogManager;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntriesRequest;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntryRequest;
import org.apache.iotdb.cluster.rpc.thrift.ElectionRequest;
import org.apache.iotdb.cluster.rpc.thrift.ExecutNonQueryReq;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatRequest;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatResponse;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.rpc.thrift.RequestCommitIndexResponse;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.cluster.server.handlers.caller.AppendNodeEntryHandler;
import org.apache.iotdb.cluster.server.handlers.caller.GenericHandler;
import org.apache.iotdb.cluster.server.monitor.Peer;
import org.apache.iotdb.cluster.server.monitor.Timer;
import org.apache.iotdb.cluster.utils.ClientUtils;
import org.apache.iotdb.cluster.utils.IOUtils;
import org.apache.iotdb.cluster.utils.PlanSerializer;
import org.apache.iotdb.cluster.utils.StatusUtils;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.IoTDBException;
import org.apache.iotdb.db.exception.metadata.DuplicatedTemplateException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupAlreadySetException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RaftMember {
    private static final Logger logger = LoggerFactory.getLogger(RaftMember.class);
    public static final boolean USE_LOG_DISPATCHER = false;
    private static final String MSG_FORWARD_TIMEOUT = "{}: Forward {} to {} time out";
    private static final String MSG_FORWARD_ERROR = "{}: encountered an error when forwarding {} to {}";
    private static final String MSG_NO_LEADER_COMMIT_INDEX = "{}: Cannot request commit index from {}";
    private static final String MSG_NO_LEADER_IN_SYNC = "{}: No leader is found when synchronizing";
    public static final String MSG_LOG_IS_ACCEPTED = "{}: log {} is accepted";
    private static long waitLeaderTimeMs = 60000L;
    private final Object waitLeaderCondition = new Object();
    private final Object snapshotApplyLock = new Object();
    protected Node thisNode = ClusterConstant.EMPTY_NODE;
    protected List<Node> allNodes;
    ClusterConfig config = ClusterDescriptor.getInstance().getConfig();
    String name;
    Random random = new Random();
    Map<Node, Peer> peerMap;
    AtomicLong term = new AtomicLong(0L);
    volatile NodeCharacter character = NodeCharacter.ELECTOR;
    AtomicReference<Node> leader = new AtomicReference<Node>(ClusterConstant.EMPTY_NODE);
    volatile Node voteFor;
    volatile long lastHeartbeatReceivedTime;
    RaftLogManager logManager;
    ExecutorService heartBeatService;
    volatile boolean readOnly = false;
    long lastReportedLogIndex;
    private ExecutorService catchUpService;
    private Map<Node, Long> lastCatchUpResponseTime = new ConcurrentHashMap<Node, Long>();
    private AsyncClientPool asyncClientPool;
    private AsyncClientPool asyncSendLogClientPool;
    private SyncClientPool syncClientPool;
    private AsyncClientPool asyncHeartbeatClientPool;
    private SyncClientPool syncHeartbeatClientPool;
    private Object syncLock = new Object();
    private ExecutorService appendLogThreadPool;
    private ExecutorService serialToParallelPool;
    private ExecutorService commitLogPool;
    private LogDispatcher logDispatcher;
    protected PlanExecutor localExecutor;

    protected RaftMember() {
    }

    protected RaftMember(String name, AsyncClientPool asyncPool, SyncClientPool syncPool, AsyncClientPool asyncHeartbeatPool, SyncClientPool syncHeartbeatPool) {
        this.name = name;
        this.asyncClientPool = asyncPool;
        this.syncClientPool = syncPool;
        this.asyncHeartbeatClientPool = asyncHeartbeatPool;
        this.syncHeartbeatClientPool = syncHeartbeatPool;
        this.asyncSendLogClientPool = this.asyncClientPool;
    }

    protected RaftMember(String name, AsyncClientPool asyncPool, SyncClientPool syncPool, AsyncClientPool asyncHeartbeatPool, SyncClientPool syncHeartbeatPool, AsyncClientPool asyncSendLogClientPool) {
        this.name = name;
        this.asyncClientPool = asyncPool;
        this.syncClientPool = syncPool;
        this.asyncHeartbeatClientPool = asyncHeartbeatPool;
        this.syncHeartbeatClientPool = syncHeartbeatPool;
        this.asyncSendLogClientPool = asyncSendLogClientPool;
    }

    public void start() {
        if (this.heartBeatService != null) {
            return;
        }
        this.startBackGroundThreads();
        logger.info("{} started", (Object)this.name);
    }

    void startBackGroundThreads() {
        this.heartBeatService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, this.name + "-HeartbeatThread@" + System.currentTimeMillis()));
        this.catchUpService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat(this.getName() + "-CatchUpThread%d").build());
        this.appendLogThreadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 10, new ThreadFactoryBuilder().setNameFormat(this.getName() + "-AppendLog%d").build());
        if (!this.config.isUseAsyncServer()) {
            this.serialToParallelPool = new ThreadPoolExecutor(this.allNodes.size(), Math.max(this.allNodes.size(), Runtime.getRuntime().availableProcessors()), 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(this.getName() + "-SerialToParallel%d").build());
        }
        this.commitLogPool = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(this.getName() + "-CommitLog%d").build());
    }

    public String getName() {
        return this.name;
    }

    public RaftLogManager getLogManager() {
        return this.logManager;
    }

    public void setLogManager(RaftLogManager logManager) {
        if (this.logManager != null) {
            this.logManager.close();
        }
        this.logManager = logManager;
    }

    public void stop() {
        this.closeLogManager();
        if (this.heartBeatService == null) {
            return;
        }
        this.heartBeatService.shutdownNow();
        this.catchUpService.shutdownNow();
        this.appendLogThreadPool.shutdownNow();
        try {
            this.heartBeatService.awaitTermination(10L, TimeUnit.SECONDS);
            this.catchUpService.awaitTermination(10L, TimeUnit.SECONDS);
            this.appendLogThreadPool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Unexpected interruption when waiting for heartBeatService and catchUpService to end", (Throwable)e);
        }
        if (this.serialToParallelPool != null) {
            this.serialToParallelPool.shutdownNow();
            try {
                this.serialToParallelPool.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Unexpected interruption when waiting for asyncThreadPool to end", (Throwable)e);
            }
        }
        if (this.commitLogPool != null) {
            this.commitLogPool.shutdownNow();
            try {
                this.commitLogPool.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Unexpected interruption when waiting for commitLogPool to end", (Throwable)e);
            }
        }
        this.catchUpService = null;
        this.heartBeatService = null;
        this.appendLogThreadPool = null;
        logger.info("Member {} stopped", (Object)this.name);
    }

    public void closeLogManager() {
        if (this.logManager != null) {
            this.logManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeartBeatResponse processHeartbeatRequest(HeartBeatRequest request) {
        logger.trace("{} received a heartbeat", (Object)this.name);
        AtomicLong atomicLong = this.term;
        synchronized (atomicLong) {
            long thisTerm = this.term.get();
            long leaderTerm = request.getTerm();
            HeartBeatResponse response = new HeartBeatResponse();
            if (leaderTerm < thisTerm) {
                response.setTerm(thisTerm);
                if (logger.isTraceEnabled()) {
                    logger.trace("{} received a heartbeat from a stale leader {}", (Object)this.name, (Object)request.getLeader());
                }
            } else {
                this.stepDown(leaderTerm, true);
                this.setLeader(request.getLeader());
                if (this.character != NodeCharacter.FOLLOWER) {
                    this.term.notifyAll();
                }
                this.processValidHeartbeatReq(request, response);
                response.setTerm(-1L);
                response.setFollower(this.thisNode);
                RaftLogManager raftLogManager = this.logManager;
                synchronized (raftLogManager) {
                    response.setLastLogIndex(this.logManager.getLastLogIndex());
                    response.setLastLogTerm(this.logManager.getLastLogTerm());
                }
                this.tryUpdateCommitIndex(leaderTerm, request.getCommitLogIndex(), request.getCommitLogTerm());
                if (logger.isTraceEnabled()) {
                    logger.trace("{} received heartbeat from a valid leader {}", (Object)this.name, (Object)request.getLeader());
                }
            }
            return response;
        }
    }

    private void tryUpdateCommitIndex(long leaderTerm, long commitIndex, long commitTerm) {
        if (leaderTerm >= this.term.get() && this.logManager.getCommitLogIndex() < commitIndex) {
            CommitLogTask commitLogTask = new CommitLogTask(this.logManager, commitIndex, commitTerm);
            commitLogTask.registerCallback(new CommitLogCallback(this));
            if (this.commitLogPool != null && !this.commitLogPool.isShutdown()) {
                this.commitLogPool.submit(commitLogTask);
            }
            logger.debug("{}: Inconsistent log found, leaderCommit: {}-{}, localCommit: {}-{}, localLast: {}-{}", new Object[]{this.name, commitIndex, commitTerm, this.logManager.getCommitLogIndex(), this.logManager.getCommitLogTerm(), this.logManager.getLastLogIndex(), this.logManager.getLastLogTerm()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long processElectionRequest(ElectionRequest electionRequest) {
        AtomicLong atomicLong = this.term;
        synchronized (atomicLong) {
            long currentTerm = this.term.get();
            long response = this.checkElectorTerm(currentTerm, electionRequest.getTerm(), electionRequest.getElector());
            if (response != -1L) {
                return response;
            }
            response = this.checkElectorLogProgress(electionRequest);
            logger.info("{} sending response {} to the elector {}", new Object[]{this.name, response, electionRequest.getElector()});
            return response;
        }
    }

    private long checkElectorTerm(long currentTerm, long electorTerm, Node elector) {
        if (electorTerm < currentTerm) {
            logger.info("{} sending localTerm {} to the elector {} because it's term {} is smaller.", new Object[]{this.name, currentTerm, elector, electorTerm});
            return currentTerm;
        }
        if (currentTerm == electorTerm && this.voteFor != null && !Objects.equals(this.voteFor, elector)) {
            logger.info("{} sending rejection to the elector {} because member already has voted {} in this term {}.", new Object[]{this.name, elector, this.voteFor, currentTerm});
            return -3L;
        }
        if (electorTerm > currentTerm) {
            logger.info("{} received an election from elector {} which has bigger term {} than localTerm {}, raftMember should step down first and then continue to decide whether to grant it's vote by log status.", new Object[]{this.name, elector, electorTerm, currentTerm});
            this.stepDown(electorTerm, false);
        }
        return -1L;
    }

    public long appendEntry(AppendEntryRequest request) throws UnknownLogTypeException {
        logger.debug("{} received an AppendEntryRequest: {}", (Object)this.name, (Object)request);
        long checkResult = this.checkRequestTerm(request.term, request.leader);
        if (checkResult != -1L) {
            return checkResult;
        }
        long startTime = Timer.Statistic.RAFT_RECEIVER_LOG_PARSE.getOperationStartTime();
        int logByteSize = request.getEntry().length;
        Log log = LogParser.getINSTANCE().parse(request.entry);
        log.setByteSize(logByteSize);
        Timer.Statistic.RAFT_RECEIVER_LOG_PARSE.calOperationCostTimeFromStart(startTime);
        long result = this.appendEntry(request.prevLogIndex, request.prevLogTerm, request.leaderCommit, log);
        logger.debug("{} AppendEntryRequest of {} completed with result {}", new Object[]{this.name, log, result});
        return result;
    }

    public long appendEntries(AppendEntriesRequest request) throws UnknownLogTypeException {
        logger.debug("{} received an AppendEntriesRequest", (Object)this.name);
        long checkResult = this.checkRequestTerm(request.term, request.leader);
        if (checkResult != -1L) {
            return checkResult;
        }
        ArrayList<Log> logs = new ArrayList<Log>();
        int logByteSize = 0;
        long startTime = Timer.Statistic.RAFT_RECEIVER_LOG_PARSE.getOperationStartTime();
        for (ByteBuffer buffer : request.getEntries()) {
            Log log;
            buffer.mark();
            logByteSize = buffer.limit() - buffer.position();
            try {
                log = LogParser.getINSTANCE().parse(buffer);
                log.setByteSize(logByteSize);
            }
            catch (BufferUnderflowException e) {
                buffer.reset();
                throw e;
            }
            logs.add(log);
        }
        Timer.Statistic.RAFT_RECEIVER_LOG_PARSE.calOperationCostTimeFromStart(startTime);
        long response = this.appendEntries(request.prevLogIndex, request.prevLogTerm, request.leaderCommit, logs);
        if (logger.isDebugEnabled()) {
            logger.debug("{} AppendEntriesRequest of log size {} completed with result {}", new Object[]{this.name, request.getEntries().size(), response});
        }
        return response;
    }

    public PlanExecutor getLocalExecutor() throws QueryProcessException {
        if (this.localExecutor == null) {
            this.localExecutor = new PlanExecutor();
        }
        return this.localExecutor;
    }

    public RaftService.AsyncClient getAsyncHeartbeatClient(Node node) {
        return this.getAsyncClient(node, this.asyncHeartbeatClientPool, false);
    }

    public RaftService.Client getSyncHeartbeatClient(Node node) {
        return this.getSyncClient(this.syncHeartbeatClientPool, node, false);
    }

    public void sendLogAsync(Log log, AtomicInteger voteCounter, Node node, AtomicBoolean leaderShipStale, AtomicLong newLeaderTerm, AppendEntryRequest request, Peer peer) {
        RaftService.AsyncClient client = this.getSendLogAsyncClient(node);
        if (client != null) {
            AppendNodeEntryHandler handler = this.getAppendNodeEntryHandler(log, voteCounter, node, leaderShipStale, newLeaderTerm, peer);
            try {
                client.appendEntry(request, (AsyncMethodCallback)handler);
                logger.debug("{} sending a log to {}: {}", new Object[]{this.name, node, log});
            }
            catch (Exception e) {
                logger.warn("{} cannot append log to node {}", new Object[]{this.name, node, e});
            }
        }
    }

    private RaftService.Client getSyncClient(SyncClientPool pool, Node node, boolean activatedOnly) {
        if (ClusterConstant.EMPTY_NODE.equals(node) || node == null) {
            return null;
        }
        return pool.getClient(node, activatedOnly);
    }

    public NodeCharacter getCharacter() {
        return this.character;
    }

    public void setCharacter(NodeCharacter character) {
        if (!Objects.equals((Object)character, (Object)this.character)) {
            logger.info("{} has become a {}", (Object)this.name, (Object)character);
            this.character = character;
        }
    }

    public long getLastHeartbeatReceivedTime() {
        return this.lastHeartbeatReceivedTime;
    }

    public void setLastHeartbeatReceivedTime(long lastHeartbeatReceivedTime) {
        this.lastHeartbeatReceivedTime = lastHeartbeatReceivedTime;
    }

    public Node getLeader() {
        return this.leader.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeader(Node leader) {
        if (!Objects.equals(leader, this.leader.get())) {
            if (ClusterConstant.EMPTY_NODE.equals(leader) || leader == null) {
                logger.info("{} has been set to null in term {}", (Object)this.getName(), (Object)this.term.get());
            } else if (!Objects.equals(leader, this.thisNode)) {
                logger.info("{} has become a follower of {} in term {}", new Object[]{this.getName(), leader, this.term.get()});
            }
            Object object = this.waitLeaderCondition;
            synchronized (object) {
                if (leader == null) {
                    this.leader.set(ClusterConstant.EMPTY_NODE);
                } else {
                    this.leader.set(leader);
                }
                if (!ClusterConstant.EMPTY_NODE.equals(this.leader.get())) {
                    this.waitLeaderCondition.notifyAll();
                }
            }
        }
    }

    public Collection<Node> getAllNodes() {
        return this.allNodes;
    }

    public void setAllNodes(List<Node> allNodes) {
        this.allNodes = allNodes;
    }

    public Map<Node, Long> getLastCatchUpResponseTime() {
        return this.lastCatchUpResponseTime;
    }

    public void processValidHeartbeatResp(HeartBeatResponse response, Node receiver) {
    }

    public void onElectionWins() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void catchUp(Node follower, long lastLogIdx) {
        ExecutorService executorService = this.catchUpService;
        synchronized (executorService) {
            Long lastCatchupResp = this.lastCatchUpResponseTime.get(follower);
            if (lastCatchupResp != null && System.currentTimeMillis() - lastCatchupResp < (long)this.config.getCatchUpTimeoutMS()) {
                logger.debug("{}: last catch up of {} is ongoing", (Object)this.name, (Object)follower);
                return;
            }
            this.lastCatchUpResponseTime.put(follower, System.currentTimeMillis());
        }
        logger.info("{}: Start to make {} catch up", (Object)this.name, (Object)follower);
        if (!this.catchUpService.isShutdown()) {
            Future<?> future = this.catchUpService.submit(new CatchUpTask(follower, this.peerMap.get(follower), this, lastLogIdx));
            this.catchUpService.submit(() -> {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    logger.error("{}: Catch up task exits with unexpected exception", (Object)this.name, (Object)e);
                }
            });
        }
    }

    public TSStatus executeNonQueryPlan(ExecutNonQueryReq request) throws IOException, IllegalPathException {
        PhysicalPlan plan = PhysicalPlan.Factory.create((ByteBuffer)request.planBytes);
        TSStatus answer = this.executeNonQueryPlan(plan);
        logger.debug("{}: Received a plan {}, executed answer: {}", new Object[]{this.name, plan, answer});
        return answer;
    }

    abstract TSStatus executeNonQueryPlan(PhysicalPlan var1);

    public void syncLeaderWithConsistencyCheck(boolean isWriteRequest) throws CheckConsistencyException {
        if (!isWriteRequest) {
            switch (this.config.getConsistencyLevel()) {
                case STRONG_CONSISTENCY: {
                    this.syncLeader(new StrongCheckConsistency());
                    return;
                }
                case MID_CONSISTENCY: {
                    this.syncLeader(new MidCheckConsistency());
                    return;
                }
                case WEAK_CONSISTENCY: {
                    return;
                }
            }
            throw new CheckConsistencyException("unknown consistency=" + this.config.getConsistencyLevel().name());
        }
        this.syncLeader(new StrongCheckConsistency());
    }

    public boolean syncLeader(CheckConsistency checkConsistency) throws CheckConsistencyException {
        if (this.character == NodeCharacter.LEADER) {
            return true;
        }
        this.waitLeader();
        if (this.leader.get() == null || ClusterConstant.EMPTY_NODE.equals(this.leader.get())) {
            logger.warn(MSG_NO_LEADER_IN_SYNC, (Object)this.name);
            return false;
        }
        if (this.character == NodeCharacter.LEADER) {
            return true;
        }
        logger.debug("{}: try synchronizing with the leader {}", (Object)this.name, (Object)this.leader.get());
        return this.waitUntilCatchUp(checkConsistency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitLeader() {
        long startTime = System.currentTimeMillis();
        while (this.leader.get() == null || ClusterConstant.EMPTY_NODE.equals(this.leader.get())) {
            Object object = this.waitLeaderCondition;
            synchronized (object) {
                try {
                    this.waitLeaderCondition.wait(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error("Unexpected interruption when waiting for a leader", (Throwable)e);
                }
            }
            long consumedTime = System.currentTimeMillis() - startTime;
            if (consumedTime < RaftMember.getWaitLeaderTimeMs()) continue;
            logger.warn("{}: leader is still offline after {}ms", (Object)this.name, (Object)consumedTime);
            break;
        }
        logger.debug("{}: current leader is {}", (Object)this.name, (Object)this.leader.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitUntilCatchUp(CheckConsistency checkConsistency) throws CheckConsistencyException {
        long leaderCommitId = Long.MIN_VALUE;
        try {
            RequestCommitIndexResponse response = this.config.isUseAsyncServer() ? this.requestCommitIdAsync() : this.requestCommitIdSync();
            leaderCommitId = response.getCommitLogIndex();
            this.tryUpdateCommitIndex(response.getTerm(), response.getCommitLogIndex(), response.getCommitLogTerm());
            boolean bl = this.syncLocalApply(leaderCommitId);
            return bl;
        }
        catch (TException e) {
            logger.error(MSG_NO_LEADER_COMMIT_INDEX, new Object[]{this.name, this.leader.get(), e});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error(MSG_NO_LEADER_COMMIT_INDEX, new Object[]{this.name, this.leader.get(), e});
        }
        finally {
            if (checkConsistency != null) {
                checkConsistency.postCheckConsistency(leaderCommitId, this.logManager.getMaxHaveAppliedCommitIndex());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncLocalApply(long leaderCommitId) {
        long startTime = System.currentTimeMillis();
        long waitedTime = 0L;
        long localAppliedId = 0L;
        while (waitedTime < (long)RaftServer.getSyncLeaderMaxWaitMs()) {
            try {
                localAppliedId = this.logManager.getMaxHaveAppliedCommitIndex();
                logger.debug("{}: synchronizing commitIndex {}/{}", new Object[]{this.name, localAppliedId, leaderCommitId});
                if (leaderCommitId <= localAppliedId) {
                    if (logger.isDebugEnabled()) {
                        waitedTime = System.currentTimeMillis() - startTime;
                        logger.debug("{}: synchronized with the leader after {}ms", (Object)this.name, (Object)waitedTime);
                    }
                    return true;
                }
                waitedTime = System.currentTimeMillis() - startTime;
                Object object = this.syncLock;
                synchronized (object) {
                    this.syncLock.wait(RaftServer.getHeartBeatIntervalMs());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error(MSG_NO_LEADER_COMMIT_INDEX, new Object[]{this.name, this.leader.get(), e});
            }
        }
        logger.warn("{}: Failed to synchronize with the leader after {}ms", (Object)this.name, (Object)waitedTime);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TSStatus processPlanLocally(PhysicalPlan plan) {
        logger.debug("{}: Processing plan {}", (Object)this.name, (Object)plan);
        if (this.readOnly) {
            return StatusUtils.NODE_READ_ONLY;
        }
        long startTime = Timer.Statistic.RAFT_SENDER_APPEND_LOG.getOperationStartTime();
        PhysicalPlanLog log = new PhysicalPlanLog();
        RaftLogManager raftLogManager = this.logManager;
        synchronized (raftLogManager) {
            log.setCurrLogTerm(this.getTerm().get());
            log.setCurrLogIndex(this.logManager.getLastLogIndex() + 1L);
            log.setPlan(plan);
            plan.setIndex(log.getCurrLogIndex());
            this.logManager.append(log);
        }
        Timer.Statistic.RAFT_SENDER_APPEND_LOG.calOperationCostTimeFromStart(startTime);
        try {
            if (this.appendLogInGroup(log)) {
                return StatusUtils.OK;
            }
        }
        catch (LogExecutionException e) {
            return this.handleLogExecutionException(log.getPlan(), IOUtils.getRootCause(e));
        }
        return StatusUtils.TIME_OUT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSStatus processPlanLocallyV2(PhysicalPlan plan) {
        LogDispatcher.SendLogRequest sendLogRequest;
        logger.debug("{}: Processing plan {}", (Object)this.name, (Object)plan);
        if (this.readOnly) {
            return StatusUtils.NODE_READ_ONLY;
        }
        PhysicalPlanLog log = new PhysicalPlanLog();
        long startTime = Timer.Statistic.RAFT_SENDER_COMPETE_LOG_MANAGER_BEFORE_APPEND_V2.getOperationStartTime();
        RaftLogManager raftLogManager = this.logManager;
        synchronized (raftLogManager) {
            Timer.Statistic.RAFT_SENDER_COMPETE_LOG_MANAGER_BEFORE_APPEND_V2.calOperationCostTimeFromStart(startTime);
            log.setCurrLogTerm(this.getTerm().get());
            log.setCurrLogIndex(this.logManager.getLastLogIndex() + 1L);
            log.setPlan(plan);
            plan.setIndex(log.getCurrLogIndex());
            startTime = Timer.Statistic.RAFT_SENDER_APPEND_LOG_V2.getOperationStartTime();
            this.logManager.append(log);
            Timer.Statistic.RAFT_SENDER_APPEND_LOG_V2.calOperationCostTimeFromStart(startTime);
            startTime = Timer.Statistic.RAFT_SENDER_BUILD_LOG_REQUEST.getOperationStartTime();
            sendLogRequest = this.buildSendLogRequest(log);
            Timer.Statistic.RAFT_SENDER_BUILD_LOG_REQUEST.calOperationCostTimeFromStart(startTime);
            startTime = Timer.Statistic.RAFT_SENDER_OFFER_LOG.getOperationStartTime();
            log.setCreateTime(System.nanoTime());
            this.getLogDispatcher().offer(sendLogRequest);
            Timer.Statistic.RAFT_SENDER_OFFER_LOG.calOperationCostTimeFromStart(startTime);
        }
        try {
            AppendLogResult appendLogResult = this.waitAppendResult(sendLogRequest.getVoteCounter(), sendLogRequest.getLeaderShipStale(), sendLogRequest.getNewLeaderTerm());
            Timer.Statistic.RAFT_SENDER_LOG_FROM_CREATE_TO_ACCEPT.calOperationCostTimeFromStart(sendLogRequest.getLog().getCreateTime());
            switch (appendLogResult) {
                case OK: {
                    logger.debug(MSG_LOG_IS_ACCEPTED, (Object)this.name, (Object)log);
                    startTime = Timer.Statistic.RAFT_SENDER_COMMIT_LOG.getOperationStartTime();
                    this.commitLog(log);
                    Timer.Statistic.RAFT_SENDER_COMMIT_LOG.calOperationCostTimeFromStart(startTime);
                    return StatusUtils.OK;
                }
                case TIME_OUT: {
                    logger.debug("{}: log {} timed out...", (Object)this.name, (Object)log);
                    break;
                }
            }
        }
        catch (LogExecutionException e) {
            return this.handleLogExecutionException(log.getPlan(), IOUtils.getRootCause(e));
        }
        return StatusUtils.TIME_OUT;
    }

    public LogDispatcher.SendLogRequest buildSendLogRequest(Log log) {
        AtomicInteger voteCounter = new AtomicInteger(this.allNodes.size() / 2);
        AtomicBoolean leaderShipStale = new AtomicBoolean(false);
        AtomicLong newLeaderTerm = new AtomicLong(this.term.get());
        long startTime = Timer.Statistic.RAFT_SENDER_BUILD_APPEND_REQUEST.getOperationStartTime();
        AppendEntryRequest appendEntryRequest = this.buildAppendEntryRequest(log, false);
        Timer.Statistic.RAFT_SENDER_BUILD_APPEND_REQUEST.calOperationCostTimeFromStart(startTime);
        return new LogDispatcher.SendLogRequest(log, voteCounter, leaderShipStale, newLeaderTerm, appendEntryRequest);
    }

    static long getWaitLeaderTimeMs() {
        return waitLeaderTimeMs;
    }

    static void setWaitLeaderTimeMs(long waitLeaderTimeMs) {
        RaftMember.waitLeaderTimeMs = waitLeaderTimeMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RequestCommitIndexResponse requestCommitIdAsync() throws TException, InterruptedException {
        RequestCommitIndexResponse response = new RequestCommitIndexResponse(Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
        AtomicReference<RequestCommitIndexResponse> commitIdResult = new AtomicReference<RequestCommitIndexResponse>(response);
        RaftService.AsyncClient client = this.getAsyncClient(this.leader.get());
        if (client == null) {
            logger.warn(MSG_NO_LEADER_IN_SYNC, (Object)this.name);
            return commitIdResult.get();
        }
        AtomicReference<RequestCommitIndexResponse> atomicReference = commitIdResult;
        synchronized (atomicReference) {
            client.requestCommitIndex(this.getHeader(), new GenericHandler<RequestCommitIndexResponse>(this.leader.get(), commitIdResult));
            commitIdResult.wait(RaftServer.getSyncLeaderMaxWaitMs());
        }
        return commitIdResult.get();
    }

    private RequestCommitIndexResponse requestCommitIdSync() throws TException {
        RequestCommitIndexResponse response;
        RaftService.Client client = this.getSyncClient(this.leader.get());
        if (client == null) {
            logger.warn(MSG_NO_LEADER_IN_SYNC, (Object)this.name);
            RequestCommitIndexResponse response2 = new RequestCommitIndexResponse(Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
            return response2;
        }
        try {
            response = client.requestCommitIndex(this.getHeader());
        }
        catch (TException e) {
            client.getInputProtocol().getTransport().close();
            throw e;
        }
        finally {
            ClientUtils.putBackSyncClient(client);
        }
        return response;
    }

    public long getCommitIndex() {
        if (this.character == NodeCharacter.LEADER) {
            return this.logManager.getCommitLogIndex();
        }
        return Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadOnly() {
        RaftLogManager raftLogManager = this.logManager;
        synchronized (raftLogManager) {
            this.readOnly = true;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void initPeerMap() {
        this.peerMap = new ConcurrentHashMap<Node, Peer>();
        for (Node entry : this.allNodes) {
            this.peerMap.computeIfAbsent(entry, k -> new Peer(this.logManager.getLastLogIndex()));
        }
    }

    public Map<Node, Peer> getPeerMap() {
        return this.peerMap;
    }

    public boolean matchLog(long index, long term) {
        boolean matched = this.logManager.matchTerm(term, index);
        logger.debug("Log {}-{} matched: {}", new Object[]{index, term, matched});
        return matched;
    }

    public ExecutorService getSerialToParallelPool() {
        return this.serialToParallelPool;
    }

    public Object getSyncLock() {
        return this.syncLock;
    }

    void processValidHeartbeatReq(HeartBeatRequest request, HeartBeatResponse response) {
    }

    long checkElectorLogProgress(ElectionRequest electionRequest) {
        long thatLastLogTerm;
        long thatTerm = electionRequest.getTerm();
        long thatLastLogIndex = electionRequest.getLastLogIndex();
        long resp = this.checkLogProgress(thatLastLogIndex, thatLastLogTerm = electionRequest.getLastLogTerm());
        if (resp == -1L) {
            logger.info("{} accepted an election request, term:{}/{}, logIndex:{}/{}, logTerm:{}/{}", new Object[]{this.name, thatTerm, this.term.get(), thatLastLogIndex, this.logManager.getLastLogIndex(), thatLastLogTerm, this.logManager.getLastLogTerm()});
            this.setCharacter(NodeCharacter.FOLLOWER);
            this.lastHeartbeatReceivedTime = System.currentTimeMillis();
            this.setVoteFor(electionRequest.getElector());
            this.updateHardState(thatTerm, this.getVoteFor());
        } else {
            logger.info("{} rejected an election request, term:{}/{}, logIndex:{}/{}, logTerm:{}/{}", new Object[]{this.name, thatTerm, this.term.get(), thatLastLogIndex, this.logManager.getLastLogIndex(), thatLastLogTerm, this.logManager.getLastLogTerm()});
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long checkLogProgress(long lastLogIndex, long lastLogTerm) {
        long response;
        RaftLogManager raftLogManager = this.logManager;
        synchronized (raftLogManager) {
            response = this.logManager.isLogUpToDate(lastLogTerm, lastLogIndex) ? -1L : -2L;
        }
        return response;
    }

    public TSStatus forwardPlan(PhysicalPlan plan, Node node, Node header) {
        if (node == null || node.equals(this.thisNode)) {
            logger.debug("{}: plan {} has no where to be forwarded", (Object)this.name, (Object)plan);
            return StatusUtils.NO_LEADER;
        }
        logger.debug("{}: Forward {} to node {}", new Object[]{this.name, plan, node});
        TSStatus status = this.config.isUseAsyncServer() ? this.forwardPlanAsync(plan, node, header) : this.forwardPlanSync(plan, node, header);
        if (status.getCode() == TSStatusCode.NO_CONNECTION.getStatusCode() && (header == null || header.equals(this.getHeader())) && this.leader.get() != null && this.leader.get().equals(node)) {
            this.lastHeartbeatReceivedTime = -1L;
            this.leader.set(null);
            this.waitLeader();
        }
        return status;
    }

    private TSStatus forwardPlanAsync(PhysicalPlan plan, Node receiver, Node header) {
        RaftService.AsyncClient client = this.getAsyncClient(receiver);
        if (client == null) {
            logger.debug("{}: can not get client for node={}", (Object)this.name, (Object)receiver);
            return StatusUtils.NO_CONNECTION.deepCopy().setMessage(String.format("%s cannot be reached", receiver));
        }
        return this.forwardPlanAsync(plan, receiver, header, client);
    }

    public TSStatus forwardPlanAsync(PhysicalPlan plan, Node receiver, Node header, RaftService.AsyncClient client) {
        try {
            TSStatus tsStatus = SyncClientAdaptor.executeNonQuery(client, plan, header, receiver);
            if (tsStatus == null) {
                tsStatus = StatusUtils.TIME_OUT;
                logger.warn(MSG_FORWARD_TIMEOUT, new Object[]{this.name, plan, receiver});
            }
            return tsStatus;
        }
        catch (IOException | TException e) {
            logger.error(MSG_FORWARD_ERROR, new Object[]{this.name, plan, receiver, e});
            return StatusUtils.getStatus(StatusUtils.INTERNAL_ERROR, e.getMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("{}: forward {} to {} interrupted", new Object[]{this.name, plan, receiver});
            return StatusUtils.TIME_OUT;
        }
    }

    private TSStatus forwardPlanSync(PhysicalPlan plan, Node receiver, Node header) {
        RaftService.Client client = this.getSyncClient(receiver);
        if (client == null) {
            logger.warn(MSG_FORWARD_TIMEOUT, new Object[]{this.name, plan, receiver});
            return StatusUtils.TIME_OUT;
        }
        return this.forwardPlanSync(plan, receiver, header, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus forwardPlanSync(PhysicalPlan plan, Node receiver, Node header, RaftService.Client client) {
        try {
            TSStatus tsStatus;
            ExecutNonQueryReq req = new ExecutNonQueryReq();
            req.setPlanBytes(PlanSerializer.getInstance().serialize(plan));
            if (header != null) {
                req.setHeader(header);
            }
            if ((tsStatus = client.executeNonQueryPlan(req)) == null) {
                tsStatus = StatusUtils.TIME_OUT;
                logger.warn(MSG_FORWARD_TIMEOUT, new Object[]{this.name, plan, receiver});
            }
            TSStatus tSStatus = tsStatus;
            return tSStatus;
        }
        catch (IOException e) {
            logger.error(MSG_FORWARD_ERROR, new Object[]{this.name, plan, receiver, e});
            TSStatus tsStatus = StatusUtils.getStatus(StatusUtils.INTERNAL_ERROR, e.getMessage());
            return tsStatus;
        }
        catch (TException e) {
            TSStatus status;
            if (e.getCause() instanceof SocketTimeoutException) {
                status = StatusUtils.TIME_OUT;
                logger.warn(MSG_FORWARD_TIMEOUT, new Object[]{this.name, plan, receiver});
            } else {
                logger.error(MSG_FORWARD_ERROR, new Object[]{this.name, plan, receiver, e});
                status = StatusUtils.getStatus(StatusUtils.INTERNAL_ERROR, e.getMessage());
            }
            client.getInputProtocol().getTransport().close();
            TSStatus tSStatus = status;
            return tSStatus;
        }
        finally {
            ClientUtils.putBackSyncClient(client);
        }
    }

    public RaftService.AsyncClient getAsyncClient(Node node) {
        return this.getAsyncClient(node, this.asyncClientPool, true);
    }

    public RaftService.AsyncClient getAsyncClient(Node node, boolean activatedOnly) {
        return this.getAsyncClient(node, this.asyncClientPool, activatedOnly);
    }

    public RaftService.AsyncClient getSendLogAsyncClient(Node node) {
        return this.getAsyncClient(node, this.asyncSendLogClientPool, true);
    }

    private RaftService.AsyncClient getAsyncClient(Node node, AsyncClientPool pool, boolean activatedOnly) {
        if (ClusterConstant.EMPTY_NODE.equals(node) || node == null) {
            return null;
        }
        try {
            return pool.getClient(node, activatedOnly);
        }
        catch (IOException e) {
            logger.warn("{} cannot connect to node {}", new Object[]{this.name, node, e});
            return null;
        }
    }

    public RaftService.Client getSyncClient(Node node) {
        return this.getSyncClient(this.syncClientPool, node, true);
    }

    public RaftService.Client getSyncClient(Node node, boolean activatedOnly) {
        return this.getSyncClient(this.syncClientPool, node, activatedOnly);
    }

    public AtomicLong getTerm() {
        return this.term;
    }

    private synchronized LogDispatcher getLogDispatcher() {
        if (this.logDispatcher == null) {
            this.logDispatcher = new LogDispatcher(this);
        }
        return this.logDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppendLogResult waitAppendResult(AtomicInteger voteCounter, AtomicBoolean leaderShipStale, AtomicLong newLeaderTerm) {
        long startTime = Timer.Statistic.RAFT_SENDER_VOTE_COUNTER.getOperationStartTime();
        AtomicInteger atomicInteger = voteCounter;
        synchronized (atomicInteger) {
            long waitStart = System.currentTimeMillis();
            long alreadyWait = 0L;
            while (voteCounter.get() > 0 && alreadyWait < (long)RaftServer.getWriteOperationTimeoutMS() && voteCounter.get() != Integer.MAX_VALUE) {
                try {
                    voteCounter.wait(RaftServer.getWriteOperationTimeoutMS());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn("Unexpected interruption when sending a log", (Throwable)e);
                }
                alreadyWait = System.currentTimeMillis() - waitStart;
            }
        }
        Timer.Statistic.RAFT_SENDER_VOTE_COUNTER.calOperationCostTimeFromStart(startTime);
        if (leaderShipStale.get()) {
            this.stepDown(newLeaderTerm.get(), false);
            return AppendLogResult.LEADERSHIP_STALE;
        }
        if (this.character != NodeCharacter.LEADER) {
            return AppendLogResult.LEADERSHIP_STALE;
        }
        if (voteCounter.get() > 0) {
            return AppendLogResult.TIME_OUT;
        }
        return AppendLogResult.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitLog(Log log) throws LogExecutionException {
        long startTime = Timer.Statistic.RAFT_SENDER_COMPETE_LOG_MANAGER_BEFORE_COMMIT.getOperationStartTime();
        Object object = this.logManager;
        synchronized (object) {
            Timer.Statistic.RAFT_SENDER_COMPETE_LOG_MANAGER_BEFORE_COMMIT.calOperationCostTimeFromStart(startTime);
            startTime = Timer.Statistic.RAFT_SENDER_COMMIT_LOG_IN_MANAGER.getOperationStartTime();
            this.logManager.commitTo(log.getCurrLogIndex());
        }
        Timer.Statistic.RAFT_SENDER_COMMIT_LOG_IN_MANAGER.calOperationCostTimeFromStart(startTime);
        startTime = Timer.Statistic.RAFT_SENDER_COMMIT_WAIT_LOG_APPLY.getOperationStartTime();
        object = log;
        synchronized (object) {
            while (!log.isApplied()) {
                try {
                    log.wait(5L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new LogExecutionException(e);
                }
            }
        }
        Timer.Statistic.RAFT_SENDER_COMMIT_WAIT_LOG_APPLY.calOperationCostTimeFromStart(startTime);
        if (log.getException() != null) {
            throw new LogExecutionException(log.getException());
        }
    }

    protected TSStatus handleLogExecutionException(PhysicalPlan log, Throwable cause) {
        if (cause instanceof BatchProcessException) {
            return RpcUtils.getStatus(Arrays.asList(((BatchProcessException)cause).getFailingStatus()));
        }
        if (cause instanceof DuplicatedTemplateException) {
            return StatusUtils.DUPLICATED_TEMPLATE.deepCopy().setMessage(cause.getMessage());
        }
        if (cause instanceof StorageGroupNotSetException) {
            TSStatus status = StatusUtils.getStatus(TSStatusCode.STORAGE_GROUP_NOT_EXIST);
            status.setMessage(cause.getMessage());
            return status;
        }
        TSStatus tsStatus = StatusUtils.getStatus(StatusUtils.EXECUTE_STATEMENT_ERROR, cause.getMessage());
        if (cause instanceof RuntimeException) {
            logger.error("RuntimeException during executing {}", (Object)log, (Object)cause);
        }
        if (cause instanceof IoTDBException) {
            tsStatus.setCode(((IoTDBException)cause).getErrorCode());
        }
        if (!(cause instanceof PathNotExistException || cause instanceof PathAlreadyExistException || cause instanceof StorageGroupAlreadySetException)) {
            logger.debug("{} cannot be executed because ", (Object)log, (Object)cause);
        }
        return tsStatus;
    }

    AppendEntryRequest buildAppendEntryRequest(Log log, boolean serializeNow) {
        AppendEntryRequest request = new AppendEntryRequest();
        request.setTerm(this.term.get());
        if (serializeNow) {
            ByteBuffer byteBuffer = log.serialize();
            log.setByteSize(byteBuffer.array().length);
            request.setEntry(byteBuffer);
        }
        request.setLeader(this.getThisNode());
        request.setLeaderCommit(this.logManager.getCommitLogIndex());
        request.setPrevLogIndex(log.getCurrLogIndex() - 1L);
        try {
            request.setPrevLogTerm(this.logManager.getTerm(log.getCurrLogIndex() - 1L));
        }
        catch (Exception e) {
            logger.error("getTerm failed for newly append entries", (Throwable)e);
        }
        if (this.getHeader() != null) {
            request.setHeader(this.getHeader());
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepDown(long newTerm, boolean fromLeader) {
        AtomicLong atomicLong = this.term;
        synchronized (atomicLong) {
            long currTerm = this.term.get();
            if (currTerm < newTerm) {
                logger.info("{} has update it's term to {}", (Object)this.getName(), (Object)newTerm);
                this.term.set(newTerm);
                this.setVoteFor(null);
                this.setLeader(ClusterConstant.EMPTY_NODE);
                this.updateHardState(newTerm, this.getVoteFor());
            }
            if (fromLeader) {
                this.setCharacter(NodeCharacter.FOLLOWER);
                this.lastHeartbeatReceivedTime = System.currentTimeMillis();
            }
        }
    }

    public Node getThisNode() {
        return this.thisNode;
    }

    public void setThisNode(Node thisNode) {
        this.thisNode = thisNode;
    }

    public Node getHeader() {
        return null;
    }

    public void updateHardState(long currentTerm, Node voteFor) {
        HardState state = this.logManager.getHardState();
        state.setCurrentTerm(currentTerm);
        state.setVoteFor(voteFor);
        this.logManager.updateHardState(state);
    }

    public Node getVoteFor() {
        return this.voteFor;
    }

    public void setVoteFor(Node voteFor) {
        if (!Objects.equals(voteFor, this.voteFor)) {
            logger.info("{} has update it's voteFor to {}", (Object)this.getName(), (Object)voteFor);
            this.voteFor = voteFor;
        }
    }

    boolean appendLogInGroup(Log log) throws LogExecutionException {
        if (this.allNodes.size() == 1) {
            long startTime = Timer.Statistic.RAFT_SENDER_COMMIT_LOG.getOperationStartTime();
            logger.debug(MSG_LOG_IS_ACCEPTED, (Object)this.name, (Object)log);
            this.commitLog(log);
            Timer.Statistic.RAFT_SENDER_COMMIT_LOG.calOperationCostTimeFromStart(startTime);
            return true;
        }
        int retryTime = 0;
        block6: while (true) {
            long startTime = Timer.Statistic.RAFT_SENDER_SEND_LOG_TO_FOLLOWERS.getOperationStartTime();
            logger.debug("{}: Send log {} to other nodes, retry times: {}", new Object[]{this.name, log, retryTime});
            if (this.character != NodeCharacter.LEADER) {
                logger.debug("Has lose leadership, so need not to send log");
                return false;
            }
            AppendLogResult result = this.sendLogToFollowers(log, this.allNodes.size() / 2);
            Timer.Statistic.RAFT_SENDER_SEND_LOG_TO_FOLLOWERS.calOperationCostTimeFromStart(startTime);
            switch (result) {
                case OK: {
                    startTime = Timer.Statistic.RAFT_SENDER_COMMIT_LOG.getOperationStartTime();
                    logger.debug(MSG_LOG_IS_ACCEPTED, (Object)this.name, (Object)log);
                    this.commitLog(log);
                    Timer.Statistic.RAFT_SENDER_COMMIT_LOG.calOperationCostTimeFromStart(startTime);
                    return true;
                }
                case TIME_OUT: {
                    logger.debug("{}: log {} timed out, retrying...", (Object)this.name, (Object)log);
                    try {
                        Thread.sleep(1000L);
                        continue block6;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (++retryTime <= 5) continue block6;
                    return false;
                }
            }
            break;
        }
        return false;
    }

    private AppendLogResult sendLogToFollowers(Log log, int requiredQuorum) {
        if (requiredQuorum <= 0) {
            return this.sendLogToFollowers(log, new AtomicInteger(this.allNodes.size() / 2));
        }
        return this.sendLogToFollowers(log, new AtomicInteger(Math.min(requiredQuorum, this.allNodes.size() - 1)));
    }

    private AppendLogResult sendLogToFollowers(Log log, AtomicInteger voteCounter) {
        if (this.allNodes.size() == 1) {
            return AppendLogResult.OK;
        }
        logger.debug("{} sending a log to followers: {}", (Object)this.name, (Object)log);
        AtomicBoolean leaderShipStale = new AtomicBoolean(false);
        AtomicLong newLeaderTerm = new AtomicLong(this.term.get());
        AppendEntryRequest request = this.buildAppendEntryRequest(log, true);
        try {
            if (this.allNodes.size() > 2) {
                for (Node node : this.allNodes) {
                    this.appendLogThreadPool.submit(() -> this.sendLogToFollower(log, voteCounter, node, leaderShipStale, newLeaderTerm, request));
                    if (this.character == NodeCharacter.LEADER) continue;
                    return AppendLogResult.LEADERSHIP_STALE;
                }
            } else {
                for (Node node : this.allNodes) {
                    this.sendLogToFollower(log, voteCounter, node, leaderShipStale, newLeaderTerm, request);
                    if (this.character == NodeCharacter.LEADER) continue;
                    return AppendLogResult.LEADERSHIP_STALE;
                }
            }
        }
        catch (ConcurrentModificationException e) {
            return AppendLogResult.TIME_OUT;
        }
        return this.waitAppendResult(voteCounter, leaderShipStale, newLeaderTerm);
    }

    public void sendLogToFollower(Log log, AtomicInteger voteCounter, Node node, AtomicBoolean leaderShipStale, AtomicLong newLeaderTerm, AppendEntryRequest request) {
        if (node.equals(this.thisNode)) {
            return;
        }
        long startTime = Timer.Statistic.RAFT_SENDER_WAIT_FOR_PREV_LOG.getOperationStartTime();
        Peer peer = this.peerMap.computeIfAbsent(node, k -> new Peer(this.logManager.getLastLogIndex()));
        if (!this.waitForPrevLog(peer, log)) {
            logger.warn("{}: node {} timed out when appending {}", new Object[]{this.name, node, log});
            return;
        }
        Timer.Statistic.RAFT_SENDER_WAIT_FOR_PREV_LOG.calOperationCostTimeFromStart(startTime);
        if (this.character != NodeCharacter.LEADER) {
            return;
        }
        if (this.config.isUseAsyncServer()) {
            this.sendLogAsync(log, voteCounter, node, leaderShipStale, newLeaderTerm, request, peer);
        } else {
            this.sendLogSync(log, voteCounter, node, leaderShipStale, newLeaderTerm, request, peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForPrevLog(Peer peer, Log log) {
        int maxLogDiff = this.config.getMaxNumOfLogsInMem();
        long waitStart = System.currentTimeMillis();
        long alreadyWait = 0L;
        while (peer.getMatchIndex() < log.getCurrLogIndex() - (long)maxLogDiff && this.character == NodeCharacter.LEADER && alreadyWait <= (long)RaftServer.getWriteOperationTimeoutMS()) {
            Peer peer2 = peer;
            synchronized (peer2) {
                try {
                    peer.wait(RaftServer.getWriteOperationTimeoutMS());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn("Waiting for peer to catch up interrupted");
                    return false;
                }
            }
            alreadyWait = System.currentTimeMillis() - waitStart;
        }
        return alreadyWait <= (long)RaftServer.getWriteOperationTimeoutMS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLogSync(Log log, AtomicInteger voteCounter, Node node, AtomicBoolean leaderShipStale, AtomicLong newLeaderTerm, AppendEntryRequest request, Peer peer) {
        RaftService.Client client = this.getSyncClient(node);
        if (client != null) {
            AppendNodeEntryHandler handler = this.getAppendNodeEntryHandler(log, voteCounter, node, leaderShipStale, newLeaderTerm, peer);
            try {
                logger.debug("{} sending a log to {}: {}", new Object[]{this.name, node, log});
                long result = client.appendEntry(request);
                handler.onComplete(result);
            }
            catch (TException e) {
                client.getInputProtocol().getTransport().close();
                handler.onError((Exception)((Object)e));
            }
            catch (Exception e) {
                handler.onError(e);
            }
            finally {
                ClientUtils.putBackSyncClient(client);
            }
        }
    }

    public AppendNodeEntryHandler getAppendNodeEntryHandler(Log log, AtomicInteger voteCounter, Node node, AtomicBoolean leaderShipStale, AtomicLong newLeaderTerm, Peer peer) {
        AppendNodeEntryHandler handler = new AppendNodeEntryHandler();
        handler.setReceiver(node);
        handler.setVoteCounter(voteCounter);
        handler.setLeaderShipStale(leaderShipStale);
        handler.setLog(log);
        handler.setMember(this);
        handler.setPeer(peer);
        handler.setReceiverTerm(newLeaderTerm);
        return handler;
    }

    public void setAppendLogThreadPool(ExecutorService appendLogThreadPool) {
        this.appendLogThreadPool = appendLogThreadPool;
    }

    public Object getSnapshotApplyLock() {
        return this.snapshotApplyLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long appendEntry(long prevLogIndex, long prevLogTerm, long leaderCommit, Log log) {
        long success;
        long resp = this.checkPrevLogIndex(prevLogIndex);
        if (resp != -1L) {
            return resp;
        }
        long startTime = Timer.Statistic.RAFT_RECEIVER_APPEND_ENTRY.getOperationStartTime();
        RaftLogManager raftLogManager = this.logManager;
        synchronized (raftLogManager) {
            success = this.logManager.maybeAppend(prevLogIndex, prevLogTerm, leaderCommit, log);
        }
        Timer.Statistic.RAFT_RECEIVER_APPEND_ENTRY.calOperationCostTimeFromStart(startTime);
        if (success != -1L) {
            logger.debug("{} append a new log {}", (Object)this.name, (Object)log);
            resp = -1L;
        } else {
            resp = -2L;
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForPrevLog(long prevLogIndex) {
        long waitStart = System.currentTimeMillis();
        long alreadyWait = 0L;
        Object logUpdateCondition = this.logManager.getLogUpdateCondition(prevLogIndex);
        long lastLogIndex = this.logManager.getLastLogIndex();
        while (lastLogIndex < prevLogIndex && alreadyWait <= (long)RaftServer.getWriteOperationTimeoutMS()) {
            try {
                Object object = logUpdateCondition;
                synchronized (object) {
                    logUpdateCondition.wait(1L);
                }
                lastLogIndex = this.logManager.getLastLogIndex();
                if (lastLogIndex >= prevLogIndex) {
                    return true;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            alreadyWait = System.currentTimeMillis() - waitStart;
        }
        return alreadyWait <= (long)RaftServer.getWriteOperationTimeoutMS();
    }

    private long checkPrevLogIndex(long prevLogIndex) {
        long lastLogIndex = this.logManager.getLastLogIndex();
        long startTime = Timer.Statistic.RAFT_RECEIVER_WAIT_FOR_PREV_LOG.getOperationStartTime();
        if (lastLogIndex < prevLogIndex && !this.waitForPrevLog(prevLogIndex)) {
            Timer.Statistic.RAFT_RECEIVER_INDEX_DIFF.add(prevLogIndex - lastLogIndex);
            return -2L;
        }
        Timer.Statistic.RAFT_RECEIVER_WAIT_FOR_PREV_LOG.calOperationCostTimeFromStart(startTime);
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long appendEntries(long prevLogIndex, long prevLogTerm, long leaderCommit, List<Log> logs) {
        logger.debug("{}, prevLogIndex={}, prevLogTerm={}, leaderCommit={}", new Object[]{this.name, prevLogIndex, prevLogTerm, leaderCommit});
        if (logs.isEmpty()) {
            return -1L;
        }
        long resp = this.checkPrevLogIndex(prevLogIndex);
        if (resp != -1L) {
            return resp;
        }
        RaftLogManager raftLogManager = this.logManager;
        synchronized (raftLogManager) {
            long startTime = Timer.Statistic.RAFT_RECEIVER_APPEND_ENTRY.getOperationStartTime();
            resp = this.logManager.maybeAppend(prevLogIndex, prevLogTerm, leaderCommit, logs);
            Timer.Statistic.RAFT_RECEIVER_APPEND_ENTRY.calOperationCostTimeFromStart(startTime);
            if (resp != -1L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} append a new log list {}, commit to {}", new Object[]{this.name, logs, leaderCommit});
                }
                resp = -1L;
            } else {
                resp = -2L;
            }
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checkRequestTerm(long leaderTerm, Node leader) {
        long localTerm;
        AtomicLong atomicLong = this.term;
        synchronized (atomicLong) {
            localTerm = this.term.get();
            if (leaderTerm < localTerm) {
                logger.debug("{} rejected the AppendEntriesRequest for term: {}/{}", new Object[]{this.name, leaderTerm, localTerm});
                return localTerm;
            }
            if (leaderTerm > localTerm) {
                this.stepDown(leaderTerm, true);
            } else {
                this.lastHeartbeatReceivedTime = System.currentTimeMillis();
            }
            this.setLeader(leader);
            if (this.character != NodeCharacter.FOLLOWER) {
                this.term.notifyAll();
            }
        }
        logger.debug("{} accepted the AppendEntryRequest for term: {}", (Object)this.name, (Object)localTerm);
        return -1L;
    }

    static enum AppendLogResult {
        OK,
        TIME_OUT,
        LEADERSHIP_STALE;

    }

    public static class StrongCheckConsistency
    implements CheckConsistency {
        @Override
        public void postCheckConsistency(long leaderCommitId, long localAppliedId) throws CheckConsistencyException {
            if (leaderCommitId > localAppliedId || leaderCommitId == Long.MAX_VALUE || leaderCommitId == Long.MIN_VALUE) {
                throw CheckConsistencyException.CHECK_STRONG_CONSISTENCY_EXCEPTION;
            }
        }
    }

    public static class MidCheckConsistency
    implements CheckConsistency {
        @Override
        public void postCheckConsistency(long leaderCommitId, long localAppliedId) throws CheckConsistencyException {
            if (leaderCommitId == Long.MAX_VALUE || leaderCommitId == Long.MIN_VALUE || leaderCommitId - localAppliedId > ClusterDescriptor.getInstance().getConfig().getMaxReadLogLag()) {
                throw CheckConsistencyException.CHECK_MID_CONSISTENCY_EXCEPTION;
            }
        }
    }

    public static interface CheckConsistency {
        public void postCheckConsistency(long var1, long var3) throws CheckConsistencyException;
    }
}

