/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.IQueueRepository;
import io.moquette.broker.IRetainedRepository;
import io.moquette.broker.ISubscriptionsRepository;
import io.moquette.broker.config.IConfig;
import io.moquette.persistence.H2QueueRepository;
import io.moquette.persistence.H2RetainedRepository;
import io.moquette.persistence.H2SubscriptionsRepository;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2Builder {
    private static final Logger LOG = LoggerFactory.getLogger(H2Builder.class);
    private final String storePath;
    private final int autosaveInterval;
    private final ScheduledExecutorService scheduler;
    private MVStore mvStore;

    public H2Builder(IConfig props, ScheduledExecutorService scheduler) {
        this.storePath = props.getProperty("persistent_store", "");
        String autosaveProp = props.getProperty("autosave_interval", "30");
        this.autosaveInterval = Integer.parseInt(autosaveProp);
        this.scheduler = scheduler;
    }

    public H2Builder initStore() {
        LOG.info("Initializing H2 store");
        if (this.storePath == null || this.storePath.isEmpty()) {
            throw new IllegalArgumentException("H2 store path can't be null or empty");
        }
        this.mvStore = new MVStore.Builder().fileName(this.storePath).autoCommitDisabled().open();
        LOG.trace("Scheduling H2 commit task");
        this.scheduler.scheduleWithFixedDelay(() -> {
            LOG.trace("Committing to H2");
            this.mvStore.commit();
        }, this.autosaveInterval, this.autosaveInterval, TimeUnit.SECONDS);
        return this;
    }

    public ISubscriptionsRepository subscriptionsRepository() {
        return new H2SubscriptionsRepository(this.mvStore);
    }

    public void closeStore() {
        this.mvStore.close();
    }

    public IQueueRepository queueRepository() {
        return new H2QueueRepository(this.mvStore);
    }

    public IRetainedRepository retainedRepository() {
        return new H2RetainedRepository(this.mvStore);
    }
}

