/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.db.query.udf.api.UDTF;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.collector.PointCollector;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.db.query.udf.api.exception.UDFException;
import org.apache.iotdb.db.query.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class UDTFValueTrend
implements UDTF {
    protected boolean hasPrevious = false;
    protected int previousInt = 0;
    protected long previousLong = 0L;
    protected float previousFloat = 0.0f;
    protected double previousDouble = 0.0;
    protected TSDataType dataType;

    @Override
    public void validate(UDFParameterValidator validator) throws UDFException {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
    }

    protected void updatePreviousValue(Row row) throws UDFInputSeriesDataTypeNotValidException {
        switch (this.dataType) {
            case INT32: {
                this.previousInt = row.getInt(0);
                break;
            }
            case INT64: {
                this.previousLong = row.getLong(0);
                break;
            }
            case FLOAT: {
                this.previousFloat = row.getFloat(0);
                break;
            }
            case DOUBLE: {
                this.previousDouble = row.getDouble(0);
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, this.dataType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
            }
        }
    }

    protected abstract void doTransform(Row var1, PointCollector var2) throws UDFInputSeriesDataTypeNotValidException, IOException;
}

