/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup.timeindex;

import org.apache.iotdb.db.engine.storagegroup.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.engine.storagegroup.timeindex.FileTimeIndex;
import org.apache.iotdb.db.engine.storagegroup.timeindex.ITimeIndex;

public enum TimeIndexLevel {
    FILE_TIME_INDEX,
    DEVICE_TIME_INDEX;


    public ITimeIndex getTimeIndex() {
        switch (this) {
            case FILE_TIME_INDEX: {
                return new FileTimeIndex();
            }
        }
        return new DeviceTimeIndex();
    }

    public ITimeIndex getTimeIndex(int deviceNumInLastClosedTsFile) {
        switch (this) {
            case FILE_TIME_INDEX: {
                return new FileTimeIndex();
            }
        }
        return new DeviceTimeIndex(deviceNumInLastClosedTsFile);
    }

    public static TimeIndexLevel valueOf(int ordinal) {
        if (ordinal < 0 || ordinal >= TimeIndexLevel.values().length) {
            throw new IndexOutOfBoundsException("Invalid ordinal");
        }
        return TimeIndexLevel.values()[ordinal];
    }
}

