/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.task;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.merge.manage.MergeContext;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.merge.recover.MergeLogger;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.exception.write.TsFileNotCompleteException;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.writer.ForceAppendTsFileWriter;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeFileTask {
    private static final Logger logger = LoggerFactory.getLogger(MergeFileTask.class);
    private String taskName;
    private MergeContext context;
    private MergeLogger mergeLogger;
    private MergeResource resource;
    private List<TsFileResource> unmergedFiles;
    private FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    private int currentMergeIndex;
    private String currMergeFile;

    MergeFileTask(String taskName, MergeContext context, MergeLogger mergeLogger, MergeResource resource, List<TsFileResource> unmergedSeqFiles) {
        this.taskName = taskName;
        this.context = context;
        this.mergeLogger = mergeLogger;
        this.resource = resource;
        this.unmergedFiles = unmergedSeqFiles;
    }

    void mergeFiles() throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info("{} starts to merge {} files", (Object)this.taskName, (Object)this.unmergedFiles.size());
        }
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < this.unmergedFiles.size(); ++i) {
            int unmergedChunkNum;
            TsFileResource seqFile = this.unmergedFiles.get(i);
            this.currentMergeIndex = i;
            this.currMergeFile = seqFile.getTsFilePath();
            int mergedChunkNum = this.context.getMergedChunkCnt().getOrDefault(seqFile, 0);
            if (mergedChunkNum >= (unmergedChunkNum = this.context.getUnmergedChunkCnt().getOrDefault(seqFile, 0).intValue())) {
                if (logger.isInfoEnabled()) {
                    logger.info("{} moving unmerged data of {} to the merged file, {} merged chunks, {} unmerged chunks", new Object[]{this.taskName, seqFile.getTsFile().getName(), mergedChunkNum, unmergedChunkNum});
                }
                this.moveUnmergedToNew(seqFile);
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info("{} moving merged data of {} to the old file {} merged chunks, {} unmerged chunks", new Object[]{this.taskName, seqFile.getTsFile().getName(), mergedChunkNum, unmergedChunkNum});
                }
                this.moveMergedToOld(seqFile);
            }
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                return;
            }
            this.logProgress();
        }
        if (logger.isInfoEnabled()) {
            logger.info("{} has merged all files after {}ms", (Object)this.taskName, (Object)(System.currentTimeMillis() - startTime));
        }
        this.mergeLogger.logMergeEnd();
    }

    private void logProgress() {
        if (logger.isDebugEnabled()) {
            logger.debug("{} has merged {}, processed {}/{} files", new Object[]{this.taskName, this.currMergeFile, this.currentMergeIndex + 1, this.unmergedFiles.size()});
        }
    }

    public String getProgress() {
        return String.format("Merging %s, processed %d/%d files", this.currMergeFile, this.currentMergeIndex + 1, this.unmergedFiles.size());
    }

    private void moveMergedToOld(TsFileResource seqFile) throws IOException {
        int mergedChunkNum = this.context.getMergedChunkCnt().getOrDefault(seqFile, 0);
        if (mergedChunkNum == 0) {
            this.resource.removeFileAndWriter(seqFile);
            return;
        }
        seqFile.writeLock();
        try {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            FileReaderManager.getInstance().closeFileAndRemoveReader(seqFile.getTsFilePath());
            this.resource.removeFileReader(seqFile);
            TsFileIOWriter oldFileWriter = this.getOldFileWriter(seqFile);
            oldFileWriter.filterChunks(new HashMap<PartialPath, List<Long>>(this.context.getUnmergedChunkStartTimes().get(seqFile)));
            RestorableTsFileIOWriter newFileWriter = this.resource.getMergeFileWriter(seqFile, false);
            newFileWriter.close();
            try (TsFileSequenceReader newFileReader = new TsFileSequenceReader(newFileWriter.getFile().getPath());){
                Map chunkMetadataListInChunkGroups = newFileWriter.getDeviceChunkMetadataMap();
                if (logger.isDebugEnabled()) {
                    logger.debug("{} find {} merged chunk groups", (Object)this.taskName, (Object)chunkMetadataListInChunkGroups.size());
                }
                Iterator iterator = chunkMetadataListInChunkGroups.entrySet().iterator();
                while (true) {
                    if (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String deviceId = (String)entry.getKey();
                        List chunkMetadataList = (List)entry.getValue();
                        this.writeMergedChunkGroup(chunkMetadataList, deviceId, newFileReader, oldFileWriter);
                        if (!Thread.interrupted()) continue;
                        Thread.currentThread().interrupt();
                        oldFileWriter.close();
                        this.restoreOldFile(seqFile);
                        return;
                        continue;
                    }
                    break;
                }
            }
            this.updateStartTimeAndEndTime(seqFile, oldFileWriter);
            oldFileWriter.endFile();
            this.updatePlanIndexes(seqFile);
            seqFile.serialize();
            this.mergeLogger.logFileMergeEnd();
            logger.debug("{} moved merged chunks of {} to the old file", (Object)this.taskName, (Object)seqFile);
            if (!newFileWriter.getFile().delete()) {
                logger.warn("fail to delete {}", (Object)newFileWriter.getFile());
            }
            File nextMergeVersionFile = TsFileResource.modifyTsFileNameUnseqMergCnt(seqFile.getTsFile());
            this.fsFactory.moveFile(seqFile.getTsFile(), nextMergeVersionFile);
            this.fsFactory.moveFile(this.fsFactory.getFile(seqFile.getTsFile().getAbsolutePath() + ".resource"), this.fsFactory.getFile(nextMergeVersionFile.getAbsolutePath() + ".resource"));
            seqFile.setFile(nextMergeVersionFile);
        }
        catch (Exception e) {
            this.restoreOldFile(seqFile);
            throw e;
        }
        finally {
            seqFile.writeUnlock();
        }
    }

    private void updateStartTimeAndEndTime(TsFileResource seqFile, TsFileIOWriter fileWriter) {
        Map deviceChunkMetadataListMap = fileWriter.getDeviceChunkMetadataMap();
        for (Map.Entry deviceChunkMetadataListEntry : deviceChunkMetadataListMap.entrySet()) {
            String device = (String)deviceChunkMetadataListEntry.getKey();
            for (ChunkMetadata chunkMetadata : (List)deviceChunkMetadataListEntry.getValue()) {
                this.resource.updateStartTime(seqFile, device, chunkMetadata.getStartTime());
                this.resource.updateEndTime(seqFile, device, chunkMetadata.getEndTime());
            }
        }
        Map<String, Pair<Long, Long>> deviceStartEndTimePairMap = this.resource.getStartEndTime(seqFile);
        for (Map.Entry<String, Pair<Long, Long>> deviceStartEndTimePairEntry : deviceStartEndTimePairMap.entrySet()) {
            String device = deviceStartEndTimePairEntry.getKey();
            Pair<Long, Long> startEndTimePair = deviceStartEndTimePairEntry.getValue();
            seqFile.putStartTime(device, (Long)startEndTimePair.left);
            seqFile.putEndTime(device, (Long)startEndTimePair.right);
        }
    }

    private void restoreOldFile(TsFileResource seqFile) throws IOException {
        RestorableTsFileIOWriter oldFileRecoverWriter = new RestorableTsFileIOWriter(seqFile.getTsFile());
        if (oldFileRecoverWriter.hasCrashed() && oldFileRecoverWriter.canWrite()) {
            oldFileRecoverWriter.endFile();
        } else {
            oldFileRecoverWriter.close();
        }
    }

    private TsFileIOWriter getOldFileWriter(TsFileResource seqFile) throws IOException {
        ForceAppendTsFileWriter oldFileWriter;
        try {
            oldFileWriter = new ForceAppendTsFileWriter(seqFile.getTsFile());
            this.mergeLogger.logFileMergeStart(seqFile.getTsFile(), oldFileWriter.getTruncatePosition());
            logger.debug("{} moving merged chunks of {} to the old file", (Object)this.taskName, (Object)seqFile);
            oldFileWriter.doTruncate();
        }
        catch (TsFileNotCompleteException e) {
            oldFileWriter = new RestorableTsFileIOWriter(seqFile.getTsFile());
        }
        return oldFileWriter;
    }

    private void updatePlanIndexes(TsFileResource seqFile) {
        for (TsFileResource unseqFile : this.resource.getUnseqFiles()) {
            seqFile.updatePlanIndexes(unseqFile);
        }
    }

    private void writeMergedChunkGroup(List<ChunkMetadata> chunkMetadataList, String device, TsFileSequenceReader reader, TsFileIOWriter fileWriter) throws IOException {
        fileWriter.startChunkGroup(device);
        for (ChunkMetadata chunkMetaData : chunkMetadataList) {
            Chunk chunk = reader.readMemChunk(chunkMetaData);
            fileWriter.writeChunk(chunk, chunkMetaData);
            this.context.incTotalPointWritten(chunkMetaData.getNumOfPoints());
        }
        fileWriter.endChunkGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveUnmergedToNew(TsFileResource seqFile) throws IOException {
        Map<PartialPath, List<Long>> fileUnmergedChunkStartTimes = this.context.getUnmergedChunkStartTimes().get(seqFile);
        RestorableTsFileIOWriter fileWriter = this.resource.getMergeFileWriter(seqFile, false);
        this.mergeLogger.logFileMergeStart(fileWriter.getFile(), fileWriter.getFile().length());
        logger.debug("{} moving unmerged chunks of {} to the new file", (Object)this.taskName, (Object)seqFile);
        int unmergedChunkNum = this.context.getUnmergedChunkCnt().getOrDefault(seqFile, 0);
        if (unmergedChunkNum > 0) {
            for (Map.Entry<PartialPath, List<Long>> entry : fileUnmergedChunkStartTimes.entrySet()) {
                PartialPath path = entry.getKey();
                List<Long> chunkStartTimes = entry.getValue();
                if (chunkStartTimes.isEmpty()) continue;
                List<ChunkMetadata> chunkMetadataList = this.resource.queryChunkMetadata(path, seqFile);
                if (logger.isDebugEnabled()) {
                    logger.debug("{} find {} unmerged chunks", (Object)this.taskName, (Object)chunkMetadataList.size());
                }
                fileWriter.startChunkGroup(path.getDevice());
                this.writeUnmergedChunks(chunkStartTimes, chunkMetadataList, this.resource.getFileReader(seqFile), fileWriter);
                if (Thread.interrupted()) {
                    Thread.currentThread().interrupt();
                    return;
                }
                fileWriter.endChunkGroup();
            }
        }
        this.updateStartTimeAndEndTime(seqFile, (TsFileIOWriter)fileWriter);
        this.resource.removeFileReader(seqFile);
        fileWriter.endFile();
        this.updatePlanIndexes(seqFile);
        seqFile.writeLock();
        try {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            seqFile.serialize();
            this.mergeLogger.logFileMergeEnd();
            logger.debug("{} moved unmerged chunks of {} to the new file", (Object)this.taskName, (Object)seqFile);
            FileReaderManager.getInstance().closeFileAndRemoveReader(seqFile.getTsFilePath());
            if (!seqFile.getTsFile().delete()) {
                logger.warn("fail to delete {}", (Object)seqFile.getTsFile());
            }
            File nextMergeVersionFile = TsFileResource.modifyTsFileNameUnseqMergCnt(seqFile.getTsFile());
            this.fsFactory.moveFile(fileWriter.getFile(), nextMergeVersionFile);
            this.fsFactory.moveFile(this.fsFactory.getFile(seqFile.getTsFile().getAbsolutePath() + ".resource"), this.fsFactory.getFile(nextMergeVersionFile.getAbsolutePath() + ".resource"));
            seqFile.setFile(nextMergeVersionFile);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (IoTDBDescriptor.getInstance().getConfig().isMetaDataCacheEnable()) {
                ChunkCache.getInstance().clear();
                TimeSeriesMetadataCache.getInstance().clear();
            }
            seqFile.writeUnlock();
        }
    }

    private long writeUnmergedChunks(List<Long> chunkStartTimes, List<ChunkMetadata> chunkMetadataList, TsFileSequenceReader reader, RestorableTsFileIOWriter fileWriter) throws IOException {
        long maxVersion = 0L;
        int chunkIdx = 0;
        for (Long startTime : chunkStartTimes) {
            while (chunkIdx < chunkMetadataList.size()) {
                ChunkMetadata metaData = chunkMetadataList.get(chunkIdx);
                if (metaData.getStartTime() == startTime.longValue()) {
                    Chunk chunk = reader.readMemChunk(metaData);
                    fileWriter.writeChunk(chunk, metaData);
                    maxVersion = metaData.getVersion() > maxVersion ? metaData.getVersion() : maxVersion;
                    this.context.incTotalPointWritten(metaData.getNumOfPoints());
                    break;
                }
                ++chunkIdx;
            }
            if (!Thread.interrupted()) continue;
            Thread.currentThread().interrupt();
            return maxVersion;
        }
        return maxVersion;
    }
}

