/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metrics.source;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import org.apache.iotdb.db.metrics.server.ServerArgument;
import org.apache.iotdb.db.metrics.source.Source;

public class MetricsSource
implements Source {
    private static final String SOURCE_NAME = "iot-metrics";
    public MetricRegistry metricRegistry;
    public ServerArgument serverArgument;

    public MetricsSource(ServerArgument serverArgument, MetricRegistry metricRegistry) {
        this.serverArgument = serverArgument;
        this.metricRegistry = metricRegistry;
    }

    public void registerInfo() {
        this.metricRegistry.register(MetricRegistry.name((String)SOURCE_NAME, (String[])new String[]{"host"}), (Metric)new Gauge<String>(){

            public String getValue() {
                return MetricsSource.this.serverArgument.getHost();
            }
        });
        this.metricRegistry.register(MetricRegistry.name((String)SOURCE_NAME, (String[])new String[]{"port"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return MetricsSource.this.serverArgument.getPort();
            }
        });
        this.metricRegistry.register(MetricRegistry.name((String)SOURCE_NAME, (String[])new String[]{"cores"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return MetricsSource.this.serverArgument.getCores();
            }
        });
        this.metricRegistry.register(MetricRegistry.name((String)SOURCE_NAME, (String[])new String[]{"cpu_ratio"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return MetricsSource.this.serverArgument.getCpuRatio();
            }
        });
        this.metricRegistry.register(MetricRegistry.name((String)SOURCE_NAME, (String[])new String[]{"total_memory"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return (int)MetricsSource.this.serverArgument.getTotalMemory();
            }
        });
        this.metricRegistry.register(MetricRegistry.name((String)SOURCE_NAME, (String[])new String[]{"max_memory"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return (int)MetricsSource.this.serverArgument.getMaxMemory();
            }
        });
        this.metricRegistry.register(MetricRegistry.name((String)SOURCE_NAME, (String[])new String[]{"free_memory"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return (int)MetricsSource.this.serverArgument.getFreeMemory();
            }
        });
        this.metricRegistry.register(MetricRegistry.name((String)SOURCE_NAME, (String[])new String[]{"totalPhysical_memory"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return (int)MetricsSource.this.serverArgument.getTotalPhysicalMemory();
            }
        });
        this.metricRegistry.register(MetricRegistry.name((String)SOURCE_NAME, (String[])new String[]{"freePhysical_memory"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return (int)MetricsSource.this.serverArgument.getFreePhysicalMemory();
            }
        });
        this.metricRegistry.register(MetricRegistry.name((String)SOURCE_NAME, (String[])new String[]{"usedPhysical_memory"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return (int)MetricsSource.this.serverArgument.getUsedPhysicalMemory();
            }
        });
    }

    @Override
    public String sourceName() {
        return SOURCE_NAME;
    }
}

