/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read;

import java.io.File;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.compress.IUnCompressor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.TsFileRuntimeException;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexEntry;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.controller.MetadataQuerierByFileImpl;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.utils.BloomFilter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileSequenceReader
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TsFileSequenceReader.class);
    private static final Logger resourceLogger = LoggerFactory.getLogger((String)"FileMonitor");
    protected static final TSFileConfig config = TSFileDescriptor.getInstance().getConfig();
    private static final String METADATA_INDEX_NODE_DESERIALIZE_ERROR = "Something error happened while deserializing MetadataIndexNode of file {}";
    protected String file;
    protected TsFileInput tsFileInput;
    protected long fileMetadataPos;
    protected int fileMetadataSize;
    private ByteBuffer markerBuffer = ByteBuffer.allocate(1);
    protected TsFileMetadata tsFileMetaData;
    private Map<String, Map<String, TimeseriesMetadata>> cachedDeviceMetadata = new ConcurrentHashMap<String, Map<String, TimeseriesMetadata>>();
    private static final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private boolean cacheDeviceMetadata;
    private long minPlanIndex = Long.MAX_VALUE;
    private long maxPlanIndex = Long.MIN_VALUE;

    public TsFileSequenceReader(String file) throws IOException {
        this(file, true);
    }

    public TsFileSequenceReader(String file, boolean loadMetadataSize) throws IOException {
        if (resourceLogger.isDebugEnabled()) {
            resourceLogger.debug("{} reader is opened. {}", (Object)file, (Object)this.getClass().getName());
        }
        this.file = file;
        this.tsFileInput = FSFactoryProducer.getFileInputFactory().getTsFileInput(file);
        try {
            if (loadMetadataSize) {
                this.loadMetadataSize();
            }
        }
        catch (Throwable e) {
            this.tsFileInput.close();
            throw e;
        }
    }

    public TsFileSequenceReader(String file, boolean loadMetadata, boolean cacheDeviceMetadata) throws IOException {
        this(file, loadMetadata);
        this.cacheDeviceMetadata = cacheDeviceMetadata;
    }

    public TsFileSequenceReader(TsFileInput input) throws IOException {
        this(input, true);
    }

    public TsFileSequenceReader(TsFileInput input, boolean loadMetadataSize) throws IOException {
        this.tsFileInput = input;
        try {
            if (loadMetadataSize) {
                this.loadMetadataSize();
            }
        }
        catch (Throwable e) {
            this.tsFileInput.close();
            throw e;
        }
    }

    public TsFileSequenceReader(TsFileInput input, long fileMetadataPos, int fileMetadataSize) {
        this.tsFileInput = input;
        this.fileMetadataPos = fileMetadataPos;
        this.fileMetadataSize = fileMetadataSize;
    }

    public void loadMetadataSize() throws IOException {
        ByteBuffer metadataSize = ByteBuffer.allocate(4);
        if (this.readTailMagic().equals("TsFile")) {
            this.tsFileInput.read(metadataSize, this.tsFileInput.size() - (long)"TsFile".getBytes().length - 4L);
            metadataSize.flip();
            this.fileMetadataSize = ReadWriteIOUtils.readInt(metadataSize);
            this.fileMetadataPos = this.tsFileInput.size() - (long)"TsFile".getBytes().length - 4L - (long)this.fileMetadataSize;
        }
    }

    public long getFileMetadataPos() {
        return this.fileMetadataPos;
    }

    public int getFileMetadataSize() {
        return this.fileMetadataSize;
    }

    public String readTailMagic() throws IOException {
        long totalSize = this.tsFileInput.size();
        ByteBuffer magicStringBytes = ByteBuffer.allocate("TsFile".getBytes().length);
        this.tsFileInput.read(magicStringBytes, totalSize - (long)"TsFile".getBytes().length);
        magicStringBytes.flip();
        return new String(magicStringBytes.array());
    }

    public boolean isComplete() throws IOException {
        long size = this.tsFileInput.size();
        if (size >= (long)("TsFile".getBytes().length * 2 + 1)) {
            String tailMagic = this.readTailMagic();
            String headMagic = this.readHeadMagic();
            return tailMagic.equals(headMagic);
        }
        return false;
    }

    public String readHeadMagic() throws IOException {
        ByteBuffer magicStringBytes = ByteBuffer.allocate("TsFile".getBytes().length);
        this.tsFileInput.read(magicStringBytes, 0L);
        magicStringBytes.flip();
        return new String(magicStringBytes.array());
    }

    public byte readVersionNumber() throws IOException {
        ByteBuffer versionNumberByte = ByteBuffer.allocate(1);
        this.tsFileInput.read(versionNumberByte, "TsFile".getBytes().length);
        versionNumberByte.flip();
        return versionNumberByte.get();
    }

    public TsFileMetadata readFileMetadata() throws IOException {
        try {
            if (this.tsFileMetaData == null) {
                this.tsFileMetaData = TsFileMetadata.deserializeFrom(this.readData(this.fileMetadataPos, this.fileMetadataSize));
            }
        }
        catch (BufferOverflowException e) {
            logger.error("Something error happened while reading file metadata of file {}", (Object)this.file);
            throw e;
        }
        return this.tsFileMetaData;
    }

    public BloomFilter readBloomFilter() throws IOException {
        this.readFileMetadata();
        return this.tsFileMetaData.getBloomFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TimeseriesMetadata> readDeviceMetadata(String device) throws IOException {
        if (!this.cacheDeviceMetadata) {
            return this.readDeviceMetadataFromDisk(device);
        }
        cacheLock.readLock().lock();
        try {
            if (this.cachedDeviceMetadata.containsKey(device)) {
                Map<String, TimeseriesMetadata> map = this.cachedDeviceMetadata.get(device);
                return map;
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        cacheLock.writeLock().lock();
        try {
            if (this.cachedDeviceMetadata.containsKey(device)) {
                Map<String, TimeseriesMetadata> map = this.cachedDeviceMetadata.get(device);
                return map;
            }
            this.readFileMetadata();
            Map<String, TimeseriesMetadata> deviceMetadata = this.readDeviceMetadataFromDisk(device);
            this.cachedDeviceMetadata.put(device, deviceMetadata);
            Map<String, TimeseriesMetadata> map = deviceMetadata;
            return map;
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    private Map<String, TimeseriesMetadata> readDeviceMetadataFromDisk(String device) throws IOException {
        this.readFileMetadata();
        List<TimeseriesMetadata> timeseriesMetadataList = this.getDeviceTimeseriesMetadataWithoutChunkMetadata(device);
        HashMap<String, TimeseriesMetadata> deviceMetadata = new HashMap<String, TimeseriesMetadata>();
        for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataList) {
            deviceMetadata.put(timeseriesMetadata.getMeasurementId(), timeseriesMetadata);
        }
        return deviceMetadata;
    }

    public TimeseriesMetadata readTimeseriesMetadata(Path path, boolean ignoreNotExists) throws IOException {
        this.readFileMetadata();
        MetadataIndexNode deviceMetadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffset(deviceMetadataIndexNode, path.getDevice(), true, true);
        if (metadataIndexPair == null) {
            if (ignoreNotExists) {
                return null;
            }
            throw new IOException("Device {" + path.getDevice() + "} is not in tsFileMetaData");
        }
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        MetadataIndexNode metadataIndexNode = deviceMetadataIndexNode;
        if (!metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
            try {
                metadataIndexNode = MetadataIndexNode.deserializeFrom(buffer);
            }
            catch (BufferOverflowException e) {
                logger.error(METADATA_INDEX_NODE_DESERIALIZE_ERROR, (Object)this.file);
                throw e;
            }
            metadataIndexPair = this.getMetadataAndEndOffset(metadataIndexNode, path.getMeasurement(), false, false);
        }
        if (metadataIndexPair == null) {
            return null;
        }
        ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        while (buffer.hasRemaining()) {
            try {
                timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(buffer, true));
            }
            catch (BufferOverflowException e) {
                logger.error("Something error happened while deserializing TimeseriesMetadata of file {}", (Object)this.file);
                throw e;
            }
        }
        int searchResult = this.binarySearchInTimeseriesMetadataList(timeseriesMetadataList, path.getMeasurement());
        return searchResult >= 0 ? (TimeseriesMetadata)timeseriesMetadataList.get(searchResult) : null;
    }

    public List<TimeseriesMetadata> readTimeseriesMetadata(Path path, Set<String> allSensors) throws IOException {
        this.readFileMetadata();
        MetadataIndexNode deviceMetadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffset(deviceMetadataIndexNode, path.getDevice(), true, true);
        if (metadataIndexPair == null) {
            return Collections.emptyList();
        }
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        MetadataIndexNode metadataIndexNode = deviceMetadataIndexNode;
        if (!metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
            try {
                metadataIndexNode = MetadataIndexNode.deserializeFrom(buffer);
            }
            catch (BufferOverflowException e) {
                logger.error(METADATA_INDEX_NODE_DESERIALIZE_ERROR, (Object)this.file);
                throw e;
            }
            metadataIndexPair = this.getMetadataAndEndOffset(metadataIndexNode, path.getMeasurement(), false, false);
        }
        if (metadataIndexPair == null) {
            return Collections.emptyList();
        }
        ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        while (buffer.hasRemaining()) {
            TimeseriesMetadata timeseriesMetadata;
            try {
                timeseriesMetadata = TimeseriesMetadata.deserializeFrom(buffer, true);
            }
            catch (BufferOverflowException e) {
                logger.error("Something error happened while deserializing TimeseriesMetadata of file {}", (Object)this.file);
                throw e;
            }
            if (!allSensors.contains(timeseriesMetadata.getMeasurementId())) continue;
            timeseriesMetadataList.add(timeseriesMetadata);
        }
        return timeseriesMetadataList;
    }

    public List<TimeseriesMetadata> readTimeseriesMetadata(String device, Set<String> measurements) throws IOException {
        this.readFileMetadata();
        MetadataIndexNode deviceMetadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffset(deviceMetadataIndexNode, device, true, false);
        if (metadataIndexPair == null) {
            return Collections.emptyList();
        }
        ArrayList<TimeseriesMetadata> resultTimeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        ArrayList<String> measurementList = new ArrayList<String>(measurements);
        HashSet<String> measurementsHadFound = new HashSet<String>();
        for (int i = 0; i < measurementList.size(); ++i) {
            if (measurementsHadFound.contains(measurementList.get(i))) continue;
            ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
            Pair<MetadataIndexEntry, Long> measurementMetadataIndexPair = metadataIndexPair;
            ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
            MetadataIndexNode metadataIndexNode = deviceMetadataIndexNode;
            if (!metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                try {
                    metadataIndexNode = MetadataIndexNode.deserializeFrom(buffer);
                }
                catch (BufferOverflowException e) {
                    logger.error(METADATA_INDEX_NODE_DESERIALIZE_ERROR, (Object)this.file);
                    throw e;
                }
                measurementMetadataIndexPair = this.getMetadataAndEndOffset(metadataIndexNode, (String)measurementList.get(i), false, false);
            }
            if (measurementMetadataIndexPair == null) {
                return Collections.emptyList();
            }
            buffer = this.readData(((MetadataIndexEntry)measurementMetadataIndexPair.left).getOffset(), (Long)measurementMetadataIndexPair.right);
            while (buffer.hasRemaining()) {
                try {
                    timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(buffer, true));
                }
                catch (BufferOverflowException e) {
                    logger.error("Something error happened while deserializing TimeseriesMetadata of file {}", (Object)this.file);
                    throw e;
                }
            }
            for (int j = i; j < measurementList.size(); ++j) {
                int searchResult;
                String current = (String)measurementList.get(j);
                if (!measurementsHadFound.contains(current) && (searchResult = this.binarySearchInTimeseriesMetadataList(timeseriesMetadataList, current)) >= 0) {
                    resultTimeseriesMetadataList.add((TimeseriesMetadata)timeseriesMetadataList.get(searchResult));
                    measurementsHadFound.add(current);
                }
                if (measurementsHadFound.size() != measurements.size()) continue;
                return resultTimeseriesMetadataList;
            }
        }
        return resultTimeseriesMetadataList;
    }

    protected int binarySearchInTimeseriesMetadataList(List<TimeseriesMetadata> timeseriesMetadataList, String key) {
        int low = 0;
        int high = timeseriesMetadataList.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            TimeseriesMetadata midVal = timeseriesMetadataList.get(mid);
            int cmp = midVal.getMeasurementId().compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public List<String> getAllDevices() throws IOException {
        if (this.tsFileMetaData == null) {
            this.readFileMetadata();
        }
        return this.getAllDevices(this.tsFileMetaData.getMetadataIndex());
    }

    private List<String> getAllDevices(MetadataIndexNode metadataIndexNode) throws IOException {
        ArrayList<String> deviceList = new ArrayList<String>();
        int metadataIndexListSize = metadataIndexNode.getChildren().size();
        if (metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
            deviceList.addAll(metadataIndexNode.getChildren().stream().map(MetadataIndexEntry::getName).collect(Collectors.toList()));
            return deviceList;
        }
        for (int i = 0; i < metadataIndexListSize; ++i) {
            ByteBuffer buffer;
            MetadataIndexNode node;
            long endOffset = metadataIndexNode.getEndOffset();
            if (i != metadataIndexListSize - 1) {
                endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
            }
            if ((node = MetadataIndexNode.deserializeFrom(buffer = this.readData(metadataIndexNode.getChildren().get(i).getOffset(), endOffset))).getNodeType().equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
                deviceList.addAll(node.getChildren().stream().map(MetadataIndexEntry::getName).collect(Collectors.toList()));
                continue;
            }
            deviceList.addAll(this.getAllDevices(node));
        }
        return deviceList;
    }

    public Map<String, List<ChunkMetadata>> readChunkMetadataInDevice(String device) throws IOException {
        this.readFileMetadata();
        List<TimeseriesMetadata> timeseriesMetadataMap = this.getDeviceTimeseriesMetadata(device);
        if (timeseriesMetadataMap.isEmpty()) {
            return new HashMap<String, List<ChunkMetadata>>();
        }
        HashMap<String, List<ChunkMetadata>> seriesMetadata = new HashMap<String, List<ChunkMetadata>>();
        for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataMap) {
            seriesMetadata.put(timeseriesMetadata.getMeasurementId(), timeseriesMetadata.getChunkMetadataList());
        }
        return seriesMetadata;
    }

    public List<Path> getAllPaths() throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String device : this.getAllDevices()) {
            Map<String, TimeseriesMetadata> timeseriesMetadataMap = this.readDeviceMetadata(device);
            for (String measurementId : timeseriesMetadataMap.keySet()) {
                paths.add(new Path(device, measurementId));
            }
        }
        return paths;
    }

    private void generateMetadataIndex(MetadataIndexEntry metadataIndex, ByteBuffer buffer, String deviceId, MetadataIndexNodeType type, Map<String, List<TimeseriesMetadata>> timeseriesMetadataMap, boolean needChunkMetadata) throws IOException {
        try {
            if (type.equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
                while (buffer.hasRemaining()) {
                    timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(buffer, needChunkMetadata));
                }
                timeseriesMetadataMap.computeIfAbsent(deviceId, k -> new ArrayList()).addAll(timeseriesMetadataList);
            } else {
                deviceId = metadataIndex.getName();
                MetadataIndexNode metadataIndexNode = MetadataIndexNode.deserializeFrom(buffer);
                int metadataIndexListSize = metadataIndexNode.getChildren().size();
                for (int i = 0; i < metadataIndexListSize; ++i) {
                    long endOffset = metadataIndexNode.getEndOffset();
                    if (i != metadataIndexListSize - 1) {
                        endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
                    }
                    ByteBuffer nextBuffer = this.readData(metadataIndexNode.getChildren().get(i).getOffset(), endOffset);
                    this.generateMetadataIndex(metadataIndexNode.getChildren().get(i), nextBuffer, deviceId, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadata);
                }
            }
        }
        catch (BufferOverflowException e) {
            logger.error("Something error happened while generating MetadataIndex of file {}", (Object)this.file);
            throw e;
        }
    }

    public Map<String, List<TimeseriesMetadata>> getAllTimeseriesMetadata() throws IOException {
        if (this.tsFileMetaData == null) {
            this.readFileMetadata();
        }
        HashMap<String, List<TimeseriesMetadata>> timeseriesMetadataMap = new HashMap<String, List<TimeseriesMetadata>>();
        MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        List<MetadataIndexEntry> metadataIndexEntryList = metadataIndexNode.getChildren();
        for (int i = 0; i < metadataIndexEntryList.size(); ++i) {
            MetadataIndexEntry metadataIndexEntry = metadataIndexEntryList.get(i);
            long endOffset = this.tsFileMetaData.getMetadataIndex().getEndOffset();
            if (i != metadataIndexEntryList.size() - 1) {
                endOffset = metadataIndexEntryList.get(i + 1).getOffset();
            }
            ByteBuffer buffer = this.readData(metadataIndexEntry.getOffset(), endOffset);
            this.generateMetadataIndex(metadataIndexEntry, buffer, null, metadataIndexNode.getNodeType(), timeseriesMetadataMap, false);
        }
        return timeseriesMetadataMap;
    }

    private List<TimeseriesMetadata> getDeviceTimeseriesMetadataWithoutChunkMetadata(String device) throws IOException {
        MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffset(metadataIndexNode, device, true, true);
        if (metadataIndexPair == null) {
            return Collections.emptyList();
        }
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        TreeMap<String, List<TimeseriesMetadata>> timeseriesMetadataMap = new TreeMap<String, List<TimeseriesMetadata>>();
        this.generateMetadataIndex((MetadataIndexEntry)metadataIndexPair.left, buffer, device, MetadataIndexNodeType.INTERNAL_MEASUREMENT, timeseriesMetadataMap, false);
        ArrayList<TimeseriesMetadata> deviceTimeseriesMetadata = new ArrayList<TimeseriesMetadata>();
        for (List timeseriesMetadataList : timeseriesMetadataMap.values()) {
            deviceTimeseriesMetadata.addAll(timeseriesMetadataList);
        }
        return deviceTimeseriesMetadata;
    }

    private List<TimeseriesMetadata> getDeviceTimeseriesMetadata(String device) throws IOException {
        MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffset(metadataIndexNode, device, true, true);
        if (metadataIndexPair == null) {
            return Collections.emptyList();
        }
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        TreeMap<String, List<TimeseriesMetadata>> timeseriesMetadataMap = new TreeMap<String, List<TimeseriesMetadata>>();
        this.generateMetadataIndex((MetadataIndexEntry)metadataIndexPair.left, buffer, device, MetadataIndexNodeType.INTERNAL_MEASUREMENT, timeseriesMetadataMap, true);
        ArrayList<TimeseriesMetadata> deviceTimeseriesMetadata = new ArrayList<TimeseriesMetadata>();
        for (List timeseriesMetadataList : timeseriesMetadataMap.values()) {
            deviceTimeseriesMetadata.addAll(timeseriesMetadataList);
        }
        return deviceTimeseriesMetadata;
    }

    protected Pair<MetadataIndexEntry, Long> getMetadataAndEndOffset(MetadataIndexNode metadataIndex, String name, boolean isDeviceLevel, boolean exactSearch) throws IOException {
        try {
            if (isDeviceLevel && !metadataIndex.getNodeType().equals((Object)MetadataIndexNodeType.INTERNAL_DEVICE) || !isDeviceLevel && !metadataIndex.getNodeType().equals((Object)MetadataIndexNodeType.INTERNAL_MEASUREMENT)) {
                return metadataIndex.getChildIndexEntry(name, exactSearch);
            }
            Pair<MetadataIndexEntry, Long> childIndexEntry = metadataIndex.getChildIndexEntry(name, false);
            ByteBuffer buffer = this.readData(((MetadataIndexEntry)childIndexEntry.left).getOffset(), (Long)childIndexEntry.right);
            return this.getMetadataAndEndOffset(MetadataIndexNode.deserializeFrom(buffer), name, isDeviceLevel, exactSearch);
        }
        catch (BufferOverflowException e) {
            logger.error("Something error happened while deserializing MetadataIndex of file {}", (Object)this.file);
            throw e;
        }
    }

    public ChunkGroupHeader readChunkGroupHeader() throws IOException {
        return ChunkGroupHeader.deserializeFrom(this.tsFileInput.wrapAsInputStream(), true);
    }

    public ChunkGroupHeader readChunkGroupHeader(long position, boolean markerRead) throws IOException {
        return ChunkGroupHeader.deserializeFrom(this.tsFileInput, position, markerRead);
    }

    public void readPlanIndex() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        if (ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer) == 0) {
            throw new IOException("reach the end of the file.");
        }
        buffer.flip();
        this.minPlanIndex = buffer.getLong();
        buffer.clear();
        if (ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer) == 0) {
            throw new IOException("reach the end of the file.");
        }
        buffer.flip();
        this.maxPlanIndex = buffer.getLong();
    }

    public ChunkHeader readChunkHeader(byte chunkType) throws IOException {
        return ChunkHeader.deserializeFrom(this.tsFileInput.wrapAsInputStream(), chunkType);
    }

    private ChunkHeader readChunkHeader(long position, int chunkHeaderSize) throws IOException {
        return ChunkHeader.deserializeFrom(this.tsFileInput, position, chunkHeaderSize);
    }

    private ByteBuffer readChunk(long position, int dataSize) throws IOException {
        return this.readData(position, dataSize);
    }

    public Chunk readMemChunk(ChunkMetadata metaData) throws IOException {
        int chunkHeadSize = ChunkHeader.getSerializedSize(metaData.getMeasurementUid());
        ChunkHeader header = this.readChunkHeader(metaData.getOffsetOfChunkHeader(), chunkHeadSize);
        ByteBuffer buffer = this.readChunk(metaData.getOffsetOfChunkHeader() + (long)header.getSerializedSize(), header.getDataSize());
        return new Chunk(header, buffer, metaData.getDeleteIntervalList(), metaData.getStatistics());
    }

    public PageHeader readPageHeader(TSDataType type, boolean hasStatistic) throws IOException {
        return PageHeader.deserializeFrom(this.tsFileInput.wrapAsInputStream(), type, hasStatistic);
    }

    public long position() throws IOException {
        return this.tsFileInput.position();
    }

    public void position(long offset) throws IOException {
        this.tsFileInput.position(offset);
    }

    public void skipPageData(PageHeader header) throws IOException {
        this.tsFileInput.position(this.tsFileInput.position() + (long)header.getCompressedSize());
    }

    public ByteBuffer readCompressedPage(PageHeader header) throws IOException {
        return this.readData(-1L, header.getCompressedSize());
    }

    public ByteBuffer readPage(PageHeader header, CompressionType type) throws IOException {
        ByteBuffer buffer = this.readData(-1L, header.getCompressedSize());
        IUnCompressor unCompressor = IUnCompressor.getUnCompressor(type);
        ByteBuffer uncompressedBuffer = ByteBuffer.allocate(header.getUncompressedSize());
        if (type == CompressionType.UNCOMPRESSED) {
            return buffer;
        }
        unCompressor.uncompress(buffer.array(), buffer.position(), buffer.remaining(), uncompressedBuffer.array(), 0);
        return uncompressedBuffer;
    }

    public byte readMarker() throws IOException {
        this.markerBuffer.clear();
        if (ReadWriteIOUtils.readAsPossible(this.tsFileInput, this.markerBuffer) == 0) {
            throw new IOException("reach the end of the file.");
        }
        this.markerBuffer.flip();
        return this.markerBuffer.get();
    }

    @Override
    public void close() throws IOException {
        if (resourceLogger.isDebugEnabled()) {
            resourceLogger.debug("{} reader is closed.", (Object)this.file);
        }
        this.tsFileInput.close();
    }

    public String getFileName() {
        return this.file;
    }

    public long fileSize() throws IOException {
        return this.tsFileInput.size();
    }

    protected ByteBuffer readData(long position, int size) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        if (position < 0L) {
            if (ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer) != size) {
                throw new IOException("reach the end of the data");
            }
        } else {
            long actualReadSize = ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer, position, size);
            if (actualReadSize != (long)size) {
                throw new IOException(String.format("reach the end of the data. Size of data that want to read: %s,actual read size: %s, position: %s", size, actualReadSize, position));
            }
        }
        buffer.flip();
        return buffer;
    }

    protected ByteBuffer readData(long start, long end) throws IOException {
        return this.readData(start, (int)(end - start));
    }

    public int readRaw(long position, int length, ByteBuffer target) throws IOException {
        return ReadWriteIOUtils.readAsPossible(this.tsFileInput, target, position, length);
    }

    public long selfCheck(Map<Path, MeasurementSchema> newSchema, List<ChunkGroupMetadata> chunkGroupMetadataList, boolean fastFinish, boolean loadLastChunkMetadata) throws IOException {
        File checkFile = FSFactoryProducer.getFSFactory().getFile(this.file);
        if (!checkFile.exists()) {
            return -4L;
        }
        long fileSize = checkFile.length();
        ArrayList<ChunkMetadata> chunkMetadataList = new ArrayList<ChunkMetadata>();
        int headerLength = "TsFile".getBytes().length + 1;
        if (fileSize < (long)headerLength) {
            return -3L;
        }
        if (!"TsFile".equals(this.readHeadMagic()) || 3 != this.readVersionNumber()) {
            return -3L;
        }
        this.tsFileInput.position(headerLength);
        if (fileSize == (long)headerLength) {
            return headerLength;
        }
        if (this.isComplete()) {
            this.loadMetadataSize();
            if (fastFinish) {
                return -1L;
            }
        }
        long truncatedSize = headerLength;
        String lastDeviceId = null;
        ArrayList<MeasurementSchema> measurementSchemaList = new ArrayList<MeasurementSchema>();
        try {
            byte marker;
            block15: while ((marker = this.readMarker()) != 2) {
                switch (marker) {
                    case 1: 
                    case 5: {
                        Object pageHeader;
                        long fileOffsetOfChunk = this.position() - 1L;
                        ChunkHeader chunkHeader = this.readChunkHeader(marker);
                        String measurementID = chunkHeader.getMeasurementID();
                        MeasurementSchema measurementSchema = new MeasurementSchema(measurementID, chunkHeader.getDataType(), chunkHeader.getEncodingType(), chunkHeader.getCompressionType());
                        measurementSchemaList.add(measurementSchema);
                        TSDataType dataType = chunkHeader.getDataType();
                        Statistics chunkStatistics = Statistics.getStatsByType(dataType);
                        if (chunkHeader.getChunkType() == 1) {
                            for (int dataSize = chunkHeader.getDataSize(); dataSize > 0; dataSize -= ((PageHeader)pageHeader).getSerializedPageSize()) {
                                pageHeader = this.readPageHeader(chunkHeader.getDataType(), true);
                                chunkStatistics.mergeStatistics(((PageHeader)pageHeader).getStatistics());
                                this.skipPageData((PageHeader)pageHeader);
                                chunkHeader.increasePageNums(1);
                            }
                        } else {
                            pageHeader = this.readPageHeader(chunkHeader.getDataType(), false);
                            Decoder valueDecoder = Decoder.getDecoderByType(chunkHeader.getEncodingType(), chunkHeader.getDataType());
                            ByteBuffer pageData = this.readPage((PageHeader)pageHeader, chunkHeader.getCompressionType());
                            Decoder timeDecoder = Decoder.getDecoderByType(TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), TSDataType.INT64);
                            PageReader reader = new PageReader((PageHeader)pageHeader, pageData, chunkHeader.getDataType(), valueDecoder, timeDecoder, null);
                            BatchData batchData = reader.getAllSatisfiedPageData();
                            while (batchData.hasCurrent()) {
                                switch (dataType) {
                                    case INT32: {
                                        chunkStatistics.update(batchData.currentTime(), batchData.getInt());
                                        break;
                                    }
                                    case INT64: {
                                        chunkStatistics.update(batchData.currentTime(), batchData.getLong());
                                        break;
                                    }
                                    case FLOAT: {
                                        chunkStatistics.update(batchData.currentTime(), batchData.getFloat());
                                        break;
                                    }
                                    case DOUBLE: {
                                        chunkStatistics.update(batchData.currentTime(), batchData.getDouble());
                                        break;
                                    }
                                    case BOOLEAN: {
                                        chunkStatistics.update(batchData.currentTime(), batchData.getBoolean());
                                        break;
                                    }
                                    case TEXT: {
                                        chunkStatistics.update(batchData.currentTime(), batchData.getBinary());
                                        break;
                                    }
                                    default: {
                                        throw new IOException("Unexpected type " + (Object)((Object)dataType));
                                    }
                                }
                                batchData.next();
                            }
                            chunkHeader.increasePageNums(1);
                        }
                        ChunkMetadata currentChunk = new ChunkMetadata(measurementID, dataType, fileOffsetOfChunk, chunkStatistics);
                        chunkMetadataList.add(currentChunk);
                        continue block15;
                    }
                    case 0: {
                        Object pageHeader;
                        truncatedSize = this.position() - 1L;
                        if (lastDeviceId != null) {
                            if (newSchema != null) {
                                pageHeader = measurementSchemaList.iterator();
                                while (pageHeader.hasNext()) {
                                    MeasurementSchema tsSchema = (MeasurementSchema)pageHeader.next();
                                    newSchema.putIfAbsent(new Path(lastDeviceId, tsSchema.getMeasurementId()), tsSchema);
                                }
                            }
                            measurementSchemaList = new ArrayList();
                            chunkGroupMetadataList.add(new ChunkGroupMetadata(lastDeviceId, chunkMetadataList));
                        }
                        chunkMetadataList = new ArrayList();
                        ChunkGroupHeader chunkGroupHeader = this.readChunkGroupHeader();
                        lastDeviceId = chunkGroupHeader.getDeviceID();
                        continue block15;
                    }
                    case 4: {
                        truncatedSize = this.position() - 1L;
                        if (lastDeviceId != null) {
                            if (newSchema != null) {
                                for (MeasurementSchema tsSchema : measurementSchemaList) {
                                    newSchema.putIfAbsent(new Path(lastDeviceId, tsSchema.getMeasurementId()), tsSchema);
                                }
                            }
                            measurementSchemaList = new ArrayList();
                            chunkGroupMetadataList.add(new ChunkGroupMetadata(lastDeviceId, chunkMetadataList));
                            lastDeviceId = null;
                        }
                        this.readPlanIndex();
                        truncatedSize = this.position();
                        continue block15;
                    }
                }
                throw new IOException("Unexpected marker " + marker);
            }
            if (lastDeviceId != null) {
                if (newSchema != null) {
                    for (MeasurementSchema tsSchema : measurementSchemaList) {
                        newSchema.putIfAbsent(new Path(lastDeviceId, tsSchema.getMeasurementId()), tsSchema);
                    }
                }
                chunkGroupMetadataList.add(new ChunkGroupMetadata(lastDeviceId, chunkMetadataList));
                lastDeviceId = null;
            }
            truncatedSize = this.position() - 1L;
        }
        catch (Exception e) {
            logger.info("TsFile {} self-check cannot proceed at position {} recovered, because : {}", new Object[]{this.file, this.position(), e.getMessage()});
        }
        if (loadLastChunkMetadata && lastDeviceId != null && chunkMetadataList.size() > 0) {
            chunkGroupMetadataList.add(new ChunkGroupMetadata(lastDeviceId, chunkMetadataList));
            if (newSchema != null) {
                for (MeasurementSchema tsSchema : measurementSchemaList) {
                    newSchema.putIfAbsent(new Path(lastDeviceId, tsSchema.getMeasurementId()), tsSchema);
                }
            }
        }
        return truncatedSize;
    }

    public List<ChunkMetadata> getChunkMetadataList(Path path, boolean ignoreNotExists) throws IOException {
        TimeseriesMetadata timeseriesMetaData = this.readTimeseriesMetadata(path, ignoreNotExists);
        if (timeseriesMetaData == null) {
            return Collections.emptyList();
        }
        List<ChunkMetadata> chunkMetadataList = this.readChunkMetaDataList(timeseriesMetaData);
        chunkMetadataList.sort(Comparator.comparingLong(ChunkMetadata::getStartTime));
        return chunkMetadataList;
    }

    public List<ChunkMetadata> getChunkMetadataList(Path path) throws IOException {
        return this.getChunkMetadataList(path, false);
    }

    public List<ChunkMetadata> readChunkMetaDataList(TimeseriesMetadata timeseriesMetaData) throws IOException {
        return timeseriesMetaData.getChunkMetadataList();
    }

    public Map<String, TSDataType> getAllMeasurements() throws IOException {
        HashMap<String, TSDataType> result = new HashMap<String, TSDataType>();
        for (String device : this.getAllDevices()) {
            Map<String, TimeseriesMetadata> timeseriesMetadataMap = this.readDeviceMetadata(device);
            for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataMap.values()) {
                result.put(timeseriesMetadata.getMeasurementId(), timeseriesMetadata.getTSDataType());
            }
        }
        return result;
    }

    public Map<String, List<String>> getDeviceMeasurementsMap() throws IOException {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (String device : this.getAllDevices()) {
            Map<String, TimeseriesMetadata> timeseriesMetadataMap = this.readDeviceMetadata(device);
            for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataMap.values()) {
                result.computeIfAbsent(device, d -> new ArrayList()).add(timeseriesMetadata.getMeasurementId());
            }
        }
        return result;
    }

    public List<String> getDeviceNameInRange(long start, long end) throws IOException {
        ArrayList<String> res = new ArrayList<String>();
        for (String device : this.getAllDevices()) {
            Map<String, List<ChunkMetadata>> seriesMetadataMap = this.readChunkMetadataInDevice(device);
            if (!this.hasDataInPartition(seriesMetadataMap, start, end)) continue;
            res.add(device);
        }
        return res;
    }

    private boolean hasDataInPartition(Map<String, List<ChunkMetadata>> seriesMetadataMap, long start, long end) {
        for (List<ChunkMetadata> chunkMetadataList : seriesMetadataMap.values()) {
            for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                LocateStatus location = MetadataQuerierByFileImpl.checkLocateStatus(chunkMetadata, start, end);
                if (location != LocateStatus.in) continue;
                return true;
            }
        }
        return false;
    }

    public long getMinPlanIndex() {
        return this.minPlanIndex;
    }

    public long getMaxPlanIndex() {
        return this.maxPlanIndex;
    }

    public Iterator<Map<String, List<ChunkMetadata>>> getMeasurementChunkMetadataListMapIterator(String device) throws IOException {
        this.readFileMetadata();
        MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
        Pair<MetadataIndexEntry, Long> metadataIndexPair = this.getMetadataAndEndOffset(metadataIndexNode, device, true, true);
        if (metadataIndexPair == null) {
            return new Iterator<Map<String, List<ChunkMetadata>>>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public LinkedHashMap<String, List<ChunkMetadata>> next() {
                    throw new NoSuchElementException();
                }
            };
        }
        final LinkedList<Pair<Long, Long>> queue = new LinkedList<Pair<Long, Long>>();
        ByteBuffer buffer = this.readData(((MetadataIndexEntry)metadataIndexPair.left).getOffset(), (Long)metadataIndexPair.right);
        this.collectEachLeafMeasurementNodeOffsetRange(buffer, queue);
        return new Iterator<Map<String, List<ChunkMetadata>>>(){

            @Override
            public boolean hasNext() {
                return !queue.isEmpty();
            }

            @Override
            public LinkedHashMap<String, List<ChunkMetadata>> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Pair startEndPair = (Pair)queue.remove();
                LinkedHashMap<String, List<ChunkMetadata>> measurementChunkMetadataList = new LinkedHashMap<String, List<ChunkMetadata>>();
                try {
                    ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
                    ByteBuffer nextBuffer = TsFileSequenceReader.this.readData((long)((Long)startEndPair.left), (Long)startEndPair.right);
                    while (nextBuffer.hasRemaining()) {
                        timeseriesMetadataList.add(TimeseriesMetadata.deserializeFrom(nextBuffer, true));
                    }
                    for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataList) {
                        measurementChunkMetadataList.computeIfAbsent(timeseriesMetadata.getMeasurementId(), m -> new ArrayList()).addAll(timeseriesMetadata.getChunkMetadataList());
                    }
                    return measurementChunkMetadataList;
                }
                catch (IOException e) {
                    throw new TsFileRuntimeException("Error occurred while reading a time series metadata block.");
                }
            }
        };
    }

    private void collectEachLeafMeasurementNodeOffsetRange(ByteBuffer buffer, Queue<Pair<Long, Long>> queue) throws IOException {
        try {
            MetadataIndexNode metadataIndexNode = MetadataIndexNode.deserializeFrom(buffer);
            MetadataIndexNodeType metadataIndexNodeType = metadataIndexNode.getNodeType();
            int metadataIndexListSize = metadataIndexNode.getChildren().size();
            for (int i = 0; i < metadataIndexListSize; ++i) {
                long startOffset = metadataIndexNode.getChildren().get(i).getOffset();
                long endOffset = metadataIndexNode.getEndOffset();
                if (i != metadataIndexListSize - 1) {
                    endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
                }
                if (metadataIndexNodeType.equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                    queue.add(new Pair<Long, Long>(startOffset, endOffset));
                    continue;
                }
                this.collectEachLeafMeasurementNodeOffsetRange(this.readData(startOffset, endOffset), queue);
            }
        }
        catch (BufferOverflowException e) {
            logger.error("Error occurred while collecting offset ranges of measurement nodes of file {}", (Object)this.file);
            throw e;
        }
    }

    public static enum LocateStatus {
        in,
        before,
        after;

    }
}

