/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.runtime.SQLParserException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.DeleteDataOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.InOperator;
import org.apache.iotdb.db.qp.logical.crud.InsertOperator;
import org.apache.iotdb.db.qp.logical.crud.LikeOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.RegexpOperator;
import org.apache.iotdb.db.qp.logical.sys.AlterTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.logical.sys.CountOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateFunctionOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateIndexOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateTriggerOperator;
import org.apache.iotdb.db.qp.logical.sys.DataAuthOperator;
import org.apache.iotdb.db.qp.logical.sys.DeletePartitionOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.DropFunctionOperator;
import org.apache.iotdb.db.qp.logical.sys.DropIndexOperator;
import org.apache.iotdb.db.qp.logical.sys.DropTriggerOperator;
import org.apache.iotdb.db.qp.logical.sys.FlushOperator;
import org.apache.iotdb.db.qp.logical.sys.KillQueryOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadConfigurationOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadDataOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadFilesOperator;
import org.apache.iotdb.db.qp.logical.sys.MoveFileOperator;
import org.apache.iotdb.db.qp.logical.sys.RemoveFileOperator;
import org.apache.iotdb.db.qp.logical.sys.SetStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.SetSystemModeOperator;
import org.apache.iotdb.db.qp.logical.sys.SetTTLOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowChildNodesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowChildPathsOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowDevicesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowFunctionsOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowLockInfoOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTTLOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTriggersOperator;
import org.apache.iotdb.db.qp.logical.sys.StartTriggerOperator;
import org.apache.iotdb.db.qp.logical.sys.StopTriggerOperator;
import org.apache.iotdb.db.qp.logical.sys.TracingOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.AlignByDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePartitionPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimeFillPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryIndexPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.physical.sys.AlterTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.ClearCachePlan;
import org.apache.iotdb.db.qp.physical.sys.CountPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateFunctionPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateIndexPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateSnapshotPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.DataAuthPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DropFunctionPlan;
import org.apache.iotdb.db.qp.physical.sys.DropIndexPlan;
import org.apache.iotdb.db.qp.physical.sys.DropTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.FlushPlan;
import org.apache.iotdb.db.qp.physical.sys.KillQueryPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadConfigurationPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadDataPlan;
import org.apache.iotdb.db.qp.physical.sys.MergePlan;
import org.apache.iotdb.db.qp.physical.sys.OperateFilePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetSystemModePlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowChildNodesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowChildPathsPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowFunctionsPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowLockInfoPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowMergeStatusPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowQueryProcesslistPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTriggersPlan;
import org.apache.iotdb.db.qp.physical.sys.StartTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.StopTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.TracingPlan;
import org.apache.iotdb.db.query.udf.core.context.UDFContext;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.utils.Pair;

public class PhysicalGenerator {
    public PhysicalPlan transformToPhysicalPlan(Operator operator, int fetchSize) throws QueryProcessException {
        PhysicalPlan physicalPlan = this.doTransformation(operator, fetchSize);
        physicalPlan.setDebug(operator.isDebug());
        return physicalPlan;
    }

    private PhysicalPlan doTransformation(Operator operator, int fetchSize) throws QueryProcessException {
        switch (operator.getType()) {
            case AUTHOR: {
                AuthorOperator author = (AuthorOperator)operator;
                try {
                    return new AuthorPlan(author.getAuthorType(), author.getUserName(), author.getRoleName(), author.getPassWord(), author.getNewPassword(), author.getPrivilegeList(), author.getNodeName());
                }
                catch (AuthException e) {
                    throw new QueryProcessException(e.getMessage());
                }
            }
            case GRANT_WATERMARK_EMBEDDING: 
            case REVOKE_WATERMARK_EMBEDDING: {
                DataAuthOperator dataAuthOperator = (DataAuthOperator)operator;
                return new DataAuthPlan(dataAuthOperator.getType(), dataAuthOperator.getUsers());
            }
            case LOADDATA: {
                LoadDataOperator loadData = (LoadDataOperator)operator;
                return new LoadDataPlan(loadData.getInputFilePath(), loadData.getMeasureType());
            }
            case METADATA: 
            case SET_STORAGE_GROUP: {
                SetStorageGroupOperator setStorageGroup = (SetStorageGroupOperator)operator;
                return new SetStorageGroupPlan(setStorageGroup.getPath());
            }
            case DELETE_STORAGE_GROUP: {
                DeleteStorageGroupOperator deleteStorageGroup = (DeleteStorageGroupOperator)operator;
                return new DeleteStorageGroupPlan(deleteStorageGroup.getDeletePathList());
            }
            case CREATE_TIMESERIES: {
                CreateTimeSeriesOperator createOperator = (CreateTimeSeriesOperator)operator;
                if (createOperator.getTags() != null && !createOperator.getTags().isEmpty() && createOperator.getAttributes() != null && !createOperator.getAttributes().isEmpty()) {
                    for (String tagKey : createOperator.getTags().keySet()) {
                        if (!createOperator.getAttributes().containsKey(tagKey)) continue;
                        throw new QueryProcessException(String.format("Tag and attribute shouldn't have the same property key [%s]", tagKey));
                    }
                }
                return new CreateTimeSeriesPlan(createOperator.getPath(), createOperator.getDataType(), createOperator.getEncoding(), createOperator.getCompressor(), createOperator.getProps(), createOperator.getTags(), createOperator.getAttributes(), createOperator.getAlias());
            }
            case DELETE_TIMESERIES: {
                DeleteTimeSeriesOperator deletePath = (DeleteTimeSeriesOperator)operator;
                return new DeleteTimeSeriesPlan(deletePath.getDeletePathList());
            }
            case CREATE_INDEX: {
                CreateIndexOperator createIndexOp = (CreateIndexOperator)operator;
                return new CreateIndexPlan(createIndexOp.getSelectedPaths(), createIndexOp.getProps(), createIndexOp.getTime(), createIndexOp.getIndexType());
            }
            case DROP_INDEX: {
                DropIndexOperator dropIndexOp = (DropIndexOperator)operator;
                return new DropIndexPlan(dropIndexOp.getSelectedPaths(), dropIndexOp.getIndexType());
            }
            case ALTER_TIMESERIES: {
                AlterTimeSeriesOperator alterTimeSeriesOperator = (AlterTimeSeriesOperator)operator;
                return new AlterTimeSeriesPlan(alterTimeSeriesOperator.getPath(), alterTimeSeriesOperator.getAlterType(), alterTimeSeriesOperator.getAlterMap(), alterTimeSeriesOperator.getAlias(), alterTimeSeriesOperator.getTagsMap(), alterTimeSeriesOperator.getAttributesMap());
            }
            case DELETE: {
                DeleteDataOperator delete = (DeleteDataOperator)operator;
                List<PartialPath> paths = delete.getSelectedPaths();
                return new DeletePlan(delete.getStartTime(), delete.getEndTime(), paths);
            }
            case INSERT: {
                InsertOperator insert = (InsertOperator)operator;
                List<PartialPath> paths = insert.getSelectedPaths();
                if (insert.getMeasurementList().length != insert.getValueList().length) {
                    throw new SQLParserException(String.format("the measurementList's size %d is not consistent with the valueList's size %d", insert.getMeasurementList().length, insert.getValueList().length));
                }
                return new InsertRowPlan(paths.get(0), insert.getTime(), insert.getMeasurementList(), insert.getValueList());
            }
            case MERGE: {
                if (operator.getTokenIntType() == 83) {
                    return new MergePlan(Operator.OperatorType.FULL_MERGE);
                }
                return new MergePlan();
            }
            case FLUSH: {
                FlushOperator flushOperator = (FlushOperator)operator;
                return new FlushPlan(flushOperator.isSeq(), flushOperator.getStorageGroupList());
            }
            case TRACING: {
                TracingOperator tracingOperator = (TracingOperator)operator;
                return new TracingPlan(tracingOperator.isTracingOn());
            }
            case SET_SYSTEM_MODE: {
                SetSystemModeOperator setSystemModeOperator = (SetSystemModeOperator)operator;
                return new SetSystemModePlan(setSystemModeOperator.isReadOnly());
            }
            case QUERY: {
                QueryOperator query = (QueryOperator)operator;
                return this.transformQuery(query, fetchSize);
            }
            case TTL: {
                switch (operator.getTokenIntType()) {
                    case 63: {
                        SetTTLOperator setTTLOperator = (SetTTLOperator)operator;
                        return new SetTTLPlan(setTTLOperator.getStorageGroup(), setTTLOperator.getDataTTL());
                    }
                    case 64: {
                        SetTTLOperator unsetTTLOperator = (SetTTLOperator)operator;
                        return new SetTTLPlan(unsetTTLOperator.getStorageGroup());
                    }
                    case 65: {
                        ShowTTLOperator showTTLOperator = (ShowTTLOperator)operator;
                        return new ShowTTLPlan(showTTLOperator.getStorageGroups());
                    }
                }
                throw new LogicalOperatorException(String.format("not supported operator type %s in ttl operation.", new Object[]{operator.getType()}));
            }
            case LOAD_CONFIGURATION: {
                LoadConfigurationOperator.LoadConfigurationOperatorType type = ((LoadConfigurationOperator)operator).getLoadConfigurationOperatorType();
                return this.generateLoadConfigurationPlan(type);
            }
            case SHOW: {
                switch (operator.getTokenIntType()) {
                    case 67: {
                        return new ShowPlan(ShowPlan.ShowContentType.FLUSH_TASK_INFO);
                    }
                    case 72: {
                        return new ShowPlan(ShowPlan.ShowContentType.VERSION);
                    }
                    case 73: {
                        ShowTimeSeriesOperator showTimeSeriesOperator = (ShowTimeSeriesOperator)operator;
                        ShowTimeSeriesPlan showTimeSeriesPlan = new ShowTimeSeriesPlan(showTimeSeriesOperator.getPath(), showTimeSeriesOperator.getLimit(), showTimeSeriesOperator.getOffset(), fetchSize);
                        showTimeSeriesPlan.setIsContains(showTimeSeriesOperator.isContains());
                        showTimeSeriesPlan.setKey(showTimeSeriesOperator.getKey());
                        showTimeSeriesPlan.setValue(showTimeSeriesOperator.getValue());
                        showTimeSeriesPlan.setOrderByHeat(showTimeSeriesOperator.isOrderByHeat());
                        return showTimeSeriesPlan;
                    }
                    case 74: {
                        return new ShowStorageGroupPlan(ShowPlan.ShowContentType.STORAGE_GROUP, ((ShowStorageGroupOperator)operator).getPath());
                    }
                    case 105: {
                        return new ShowLockInfoPlan(ShowPlan.ShowContentType.LOCK_INFO, ((ShowLockInfoOperator)operator).getPath());
                    }
                    case 76: {
                        ShowDevicesOperator showDevicesOperator = (ShowDevicesOperator)operator;
                        return new ShowDevicesPlan(showDevicesOperator.getPath(), showDevicesOperator.getLimit(), showDevicesOperator.getOffset(), fetchSize, showDevicesOperator.hasSgCol());
                    }
                    case 95: {
                        return new CountPlan(ShowPlan.ShowContentType.COUNT_DEVICES, ((CountOperator)operator).getPath());
                    }
                    case 96: {
                        return new CountPlan(ShowPlan.ShowContentType.COUNT_STORAGE_GROUP, ((CountOperator)operator).getPath());
                    }
                    case 78: {
                        return new CountPlan(ShowPlan.ShowContentType.COUNT_NODE_TIMESERIES, ((CountOperator)operator).getPath(), ((CountOperator)operator).getLevel());
                    }
                    case 79: {
                        return new CountPlan(ShowPlan.ShowContentType.COUNT_NODES, ((CountOperator)operator).getPath(), ((CountOperator)operator).getLevel());
                    }
                    case 77: {
                        return new CountPlan(ShowPlan.ShowContentType.COUNT_TIMESERIES, ((CountOperator)operator).getPath());
                    }
                    case 75: {
                        return new ShowChildPathsPlan(ShowPlan.ShowContentType.CHILD_PATH, ((ShowChildPathsOperator)operator).getPath());
                    }
                    case 99: {
                        return new ShowChildNodesPlan(ShowPlan.ShowContentType.CHILD_NODE, ((ShowChildNodesOperator)operator).getPath());
                    }
                    case 97: {
                        return new ShowQueryProcesslistPlan(ShowPlan.ShowContentType.QUERY_PROCESSLIST);
                    }
                    case 94: {
                        return new ShowFunctionsPlan(((ShowFunctionsOperator)operator).showTemporary());
                    }
                    case 104: {
                        return new ShowTriggersPlan(((ShowTriggersOperator)operator).getPath());
                    }
                }
                throw new LogicalOperatorException(String.format("not supported operator type %s in show operation.", new Object[]{operator.getType()}));
            }
            case LOAD_FILES: {
                return new OperateFilePlan(((LoadFilesOperator)operator).getFile(), Operator.OperatorType.LOAD_FILES, ((LoadFilesOperator)operator).isAutoCreateSchema(), ((LoadFilesOperator)operator).getSgLevel(), ((LoadFilesOperator)operator).isVerifyMetadata());
            }
            case REMOVE_FILE: {
                return new OperateFilePlan(((RemoveFileOperator)operator).getFile(), Operator.OperatorType.REMOVE_FILE);
            }
            case MOVE_FILE: {
                return new OperateFilePlan(((MoveFileOperator)operator).getFile(), ((MoveFileOperator)operator).getTargetDir(), Operator.OperatorType.MOVE_FILE);
            }
            case CLEAR_CACHE: {
                return new ClearCachePlan();
            }
            case SHOW_MERGE_STATUS: {
                return new ShowMergeStatusPlan();
            }
            case DELETE_PARTITION: {
                DeletePartitionOperator op = (DeletePartitionOperator)operator;
                return new DeletePartitionPlan(op.getStorageGroupName(), op.getPartitionId());
            }
            case CREATE_SCHEMA_SNAPSHOT: {
                return new CreateSnapshotPlan();
            }
            case KILL: {
                return new KillQueryPlan(((KillQueryOperator)operator).getQueryId());
            }
            case CREATE_FUNCTION: {
                CreateFunctionOperator createFunctionOperator = (CreateFunctionOperator)operator;
                return new CreateFunctionPlan(createFunctionOperator.isTemporary(), createFunctionOperator.getUdfName(), createFunctionOperator.getClassName());
            }
            case DROP_FUNCTION: {
                DropFunctionOperator dropFunctionOperator = (DropFunctionOperator)operator;
                return new DropFunctionPlan(dropFunctionOperator.getUdfName());
            }
            case CREATE_TRIGGER: {
                CreateTriggerOperator createTriggerOperator = (CreateTriggerOperator)operator;
                return new CreateTriggerPlan(createTriggerOperator.getTriggerName(), createTriggerOperator.getEvent(), createTriggerOperator.getFullPath(), createTriggerOperator.getClassName(), createTriggerOperator.getAttributes());
            }
            case DROP_TRIGGER: {
                return new DropTriggerPlan(((DropTriggerOperator)operator).getTriggerName());
            }
            case START_TRIGGER: {
                return new StartTriggerPlan(((StartTriggerOperator)operator).getTriggerName());
            }
            case STOP_TRIGGER: {
                return new StopTriggerPlan(((StopTriggerOperator)operator).getTriggerName());
            }
        }
        throw new LogicalOperatorException(operator.getType().toString(), "");
    }

    protected PhysicalPlan generateLoadConfigurationPlan(LoadConfigurationOperator.LoadConfigurationOperatorType type) throws QueryProcessException {
        switch (type) {
            case GLOBAL: {
                return new LoadConfigurationPlan(LoadConfigurationPlan.LoadConfigurationPlanType.GLOBAL);
            }
            case LOCAL: {
                return new LoadConfigurationPlan(LoadConfigurationPlan.LoadConfigurationPlanType.LOCAL);
            }
        }
        throw new QueryProcessException(String.format("Unrecognized load configuration operator type, %s", type.name()));
    }

    protected Pair<List<TSDataType>, List<TSDataType>> getSeriesTypes(List<PartialPath> paths, String aggregation) throws MetadataException {
        List<TSDataType> measurementDataTypes = SchemaUtils.getSeriesTypesByPaths(paths, (String)null);
        if (aggregation == null) {
            return new Pair(measurementDataTypes, measurementDataTypes);
        }
        List<TSDataType> columnDataTypes = SchemaUtils.getSeriesTypesByPaths(paths, aggregation);
        return new Pair(columnDataTypes, measurementDataTypes);
    }

    protected List<TSDataType> getSeriesTypes(List<PartialPath> paths) throws MetadataException {
        return SchemaUtils.getSeriesTypesByPaths(paths);
    }

    private PhysicalPlan transformQuery(QueryOperator queryOperator, int fetchSize) throws QueryProcessException {
        QueryPlan queryPlan;
        if (queryOperator.hasAggregation()) {
            queryPlan = new AggPhysicalPlanRule().transform(queryOperator, fetchSize);
        } else if (queryOperator.isFill()) {
            queryPlan = new FillPhysicalPlanRule().transform(queryOperator, fetchSize);
        } else if (queryOperator.isLastQuery()) {
            queryPlan = new LastQueryPlan();
        } else if (queryOperator.getIndexType() != null) {
            queryPlan = new QueryIndexPlan();
        } else if (queryOperator.hasUdf()) {
            queryPlan = new UDTFPlan(queryOperator.getSelectOperator().getZoneId());
            ((UDTFPlan)queryPlan).constructUdfExecutors(queryOperator.getSelectOperator().getUdfList());
        } else {
            queryPlan = new RawDataQueryPlan();
        }
        if (queryOperator.isAlignByDevice()) {
            queryPlan = this.getAlignQueryPlan(queryOperator, fetchSize, queryPlan);
        } else {
            queryPlan.setPaths(queryOperator.getSelectedPaths());
            if (queryPlan instanceof LastQueryPlan && !queryOperator.isAlignByTime()) {
                throw new QueryProcessException("Disable align cannot be applied to LAST query.");
            }
            queryPlan.setAlignByTime(queryOperator.isAlignByTime());
            FilterOperator filterOperator = queryOperator.getFilterOperator();
            if (filterOperator != null) {
                ArrayList<PartialPath> filterPaths = new ArrayList<PartialPath>(filterOperator.getPathSet());
                try {
                    List<TSDataType> seriesTypes = this.getSeriesTypes(filterPaths);
                    HashMap<PartialPath, TSDataType> pathTSDataTypeHashMap = new HashMap<PartialPath, TSDataType>();
                    for (int i = 0; i < filterPaths.size(); ++i) {
                        ((RawDataQueryPlan)queryPlan).addFilterPathInDeviceToMeasurements((Path)filterPaths.get(i));
                        pathTSDataTypeHashMap.put((PartialPath)filterPaths.get(i), seriesTypes.get(i));
                    }
                    IExpression expression = filterOperator.transformToExpression(pathTSDataTypeHashMap);
                    ((RawDataQueryPlan)queryPlan).setExpression(expression);
                }
                catch (MetadataException e) {
                    throw new LogicalOptimizeException(e.getMessage());
                }
            }
        }
        queryPlan.setWithoutAllNull(queryOperator.isWithoutAllNull());
        queryPlan.setWithoutAnyNull(queryOperator.isWithoutAnyNull());
        if (queryOperator.getIndexType() != null) {
            if (queryPlan instanceof QueryIndexPlan) {
                ((QueryIndexPlan)queryPlan).setIndexType(queryOperator.getIndexType());
                ((QueryIndexPlan)queryPlan).setProps(queryOperator.getProps());
            }
            return queryPlan;
        }
        try {
            this.deduplicate(queryPlan);
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        queryPlan.setRowLimit(queryOperator.getRowLimit());
        queryPlan.setRowOffset(queryOperator.getRowOffset());
        queryPlan.setAscending(queryOperator.isAscending());
        return queryPlan;
    }

    private QueryPlan getAlignQueryPlan(QueryOperator queryOperator, int fetchSize, QueryPlan queryPlan) throws QueryProcessException {
        AlignByDevicePlan alignByDevicePlan = new AlignByDevicePlan();
        if (queryPlan instanceof GroupByTimePlan) {
            alignByDevicePlan.setGroupByTimePlan((GroupByTimePlan)queryPlan);
        } else if (queryPlan instanceof FillQueryPlan) {
            alignByDevicePlan.setFillQueryPlan((FillQueryPlan)queryPlan);
        } else if (queryPlan instanceof AggregationPlan) {
            if (((AggregationPlan)queryPlan).getLevel() >= 0) {
                throw new QueryProcessException("group by level does not support align by device now.");
            }
            alignByDevicePlan.setAggregationPlan((AggregationPlan)queryPlan);
        }
        List<PartialPath> prefixPaths = queryOperator.getFromOperator().getPrefixPaths();
        List<PartialPath> devices = this.removeStarsInDeviceWithUnique(prefixPaths);
        List<PartialPath> suffixPaths = queryOperator.getSelectOperator().getSuffixPaths();
        List<String> originAggregations = queryOperator.getSelectOperator().getAggregations();
        List<String> measurements = new ArrayList<String>();
        HashMap<String, String> measurementAliasMap = new HashMap<String, String>();
        HashMap<String, TSDataType> columnDataTypeMap = new HashMap<String, TSDataType>();
        HashMap<String, AlignByDevicePlan.MeasurementType> measurementTypeMap = new HashMap<String, AlignByDevicePlan.MeasurementType>();
        HashMap<String, TSDataType> measurementDataTypeMap = new HashMap<String, TSDataType>();
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        for (int i = 0; i < suffixPaths.size(); ++i) {
            PartialPath suffixPath = suffixPaths.get(i);
            LinkedHashSet<String> measurementSetOfGivenSuffix = new LinkedHashSet<String>();
            if (suffixPath.getMeasurement().startsWith("'")) {
                measurements.add(suffixPath.getMeasurement());
                measurementTypeMap.put(suffixPath.getMeasurement(), AlignByDevicePlan.MeasurementType.Constant);
                continue;
            }
            for (PartialPath device : devices) {
                PartialPath fullPath = device.concatPath(suffixPath);
                try {
                    String nonExistMeasurement;
                    List<PartialPath> actualPaths = this.getMatchedTimeseries(fullPath);
                    if (suffixPath.isTsAliasExists()) {
                        if (actualPaths.size() == 1) {
                            String columnName = actualPaths.get(0).getMeasurement();
                            if (originAggregations != null && !originAggregations.isEmpty()) {
                                measurementAliasMap.put(originAggregations.get(i) + "(" + columnName + ")", suffixPath.getTsAlias());
                            } else {
                                measurementAliasMap.put(columnName, suffixPath.getTsAlias());
                            }
                        } else if (actualPaths.size() >= 2) {
                            throw new QueryProcessException("alias '" + suffixPath.getTsAlias() + "' can only be matched with one time series");
                        }
                    }
                    if (originAggregations != null && actualPaths.isEmpty() && originAggregations.isEmpty() && measurementSetOfGivenSuffix.add(nonExistMeasurement = fullPath.getMeasurement()) && measurementTypeMap.get(nonExistMeasurement) != AlignByDevicePlan.MeasurementType.Exist) {
                        measurementTypeMap.put(fullPath.getMeasurement(), AlignByDevicePlan.MeasurementType.NonExist);
                    }
                    String aggregation = originAggregations != null && !originAggregations.isEmpty() ? originAggregations.get(i) : null;
                    Pair<List<TSDataType>, List<TSDataType>> pair = this.getSeriesTypes(actualPaths, aggregation);
                    List columnDataTypes = (List)pair.left;
                    List measurementDataTypes = (List)pair.right;
                    for (int pathIdx = 0; pathIdx < actualPaths.size(); ++pathIdx) {
                        PartialPath path = new PartialPath(actualPaths.get(pathIdx).getNodes());
                        String measurementChecked = originAggregations != null && !originAggregations.isEmpty() ? originAggregations.get(i) + "(" + path.getMeasurement() + ")" : path.getMeasurement();
                        TSDataType columnDataType = (TSDataType)columnDataTypes.get(pathIdx);
                        if (columnDataTypeMap.containsKey(measurementChecked)) {
                            if (!columnDataType.equals(columnDataTypeMap.get(measurementChecked))) {
                                throw new QueryProcessException("The data types of the same measurement column should be the same across devices in ALIGN_BY_DEVICE sql. For more details please refer to the SQL document.");
                            }
                        } else {
                            columnDataTypeMap.put(measurementChecked, columnDataType);
                            measurementDataTypeMap.put(measurementChecked, (TSDataType)measurementDataTypes.get(pathIdx));
                        }
                        if (measurementSetOfGivenSuffix.add(measurementChecked) || measurementTypeMap.get(measurementChecked) != AlignByDevicePlan.MeasurementType.Exist) {
                            measurementTypeMap.put(measurementChecked, AlignByDevicePlan.MeasurementType.Exist);
                        }
                        paths.add(path);
                    }
                }
                catch (MetadataException e) {
                    throw new LogicalOptimizeException(String.format("Error when getting all paths of a full path: %s", fullPath.getFullPath()) + e.getMessage());
                }
            }
            measurements.addAll(measurementSetOfGivenSuffix);
        }
        if (queryOperator.hasSlimit()) {
            int seriesSlimit = queryOperator.getSeriesLimit();
            int seriesOffset = queryOperator.getSeriesOffset();
            measurements = this.slimitTrimColumn(measurements, seriesSlimit, seriesOffset);
        }
        alignByDevicePlan.setMeasurements(measurements);
        alignByDevicePlan.setMeasurementAliasMap(measurementAliasMap);
        alignByDevicePlan.setDevices(devices);
        alignByDevicePlan.setColumnDataTypeMap(columnDataTypeMap);
        alignByDevicePlan.setMeasurementTypeMap(measurementTypeMap);
        alignByDevicePlan.setMeasurementDataTypeMap(measurementDataTypeMap);
        alignByDevicePlan.setPaths(paths);
        FilterOperator filterOperator = queryOperator.getFilterOperator();
        if (filterOperator != null) {
            alignByDevicePlan.setDeviceToFilterMap(this.concatFilterByDevice(devices, filterOperator));
        }
        queryPlan = alignByDevicePlan;
        return queryPlan;
    }

    private Map<String, IExpression> concatFilterByDevice(List<PartialPath> devices, FilterOperator operator) throws QueryProcessException {
        HashMap<String, IExpression> deviceToFilterMap = new HashMap<String, IExpression>();
        HashSet<PartialPath> filterPaths = new HashSet<PartialPath>();
        Iterator<PartialPath> deviceIterator = devices.iterator();
        while (deviceIterator.hasNext()) {
            PartialPath device = deviceIterator.next();
            FilterOperator newOperator = operator.copy();
            try {
                this.concatFilterPath(device, newOperator, filterPaths);
            }
            catch (PathNotExistException e) {
                deviceIterator.remove();
                continue;
            }
            ArrayList<PartialPath> filterPathList = new ArrayList<PartialPath>(filterPaths);
            try {
                List<TSDataType> seriesTypes = this.getSeriesTypes(filterPathList);
                HashMap<PartialPath, TSDataType> pathTSDataTypeHashMap = new HashMap<PartialPath, TSDataType>();
                for (int i = 0; i < filterPathList.size(); ++i) {
                    pathTSDataTypeHashMap.put((PartialPath)filterPathList.get(i), seriesTypes.get(i));
                }
                deviceToFilterMap.put(device.getFullPath(), newOperator.transformToExpression(pathTSDataTypeHashMap));
                filterPaths.clear();
            }
            catch (MetadataException e) {
                throw new QueryProcessException(e);
            }
        }
        return deviceToFilterMap;
    }

    private List<PartialPath> removeStarsInDeviceWithUnique(List<PartialPath> paths) throws LogicalOptimizeException {
        ArrayList<PartialPath> retDevices;
        LinkedHashSet<PartialPath> deviceSet = new LinkedHashSet<PartialPath>();
        try {
            for (PartialPath path : paths) {
                Set<PartialPath> tempDS = this.getMatchedDevices(path);
                deviceSet.addAll(tempDS);
            }
            retDevices = new ArrayList<PartialPath>(deviceSet);
        }
        catch (MetadataException e) {
            throw new LogicalOptimizeException("error when remove star: " + e.getMessage());
        }
        return retDevices;
    }

    private void concatFilterPath(PartialPath prefix, FilterOperator operator, Set<PartialPath> filterPaths) throws PathNotExistException {
        FunctionOperator basicOperator;
        if (!operator.isLeaf()) {
            for (FilterOperator child : operator.getChildren()) {
                this.concatFilterPath(prefix, child, filterPaths);
            }
            return;
        }
        switch (operator.getType()) {
            case IN: {
                basicOperator = (InOperator)operator;
                break;
            }
            case LIKE: {
                basicOperator = (LikeOperator)operator;
                break;
            }
            case REGEXP: {
                basicOperator = (RegexpOperator)operator;
                break;
            }
            default: {
                basicOperator = (BasicFunctionOperator)operator;
            }
        }
        PartialPath filterPath = basicOperator.getSinglePath();
        if (SQLConstant.isReservedPath(filterPath) || filterPath.getFirstNode().startsWith("root")) {
            filterPaths.add(filterPath);
            return;
        }
        PartialPath concatPath = prefix.concatPath(filterPath);
        if (!IoTDB.metaManager.isPathExist(concatPath)) {
            throw new PathNotExistException(concatPath.getFullPath());
        }
        filterPaths.add(concatPath);
        basicOperator.setSinglePath(concatPath);
    }

    private void deduplicate(QueryPlan queryPlan) throws MetadataException {
        List<PartialPath> paths = queryPlan.getPaths();
        List<TSDataType> dataTypes = this.getSeriesTypes(paths);
        queryPlan.setDataTypes(dataTypes);
        if (queryPlan instanceof AlignByDevicePlan) {
            return;
        }
        RawDataQueryPlan rawDataQueryPlan = (RawDataQueryPlan)queryPlan;
        HashSet<String> columnForReaderSet = new HashSet<String>();
        if (queryPlan instanceof LastQueryPlan) {
            for (int i = 0; i < paths.size(); ++i) {
                PartialPath path = paths.get(i);
                String column = queryPlan.getColumnForReaderFromPath(path, i);
                if (columnForReaderSet.contains(column)) continue;
                TSDataType seriesType = dataTypes.get(i);
                rawDataQueryPlan.addDeduplicatedPaths(path);
                rawDataQueryPlan.addDeduplicatedDataTypes(seriesType);
                columnForReaderSet.add(column);
            }
            return;
        }
        ArrayList<Pair> indexedPaths = new ArrayList<Pair>();
        for (int i = 0; i < paths.size(); ++i) {
            PartialPath path = paths.get(i);
            if (path != null) {
                indexedPaths.add(new Pair((Object)paths.get(i), (Object)i));
                continue;
            }
            UDFContext context = ((UDTFPlan)queryPlan).getExecutorByOriginalOutputColumnIndex(i).getContext();
            for (PartialPath udfPath : context.getPaths()) {
                indexedPaths.add(new Pair((Object)udfPath, (Object)i));
            }
        }
        indexedPaths.sort(Comparator.comparing(pair -> (PartialPath)pair.left));
        HashMap<String, Integer> pathNameToReaderIndex = new HashMap<String, Integer>();
        HashSet<String> columnForDisplaySet = new HashSet<String>();
        for (Pair indexedPath : indexedPaths) {
            String columnForDisplay;
            boolean isUdf;
            PartialPath originalPath = (PartialPath)indexedPath.left;
            Integer originalIndex = (Integer)indexedPath.right;
            String columnForReader = queryPlan.getColumnForReaderFromPath(originalPath, originalIndex);
            boolean bl = isUdf = queryPlan instanceof UDTFPlan && paths.get(originalIndex) == null;
            if (!columnForReaderSet.contains(columnForReader)) {
                rawDataQueryPlan.addDeduplicatedPaths(originalPath);
                rawDataQueryPlan.addDeduplicatedDataTypes(isUdf ? IoTDB.metaManager.getSeriesType(originalPath) : dataTypes.get(originalIndex));
                pathNameToReaderIndex.put(columnForReader, pathNameToReaderIndex.size());
                if (queryPlan instanceof AggregationPlan) {
                    ((AggregationPlan)queryPlan).addDeduplicatedAggregations(queryPlan.getAggregations().get(originalIndex));
                }
                columnForReaderSet.add(columnForReader);
            }
            if (columnForDisplaySet.contains(columnForDisplay = queryPlan.getColumnForDisplay(columnForReader, originalIndex))) continue;
            queryPlan.addPathToIndex(columnForDisplay, queryPlan.getPathToIndex().size());
            if (queryPlan instanceof UDTFPlan) {
                if (isUdf) {
                    ((UDTFPlan)queryPlan).addUdfOutputColumn(columnForDisplay);
                } else {
                    ((UDTFPlan)queryPlan).addRawQueryOutputColumn(columnForDisplay);
                }
            }
            columnForDisplaySet.add(columnForDisplay);
        }
        if (queryPlan instanceof UDTFPlan) {
            ((UDTFPlan)queryPlan).setPathNameToReaderIndex(pathNameToReaderIndex);
        }
    }

    private List<String> slimitTrimColumn(List<String> columnList, int seriesLimit, int seriesOffset) throws QueryProcessException {
        int size = columnList.size();
        if (seriesOffset >= size) {
            String errorMessage = "The value of SOFFSET (%d) is equal to or exceeds the number of sequences (%d) that can actually be returned.";
            throw new QueryProcessException(String.format(errorMessage, seriesOffset, size));
        }
        int endPosition = seriesOffset + seriesLimit;
        if (endPosition > size) {
            endPosition = size;
        }
        return new ArrayList<String>(columnList.subList(seriesOffset, endPosition));
    }

    private static boolean verifyAllAggregationDataTypesEqual(QueryOperator queryOperator) throws MetadataException {
        String aggType;
        List<String> aggregations = queryOperator.getSelectOperator().getAggregations();
        if (aggregations.isEmpty()) {
            return true;
        }
        List<PartialPath> paths = queryOperator.getSelectedPaths();
        List<TSDataType> dataTypes = SchemaUtils.getSeriesTypesByPaths(paths);
        switch (aggType = aggregations.get(0)) {
            case "min_value": 
            case "max_value": 
            case "avg": 
            case "sum": {
                return dataTypes.stream().allMatch(arg_0 -> dataTypes.get(0).equals(arg_0));
            }
        }
        return true;
    }

    protected List<PartialPath> getMatchedTimeseries(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getAllTimeseriesPath(path);
    }

    protected Set<PartialPath> getMatchedDevices(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getDevices(path);
    }

    public static class FillPhysicalPlanRule
    implements Transfrom {
        @Override
        public QueryPlan transform(QueryOperator queryOperator, int fetchSize) throws QueryProcessException {
            if (queryOperator.hasUdf()) {
                throw new QueryProcessException("Fill functions are not supported in UDF queries.");
            }
            FillQueryPlan queryPlan = new FillQueryPlan();
            FilterOperator timeFilter = queryOperator.getFilterOperator();
            if (!timeFilter.isSingle()) {
                throw new QueryProcessException("Slice query must select a single time point");
            }
            long time = Long.parseLong(((BasicFunctionOperator)timeFilter).getValue());
            queryPlan.setQueryTime(time);
            queryPlan.setFillType(queryOperator.getFillTypes());
            return queryPlan;
        }
    }

    public static class AggPhysicalPlanRule
    implements Transfrom {
        @Override
        public QueryPlan transform(QueryOperator queryOperator, int fetchSize) throws QueryProcessException {
            if (queryOperator.hasUdf()) {
                throw new QueryProcessException("User-defined and built-in hybrid aggregation is not supported.");
            }
            AggregationPlan queryPlan = queryOperator.isGroupByTime() && queryOperator.isFill() ? new GroupByTimeFillPlan() : (queryOperator.isGroupByTime() ? new GroupByTimePlan() : new AggregationPlan());
            ((AggregationPlan)queryPlan).setAggregations(queryOperator.getSelectOperator().getAggregations());
            if (queryOperator.isGroupByTime()) {
                ((GroupByTimePlan)queryPlan).setInterval(queryOperator.getUnit());
                ((GroupByTimePlan)queryPlan).setIntervalByMonth(queryOperator.isIntervalByMonth());
                ((GroupByTimePlan)queryPlan).setSlidingStep(queryOperator.getSlidingStep());
                ((GroupByTimePlan)queryPlan).setSlidingStepByMonth(queryOperator.isSlidingStepByMonth());
                ((GroupByTimePlan)queryPlan).setLeftCRightO(queryOperator.isLeftCRightO());
                if (!queryOperator.isLeftCRightO()) {
                    ((GroupByTimePlan)queryPlan).setStartTime(queryOperator.getStartTime() + 1L);
                    ((GroupByTimePlan)queryPlan).setEndTime(queryOperator.getEndTime() + 1L);
                } else {
                    ((GroupByTimePlan)queryPlan).setStartTime(queryOperator.getStartTime());
                    ((GroupByTimePlan)queryPlan).setEndTime(queryOperator.getEndTime());
                }
            }
            if (queryOperator.isFill()) {
                ((GroupByTimeFillPlan)queryPlan).setFillType(queryOperator.getFillTypes());
                for (String aggregation : ((PhysicalPlan)queryPlan).getAggregations()) {
                    if ("last_value".equals(aggregation)) continue;
                    throw new QueryProcessException("Group By Fill only support last_value function");
                }
            } else if (queryOperator.isGroupByLevel()) {
                queryPlan.setLevel(queryOperator.getLevel());
                try {
                    if (!PhysicalGenerator.verifyAllAggregationDataTypesEqual(queryOperator)) {
                        throw new QueryProcessException("Aggregate among unmatched data types");
                    }
                }
                catch (MetadataException e) {
                    throw new QueryProcessException(e);
                }
            }
            return queryPlan;
        }
    }

    static interface Transfrom {
        public QueryPlan transform(QueryOperator var1, int var2) throws QueryProcessException;
    }
}

