/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.task;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.engine.compaction.TsFileManagement;
import org.apache.iotdb.db.engine.merge.task.MergeCallback;
import org.apache.iotdb.db.engine.merge.task.RecoverMergeTask;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionMergeRecoverTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CompactionMergeRecoverTask.class);
    private TsFileManagement.CompactionRecoverTask compactionRecoverTask;
    private RecoverMergeTask recoverMergeTask;
    private TsFileManagement tsFileManagement;
    private String storageGroupSysDir;
    private String storageGroupName;

    public CompactionMergeRecoverTask(TsFileManagement tsFileManagement, List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, String storageGroupSysDir, MergeCallback callback, String taskName, boolean fullMerge, String storageGroupName, StorageGroupProcessor.CloseCompactionMergeCallBack closeCompactionMergeCallBack) {
        TsFileManagement tsFileManagement2 = this.tsFileManagement = tsFileManagement;
        Objects.requireNonNull(tsFileManagement2);
        this.compactionRecoverTask = tsFileManagement2.new TsFileManagement.CompactionRecoverTask(closeCompactionMergeCallBack);
        this.storageGroupSysDir = storageGroupSysDir;
        this.storageGroupName = storageGroupName;
        this.recoverMergeTask = new RecoverMergeTask(seqFiles, unseqFiles, storageGroupSysDir, callback, taskName, fullMerge, storageGroupName);
    }

    @Override
    public void run() {
        this.tsFileManagement.recovered = false;
        try {
            this.recoverMergeTask.recoverMerge(true);
        }
        catch (IOException | MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.compactionRecoverTask.call();
        this.tsFileManagement.recovered = true;
        logger.info("{} Compaction recover finish", (Object)this.storageGroupName);
    }
}

