/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.partition;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.iotdb.cluster.partition.NodeAdditionResult;
import org.apache.iotdb.cluster.partition.NodeRemovalResult;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IoTDB;

public interface PartitionTable {
    public PartitionGroup route(String var1, long var2);

    public Node routeToHeaderByTime(String var1, long var2);

    public NodeAdditionResult addNode(Node var1);

    public NodeRemovalResult removeNode(Node var1);

    public List<PartitionGroup> getLocalGroups();

    public PartitionGroup getHeaderGroup(Node var1);

    public ByteBuffer serialize();

    public void deserialize(ByteBuffer var1);

    public List<Node> getAllNodes();

    public List<PartitionGroup> getGlobalGroups();

    default public PartitionGroup partitionByPathTime(PartialPath path, long timestamp) throws MetadataException {
        PartialPath storageGroup = IoTDB.metaManager.getStorageGroupPath(path);
        return this.route(storageGroup.getFullPath(), timestamp);
    }

    default public MultiKeyMap<Long, PartitionGroup> partitionByPathRangeTime(PartialPath path, long startTime, long endTime) throws MetadataException {
        long partitionInterval = StorageEngine.getTimePartitionInterval();
        MultiKeyMap timeRangeMapRaftGroup = new MultiKeyMap();
        PartialPath storageGroup = IoTDB.metaManager.getStorageGroupPath(path);
        startTime = StorageEngine.convertMilliWithPrecision((long)startTime);
        endTime = StorageEngine.convertMilliWithPrecision((long)endTime);
        while (startTime <= endTime) {
            long nextTime = (startTime / partitionInterval + 1L) * partitionInterval;
            timeRangeMapRaftGroup.put((Object)startTime, (Object)Math.min(nextTime - 1L, endTime), (Object)this.route(storageGroup.getFullPath(), startTime));
            startTime = nextTime;
        }
        return timeRangeMapRaftGroup;
    }
}

