/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.member;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.cluster.client.async.AsyncClientPool;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.async.AsyncDataHeartbeatClient;
import org.apache.iotdb.cluster.client.sync.SyncClientPool;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncDataHeartbeatClient;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.exception.LogExecutionException;
import org.apache.iotdb.cluster.exception.SnapshotInstallationException;
import org.apache.iotdb.cluster.log.LogApplier;
import org.apache.iotdb.cluster.log.Snapshot;
import org.apache.iotdb.cluster.log.applier.AsyncDataLogApplier;
import org.apache.iotdb.cluster.log.applier.DataLogApplier;
import org.apache.iotdb.cluster.log.logtypes.CloseFileLog;
import org.apache.iotdb.cluster.log.manage.FilePartitionedSnapshotLogManager;
import org.apache.iotdb.cluster.log.manage.PartitionedSnapshotLogManager;
import org.apache.iotdb.cluster.log.manage.RaftLogManager;
import org.apache.iotdb.cluster.log.snapshot.FileSnapshot;
import org.apache.iotdb.cluster.log.snapshot.PartitionedSnapshot;
import org.apache.iotdb.cluster.log.snapshot.PullSnapshotTask;
import org.apache.iotdb.cluster.log.snapshot.PullSnapshotTaskDescriptor;
import org.apache.iotdb.cluster.metadata.CMManager;
import org.apache.iotdb.cluster.partition.NodeAdditionResult;
import org.apache.iotdb.cluster.partition.NodeRemovalResult;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.partition.slot.SlotManager;
import org.apache.iotdb.cluster.partition.slot.SlotNodeAdditionResult;
import org.apache.iotdb.cluster.partition.slot.SlotNodeRemovalResult;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.cluster.query.LocalQueryExecutor;
import org.apache.iotdb.cluster.query.manage.ClusterQueryManager;
import org.apache.iotdb.cluster.rpc.thrift.ElectionRequest;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.PullSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSnapshotResp;
import org.apache.iotdb.cluster.rpc.thrift.SendSnapshotRequest;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.PullSnapshotHintService;
import org.apache.iotdb.cluster.server.heartbeat.DataHeartbeatThread;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.iotdb.cluster.server.monitor.NodeReport;
import org.apache.iotdb.cluster.server.monitor.NodeStatusManager;
import org.apache.iotdb.cluster.server.monitor.Peer;
import org.apache.iotdb.cluster.server.monitor.Timer;
import org.apache.iotdb.cluster.utils.IOUtils;
import org.apache.iotdb.cluster.utils.StatusUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.BatchPlan;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertMultiTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsOfOneDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.sys.FlushPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.EndPoint;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataGroupMember
extends RaftMember {
    private static final Logger logger = LoggerFactory.getLogger(DataGroupMember.class);
    private MetaGroupMember metaGroupMember;
    private ExecutorService pullSnapshotService;
    private PullSnapshotHintService pullSnapshotHintService;
    private ClusterQueryManager queryManager;
    protected SlotManager slotManager;
    private LocalQueryExecutor localQueryExecutor;
    LogApplier dataLogApplier;
    private boolean unchanged;

    public DataGroupMember() {
        this.setQueryManager(new ClusterQueryManager());
        this.localQueryExecutor = new LocalQueryExecutor(this);
    }

    DataGroupMember(TProtocolFactory factory, PartitionGroup nodes, Node thisNode, MetaGroupMember metaGroupMember) {
        super("Data(" + nodes.getHeader().getInternalIp() + ":" + nodes.getHeader().getMetaPort() + ")", new AsyncClientPool(new AsyncDataClient.FactoryAsync(factory)), new SyncClientPool(new SyncDataClient.FactorySync(factory)), new AsyncClientPool(new AsyncDataHeartbeatClient.FactoryAsync(factory)), new SyncClientPool(new SyncDataHeartbeatClient.FactorySync(factory)), new AsyncClientPool(new AsyncDataClient.SingleManagerFactory(factory)));
        this.thisNode = thisNode;
        this.metaGroupMember = metaGroupMember;
        this.allNodes = nodes;
        this.setQueryManager(new ClusterQueryManager());
        this.slotManager = new SlotManager(10000L, this.getMemberDir());
        this.dataLogApplier = new DataLogApplier(metaGroupMember, this);
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncApplier() && ClusterDescriptor.getInstance().getConfig().getReplicationNum() != 1) {
            this.dataLogApplier = new AsyncDataLogApplier(this.dataLogApplier, this.name);
        }
        this.logManager = new FilePartitionedSnapshotLogManager(this.dataLogApplier, metaGroupMember.getPartitionTable(), (Node)this.allNodes.get(0), thisNode, this);
        this.initPeerMap();
        this.term.set(this.logManager.getHardState().getCurrentTerm());
        this.voteFor = this.logManager.getHardState().getVoteFor();
        this.localQueryExecutor = new LocalQueryExecutor(this);
    }

    @Override
    public void start() {
        if (this.heartBeatService != null) {
            return;
        }
        super.start();
        this.heartBeatService.submit(new DataHeartbeatThread(this));
        this.pullSnapshotService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        this.pullSnapshotHintService = new PullSnapshotHintService(this);
        this.resumePullSnapshotTasks();
    }

    @Override
    public void stop() {
        logger.info("{}: stopping...", (Object)this.name);
        super.stop();
        if (this.pullSnapshotService != null) {
            this.pullSnapshotService.shutdownNow();
            try {
                this.pullSnapshotService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Unexpected interruption when waiting for pullSnapshotService to end", (Throwable)e);
            }
            this.pullSnapshotService = null;
            this.pullSnapshotHintService.stop();
        }
        try {
            this.getQueryManager().endAllQueries();
        }
        catch (StorageEngineException e) {
            logger.error("Cannot release queries of {}", (Object)this.name, (Object)e);
        }
        logger.info("{}: stopped", (Object)this.name);
    }

    @Override
    public Node getHeader() {
        return (Node)this.allNodes.get(0);
    }

    public ClusterQueryManager getQueryManager() {
        return this.queryManager;
    }

    protected void setQueryManager(ClusterQueryManager queryManager) {
        this.queryManager = queryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addNode(Node node, NodeAdditionResult result) {
        AtomicLong atomicLong = this.term;
        synchronized (atomicLong) {
            this.term.incrementAndGet();
            this.setLeader(ClusterConstant.EMPTY_NODE);
            this.setVoteFor(this.thisNode);
            this.updateHardState(this.term.get(), this.getVoteFor());
            this.setLastHeartbeatReceivedTime(System.currentTimeMillis());
            this.setCharacter(NodeCharacter.ELECTOR);
        }
        Set lostSlots = ((SlotNodeAdditionResult)result).getLostSlots().getOrDefault(this.getHeader(), Collections.emptySet());
        for (Integer lostSlot : lostSlots) {
            this.slotManager.setToSending(lostSlot);
        }
        List list = this.allNodes;
        synchronized (list) {
            int insertIndex = -1;
            for (int i = 0; i < this.allNodes.size() - 1; ++i) {
                Node prev = (Node)this.allNodes.get(i);
                Node next = (Node)this.allNodes.get(i + 1);
                if (!(prev.nodeIdentifier < node.nodeIdentifier && node.nodeIdentifier < next.nodeIdentifier || prev.nodeIdentifier < node.nodeIdentifier && next.nodeIdentifier < prev.nodeIdentifier) && (node.nodeIdentifier >= next.nodeIdentifier || next.nodeIdentifier >= prev.nodeIdentifier)) continue;
                insertIndex = i + 1;
                break;
            }
            if (insertIndex > 0) {
                this.allNodes.add(insertIndex, node);
                this.peerMap.putIfAbsent(node, new Peer(this.logManager.getLastLogIndex()));
                Node removedNode = (Node)this.allNodes.remove(this.allNodes.size() - 1);
                this.peerMap.remove(removedNode);
                logger.debug("{}: Node {} is inserted into the data group {}", new Object[]{this.name, node, this.allNodes});
                return removedNode.equals(this.thisNode);
            }
            return false;
        }
    }

    @Override
    long checkElectorLogProgress(ElectionRequest electionRequest) {
        long thatTerm = electionRequest.getTerm();
        long thatMetaLastLogIndex = electionRequest.getLastLogIndex();
        long thatMetaLastLogTerm = electionRequest.getLastLogTerm();
        long thatDataLastLogIndex = electionRequest.getDataLogLastIndex();
        long thatDataLastLogTerm = electionRequest.getDataLogLastTerm();
        logger.info("{} received an dataGroup election request, term:{}, metaLastLogIndex:{}, metaLastLogTerm:{}, dataLastLogIndex:{}, dataLastLogTerm:{}", new Object[]{this.name, thatTerm, thatMetaLastLogIndex, thatMetaLastLogTerm, thatDataLastLogIndex, thatDataLastLogTerm});
        long metaResponse = this.metaGroupMember.checkLogProgress(thatMetaLastLogIndex, thatMetaLastLogTerm);
        if (metaResponse == -2L) {
            return -7L;
        }
        long resp = this.checkLogProgress(thatDataLastLogIndex, thatDataLastLogTerm);
        if (resp == -1L) {
            logger.info("{} accepted an dataGroup election request, term:{}/{}, dataLogIndex:{}/{}, dataLogTerm:{}/{}, metaLogIndex:{}/{},metaLogTerm:{}/{}", new Object[]{this.name, thatTerm, this.term.get(), thatDataLastLogIndex, this.logManager.getLastLogIndex(), thatDataLastLogTerm, this.logManager.getLastLogTerm(), thatMetaLastLogIndex, this.metaGroupMember.getLogManager().getLastLogIndex(), thatMetaLastLogTerm, this.metaGroupMember.getLogManager().getLastLogTerm()});
            this.setCharacter(NodeCharacter.FOLLOWER);
            this.lastHeartbeatReceivedTime = System.currentTimeMillis();
            this.setVoteFor(electionRequest.getElector());
            this.updateHardState(thatTerm, this.getVoteFor());
        } else {
            logger.info("{} rejected an dataGroup election request, term:{}/{}, dataLogIndex:{}/{}, dataLogTerm:{}/{}, metaLogIndex:{}/{},metaLogTerm:{}/{}", new Object[]{this.name, thatTerm, this.term.get(), thatDataLastLogIndex, this.logManager.getLastLogIndex(), thatDataLastLogTerm, this.logManager.getLastLogTerm(), thatMetaLastLogIndex, this.metaGroupMember.getLogManager().getLastLogIndex(), thatMetaLastLogTerm, this.metaGroupMember.getLogManager().getLastLogTerm()});
        }
        return resp;
    }

    public void receiveSnapshot(SendSnapshotRequest request) throws SnapshotInstallationException {
        logger.info("{}: received a snapshot from {} with size {}", new Object[]{this.name, request.getHeader(), request.getSnapshotBytes().length});
        PartitionedSnapshot<FileSnapshot> snapshot = new PartitionedSnapshot<FileSnapshot>(FileSnapshot.Factory.INSTANCE);
        snapshot.deserialize(ByteBuffer.wrap(request.getSnapshotBytes()));
        if (logger.isDebugEnabled()) {
            logger.debug("{} received a snapshot {}", (Object)this.name, snapshot);
        }
        snapshot.getDefaultInstaller(this).install(snapshot, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PullSnapshotResp getSnapshot(PullSnapshotRequest request) throws IOException {
        this.waitLeader();
        if (this.character != NodeCharacter.LEADER && !this.readOnly) {
            return null;
        }
        if (request.isRequireReadOnly()) {
            this.setReadOnly();
        }
        List requiredSlots = request.getRequiredSlots();
        for (Integer requiredSlot : requiredSlots) {
            this.slotManager.waitSlot(requiredSlot);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: {} slots are requested, first:{}, last: {}", new Object[]{this.name, requiredSlots.size(), requiredSlots.get(0), requiredSlots.get(requiredSlots.size() - 1)});
        }
        long currLastLogIndex = this.logManager.getLastLogIndex();
        logger.info("{}: Waiting for logs to commit before snapshot, {}/{}", new Object[]{this.name, this.logManager.getCommitLogIndex(), currLastLogIndex});
        while (this.logManager.getCommitLogIndex() < currLastLogIndex) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("{}: Unexpected interruption when waiting for logs to commit", (Object)this.name, (Object)e);
            }
        }
        RaftLogManager raftLogManager = this.logManager;
        synchronized (raftLogManager) {
            PullSnapshotResp resp = new PullSnapshotResp();
            HashMap<Integer, ByteBuffer> resultMap = new HashMap<Integer, ByteBuffer>();
            this.logManager.takeSnapshot();
            PartitionedSnapshot allSnapshot = (PartitionedSnapshot)this.logManager.getSnapshot();
            Iterator iterator = requiredSlots.iterator();
            while (iterator.hasNext()) {
                int requiredSlot = (Integer)iterator.next();
                Object snapshot = allSnapshot.getSnapshot(requiredSlot);
                if (snapshot == null) continue;
                resultMap.put(requiredSlot, ((Snapshot)snapshot).serialize());
            }
            resp.setSnapshotBytes(resultMap);
            logger.debug("{}: Sending {} snapshots to the requester", (Object)this.name, (Object)resultMap.size());
            return resp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullNodeAdditionSnapshots(List<Integer> slots, Node newNode) {
        RaftLogManager raftLogManager = this.logManager;
        synchronized (raftLogManager) {
            Node node;
            logger.info("{} pulling {} slots from remote", (Object)this.name, (Object)slots.size());
            PartitionedSnapshot snapshot = (PartitionedSnapshot)this.logManager.getSnapshot();
            Map<Integer, Node> prevHolders = ((SlotPartitionTable)this.metaGroupMember.getPartitionTable()).getPreviousNodeMap(newNode);
            HashMap<Node, List> holderSlotsMap = new HashMap<Node, List>();
            Iterator<Object> iterator = slots.iterator();
            while (iterator.hasNext()) {
                int n2 = iterator.next();
                if (snapshot.getSnapshot(n2) != null || (node = prevHolders.get(n2)) == null) continue;
                holderSlotsMap.computeIfAbsent(node, n -> new ArrayList()).add(n2);
            }
            for (Map.Entry entry : holderSlotsMap.entrySet()) {
                node = (Node)entry.getKey();
                List nodeSlots = (List)entry.getValue();
                PullSnapshotTaskDescriptor taskDescriptor = new PullSnapshotTaskDescriptor(this.metaGroupMember.getPartitionTable().getHeaderGroup(node), nodeSlots, false);
                this.pullFileSnapshot(taskDescriptor, null);
            }
        }
    }

    private void pullFileSnapshot(PullSnapshotTaskDescriptor descriptor, File snapshotSave) {
        Iterator<Integer> iterator = descriptor.getSlots().iterator();
        while (iterator.hasNext()) {
            Integer nodeSlot = iterator.next();
            SlotManager.SlotStatus status = this.slotManager.getStatus(nodeSlot);
            if (status != SlotManager.SlotStatus.NULL) {
                iterator.remove();
                continue;
            }
            this.slotManager.setToPulling(nodeSlot, descriptor.getPreviousHolders().getHeader());
        }
        if (descriptor.getSlots().isEmpty()) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("{}: {} and other {} slots are set to pulling", new Object[]{this.name, descriptor.getSlots().get(0), descriptor.getSlots().size() - 1});
        }
        this.pullSnapshotService.submit(new PullSnapshotTask<FileSnapshot>(descriptor, this, FileSnapshot.Factory.INSTANCE, snapshotSave));
    }

    private void resumePullSnapshotTasks() {
        File snapshotTaskDir = new File(this.getPullSnapshotTaskDir());
        if (!snapshotTaskDir.exists()) {
            return;
        }
        File[] files = snapshotTaskDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".task")) continue;
                try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));){
                    PullSnapshotTaskDescriptor descriptor = new PullSnapshotTaskDescriptor();
                    descriptor.deserialize(dataInputStream);
                    this.pullFileSnapshot(descriptor, file);
                }
                catch (IOException e) {
                    logger.error("Cannot resume pull-snapshot-task in file {}", (Object)file, (Object)e);
                    try {
                        Files.delete(file.toPath());
                    }
                    catch (IOException ex) {
                        logger.debug("Cannot remove pull snapshot task file {}", (Object)file, (Object)e);
                    }
                }
            }
        }
    }

    public String getPullSnapshotTaskDir() {
        return this.getMemberDir() + "snapshot_task" + File.separator;
    }

    private String getMemberDir() {
        return IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "raft" + File.separator + this.getHeader().nodeIdentifier + File.separator;
    }

    public MetaGroupMember getMetaGroupMember() {
        return this.metaGroupMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closePartition(String storageGroupName, long partitionId, boolean isSeq) {
        if (this.character != NodeCharacter.LEADER) {
            return;
        }
        CloseFileLog log = new CloseFileLog(storageGroupName, partitionId, isSeq);
        RaftLogManager raftLogManager = this.logManager;
        synchronized (raftLogManager) {
            log.setCurrLogTerm(this.getTerm().get());
            log.setCurrLogIndex(this.logManager.getLastLogIndex() + 1L);
            this.logManager.append(log);
            logger.info("Send the close file request of {} to other nodes", (Object)log);
        }
        try {
            this.appendLogInGroup(log);
        }
        catch (LogExecutionException e) {
            logger.error("Cannot close partition {}#{} seq:{}", new Object[]{storageGroupName, partitionId, isSeq, e});
        }
    }

    public boolean flushFileWhenDoSnapshot(Map<String, List<Pair<Long, Boolean>>> storageGroupPartitions) {
        if (this.character != NodeCharacter.LEADER) {
            return false;
        }
        HashMap localDataMemberStorageGroupPartitions = new HashMap();
        for (Map.Entry<String, List<Pair<Long, Boolean>>> entry : storageGroupPartitions.entrySet()) {
            ArrayList<Pair> localListPair = new ArrayList<Pair>();
            String storageGroupName = entry.getKey();
            List<Pair<Long, Boolean>> tmpPairList = entry.getValue();
            for (Pair<Long, Boolean> pair : tmpPairList) {
                long partitionId = (Long)pair.left;
                Node header = this.metaGroupMember.getPartitionTable().routeToHeaderByTime(storageGroupName, partitionId * StorageEngine.getTimePartitionInterval());
                DataGroupMember localDataMember = this.metaGroupMember.getLocalDataMember(header);
                if (!localDataMember.getHeader().equals(this.getHeader())) continue;
                localListPair.add(new Pair((Object)partitionId, (Object)((Boolean)pair.right)));
            }
            try {
                localDataMemberStorageGroupPartitions.put(new PartialPath(storageGroupName), localListPair);
            }
            catch (IllegalPathException illegalPathException) {}
        }
        if (localDataMemberStorageGroupPartitions.size() <= 0) {
            logger.info("{}: have no data to flush", (Object)this.name);
            return true;
        }
        FlushPlan flushPlan = new FlushPlan(null, true, localDataMemberStorageGroupPartitions);
        try {
            PlanExecutor.flushSpecifiedStorageGroups((FlushPlan)flushPlan);
            return true;
        }
        catch (StorageGroupNotSetException e) {
            logger.error("Some SGs are missing while flushing", (Throwable)e);
            return false;
        }
    }

    @Override
    public TSStatus executeNonQueryPlan(PhysicalPlan plan) {
        if (ClusterDescriptor.getInstance().getConfig().getReplicationNum() == 1) {
            try {
                ((DataLogApplier)this.dataLogApplier).applyPhysicalPlan(plan);
                return StatusUtils.OK;
            }
            catch (Exception e) {
                boolean hasCreated;
                Throwable cause;
                block10: {
                    cause = IOUtils.getRootCause(e);
                    hasCreated = false;
                    try {
                        if (!(plan instanceof InsertPlan) || !ClusterDescriptor.getInstance().getConfig().isEnableAutoCreateSchema()) break block10;
                        if (plan instanceof InsertRowsPlan || plan instanceof InsertMultiTabletPlan) {
                            if (!(e instanceof BatchProcessException)) break block10;
                            for (TSStatus status : ((BatchProcessException)((Object)e)).getFailingStatus()) {
                                if (status.getCode() != TSStatusCode.TIMESERIES_NOT_EXIST.getStatusCode()) continue;
                                hasCreated = this.createTimeseriesForFailedInsertion((InsertPlan)plan);
                                ((BatchPlan)plan).getResults().clear();
                                break block10;
                            }
                            break block10;
                        }
                        if (cause instanceof PathNotExistException) {
                            hasCreated = this.createTimeseriesForFailedInsertion((InsertPlan)plan);
                        }
                    }
                    catch (CheckConsistencyException | MetadataException ex) {
                        logger.error("{}: Cannot auto-create timeseries for {}", new Object[]{this.name, plan, e});
                        return StatusUtils.getStatus(StatusUtils.EXECUTE_STATEMENT_ERROR, ex.getMessage());
                    }
                }
                if (hasCreated) {
                    return this.executeNonQueryPlan(plan);
                }
                return this.handleLogExecutionException(plan, cause);
            }
        }
        TSStatus status = this.executeNonQueryPlanWithKnownLeader(plan);
        if (!StatusUtils.NO_LEADER.equals(status)) {
            return status;
        }
        long startTime = Timer.Statistic.DATA_GROUP_MEMBER_WAIT_LEADER.getOperationStartTime();
        this.waitLeader();
        Timer.Statistic.DATA_GROUP_MEMBER_WAIT_LEADER.calOperationCostTimeFromStart(startTime);
        return this.executeNonQueryPlanWithKnownLeader(plan);
    }

    private TSStatus executeNonQueryPlanWithKnownLeader(PhysicalPlan plan) {
        if (this.character == NodeCharacter.LEADER) {
            boolean hasCreated;
            TSStatus status;
            long startTime;
            block11: {
                startTime = Timer.Statistic.DATA_GROUP_MEMBER_LOCAL_EXECUTION.getOperationStartTime();
                status = this.processPlanLocally(plan);
                hasCreated = false;
                try {
                    if (!(plan instanceof InsertPlan) || !ClusterDescriptor.getInstance().getConfig().isEnableAutoCreateSchema()) break block11;
                    if (plan instanceof InsertRowsPlan || plan instanceof InsertMultiTabletPlan) {
                        if (status.getCode() != TSStatusCode.MULTIPLE_ERROR.getStatusCode()) break block11;
                        for (TSStatus tmpStatus : status.getSubStatus()) {
                            if (tmpStatus.getCode() != TSStatusCode.TIMESERIES_NOT_EXIST.getStatusCode()) continue;
                            hasCreated = this.createTimeseriesForFailedInsertion((InsertPlan)plan);
                            ((BatchPlan)plan).getResults().clear();
                            break block11;
                        }
                        break block11;
                    }
                    if (status.getCode() == TSStatusCode.TIMESERIES_NOT_EXIST.getStatusCode()) {
                        hasCreated = this.createTimeseriesForFailedInsertion((InsertPlan)plan);
                    }
                }
                catch (CheckConsistencyException | MetadataException e) {
                    logger.error("{}: Cannot auto-create timeseries for {}", new Object[]{this.name, plan, e});
                    return StatusUtils.getStatus(StatusUtils.EXECUTE_STATEMENT_ERROR, e.getMessage());
                }
            }
            if (hasCreated) {
                status = this.processPlanLocally(plan);
            }
            Timer.Statistic.DATA_GROUP_MEMBER_LOCAL_EXECUTION.calOperationCostTimeFromStart(startTime);
            if (status != null) {
                return status;
            }
        } else if (this.leader.get() != null && !ClusterConstant.EMPTY_NODE.equals((Node)this.leader.get())) {
            long startTime = Timer.Statistic.DATA_GROUP_MEMBER_FORWARD_PLAN.getOperationStartTime();
            TSStatus result = this.forwardPlan(plan, (Node)this.leader.get(), this.getHeader());
            Timer.Statistic.DATA_GROUP_MEMBER_FORWARD_PLAN.calOperationCostTimeFromStart(startTime);
            if (!StatusUtils.NO_LEADER.equals(result)) {
                result.setRedirectNode(new EndPoint(((Node)this.leader.get()).getClientIp(), ((Node)this.leader.get()).getClientPort()));
                return result;
            }
        }
        return StatusUtils.NO_LEADER;
    }

    private boolean createTimeseriesForFailedInsertion(InsertPlan plan) throws CheckConsistencyException, IllegalPathException {
        logger.info("create time series for failed insertion {}", (Object)plan);
        if (plan instanceof InsertMultiTabletPlan) {
            for (InsertTabletPlan insertPlan : ((InsertMultiTabletPlan)plan).getInsertTabletPlanList()) {
                if (insertPlan.getFailedMeasurements() == null) continue;
                insertPlan.getPlanFromFailed();
            }
        }
        if (plan instanceof InsertRowsPlan) {
            for (InsertTabletPlan insertPlan : ((InsertRowsPlan)plan).getInsertRowPlanList()) {
                if (insertPlan.getFailedMeasurements() == null) continue;
                insertPlan.getPlanFromFailed();
            }
        }
        if (plan instanceof InsertRowsOfOneDevicePlan) {
            for (InsertRowPlan insertPlan : ((InsertRowsOfOneDevicePlan)plan).getRowPlans()) {
                if (insertPlan.getFailedMeasurements() == null) continue;
                insertPlan.getPlanFromFailed();
            }
        }
        if (plan.getFailedMeasurements() != null) {
            plan.getPlanFromFailed();
        }
        return ((CMManager)IoTDB.metaManager).createTimeseries(plan);
    }

    public void removeLocalData(List<Integer> slots) {
        if (slots.isEmpty()) {
            return;
        }
        HashSet<Integer> slotSet = new HashSet<Integer>(slots);
        List allStorageGroupNames = IoTDB.metaManager.getAllStorageGroupPaths();
        StorageGroupProcessor.TimePartitionFilter filter = (storageGroupName, timePartitionId) -> {
            int slot = SlotPartitionTable.getSlotStrategy().calculateSlotByPartitionNum(storageGroupName, timePartitionId, 10000);
            return slotSet.contains(slot);
        };
        for (PartialPath sg : allStorageGroupNames) {
            StorageEngine.getInstance().removePartitions(sg, filter);
        }
        for (Integer slot : slots) {
            this.slotManager.setToNull(slot);
        }
        if (logger.isInfoEnabled()) {
            logger.info("{}: data of {} and other {} slots are removed", new Object[]{this.name, slots.get(0), slots.size() - 1});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(Node removedNode, NodeRemovalResult removalResult) {
        List list = this.allNodes;
        synchronized (list) {
            List<Integer> slotsToPull;
            if (this.allNodes.contains(removedNode)) {
                this.allNodes = this.metaGroupMember.getPartitionTable().getHeaderGroup(this.getHeader());
                this.initPeerMap();
                if (removedNode.equals((Node)this.leader.get())) {
                    AtomicLong atomicLong = this.term;
                    synchronized (atomicLong) {
                        this.setCharacter(NodeCharacter.ELECTOR);
                        this.setLastHeartbeatReceivedTime(Long.MIN_VALUE);
                    }
                }
            }
            if ((slotsToPull = ((SlotNodeRemovalResult)removalResult).getNewSlotOwners().get(this.getHeader())) != null) {
                PullSnapshotTaskDescriptor taskDescriptor = new PullSnapshotTaskDescriptor(removalResult.getRemovedGroup(), slotsToPull, true);
                this.pullFileSnapshot(taskDescriptor, null);
            }
        }
    }

    public NodeReport.DataMemberReport genReport() {
        long prevLastLogIndex = this.lastReportedLogIndex;
        this.lastReportedLogIndex = this.logManager.getLastLogIndex();
        return new NodeReport.DataMemberReport(this.character, (Node)this.leader.get(), this.term.get(), this.logManager.getLastLogTerm(), this.lastReportedLogIndex, this.logManager.getCommitLogIndex(), this.logManager.getCommitLogTerm(), this.getHeader(), this.readOnly, NodeStatusManager.getINSTANCE().getLastResponseLatency(this.getHeader()), this.lastHeartbeatReceivedTime, prevLastLogIndex, this.logManager.getMaxHaveAppliedCommitIndex());
    }

    public void setMetaGroupMember(MetaGroupMember metaGroupMember) {
        this.metaGroupMember = metaGroupMember;
        this.localQueryExecutor = new LocalQueryExecutor(this);
    }

    void setLogManager(PartitionedSnapshotLogManager<Snapshot> logManager) {
        if (this.logManager != null) {
            this.logManager.close();
        }
        this.logManager = logManager;
        super.setLogManager(logManager);
        this.initPeerMap();
    }

    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    public boolean onSnapshotInstalled(List<Integer> slots) {
        ArrayList<Integer> removableSlots = new ArrayList<Integer>();
        for (Integer slot : slots) {
            int sentReplicaNum = this.slotManager.sentOneReplication(slot);
            if (sentReplicaNum < ClusterDescriptor.getInstance().getConfig().getReplicationNum()) continue;
            removableSlots.add(slot);
        }
        this.removeLocalData(removableSlots);
        return true;
    }

    public void registerPullSnapshotHint(PullSnapshotTaskDescriptor descriptor) {
        this.pullSnapshotHintService.registerHint(descriptor);
    }

    public LocalQueryExecutor getLocalQueryExecutor() {
        return this.localQueryExecutor;
    }

    public void setLocalQueryExecutor(LocalQueryExecutor localQueryExecutor) {
        this.localQueryExecutor = localQueryExecutor;
    }

    public boolean isUnchanged() {
        return this.unchanged;
    }

    public void setUnchanged(boolean unchanged) {
        this.unchanged = unchanged;
    }

    public static class Factory {
        private TProtocolFactory protocolFactory;
        private MetaGroupMember metaGroupMember;

        Factory(TProtocolFactory protocolFactory, MetaGroupMember metaGroupMember) {
            this.protocolFactory = protocolFactory;
            this.metaGroupMember = metaGroupMember;
        }

        public DataGroupMember create(PartitionGroup partitionGroup, Node thisNode) {
            return new DataGroupMember(this.protocolFactory, partitionGroup, thisNode, this.metaGroupMember);
        }
    }
}

