/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.heartbeat;

import java.net.InetSocketAddress;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.TSDataService;
import org.apache.iotdb.cluster.server.DataClusterServer;
import org.apache.iotdb.cluster.server.heartbeat.HeartbeatServer;
import org.apache.thrift.TProcessor;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;

public class DataHeartbeatServer
extends HeartbeatServer {
    private DataClusterServer dataClusterServer;

    private DataHeartbeatServer() {
    }

    public DataHeartbeatServer(Node thisNode, DataClusterServer dataClusterServer) {
        super(thisNode);
        this.dataClusterServer = dataClusterServer;
    }

    @Override
    TProcessor getProcessor() {
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            return new TSDataService.AsyncProcessor((TSDataService.AsyncIface)this.dataClusterServer);
        }
        return new TSDataService.Processor((TSDataService.Iface)this.dataClusterServer);
    }

    @Override
    TServerTransport getHeartbeatServerSocket() throws TTransportException {
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            return new TNonblockingServerSocket(new InetSocketAddress(this.config.getInternalIp(), this.thisNode.getDataPort() + 1), DataHeartbeatServer.getConnectionTimeoutInMS());
        }
        return new TServerSocket(new InetSocketAddress(this.config.getInternalIp(), this.thisNode.getDataPort() + 1));
    }

    @Override
    String getClientThreadPrefix() {
        return "DataHeartbeatClientThread-";
    }

    @Override
    String getServerClientName() {
        return "DataHeartbeatServerThread-";
    }
}

