/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.logtypes;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.utils.NodeSerializeUtils;

public class RemoveNodeLog
extends Log {
    private Node removedNode;

    @Override
    public ByteBuffer serialize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            dataOutputStream.writeByte(Log.Types.REMOVE_NODE.ordinal());
            dataOutputStream.writeLong(this.getCurrLogIndex());
            dataOutputStream.writeLong(this.getCurrLogTerm());
            NodeSerializeUtils.serialize(this.removedNode, dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.setCurrLogIndex(buffer.getLong());
        this.setCurrLogTerm(buffer.getLong());
        this.removedNode = new Node();
        NodeSerializeUtils.deserialize(this.removedNode, buffer);
    }

    public Node getRemovedNode() {
        return this.removedNode;
    }

    public void setRemovedNode(Node removedNode) {
        this.removedNode = removedNode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoveNodeLog that = (RemoveNodeLog)o;
        return Objects.equals(this.removedNode, that.removedNode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.removedNode);
    }
}

