/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.MetaUtils;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.aggregation.impl.AvgAggrResult;
import org.apache.iotdb.db.query.factory.AggregateResultFactory;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;

public class AggregateUtils {
    public static String generatePartialPathByLevel(String originalPath, int pathLevel) throws IllegalPathException {
        String[] tmpPath = MetaUtils.splitPathToDetachedPath(originalPath);
        if (tmpPath.length <= pathLevel) {
            return originalPath;
        }
        StringBuilder transformedPath = new StringBuilder();
        transformedPath.append(tmpPath[0]);
        for (int k = 1; k < tmpPath.length - 1; ++k) {
            if (k <= pathLevel) {
                transformedPath.append(".").append(tmpPath[k]);
                continue;
            }
            transformedPath.append(".").append("*");
        }
        transformedPath.append(".").append(tmpPath[tmpPath.length - 1]);
        return transformedPath.toString();
    }

    public static List<AggregateResult> mergeRecordByPath(AggregationPlan plan, RowRecord newRecord, Map<String, AggregateResult> finalPaths) throws QueryProcessException {
        if (newRecord.getFields().size() < finalPaths.size()) {
            return Collections.emptyList();
        }
        ArrayList<AggregateResult> aggregateResultList = new ArrayList<AggregateResult>();
        for (int i = 0; i < newRecord.getFields().size(); ++i) {
            if (newRecord.getFields().get(i) == null) {
                aggregateResultList.add(AggregateResultFactory.getAggrResultByName(plan.getDeduplicatedAggregations().get(i), plan.getDeduplicatedDataTypes().get(i)));
                continue;
            }
            TSDataType dataType = ((Field)newRecord.getFields().get(i)).getDataType();
            AggregateResult aggRet = AggregateResultFactory.getAggrResultByName(plan.getDeduplicatedAggregations().get(i), dataType);
            if (aggRet.getAggregationType().equals((Object)AggregationType.AVG)) {
                ((AvgAggrResult)aggRet).setAvgResult(dataType, ((Field)newRecord.getFields().get(i)).getDoubleV());
            } else {
                switch (dataType) {
                    case TEXT: {
                        aggRet.setBinaryValue(((Field)newRecord.getFields().get(i)).getBinaryV());
                        break;
                    }
                    case INT32: {
                        aggRet.setIntValue(((Field)newRecord.getFields().get(i)).getIntV());
                        break;
                    }
                    case INT64: {
                        aggRet.setLongValue(((Field)newRecord.getFields().get(i)).getLongV());
                        break;
                    }
                    case FLOAT: {
                        aggRet.setFloatValue(((Field)newRecord.getFields().get(i)).getFloatV());
                        break;
                    }
                    case DOUBLE: {
                        aggRet.setDoubleValue(((Field)newRecord.getFields().get(i)).getDoubleV());
                        break;
                    }
                    case BOOLEAN: {
                        aggRet.setBooleanValue(((Field)newRecord.getFields().get(i)).getBoolV());
                        break;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(dataType.toString());
                    }
                }
            }
            aggregateResultList.add(aggRet);
        }
        return AggregateUtils.mergeRecordByPath(plan, aggregateResultList, finalPaths);
    }

    public static List<AggregateResult> mergeRecordByPath(AggregationPlan plan, List<AggregateResult> aggResults, Map<String, AggregateResult> finalPaths) throws QueryProcessException {
        if (aggResults.size() < finalPaths.size()) {
            return Collections.emptyList();
        }
        for (Map.Entry<String, AggregateResult> entry : finalPaths.entrySet()) {
            finalPaths.put(entry.getKey(), null);
        }
        ArrayList<AggregateResult> resultSet = new ArrayList<AggregateResult>();
        List<PartialPath> dupPaths = plan.getDeduplicatedPaths();
        try {
            for (int i = 0; i < aggResults.size(); ++i) {
                if (aggResults.get(i) == null) continue;
                String transformedPath = AggregateUtils.generatePartialPathByLevel(dupPaths.get(i).getFullPath(), plan.getLevel());
                String key = plan.getDeduplicatedAggregations().get(i) + "(" + transformedPath + ")";
                AggregateResult tempAggResult = finalPaths.get(key);
                if (tempAggResult == null) {
                    finalPaths.put(key, aggResults.get(i));
                    continue;
                }
                tempAggResult.merge(aggResults.get(i));
                finalPaths.put(key, tempAggResult);
            }
        }
        catch (IllegalPathException e) {
            throw new QueryProcessException(e.getMessage());
        }
        for (Map.Entry<String, AggregateResult> entry : finalPaths.entrySet()) {
            resultSet.add(entry.getValue());
        }
        return resultSet;
    }
}

