/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetUsingDeviceTemplatePlan
extends PhysicalPlan {
    private static final Logger logger = LoggerFactory.getLogger(SetUsingDeviceTemplatePlan.class);
    PartialPath prefixPath;

    public SetUsingDeviceTemplatePlan() {
        super(false, Operator.OperatorType.SET_USING_DEVICE_TEMPLATE);
    }

    public SetUsingDeviceTemplatePlan(PartialPath prefixPath) {
        super(false, Operator.OperatorType.SET_USING_DEVICE_TEMPLATE);
        this.prefixPath = prefixPath;
    }

    @Override
    public List<PartialPath> getPaths() {
        return null;
    }

    public PartialPath getPrefixPath() {
        return this.prefixPath;
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.SET_USING_DEVICE_TEMPLATE.ordinal());
        ReadWriteIOUtils.write((String)this.prefixPath.getFullPath(), (ByteBuffer)buffer);
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        String pathString = this.readString(buffer);
        try {
            this.prefixPath = new PartialPath(pathString);
        }
        catch (IllegalPathException e) {
            logger.error("Failed to deserialize device {} from buffer", (Object)pathString);
        }
        this.index = buffer.getLong();
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.SET_USING_DEVICE_TEMPLATE.ordinal());
        ReadWriteIOUtils.write((String)this.prefixPath.getFullPath(), (OutputStream)stream);
        stream.writeLong(this.index);
    }
}

