/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.db.conf.IoTDBConstant;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.engine.merge.selector.MergeFileStrategy;
import org.apache.iotdb.db.engine.storagegroup.timeindex.TimeIndexLevel;
import org.apache.iotdb.db.exception.LoadConfigurationException;
import org.apache.iotdb.db.service.TSServiceImpl;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConfig {
    public static final String WATERMARK_GROUPED_LSB = "GroupBasedLSBMethod";
    static final String CONFIG_NAME = "iotdb-engine.properties";
    private static final Logger logger = LoggerFactory.getLogger(IoTDBConfig.class);
    private static final String MULTI_DIR_STRATEGY_PREFIX = "org.apache.iotdb.db.conf.directories.strategy.";
    private static final String DEFAULT_MULTI_DIR_STRATEGY = "MaxDiskUsableSpaceFirstStrategy";
    private static final String ID_MATCHER = "([a-zA-Z0-9/\"[ ],:@#$%&{}()*=?!~\\[\\]\\-+\\u2E80-\\u9FFF_]+)";
    private static final String STORAGE_GROUP_MATCHER = "([a-zA-Z0-9_.\\-\\u2E80-\\u9FFF]+)";
    private static final String PARTIAL_NODE_MATCHER = "[.]([a-zA-Z0-9/\"[ ],:@#$%&{}()*=?!~\\[\\]\\-+\\u2E80-\\u9FFF_]+)";
    private static final String NODE_MATCHER = "([.][\"])?([a-zA-Z0-9/\"[ ],:@#$%&{}()*=?!~\\[\\]\\-+\\u2E80-\\u9FFF_]+)([.]([a-zA-Z0-9/\"[ ],:@#$%&{}()*=?!~\\[\\]\\-+\\u2E80-\\u9FFF_]+))*([\"])?";
    public static final Pattern STORAGE_GROUP_PATTERN = Pattern.compile("([a-zA-Z0-9_.\\-\\u2E80-\\u9FFF]+)");
    public static final Pattern NODE_PATTERN = Pattern.compile("([.][\"])?([a-zA-Z0-9/\"[ ],:@#$%&{}()*=?!~\\[\\]\\-+\\u2E80-\\u9FFF_]+)([.]([a-zA-Z0-9/\"[ ],:@#$%&{}()*=?!~\\[\\]\\-+\\u2E80-\\u9FFF_]+))*([\"])?");
    private int metricsPort = 8181;
    private boolean enableMetricService = false;
    private boolean enableMQTTService = false;
    private String mqttHost = "0.0.0.0";
    private int mqttPort = 1883;
    private int mqttHandlerPoolSize = 1;
    private String mqttPayloadFormatter = "json";
    private int mqttMaxMessageSize = 0x100000;
    private String rpcAddress = "0.0.0.0";
    private boolean rpcThriftCompressionEnable = false;
    private boolean rpcAdvancedCompressionEnable = false;
    private int rpcPort = 6667;
    private int rpcMaxConcurrentClientNum = 65535;
    private long allocateMemoryForWrite = Runtime.getRuntime().maxMemory() * 4L / 10L;
    private long allocateMemoryForRead = Runtime.getRuntime().maxMemory() * 3L / 10L;
    private long allocateMemoryForSchema = Runtime.getRuntime().maxMemory() * 1L / 10L;
    private long allocateMemoryForReadWithoutCache = this.allocateMemoryForRead * 3L / 10L;
    private volatile int maxQueryDeduplicatedPathNum = 1000;
    private double bufferedArraysMemoryProportion = 0.6;
    private double flushProportion = 0.4;
    private double rejectProportion = 0.8;
    private long storageGroupSizeReportThreshold = 0x1000000L;
    private int checkPeriodWhenInsertBlocked = 50;
    private int maxWaitingTimeWhenInsertBlockedInMs = 10000;
    private boolean enableWal = true;
    private volatile boolean readOnly = false;
    private boolean enableDiscardOutOfOrderData = false;
    private int flushWalThreshold = 10000;
    private String timestampPrecision = "ms";
    private long forceWalPeriodInMs = 100L;
    private int walBufferSize = 0x1000000;
    private int maxWalBytebufferNumForEachPartition = 6;
    private long walPoolTrimIntervalInMS = 10000L;
    private int estimatedSeriesSize = 300;
    private int mlogBufferSize = 0x100000;
    private static final String DEFAULT_BASE_DIR = "data";
    private String systemDir = "data" + File.separator + "system";
    private String schemaDir = "data" + File.separator + "system" + File.separator + "schema";
    private String syncDir = "data" + File.separator + "system" + File.separator + "sync";
    private String tracingDir = "data" + File.separator + "tracing";
    private String queryDir = "data" + File.separator + "query";
    private String extDir = "ext";
    private String udfDir = "ext" + File.separator + "udf";
    private String[] dataDirs = new String[]{"data" + File.separator + "data"};
    private String multiDirStrategyClassName = null;
    private String walDir = "data" + File.separator + "wal";
    private int maxMemtableNumber = 0;
    private int batchSize = 100000;
    private int concurrentFlushThread = Runtime.getRuntime().availableProcessors();
    private int concurrentQueryThread = Runtime.getRuntime().availableProcessors();
    private boolean enableMemControl = true;
    private boolean enableIndex = false;
    private int concurrentIndexBuildThread = Runtime.getRuntime().availableProcessors();
    private long indexBufferSize = 0x8000000L;
    private int defaultIndexWindowRange = 10;
    private String indexRootFolder = "data" + File.separator + "index";
    private long unSeqTsFileSize = 1L;
    private long seqTsFileSize = 1L;
    private long memtableSizeThreshold = 0x40000000L;
    private boolean enableTimedFlushSeqMemtable = false;
    private long seqMemtableFlushInterval = 3600000L;
    private long seqMemtableFlushCheckInterval = 600000L;
    private boolean enableTimedFlushUnseqMemtable = true;
    private long unseqMemtableFlushInterval = 3600000L;
    private long unseqMemtableFlushCheckInterval = 600000L;
    private boolean enableTimedCloseTsFile = true;
    private long closeTsFileIntervalAfterFlushing = 3600000L;
    private long closeTsFileCheckInterval = 600000L;
    private int avgSeriesPointNumberThreshold = 10000;
    private int mergeChunkPointNumberThreshold = 100000;
    private int mergePagePointNumberThreshold = 100;
    private CompactionStrategy compactionStrategy = CompactionStrategy.LEVEL_COMPACTION;
    private boolean enableUnseqCompaction = true;
    private boolean enableContinuousCompaction = true;
    private int seqFileNumInEachLevel = 6;
    private int seqLevelNum = 3;
    private int unseqFileNumInEachLevel = 10;
    private int unseqLevelNum = 1;
    private int maxSelectUnseqFileNumInEachUnseqCompaction = 2000;
    private boolean metaDataCacheEnable = true;
    private long allocateMemoryForTimeSeriesMetaDataCache = this.allocateMemoryForRead / 5L;
    private long allocateMemoryForChunkCache = this.allocateMemoryForRead / 10L;
    private boolean lastCacheEnable = true;
    private boolean enableStatMonitor = false;
    private boolean enableMonitorSeriesWrite = false;
    private int mManagerCacheSize = 300000;
    private int mRemoteSchemaCacheSize = 100000;
    private boolean enableExternalSort = true;
    private int externalSortThreshold = 1000;
    private boolean isSyncEnable = false;
    private int syncServerPort = 5555;
    private String languageVersion = "EN";
    private String ipWhiteList = "0.0.0.0/0";
    private long cacheFileReaderClearPeriod = 100000L;
    private int queryTimeoutThreshold = 60000;
    private long compactionInterval = 30000L;
    private String rpcImplClassName = TSServiceImpl.class.getName();
    private boolean enablePerformanceStat = false;
    private boolean enablePerformanceTracing = false;
    private long performanceStatDisplayInterval = 60000L;
    private int performanceStatMemoryInKB = 20;
    private boolean chunkBufferPoolEnable = false;
    private boolean enableWatermark = false;
    private String watermarkSecretKey = "IoTDB*2019@Beijing";
    private String watermarkBitString = "100101110100";
    private String watermarkMethod = "GroupBasedLSBMethod(embed_row_cycle=2,embed_lsb_num=5)";
    private boolean enableAutoCreateSchema = true;
    private TSDataType booleanStringInferType = TSDataType.BOOLEAN;
    private TSDataType integerStringInferType = TSDataType.FLOAT;
    private TSDataType longStringInferType = TSDataType.DOUBLE;
    private TSDataType floatingStringInferType = TSDataType.FLOAT;
    private TSDataType nanStringInferType = TSDataType.DOUBLE;
    private int defaultStorageGroupLevel = 1;
    private TSEncoding defaultBooleanEncoding = TSEncoding.RLE;
    private TSEncoding defaultInt32Encoding = TSEncoding.RLE;
    private TSEncoding defaultInt64Encoding = TSEncoding.RLE;
    private TSEncoding defaultFloatEncoding = TSEncoding.GORILLA;
    private TSEncoding defaultDoubleEncoding = TSEncoding.GORILLA;
    private TSEncoding defaultTextEncoding = TSEncoding.PLAIN;
    private long mergeMemoryBudget = (long)((double)Runtime.getRuntime().maxMemory() * 0.1);
    private int upgradeThreadNum = 1;
    private int mergeThreadNum = 1;
    private int mergeChunkSubThreadNum = 4;
    private long mergeFileSelectionTimeBudget = 30000L;
    private boolean continueMergeAfterReboot = false;
    private long mergeIntervalSec = 0L;
    private boolean forceFullMerge = true;
    private int mergeWriteThroughputMbPerSec = 8;
    private int compactionThreadNum = 10;
    private MergeFileStrategy mergeFileStrategy = MergeFileStrategy.MAX_SERIES_NUM;
    private FSType systemFileStorageFs = FSType.LOCAL;
    private FSType tsFileStorageFs = FSType.LOCAL;
    private String coreSitePath = "/etc/hadoop/conf/core-site.xml";
    private String hdfsSitePath = "/etc/hadoop/conf/hdfs-site.xml";
    private String hdfsIp = "localhost";
    private String hdfsPort = "9000";
    private String dfsNameServices = "hdfsnamespace";
    private String dfsHaNamenodes = "nn1,nn2";
    private boolean dfsHaAutomaticFailoverEnabled = true;
    private String dfsClientFailoverProxyProvider = "org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider";
    private boolean useKerberos = false;
    private String kerberosKeytabFilePath = "/path";
    private String kerberosPrincipal = "your principal";
    private int concurrentWritingTimePartition = 500;
    private int defaultFillInterval = -1;
    private long defaultTTL = Long.MAX_VALUE;
    private int primitiveArraySize = 32;
    private boolean enablePartition = false;
    private boolean enableMTreeSnapshot = false;
    private int mtreeSnapshotInterval = 100000;
    private int mtreeSnapshotThresholdTime = 3600;
    private long partitionInterval = 604800L;
    private TimeIndexLevel timeIndexLevel = TimeIndexLevel.DEVICE_TIME_INDEX;
    private int thriftServerAwaitTimeForStopService = 60;
    private int queryCacheSizeInMetric = 50;
    private int tagAttributeTotalSize = 700;
    private int tagAttributeFlushInterval = 1000;
    private boolean enablePartialInsert = true;
    private String openIdProviderUrl = "";
    private String authorizerProvider = "org.apache.iotdb.db.auth.authorizer.LocalFileAuthorizer";
    private int udfInitialByteArrayLengthForMemoryControl = 48;
    private float udfMemoryBudgetInMB = (float)Math.min(30.0, 0.2 * (double)this.allocateMemoryForRead);
    private float udfReaderMemoryBudgetInMB = (float)(0.3333333333333333 * (double)this.udfMemoryBudgetInMB);
    private float udfTransformerMemoryBudgetInMB = (float)(0.3333333333333333 * (double)this.udfMemoryBudgetInMB);
    private float udfCollectorMemoryBudgetInMB = (float)(0.3333333333333333 * (double)this.udfMemoryBudgetInMB);
    private long startUpNanosecond = System.nanoTime();
    private int thriftMaxFrameSize = 0x20000000;
    private int thriftDefaultBufferSize = 1024;
    private int frequencyIntervalInMinute = 1;
    private long slowQueryThreshold = 5000L;
    private boolean enableRpcService = true;
    private int ioTaskQueueSizeForFlushing = 10;
    private int virtualStorageGroupNum = 1;
    private String adminName = "root";
    private String adminPassword = "root";

    public float getUdfMemoryBudgetInMB() {
        return this.udfMemoryBudgetInMB;
    }

    public void setUdfMemoryBudgetInMB(float udfMemoryBudgetInMB) {
        this.udfMemoryBudgetInMB = udfMemoryBudgetInMB;
    }

    public float getUdfReaderMemoryBudgetInMB() {
        return this.udfReaderMemoryBudgetInMB;
    }

    public void setUdfReaderMemoryBudgetInMB(float udfReaderMemoryBudgetInMB) {
        this.udfReaderMemoryBudgetInMB = udfReaderMemoryBudgetInMB;
    }

    public float getUdfTransformerMemoryBudgetInMB() {
        return this.udfTransformerMemoryBudgetInMB;
    }

    public void setUdfTransformerMemoryBudgetInMB(float udfTransformerMemoryBudgetInMB) {
        this.udfTransformerMemoryBudgetInMB = udfTransformerMemoryBudgetInMB;
    }

    public float getUdfCollectorMemoryBudgetInMB() {
        return this.udfCollectorMemoryBudgetInMB;
    }

    public void setUdfCollectorMemoryBudgetInMB(float udfCollectorMemoryBudgetInMB) {
        this.udfCollectorMemoryBudgetInMB = udfCollectorMemoryBudgetInMB;
    }

    public int getUdfInitialByteArrayLengthForMemoryControl() {
        return this.udfInitialByteArrayLengthForMemoryControl;
    }

    public void setUdfInitialByteArrayLengthForMemoryControl(int udfInitialByteArrayLengthForMemoryControl) {
        this.udfInitialByteArrayLengthForMemoryControl = udfInitialByteArrayLengthForMemoryControl;
    }

    void setConcurrentWritingTimePartition(int concurrentWritingTimePartition) {
        this.concurrentWritingTimePartition = concurrentWritingTimePartition;
    }

    public int getConcurrentWritingTimePartition() {
        return this.concurrentWritingTimePartition;
    }

    public int getDefaultFillInterval() {
        return this.defaultFillInterval;
    }

    public void setDefaultFillInterval(int defaultFillInterval) {
        this.defaultFillInterval = defaultFillInterval;
    }

    public boolean isEnablePartition() {
        return this.enablePartition;
    }

    public void setEnablePartition(boolean enablePartition) {
        this.enablePartition = enablePartition;
    }

    public boolean isEnableMTreeSnapshot() {
        return this.enableMTreeSnapshot;
    }

    public void setEnableMTreeSnapshot(boolean enableMTreeSnapshot) {
        this.enableMTreeSnapshot = enableMTreeSnapshot;
    }

    public int getMtreeSnapshotInterval() {
        return this.mtreeSnapshotInterval;
    }

    public void setMtreeSnapshotInterval(int mtreeSnapshotInterval) {
        this.mtreeSnapshotInterval = mtreeSnapshotInterval;
    }

    public int getMtreeSnapshotThresholdTime() {
        return this.mtreeSnapshotThresholdTime;
    }

    public void setMtreeSnapshotThresholdTime(int mtreeSnapshotThresholdTime) {
        this.mtreeSnapshotThresholdTime = mtreeSnapshotThresholdTime;
    }

    public long getPartitionInterval() {
        return this.partitionInterval;
    }

    public void setPartitionInterval(long partitionInterval) {
        this.partitionInterval = partitionInterval;
    }

    public TimeIndexLevel getTimeIndexLevel() {
        return this.timeIndexLevel;
    }

    public void setTimeIndexLevel(String timeIndexLevel) {
        this.timeIndexLevel = TimeIndexLevel.valueOf(timeIndexLevel);
    }

    void updatePath() {
        this.formulateFolders();
        this.confirmMultiDirStrategy();
    }

    private void formulateFolders() {
        this.systemDir = this.addHomeDir(this.systemDir);
        this.schemaDir = this.addHomeDir(this.schemaDir);
        this.syncDir = this.addHomeDir(this.syncDir);
        this.tracingDir = this.addHomeDir(this.tracingDir);
        this.walDir = this.addHomeDir(this.walDir);
        this.indexRootFolder = this.addHomeDir(this.indexRootFolder);
        this.extDir = this.addHomeDir(this.extDir);
        this.udfDir = this.addHomeDir(this.udfDir);
        if (TSFileDescriptor.getInstance().getConfig().getTSFileStorageFs().equals((Object)FSType.HDFS)) {
            String hdfsDir = this.getHdfsDir();
            this.queryDir = hdfsDir + File.separatorChar + this.queryDir;
            for (int i = 0; i < this.dataDirs.length; ++i) {
                this.dataDirs[i] = hdfsDir + File.separatorChar + this.dataDirs[i];
            }
        } else {
            this.queryDir = this.addHomeDir(this.queryDir);
            for (int i = 0; i < this.dataDirs.length; ++i) {
                this.dataDirs[i] = this.addHomeDir(this.dataDirs[i]);
            }
        }
    }

    void reloadDataDirs(String[] dataDirs) throws LoadConfigurationException {
        if (TSFileDescriptor.getInstance().getConfig().getTSFileStorageFs().equals((Object)FSType.HDFS)) {
            String hdfsDir = this.getHdfsDir();
            for (int i = 0; i < dataDirs.length; ++i) {
                dataDirs[i] = hdfsDir + File.separatorChar + dataDirs[i];
            }
        } else {
            for (int i = 0; i < dataDirs.length; ++i) {
                dataDirs[i] = this.addHomeDir(dataDirs[i]);
            }
        }
        this.dataDirs = dataDirs;
        DirectoryManager.getInstance().updateFileFolders();
    }

    private String addHomeDir(String dir) {
        String homeDir = System.getProperty("IOTDB_HOME", null);
        if (!new File(dir).isAbsolute() && homeDir != null && homeDir.length() > 0) {
            dir = !homeDir.endsWith(File.separator) ? homeDir + File.separatorChar + dir : homeDir + dir;
        }
        return dir;
    }

    private void confirmMultiDirStrategy() {
        if (this.getMultiDirStrategyClassName() == null) {
            this.multiDirStrategyClassName = DEFAULT_MULTI_DIR_STRATEGY;
        }
        if (!this.getMultiDirStrategyClassName().contains(".")) {
            this.multiDirStrategyClassName = MULTI_DIR_STRATEGY_PREFIX + this.multiDirStrategyClassName;
        }
        try {
            Class.forName(this.multiDirStrategyClassName);
        }
        catch (ClassNotFoundException e) {
            logger.warn("Cannot find given directory strategy {}, using the default value", (Object)this.getMultiDirStrategyClassName(), (Object)e);
            this.setMultiDirStrategyClassName("org.apache.iotdb.db.conf.directories.strategy.MaxDiskUsableSpaceFirstStrategy");
        }
    }

    private String getHdfsDir() {
        String[] hdfsIps = TSFileDescriptor.getInstance().getConfig().getHdfsIp();
        String hdfsDir = "hdfs://";
        hdfsDir = hdfsIps.length > 1 ? hdfsDir + TSFileDescriptor.getInstance().getConfig().getDfsNameServices() : hdfsDir + hdfsIps[0] + ":" + TSFileDescriptor.getInstance().getConfig().getHdfsPort();
        return hdfsDir;
    }

    public String[] getDataDirs() {
        return this.dataDirs;
    }

    public int getMetricsPort() {
        return this.metricsPort;
    }

    void setMetricsPort(int metricsPort) {
        this.metricsPort = metricsPort;
    }

    public boolean isEnableMetricService() {
        return this.enableMetricService;
    }

    public void setEnableMetricService(boolean enableMetricService) {
        this.enableMetricService = enableMetricService;
    }

    void setDataDirs(String[] dataDirs) {
        this.dataDirs = dataDirs;
    }

    public String getRpcAddress() {
        return this.rpcAddress;
    }

    public void setRpcAddress(String rpcAddress) {
        this.rpcAddress = rpcAddress;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public void setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public String getTimestampPrecision() {
        return this.timestampPrecision;
    }

    public void setTimestampPrecision(String timestampPrecision) {
        if (!(timestampPrecision.equals("ms") || timestampPrecision.equals("us") || timestampPrecision.equals("ns"))) {
            logger.error("Wrong timestamp precision, please set as: ms, us or ns ! Current is: " + timestampPrecision);
            System.exit(-1);
        }
        this.timestampPrecision = timestampPrecision;
    }

    public boolean isEnableWal() {
        return this.enableWal;
    }

    public void setEnableWal(boolean enableWal) {
        this.enableWal = enableWal;
    }

    public boolean isEnableDiscardOutOfOrderData() {
        return this.enableDiscardOutOfOrderData;
    }

    public void setEnableDiscardOutOfOrderData(boolean enableDiscardOutOfOrderData) {
        this.enableDiscardOutOfOrderData = enableDiscardOutOfOrderData;
    }

    public int getFlushWalThreshold() {
        return this.flushWalThreshold;
    }

    public void setFlushWalThreshold(int flushWalThreshold) {
        this.flushWalThreshold = flushWalThreshold;
    }

    public long getForceWalPeriodInMs() {
        return this.forceWalPeriodInMs;
    }

    public void setForceWalPeriodInMs(long forceWalPeriodInMs) {
        this.forceWalPeriodInMs = forceWalPeriodInMs;
    }

    public String getSystemDir() {
        return this.systemDir;
    }

    void setSystemDir(String systemDir) {
        this.systemDir = systemDir;
    }

    public String getSchemaDir() {
        return this.schemaDir;
    }

    public void setSchemaDir(String schemaDir) {
        this.schemaDir = schemaDir;
    }

    public String getSyncDir() {
        return this.syncDir;
    }

    void setSyncDir(String syncDir) {
        this.syncDir = syncDir;
    }

    public String getTracingDir() {
        return this.tracingDir;
    }

    void setTracingDir(String tracingDir) {
        this.tracingDir = tracingDir;
    }

    public String getQueryDir() {
        return this.queryDir;
    }

    void setQueryDir(String queryDir) {
        this.queryDir = queryDir;
    }

    public String getWalDir() {
        return this.walDir;
    }

    void setWalDir(String walDir) {
        this.walDir = walDir;
    }

    public String getExtDir() {
        return this.extDir;
    }

    public void setExtDir(String extDir) {
        this.extDir = extDir;
    }

    public String getUdfDir() {
        return this.udfDir;
    }

    public void setUdfDir(String udfDir) {
        this.udfDir = udfDir;
    }

    public String getMultiDirStrategyClassName() {
        return this.multiDirStrategyClassName;
    }

    void setMultiDirStrategyClassName(String multiDirStrategyClassName) {
        this.multiDirStrategyClassName = multiDirStrategyClassName;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getMaxMemtableNumber() {
        return this.maxMemtableNumber;
    }

    public void setMaxMemtableNumber(int maxMemtableNumber) {
        this.maxMemtableNumber = maxMemtableNumber;
    }

    public int getConcurrentFlushThread() {
        return this.concurrentFlushThread;
    }

    void setConcurrentFlushThread(int concurrentFlushThread) {
        this.concurrentFlushThread = concurrentFlushThread;
    }

    public int getConcurrentQueryThread() {
        return this.concurrentQueryThread;
    }

    void setConcurrentQueryThread(int concurrentQueryThread) {
        this.concurrentQueryThread = concurrentQueryThread;
    }

    public long getSeqTsFileSize() {
        return this.seqTsFileSize;
    }

    public void setSeqTsFileSize(long seqTsFileSize) {
        this.seqTsFileSize = seqTsFileSize;
    }

    public long getUnSeqTsFileSize() {
        return this.unSeqTsFileSize;
    }

    public void setUnSeqTsFileSize(long unSeqTsFileSize) {
        this.unSeqTsFileSize = unSeqTsFileSize;
    }

    public boolean isEnableStatMonitor() {
        return this.enableStatMonitor;
    }

    public void setEnableStatMonitor(boolean enableStatMonitor) {
        this.enableStatMonitor = enableStatMonitor;
    }

    public boolean isEnableMonitorSeriesWrite() {
        return this.enableMonitorSeriesWrite;
    }

    public void setEnableMonitorSeriesWrite(boolean enableMonitorSeriesWrite) {
        this.enableMonitorSeriesWrite = enableMonitorSeriesWrite;
    }

    public int getRpcMaxConcurrentClientNum() {
        return this.rpcMaxConcurrentClientNum;
    }

    void setRpcMaxConcurrentClientNum(int rpcMaxConcurrentClientNum) {
        this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
    }

    public int getmManagerCacheSize() {
        return this.mManagerCacheSize;
    }

    void setmManagerCacheSize(int mManagerCacheSize) {
        this.mManagerCacheSize = mManagerCacheSize;
    }

    public int getmRemoteSchemaCacheSize() {
        return this.mRemoteSchemaCacheSize;
    }

    public void setmRemoteSchemaCacheSize(int mRemoteSchemaCacheSize) {
        this.mRemoteSchemaCacheSize = mRemoteSchemaCacheSize;
    }

    public boolean isSyncEnable() {
        return this.isSyncEnable;
    }

    public void setSyncEnable(boolean syncEnable) {
        this.isSyncEnable = syncEnable;
    }

    public int getSyncServerPort() {
        return this.syncServerPort;
    }

    void setSyncServerPort(int syncServerPort) {
        this.syncServerPort = syncServerPort;
    }

    String getLanguageVersion() {
        return this.languageVersion;
    }

    void setLanguageVersion(String languageVersion) {
        this.languageVersion = languageVersion;
    }

    public String getIoTDBVersion() {
        return IoTDBConstant.VERSION;
    }

    public String getIoTDBMajorVersion() {
        return IoTDBConstant.MAJOR_VERSION;
    }

    public String getIoTDBMajorVersion(String version) {
        return version.equals("UNKNOWN") ? "UNKNOWN" : version.split("\\.")[0] + "." + version.split("\\.")[1];
    }

    public String getIpWhiteList() {
        return this.ipWhiteList;
    }

    public void setIpWhiteList(String ipWhiteList) {
        this.ipWhiteList = ipWhiteList;
    }

    public long getCacheFileReaderClearPeriod() {
        return this.cacheFileReaderClearPeriod;
    }

    public void setCacheFileReaderClearPeriod(long cacheFileReaderClearPeriod) {
        this.cacheFileReaderClearPeriod = cacheFileReaderClearPeriod;
    }

    public int getQueryTimeoutThreshold() {
        return this.queryTimeoutThreshold;
    }

    public void setQueryTimeoutThreshold(int queryTimeoutThreshold) {
        this.queryTimeoutThreshold = queryTimeoutThreshold;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getRpcImplClassName() {
        return this.rpcImplClassName;
    }

    public void setRpcImplClassName(String rpcImplClassName) {
        this.rpcImplClassName = rpcImplClassName;
    }

    public int getWalBufferSize() {
        return this.walBufferSize;
    }

    public void setWalBufferSize(int walBufferSize) {
        this.walBufferSize = walBufferSize;
    }

    public int getMaxWalBytebufferNumForEachPartition() {
        return this.maxWalBytebufferNumForEachPartition;
    }

    public void setMaxWalBytebufferNumForEachPartition(int maxWalBytebufferNumForEachPartition) {
        this.maxWalBytebufferNumForEachPartition = maxWalBytebufferNumForEachPartition;
    }

    public long getWalPoolTrimIntervalInMS() {
        return this.walPoolTrimIntervalInMS;
    }

    public void setWalPoolTrimIntervalInMS(long walPoolTrimIntervalInMS) {
        this.walPoolTrimIntervalInMS = walPoolTrimIntervalInMS;
    }

    public int getEstimatedSeriesSize() {
        return this.estimatedSeriesSize;
    }

    public void setEstimatedSeriesSize(int estimatedSeriesSize) {
        this.estimatedSeriesSize = estimatedSeriesSize;
    }

    public boolean isChunkBufferPoolEnable() {
        return this.chunkBufferPoolEnable;
    }

    void setChunkBufferPoolEnable(boolean chunkBufferPoolEnable) {
        this.chunkBufferPoolEnable = chunkBufferPoolEnable;
    }

    public long getMergeMemoryBudget() {
        return this.mergeMemoryBudget;
    }

    void setMergeMemoryBudget(long mergeMemoryBudget) {
        this.mergeMemoryBudget = mergeMemoryBudget;
    }

    public int getMergeThreadNum() {
        return this.mergeThreadNum;
    }

    void setMergeThreadNum(int mergeThreadNum) {
        this.mergeThreadNum = mergeThreadNum;
    }

    public long getMergeIntervalSec() {
        return this.mergeIntervalSec;
    }

    void setMergeIntervalSec(long mergeIntervalSec) {
        this.mergeIntervalSec = mergeIntervalSec;
    }

    public double getBufferedArraysMemoryProportion() {
        return this.bufferedArraysMemoryProportion;
    }

    public void setBufferedArraysMemoryProportion(double bufferedArraysMemoryProportion) {
        this.bufferedArraysMemoryProportion = bufferedArraysMemoryProportion;
    }

    public double getFlushProportion() {
        return this.flushProportion;
    }

    public void setFlushProportion(double flushProportion) {
        this.flushProportion = flushProportion;
    }

    public double getRejectProportion() {
        return this.rejectProportion;
    }

    public void setRejectProportion(double rejectProportion) {
        this.rejectProportion = rejectProportion;
    }

    public long getStorageGroupSizeReportThreshold() {
        return this.storageGroupSizeReportThreshold;
    }

    public void setStorageGroupSizeReportThreshold(long storageGroupSizeReportThreshold) {
        this.storageGroupSizeReportThreshold = storageGroupSizeReportThreshold;
    }

    public long getAllocateMemoryForWrite() {
        return this.allocateMemoryForWrite;
    }

    public void setAllocateMemoryForWrite(long allocateMemoryForWrite) {
        this.allocateMemoryForWrite = allocateMemoryForWrite;
    }

    public long getAllocateMemoryForSchema() {
        return this.allocateMemoryForSchema;
    }

    void setAllocateMemoryForSchema(long allocateMemoryForSchema) {
        this.allocateMemoryForSchema = allocateMemoryForSchema;
    }

    long getAllocateMemoryForRead() {
        return this.allocateMemoryForRead;
    }

    void setAllocateMemoryForRead(long allocateMemoryForRead) {
        this.allocateMemoryForRead = allocateMemoryForRead;
    }

    public long getAllocateMemoryForReadWithoutCache() {
        return this.allocateMemoryForReadWithoutCache;
    }

    public void setAllocateMemoryForReadWithoutCache(long allocateMemoryForReadWithoutCache) {
        this.allocateMemoryForReadWithoutCache = allocateMemoryForReadWithoutCache;
    }

    public boolean isEnableExternalSort() {
        return this.enableExternalSort;
    }

    void setEnableExternalSort(boolean enableExternalSort) {
        this.enableExternalSort = enableExternalSort;
    }

    public int getExternalSortThreshold() {
        return this.externalSortThreshold;
    }

    void setExternalSortThreshold(int externalSortThreshold) {
        this.externalSortThreshold = externalSortThreshold;
    }

    public boolean isEnablePerformanceStat() {
        return this.enablePerformanceStat;
    }

    public void setEnablePerformanceStat(boolean enablePerformanceStat) {
        this.enablePerformanceStat = enablePerformanceStat;
    }

    public boolean isEnablePerformanceTracing() {
        return this.enablePerformanceTracing;
    }

    public void setEnablePerformanceTracing(boolean enablePerformanceTracing) {
        this.enablePerformanceTracing = enablePerformanceTracing;
    }

    public long getPerformanceStatDisplayInterval() {
        return this.performanceStatDisplayInterval;
    }

    void setPerformanceStatDisplayInterval(long performanceStatDisplayInterval) {
        this.performanceStatDisplayInterval = performanceStatDisplayInterval;
    }

    public int getPerformanceStatMemoryInKB() {
        return this.performanceStatMemoryInKB;
    }

    void setPerformanceStatMemoryInKB(int performanceStatMemoryInKB) {
        this.performanceStatMemoryInKB = performanceStatMemoryInKB;
    }

    public boolean isEnablePartialInsert() {
        return this.enablePartialInsert;
    }

    public void setEnablePartialInsert(boolean enablePartialInsert) {
        this.enablePartialInsert = enablePartialInsert;
    }

    public boolean isForceFullMerge() {
        return this.forceFullMerge;
    }

    void setForceFullMerge(boolean forceFullMerge) {
        this.forceFullMerge = forceFullMerge;
    }

    public int getCompactionThreadNum() {
        return this.compactionThreadNum;
    }

    public void setCompactionThreadNum(int compactionThreadNum) {
        this.compactionThreadNum = compactionThreadNum;
    }

    public int getMergeWriteThroughputMbPerSec() {
        return this.mergeWriteThroughputMbPerSec;
    }

    public void setMergeWriteThroughputMbPerSec(int mergeWriteThroughputMbPerSec) {
        this.mergeWriteThroughputMbPerSec = mergeWriteThroughputMbPerSec;
    }

    public long getCompactionInterval() {
        return this.compactionInterval;
    }

    public void setCompactionInterval(long compactionInterval) {
        this.compactionInterval = compactionInterval;
    }

    public boolean isEnableMemControl() {
        return this.enableMemControl;
    }

    public void setEnableMemControl(boolean enableMemControl) {
        this.enableMemControl = enableMemControl;
    }

    public long getMemtableSizeThreshold() {
        return this.memtableSizeThreshold;
    }

    public void setMemtableSizeThreshold(long memtableSizeThreshold) {
        this.memtableSizeThreshold = memtableSizeThreshold;
    }

    public boolean isEnableTimedFlushSeqMemtable() {
        return this.enableTimedFlushSeqMemtable;
    }

    public void setEnableTimedFlushSeqMemtable(boolean enableTimedFlushSeqMemtable) {
        this.enableTimedFlushSeqMemtable = enableTimedFlushSeqMemtable;
    }

    public long getSeqMemtableFlushInterval() {
        return this.seqMemtableFlushInterval;
    }

    public void setSeqMemtableFlushInterval(long seqMemtableFlushInterval) {
        this.seqMemtableFlushInterval = seqMemtableFlushInterval;
    }

    public long getSeqMemtableFlushCheckInterval() {
        return this.seqMemtableFlushCheckInterval;
    }

    public void setSeqMemtableFlushCheckInterval(long seqMemtableFlushCheckInterval) {
        this.seqMemtableFlushCheckInterval = seqMemtableFlushCheckInterval;
    }

    public boolean isEnableTimedFlushUnseqMemtable() {
        return this.enableTimedFlushUnseqMemtable;
    }

    public void setEnableTimedFlushUnseqMemtable(boolean enableTimedFlushUnseqMemtable) {
        this.enableTimedFlushUnseqMemtable = enableTimedFlushUnseqMemtable;
    }

    public long getUnseqMemtableFlushInterval() {
        return this.unseqMemtableFlushInterval;
    }

    public void setUnseqMemtableFlushInterval(long unseqMemtableFlushInterval) {
        this.unseqMemtableFlushInterval = unseqMemtableFlushInterval;
    }

    public long getUnseqMemtableFlushCheckInterval() {
        return this.unseqMemtableFlushCheckInterval;
    }

    public void setUnseqMemtableFlushCheckInterval(long unseqMemtableFlushCheckInterval) {
        this.unseqMemtableFlushCheckInterval = unseqMemtableFlushCheckInterval;
    }

    public boolean isEnableTimedCloseTsFile() {
        return this.enableTimedCloseTsFile;
    }

    public void setEnableTimedCloseTsFile(boolean enableTimedCloseTsFile) {
        this.enableTimedCloseTsFile = enableTimedCloseTsFile;
    }

    public long getCloseTsFileIntervalAfterFlushing() {
        return this.closeTsFileIntervalAfterFlushing;
    }

    public void setCloseTsFileIntervalAfterFlushing(long closeTsFileIntervalAfterFlushing) {
        this.closeTsFileIntervalAfterFlushing = closeTsFileIntervalAfterFlushing;
    }

    public long getCloseTsFileCheckInterval() {
        return this.closeTsFileCheckInterval;
    }

    public void setCloseTsFileCheckInterval(long closeTsFileCheckInterval) {
        this.closeTsFileCheckInterval = closeTsFileCheckInterval;
    }

    public int getAvgSeriesPointNumberThreshold() {
        return this.avgSeriesPointNumberThreshold;
    }

    public void setAvgSeriesPointNumberThreshold(int avgSeriesPointNumberThreshold) {
        this.avgSeriesPointNumberThreshold = avgSeriesPointNumberThreshold;
    }

    public int getMergeChunkPointNumberThreshold() {
        return this.mergeChunkPointNumberThreshold;
    }

    public void setMergeChunkPointNumberThreshold(int mergeChunkPointNumberThreshold) {
        this.mergeChunkPointNumberThreshold = mergeChunkPointNumberThreshold;
    }

    public int getMergePagePointNumberThreshold() {
        return this.mergePagePointNumberThreshold;
    }

    public void setMergePagePointNumberThreshold(int mergePagePointNumberThreshold) {
        this.mergePagePointNumberThreshold = mergePagePointNumberThreshold;
    }

    public MergeFileStrategy getMergeFileStrategy() {
        return this.mergeFileStrategy;
    }

    public void setMergeFileStrategy(MergeFileStrategy mergeFileStrategy) {
        this.mergeFileStrategy = mergeFileStrategy;
    }

    public CompactionStrategy getCompactionStrategy() {
        return this.compactionStrategy;
    }

    public void setCompactionStrategy(CompactionStrategy compactionStrategy) {
        this.compactionStrategy = compactionStrategy;
    }

    public boolean isEnableUnseqCompaction() {
        return this.enableUnseqCompaction;
    }

    public void setEnableUnseqCompaction(boolean enableUnseqCompaction) {
        this.enableUnseqCompaction = enableUnseqCompaction;
    }

    public boolean isEnableContinuousCompaction() {
        return this.enableContinuousCompaction;
    }

    public void setEnableContinuousCompaction(boolean enableContinuousCompaction) {
        this.enableContinuousCompaction = enableContinuousCompaction;
    }

    public int getSeqFileNumInEachLevel() {
        return this.seqFileNumInEachLevel;
    }

    public void setSeqFileNumInEachLevel(int seqFileNumInEachLevel) {
        this.seqFileNumInEachLevel = seqFileNumInEachLevel;
    }

    public int getSeqLevelNum() {
        return this.seqLevelNum;
    }

    public void setSeqLevelNum(int seqLevelNum) {
        this.seqLevelNum = seqLevelNum;
    }

    public int getUnseqFileNumInEachLevel() {
        return this.unseqFileNumInEachLevel;
    }

    public void setUnseqFileNumInEachLevel(int unseqFileNumInEachLevel) {
        this.unseqFileNumInEachLevel = unseqFileNumInEachLevel;
    }

    public int getUnseqLevelNum() {
        return this.unseqLevelNum;
    }

    public void setUnseqLevelNum(int unseqLevelNum) {
        this.unseqLevelNum = unseqLevelNum;
    }

    public int getMaxSelectUnseqFileNumInEachUnseqCompaction() {
        return this.maxSelectUnseqFileNumInEachUnseqCompaction;
    }

    public void setMaxSelectUnseqFileNumInEachUnseqCompaction(int maxSelectUnseqFileNumInEachUnseqCompaction) {
        this.maxSelectUnseqFileNumInEachUnseqCompaction = maxSelectUnseqFileNumInEachUnseqCompaction;
    }

    public int getMergeChunkSubThreadNum() {
        return this.mergeChunkSubThreadNum;
    }

    void setMergeChunkSubThreadNum(int mergeChunkSubThreadNum) {
        this.mergeChunkSubThreadNum = mergeChunkSubThreadNum;
    }

    public long getMergeFileSelectionTimeBudget() {
        return this.mergeFileSelectionTimeBudget;
    }

    void setMergeFileSelectionTimeBudget(long mergeFileSelectionTimeBudget) {
        this.mergeFileSelectionTimeBudget = mergeFileSelectionTimeBudget;
    }

    public boolean isRpcThriftCompressionEnable() {
        return this.rpcThriftCompressionEnable;
    }

    public void setRpcThriftCompressionEnable(boolean rpcThriftCompressionEnable) {
        this.rpcThriftCompressionEnable = rpcThriftCompressionEnable;
    }

    public boolean isMetaDataCacheEnable() {
        return this.metaDataCacheEnable;
    }

    public void setMetaDataCacheEnable(boolean metaDataCacheEnable) {
        this.metaDataCacheEnable = metaDataCacheEnable;
    }

    public long getAllocateMemoryForTimeSeriesMetaDataCache() {
        return this.allocateMemoryForTimeSeriesMetaDataCache;
    }

    public void setAllocateMemoryForTimeSeriesMetaDataCache(long allocateMemoryForTimeSeriesMetaDataCache) {
        this.allocateMemoryForTimeSeriesMetaDataCache = allocateMemoryForTimeSeriesMetaDataCache;
    }

    public long getAllocateMemoryForChunkCache() {
        return this.allocateMemoryForChunkCache;
    }

    public void setAllocateMemoryForChunkCache(long allocateMemoryForChunkCache) {
        this.allocateMemoryForChunkCache = allocateMemoryForChunkCache;
    }

    public boolean isLastCacheEnabled() {
        return this.lastCacheEnable;
    }

    public void setEnableLastCache(boolean lastCacheEnable) {
        this.lastCacheEnable = lastCacheEnable;
    }

    public boolean isEnableWatermark() {
        return this.enableWatermark;
    }

    public void setEnableWatermark(boolean enableWatermark) {
        this.enableWatermark = enableWatermark;
    }

    public String getWatermarkSecretKey() {
        return this.watermarkSecretKey;
    }

    public void setWatermarkSecretKey(String watermarkSecretKey) {
        this.watermarkSecretKey = watermarkSecretKey;
    }

    public String getWatermarkBitString() {
        return this.watermarkBitString;
    }

    public void setWatermarkBitString(String watermarkBitString) {
        this.watermarkBitString = watermarkBitString;
    }

    String getWatermarkMethod() {
        return this.watermarkMethod;
    }

    public void setWatermarkMethod(String watermarkMethod) {
        this.watermarkMethod = watermarkMethod;
    }

    public String getWatermarkMethodName() {
        return this.watermarkMethod.split("\\(")[0];
    }

    public int getWatermarkParamMarkRate() {
        return Integer.parseInt(this.getWatermarkParamValue("embed_row_cycle", "5"));
    }

    public int getWatermarkParamMaxRightBit() {
        return Integer.parseInt(this.getWatermarkParamValue("embed_lsb_num", "5"));
    }

    private String getWatermarkParamValue(String key, String defaultValue) {
        String res = this.getWatermarkParamValue(key);
        if (res != null) {
            return res;
        }
        return defaultValue;
    }

    private String getWatermarkParamValue(String key) {
        String pattern = key + "=(\\w*)";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(this.watermarkMethod);
        if (m.find() && m.groupCount() > 0) {
            return m.group(1);
        }
        return null;
    }

    public boolean isAutoCreateSchemaEnabled() {
        return this.enableAutoCreateSchema;
    }

    public void setAutoCreateSchemaEnabled(boolean enableAutoCreateSchema) {
        this.enableAutoCreateSchema = enableAutoCreateSchema;
    }

    public TSDataType getBooleanStringInferType() {
        return this.booleanStringInferType;
    }

    public void setBooleanStringInferType(TSDataType booleanStringInferType) {
        this.booleanStringInferType = booleanStringInferType;
    }

    public TSDataType getIntegerStringInferType() {
        return this.integerStringInferType;
    }

    public void setIntegerStringInferType(TSDataType integerStringInferType) {
        this.integerStringInferType = integerStringInferType;
    }

    public void setLongStringInferType(TSDataType longStringInferType) {
        this.longStringInferType = longStringInferType;
    }

    public TSDataType getLongStringInferType() {
        return this.longStringInferType;
    }

    public TSDataType getFloatingStringInferType() {
        return this.floatingStringInferType;
    }

    public void setFloatingStringInferType(TSDataType floatingNumberStringInferType) {
        this.floatingStringInferType = floatingNumberStringInferType;
    }

    public TSDataType getNanStringInferType() {
        return this.nanStringInferType;
    }

    public void setNanStringInferType(TSDataType nanStringInferType) {
        if (nanStringInferType != TSDataType.DOUBLE && nanStringInferType != TSDataType.FLOAT && nanStringInferType != TSDataType.TEXT) {
            throw new IllegalArgumentException("Config Property nan_string_infer_type can only be FLOAT, DOUBLE or TEXT but is " + nanStringInferType);
        }
        this.nanStringInferType = nanStringInferType;
    }

    public int getDefaultStorageGroupLevel() {
        return this.defaultStorageGroupLevel;
    }

    void setDefaultStorageGroupLevel(int defaultStorageGroupLevel) {
        this.defaultStorageGroupLevel = defaultStorageGroupLevel;
    }

    public TSEncoding getDefaultBooleanEncoding() {
        return this.defaultBooleanEncoding;
    }

    public void setDefaultBooleanEncoding(TSEncoding defaultBooleanEncoding) {
        this.defaultBooleanEncoding = defaultBooleanEncoding;
    }

    void setDefaultBooleanEncoding(String defaultBooleanEncoding) {
        this.defaultBooleanEncoding = TSEncoding.valueOf((String)defaultBooleanEncoding);
    }

    public TSEncoding getDefaultInt32Encoding() {
        return this.defaultInt32Encoding;
    }

    public void setDefaultInt32Encoding(TSEncoding defaultInt32Encoding) {
        this.defaultInt32Encoding = defaultInt32Encoding;
    }

    void setDefaultInt32Encoding(String defaultInt32Encoding) {
        this.defaultInt32Encoding = TSEncoding.valueOf((String)defaultInt32Encoding);
    }

    public TSEncoding getDefaultInt64Encoding() {
        return this.defaultInt64Encoding;
    }

    public void setDefaultInt64Encoding(TSEncoding defaultInt64Encoding) {
        this.defaultInt64Encoding = defaultInt64Encoding;
    }

    void setDefaultInt64Encoding(String defaultInt64Encoding) {
        this.defaultInt64Encoding = TSEncoding.valueOf((String)defaultInt64Encoding);
    }

    public TSEncoding getDefaultFloatEncoding() {
        return this.defaultFloatEncoding;
    }

    public void setDefaultFloatEncoding(TSEncoding defaultFloatEncoding) {
        this.defaultFloatEncoding = defaultFloatEncoding;
    }

    void setDefaultFloatEncoding(String defaultFloatEncoding) {
        this.defaultFloatEncoding = TSEncoding.valueOf((String)defaultFloatEncoding);
    }

    public TSEncoding getDefaultDoubleEncoding() {
        return this.defaultDoubleEncoding;
    }

    public void setDefaultDoubleEncoding(TSEncoding defaultDoubleEncoding) {
        this.defaultDoubleEncoding = defaultDoubleEncoding;
    }

    void setDefaultDoubleEncoding(String defaultDoubleEncoding) {
        this.defaultDoubleEncoding = TSEncoding.valueOf((String)defaultDoubleEncoding);
    }

    public TSEncoding getDefaultTextEncoding() {
        return this.defaultTextEncoding;
    }

    public void setDefaultTextEncoding(TSEncoding defaultTextEncoding) {
        this.defaultTextEncoding = defaultTextEncoding;
    }

    void setDefaultTextEncoding(String defaultTextEncoding) {
        this.defaultTextEncoding = TSEncoding.valueOf((String)defaultTextEncoding);
    }

    public FSType getSystemFileStorageFs() {
        return this.systemFileStorageFs;
    }

    public void setSystemFileStorageFs(String systemFileStorageFs) {
        this.systemFileStorageFs = FSType.valueOf((String)systemFileStorageFs);
    }

    FSType getTsFileStorageFs() {
        return this.tsFileStorageFs;
    }

    void setTsFileStorageFs(String tsFileStorageFs) {
        this.tsFileStorageFs = FSType.valueOf((String)tsFileStorageFs);
    }

    String getCoreSitePath() {
        return this.coreSitePath;
    }

    void setCoreSitePath(String coreSitePath) {
        this.coreSitePath = coreSitePath;
    }

    String getHdfsSitePath() {
        return this.hdfsSitePath;
    }

    void setHdfsSitePath(String hdfsSitePath) {
        this.hdfsSitePath = hdfsSitePath;
    }

    public String[] getHdfsIp() {
        return this.hdfsIp.split(",");
    }

    String getRawHDFSIp() {
        return this.hdfsIp;
    }

    void setHdfsIp(String[] hdfsIp) {
        this.hdfsIp = String.join((CharSequence)",", hdfsIp);
    }

    String getHdfsPort() {
        return this.hdfsPort;
    }

    void setHdfsPort(String hdfsPort) {
        this.hdfsPort = hdfsPort;
    }

    public int getUpgradeThreadNum() {
        return this.upgradeThreadNum;
    }

    void setUpgradeThreadNum(int upgradeThreadNum) {
        this.upgradeThreadNum = upgradeThreadNum;
    }

    String getDfsNameServices() {
        return this.dfsNameServices;
    }

    void setDfsNameServices(String dfsNameServices) {
        this.dfsNameServices = dfsNameServices;
    }

    public String[] getDfsHaNamenodes() {
        return this.dfsHaNamenodes.split(",");
    }

    String getRawDfsHaNamenodes() {
        return this.dfsHaNamenodes;
    }

    void setDfsHaNamenodes(String[] dfsHaNamenodes) {
        this.dfsHaNamenodes = String.join((CharSequence)",", dfsHaNamenodes);
    }

    boolean isDfsHaAutomaticFailoverEnabled() {
        return this.dfsHaAutomaticFailoverEnabled;
    }

    void setDfsHaAutomaticFailoverEnabled(boolean dfsHaAutomaticFailoverEnabled) {
        this.dfsHaAutomaticFailoverEnabled = dfsHaAutomaticFailoverEnabled;
    }

    String getDfsClientFailoverProxyProvider() {
        return this.dfsClientFailoverProxyProvider;
    }

    void setDfsClientFailoverProxyProvider(String dfsClientFailoverProxyProvider) {
        this.dfsClientFailoverProxyProvider = dfsClientFailoverProxyProvider;
    }

    boolean isUseKerberos() {
        return this.useKerberos;
    }

    void setUseKerberos(boolean useKerberos) {
        this.useKerberos = useKerberos;
    }

    String getKerberosKeytabFilePath() {
        return this.kerberosKeytabFilePath;
    }

    void setKerberosKeytabFilePath(String kerberosKeytabFilePath) {
        this.kerberosKeytabFilePath = kerberosKeytabFilePath;
    }

    String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    void setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
    }

    public long getDefaultTTL() {
        return this.defaultTTL;
    }

    public void setDefaultTTL(long defaultTTL) {
        this.defaultTTL = defaultTTL;
    }

    public int getThriftServerAwaitTimeForStopService() {
        return this.thriftServerAwaitTimeForStopService;
    }

    public void setThriftServerAwaitTimeForStopService(int thriftServerAwaitTimeForStopService) {
        this.thriftServerAwaitTimeForStopService = thriftServerAwaitTimeForStopService;
    }

    public int getQueryCacheSizeInMetric() {
        return this.queryCacheSizeInMetric;
    }

    public void setQueryCacheSizeInMetric(int queryCacheSizeInMetric) {
        this.queryCacheSizeInMetric = queryCacheSizeInMetric;
    }

    public boolean isEnableMQTTService() {
        return this.enableMQTTService;
    }

    public void setEnableMQTTService(boolean enableMQTTService) {
        this.enableMQTTService = enableMQTTService;
    }

    public String getMqttHost() {
        return this.mqttHost;
    }

    public void setMqttHost(String mqttHost) {
        this.mqttHost = mqttHost;
    }

    public int getMqttPort() {
        return this.mqttPort;
    }

    public void setMqttPort(int mqttPort) {
        this.mqttPort = mqttPort;
    }

    public int getMqttHandlerPoolSize() {
        return this.mqttHandlerPoolSize;
    }

    public void setMqttHandlerPoolSize(int mqttHandlerPoolSize) {
        this.mqttHandlerPoolSize = mqttHandlerPoolSize;
    }

    public String getMqttPayloadFormatter() {
        return this.mqttPayloadFormatter;
    }

    public void setMqttPayloadFormatter(String mqttPayloadFormatter) {
        this.mqttPayloadFormatter = mqttPayloadFormatter;
    }

    public int getMqttMaxMessageSize() {
        return this.mqttMaxMessageSize;
    }

    public void setMqttMaxMessageSize(int mqttMaxMessageSize) {
        this.mqttMaxMessageSize = mqttMaxMessageSize;
    }

    public int getTagAttributeTotalSize() {
        return this.tagAttributeTotalSize;
    }

    public void setTagAttributeTotalSize(int tagAttributeTotalSize) {
        this.tagAttributeTotalSize = tagAttributeTotalSize;
    }

    public int getTagAttributeFlushInterval() {
        return this.tagAttributeFlushInterval;
    }

    public void setTagAttributeFlushInterval(int tagAttributeFlushInterval) {
        this.tagAttributeFlushInterval = tagAttributeFlushInterval;
    }

    public int getPrimitiveArraySize() {
        return this.primitiveArraySize;
    }

    public void setPrimitiveArraySize(int primitiveArraySize) {
        this.primitiveArraySize = primitiveArraySize;
    }

    public String getOpenIdProviderUrl() {
        return this.openIdProviderUrl;
    }

    public void setOpenIdProviderUrl(String openIdProviderUrl) {
        this.openIdProviderUrl = openIdProviderUrl;
    }

    public String getAuthorizerProvider() {
        return this.authorizerProvider;
    }

    public void setAuthorizerProvider(String authorizerProvider) {
        this.authorizerProvider = authorizerProvider;
    }

    public long getStartUpNanosecond() {
        return this.startUpNanosecond;
    }

    public int getThriftMaxFrameSize() {
        return this.thriftMaxFrameSize;
    }

    public void setThriftMaxFrameSize(int thriftMaxFrameSize) {
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        RpcTransportFactory.setThriftMaxFrameSize((int)this.thriftMaxFrameSize);
    }

    public int getThriftDefaultBufferSize() {
        return this.thriftDefaultBufferSize;
    }

    public void setThriftDefaultBufferSize(int thriftDefaultBufferSize) {
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        RpcTransportFactory.setDefaultBufferCapacity((int)this.thriftDefaultBufferSize);
    }

    public int getMaxQueryDeduplicatedPathNum() {
        return this.maxQueryDeduplicatedPathNum;
    }

    public void setMaxQueryDeduplicatedPathNum(int maxQueryDeduplicatedPathNum) {
        this.maxQueryDeduplicatedPathNum = maxQueryDeduplicatedPathNum;
    }

    public int getCheckPeriodWhenInsertBlocked() {
        return this.checkPeriodWhenInsertBlocked;
    }

    public void setCheckPeriodWhenInsertBlocked(int checkPeriodWhenInsertBlocked) {
        this.checkPeriodWhenInsertBlocked = checkPeriodWhenInsertBlocked;
    }

    public int getMaxWaitingTimeWhenInsertBlocked() {
        return this.maxWaitingTimeWhenInsertBlockedInMs;
    }

    public void setMaxWaitingTimeWhenInsertBlocked(int maxWaitingTimeWhenInsertBlocked) {
        this.maxWaitingTimeWhenInsertBlockedInMs = maxWaitingTimeWhenInsertBlocked;
    }

    public int getFrequencyIntervalInMinute() {
        return this.frequencyIntervalInMinute;
    }

    public void setFrequencyIntervalInMinute(int frequencyIntervalInMinute) {
        this.frequencyIntervalInMinute = frequencyIntervalInMinute;
    }

    public long getSlowQueryThreshold() {
        return this.slowQueryThreshold;
    }

    public void setSlowQueryThreshold(long slowQueryThreshold) {
        this.slowQueryThreshold = slowQueryThreshold;
    }

    public boolean isEnableIndex() {
        return this.enableIndex;
    }

    public void setEnableIndex(boolean enableIndex) {
        this.enableIndex = enableIndex;
    }

    void setConcurrentIndexBuildThread(int concurrentIndexBuildThread) {
        this.concurrentIndexBuildThread = concurrentIndexBuildThread;
    }

    public int getConcurrentIndexBuildThread() {
        return this.concurrentIndexBuildThread;
    }

    public long getIndexBufferSize() {
        return this.indexBufferSize;
    }

    public void setIndexBufferSize(long indexBufferSize) {
        this.indexBufferSize = indexBufferSize;
    }

    public String getIndexRootFolder() {
        return this.indexRootFolder;
    }

    public void setIndexRootFolder(String indexRootFolder) {
        this.indexRootFolder = indexRootFolder;
    }

    public int getDefaultIndexWindowRange() {
        return this.defaultIndexWindowRange;
    }

    public void setDefaultIndexWindowRange(int defaultIndexWindowRange) {
        this.defaultIndexWindowRange = defaultIndexWindowRange;
    }

    public int getVirtualStorageGroupNum() {
        return this.virtualStorageGroupNum;
    }

    public void setVirtualStorageGroupNum(int virtualStorageGroupNum) {
        this.virtualStorageGroupNum = virtualStorageGroupNum;
    }

    public boolean isRpcAdvancedCompressionEnable() {
        return this.rpcAdvancedCompressionEnable;
    }

    public void setRpcAdvancedCompressionEnable(boolean rpcAdvancedCompressionEnable) {
        this.rpcAdvancedCompressionEnable = rpcAdvancedCompressionEnable;
        RpcTransportFactory.setUseSnappy((boolean)this.rpcAdvancedCompressionEnable);
    }

    public int getMlogBufferSize() {
        return this.mlogBufferSize;
    }

    public void setMlogBufferSize(int mlogBufferSize) {
        this.mlogBufferSize = mlogBufferSize;
    }

    public boolean isEnableRpcService() {
        return this.enableRpcService;
    }

    public void setEnableRpcService(boolean enableRpcService) {
        this.enableRpcService = enableRpcService;
    }

    public int getIoTaskQueueSizeForFlushing() {
        return this.ioTaskQueueSizeForFlushing;
    }

    public void setIoTaskQueueSizeForFlushing(int ioTaskQueueSizeForFlushing) {
        this.ioTaskQueueSizeForFlushing = ioTaskQueueSizeForFlushing;
    }

    public String getAdminName() {
        return this.adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }
}

