<!--

    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at
    
        http://www.apache.org/licenses/LICENSE-2.0
    
    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.

-->

## 获取IoTDB的途径

IoTDB为您提供了两种安装方式，您可以参考下面的建议，任选其中一种：

第一种，从官网下载安装包。这是我们推荐使用的安装方式，通过该方式，您将得到一个可以立即使用的、打包好的二进制可执行文件。

第二种，使用源码编译。若您需要自行修改代码，可以使用该安装方式。

### 安装环境要求

安装前请保证您的电脑上配有JDK>=1.8的运行环境，并配置好JAVA_HOME环境变量。

如果您需要从源码进行编译，还需要安装：

1. Maven >= 3.6 的运行环境，具体安装方法可以参考以下链接：[https://maven.apache.org/install.html](https://maven.apache.org/install.html)。

> 注： 也可以选择不安装，使用我们提供的'mvnw.sh' 或 'mvnw.cmd' 工具。使用时请用'mvnw.sh' 或 'mvnw.cmd'命令代替下文的'mvn'命令。

### 从官网下载二进制可执行文件

您可以从[http://iotdb.apache.org/Download/](http://iotdb.apache.org/Download/) 上下载已经编译好的可执行程序iotdb-xxx.zip，该压缩包包含了IoTDB系统运行所需的所有必要组件。


下载后，您可使用以下操作对IoTDB的压缩包进行解压: 

```
Shell > uzip iotdb-<version>.zip
```


### 使用源码编译

您可以获取已发布的源码[https://iotdb.apache.org/Download/](https://iotdb.apache.org/Download/) ，或者从[https://github.com/apache/iotdb/tree/master](https://github.com/apache/iotdb/tree/master) git仓库获取

源码克隆后，进入到源码文件夹目录下，使用以下命令进行编译：

```
> mvn clean package -pl server -am -Dmaven.test.skip=true
```

编译后，IoTDB 服务器会在 "server/target/iotdb-server-{project.version}" 文件夹下，包含以下内容：

```
+- sbin/       <-- script files
|
+- conf/      <-- configuration files
|
+- lib/       <-- project dependencies
|
+- tools/      <-- system tools
```

### 通过Docker安装 (Dockerfile)

Apache IoTDB的Docker镜像已经上传至 [https://hub.docker.com/r/apache/iotdb](https://hub.docker.com/r/apache/iotdb)，
使用`docker pull apache/iotdb:latest`即可获取最新的docker镜像。

用户也可以根据代码提供的Dockerfile文件来自己生成镜像。
Dockerfile 存放在的 docker 工程下的 src/main/Dockerfile 中.

1. 您可以使用下面的命令构建 docker image:

```shell
$ docker build -t iotdb:base git://github.com/apache/iotdb#master:docker
```
或者:

```shell
$ git clone https://github.com/apache/iotdb
$ cd iotdb
$ mvn package -DskipTests
$ cd docker
$ docker build -t iotdb:base .
```
当 docker image 在本地构建完成当时候 (示例中的 tag为 iotdb:base)，已经距完成只有一步之遥了!

2. 创建数据文件和日志的 docker 挂载目录(docker volume):
```
$ docker volume create mydata
$ docker volume create mylogs
```
3. 运行 docker container:

```shell
$ docker run -p 6667:6667 -v mydata:/iotdb/data -v mylogs:/iotdb/logs -d iotdb:base /iotdb/bin/start-server.sh
```
您可以使用`docker ps`来检查是否运行成功，当成功时控制台会输出下面的日志:
```
CONTAINER ID        IMAGE               COMMAND                  CREATED             STATUS              PORTS                               NAMES
2a68b6944cb5        iotdb:base          "/iotdb/bin/start-se…"   4 minutes ago       Up 5 minutes        0.0.0.0:6667->6667/tcp              laughing_meitner
```
您可以使用下面的命令来获取 container 的 ID:

```shell
$ docker container ls
```
假设这个 ID 为 <C_ID>.

然后使用下面的命令获取这个 ID 对应的 IP 地址:

```shell
$ docker inspect --format='{{.NetworkSettings.IPAddress}}' <C_ID>
```
假设获取的 IP 为 <C_IP>.

4. 如果您想尝试使用 iotdb-cli 命令行, 您可以使用如下命令:

```shell
$ docker exec -it /bin/bash  <C_ID>
$ (now you have enter the container): /cli/sbin/start-cli.sh -h localhost -p 6667 -u root -pw root
```

或者运行一个新的 client docker container，命令如下:

```shell
$ docker run -it iotdb:base /cli/sbin/start-cli.sh -h <C_IP> -p 6667 -u root -pw root
```
还可以使用本地的 iotdb-cli (比如：您已经使用`mvn package`编译过源码), 假设您的 work_dir 是 cli/bin, 那么您可以直接运行:

```shell
$ start-cli.sh -h localhost -p 6667 -u root -pw root
```
5. 如果您想写一些代码来插入或者查询数据，您可以在 pom.xml 文件中加入下面的依赖:

```xml
        <dependency>
            <groupId>org.apache.iotdb</groupId>
            <artifactId>iotdb-jdbc</artifactId>
            <version>0.10.0</version>
        </dependency>
```
这里是一些使用 IoTDB-JDBC 连接 IoTDB 的示例: https://github.com/apache/iotdb/tree/master/example/jdbc/src/main/java/org/apache/iotdb

6. 现在已经大功告成了


