/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader.series;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IBatchReader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;

public abstract class AbstractFileSeriesReader
implements IBatchReader {
    protected IChunkLoader chunkLoader;
    protected List<ChunkMetadata> chunkMetadataList;
    protected ChunkReader chunkReader;
    private int chunkToRead;
    protected Filter filter;

    public AbstractFileSeriesReader(IChunkLoader chunkLoader, List<ChunkMetadata> chunkMetadataList, Filter filter) {
        this.chunkLoader = chunkLoader;
        this.chunkMetadataList = chunkMetadataList;
        this.filter = filter;
        this.chunkToRead = 0;
    }

    @Override
    public boolean hasNextBatch() throws IOException {
        if (this.chunkReader != null && this.chunkReader.hasNextSatisfiedPage()) {
            return true;
        }
        while (this.chunkToRead < this.chunkMetadataList.size()) {
            ChunkMetadata chunkMetaData = this.nextChunkMeta();
            if (!this.chunkSatisfied(chunkMetaData)) continue;
            this.initChunkReader(chunkMetaData);
            if (!this.chunkReader.hasNextSatisfiedPage()) continue;
            return true;
        }
        return false;
    }

    @Override
    public BatchData nextBatch() throws IOException {
        return this.chunkReader.nextPageData();
    }

    protected abstract void initChunkReader(ChunkMetadata var1) throws IOException;

    protected abstract boolean chunkSatisfied(ChunkMetadata var1);

    @Override
    public void close() throws IOException {
        this.chunkLoader.close();
    }

    private ChunkMetadata nextChunkMeta() {
        return this.chunkMetadataList.get(this.chunkToRead++);
    }
}

