/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.transformer;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.udf.core.reader.LayerPointReader;
import org.apache.iotdb.db.query.udf.core.transformer.Transformer;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class RawQueryPointTransformer
extends Transformer {
    private final LayerPointReader layerPointReader;

    public RawQueryPointTransformer(LayerPointReader layerPointReader) {
        this.layerPointReader = layerPointReader;
    }

    @Override
    protected boolean cacheValue() throws QueryProcessException, IOException {
        if (!this.layerPointReader.next()) {
            return false;
        }
        this.cachedTime = this.layerPointReader.currentTime();
        switch (this.layerPointReader.getDataType()) {
            case INT32: {
                this.cachedInt = this.layerPointReader.currentInt();
                break;
            }
            case INT64: {
                this.cachedLong = this.layerPointReader.currentLong();
                break;
            }
            case FLOAT: {
                this.cachedFloat = this.layerPointReader.currentFloat();
                break;
            }
            case DOUBLE: {
                this.cachedDouble = this.layerPointReader.currentDouble();
                break;
            }
            case BOOLEAN: {
                this.cachedBoolean = this.layerPointReader.currentBoolean();
                break;
            }
            case TEXT: {
                this.cachedBinary = this.layerPointReader.currentBinary();
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(this.layerPointReader.toString());
            }
        }
        this.layerPointReader.readyForNext();
        return true;
    }

    @Override
    public TSDataType getDataType() {
        return this.layerPointReader.getDataType();
    }
}

