/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.access;

import java.io.IOException;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.access.RowIterator;
import org.apache.iotdb.db.query.udf.api.access.RowWindow;
import org.apache.iotdb.db.query.udf.core.access.RowImpl;
import org.apache.iotdb.db.query.udf.core.access.RowIteratorImpl;
import org.apache.iotdb.db.query.udf.datastructure.primitive.IntList;
import org.apache.iotdb.db.query.udf.datastructure.row.ElasticSerializableRowRecordList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class RowWindowImpl
implements RowWindow {
    private final ElasticSerializableRowRecordList rowRecordList;
    private final int[] columnIndexes;
    private final TSDataType[] dataTypes;
    private final IntList windowRowIndexes;
    private final RowImpl row;
    private final RowIteratorImpl rowIterator;

    public RowWindowImpl(ElasticSerializableRowRecordList rowRecordList, int[] columnIndexes, TSDataType[] dataTypes, IntList windowRowIndexes) {
        this.rowRecordList = rowRecordList;
        this.columnIndexes = columnIndexes;
        this.dataTypes = dataTypes;
        this.windowRowIndexes = windowRowIndexes;
        this.row = new RowImpl(columnIndexes, dataTypes);
        this.rowIterator = new RowIteratorImpl(rowRecordList, columnIndexes, dataTypes, windowRowIndexes);
    }

    @Override
    public int windowSize() {
        return this.windowRowIndexes.size();
    }

    @Override
    public Row getRow(int rowIndex) throws IOException {
        if (rowIndex < 0 || this.windowRowIndexes.size() <= rowIndex) {
            throw new ArrayIndexOutOfBoundsException(String.format("Array index(%d) out of range [%d, %d).", rowIndex, 0, this.windowRowIndexes.size()));
        }
        return this.row.setRowRecord(this.rowRecordList.getRowRecord(this.windowRowIndexes.get(rowIndex)));
    }

    @Override
    public TSDataType getDataType(int columnIndex) {
        return this.dataTypes[this.columnIndexes[columnIndex]];
    }

    @Override
    public RowIterator getRowIterator() {
        this.rowIterator.reset();
        return this.rowIterator;
    }
}

