/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.access;

import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;

public class RowImpl
implements Row {
    private final int[] columnIndexes;
    private final TSDataType[] dataTypes;
    private Object[] rowRecord;

    public RowImpl(int[] columnIndexes, TSDataType[] dataTypes) {
        this.columnIndexes = columnIndexes;
        this.dataTypes = dataTypes;
    }

    @Override
    public long getTime() {
        return (Long)this.rowRecord[this.rowRecord.length - 1];
    }

    @Override
    public int getInt(int columnIndex) {
        return (Integer)this.rowRecord[this.columnIndexes[columnIndex]];
    }

    @Override
    public long getLong(int columnIndex) {
        return (Long)this.rowRecord[this.columnIndexes[columnIndex]];
    }

    @Override
    public float getFloat(int columnIndex) {
        return ((Float)this.rowRecord[this.columnIndexes[columnIndex]]).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) {
        return (Double)this.rowRecord[this.columnIndexes[columnIndex]];
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        return (Boolean)this.rowRecord[this.columnIndexes[columnIndex]];
    }

    @Override
    public Binary getBinary(int columnIndex) {
        return (Binary)this.rowRecord[this.columnIndexes[columnIndex]];
    }

    @Override
    public String getString(int columnIndex) {
        return ((Binary)this.rowRecord[this.columnIndexes[columnIndex]]).getStringValue();
    }

    @Override
    public TSDataType getDataType(int columnIndex) {
        return this.dataTypes[this.columnIndexes[columnIndex]];
    }

    @Override
    public boolean isNull(int columnIndex) {
        return this.rowRecord[this.columnIndexes[columnIndex]] == null;
    }

    public Row setRowRecord(Object[] rowRecord) {
        this.rowRecord = rowRecord;
        return this;
    }

    @Override
    public int size() {
        return this.columnIndexes.length;
    }
}

