/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.query.udf.api.UDTF;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.collector.PointCollector;
import org.apache.iotdb.db.query.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.db.query.udf.api.exception.UDFException;
import org.apache.iotdb.db.query.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class UDTFMath
implements UDTF {
    protected Transformer transformer;
    protected TSDataType dataType;

    @Override
    public void validate(UDFParameterValidator validator) throws UDFException {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws MetadataException {
        this.dataType = parameters.getDataType(0);
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(TSDataType.DOUBLE);
        this.setTransformer();
    }

    protected abstract void setTransformer();

    @Override
    public void transform(Row row, PointCollector collector) throws UDFInputSeriesDataTypeNotValidException, IOException {
        long time = row.getTime();
        switch (this.dataType) {
            case INT32: {
                collector.putDouble(time, this.transformer.transform(row.getInt(0)));
                break;
            }
            case INT64: {
                collector.putDouble(time, this.transformer.transform(row.getLong(0)));
                break;
            }
            case FLOAT: {
                collector.putDouble(time, this.transformer.transform(row.getFloat(0)));
                break;
            }
            case DOUBLE: {
                collector.putDouble(time, this.transformer.transform(row.getDouble(0)));
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, this.dataType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
            }
        }
    }

    protected static interface Transformer {
        public double transform(double var1);
    }
}

