/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor.fill;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.query.UnSupportedFillTypeException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.impl.FirstValueAggrResult;
import org.apache.iotdb.db.query.aggregation.impl.MinTimeAggrResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.executor.AggregationExecutor;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.db.query.executor.fill.LastPointReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class LinearFill
extends IFill {
    protected PartialPath seriesPath;
    protected long beforeRange;
    protected long afterRange;
    protected Filter beforeFilter;
    protected Filter afterFilter;
    protected QueryContext context;
    protected Set<String> deviceMeasurements;

    public LinearFill(long beforeRange, long afterRange) {
        this.beforeRange = beforeRange;
        this.afterRange = afterRange;
    }

    public LinearFill(TSDataType dataType, long queryTime, long beforeRange, long afterRange) {
        super(dataType, queryTime);
        this.beforeRange = beforeRange;
        this.afterRange = afterRange;
    }

    public long getBeforeRange() {
        return this.beforeRange;
    }

    public void setBeforeRange(long beforeRange) {
        this.beforeRange = beforeRange;
    }

    public long getAfterRange() {
        return this.afterRange;
    }

    public void setAfterRange(long afterRange) {
        this.afterRange = afterRange;
    }

    @Override
    public IFill copy() {
        return new LinearFill(this.dataType, this.queryTime, this.beforeRange, this.afterRange);
    }

    @Override
    void constructFilter() {
        TimeFilter.TimeGtEq lowerBound = this.beforeRange == -1L ? TimeFilter.gtEq((long)Long.MIN_VALUE) : TimeFilter.gtEq((long)(this.queryTime - this.beforeRange));
        TimeFilter.TimeLtEq upperBound = this.afterRange == -1L ? TimeFilter.ltEq((long)Long.MAX_VALUE) : TimeFilter.ltEq((long)(this.queryTime + this.afterRange));
        this.beforeFilter = FilterFactory.and((Filter)lowerBound, (Filter)TimeFilter.ltEq((long)this.queryTime));
        this.afterFilter = FilterFactory.and((Filter)TimeFilter.gtEq((long)this.queryTime), (Filter)upperBound);
    }

    @Override
    public void configureFill(PartialPath path, TSDataType dataType, long queryTime, Set<String> sensors, QueryContext context) {
        this.seriesPath = path;
        this.dataType = dataType;
        this.queryTime = queryTime;
        this.context = context;
        this.deviceMeasurements = sensors;
        this.constructFilter();
    }

    @Override
    public TimeValuePair getFillResult() throws IOException, QueryProcessException, StorageEngineException {
        TimeValuePair beforePair = this.calculatePrecedingPoint();
        TimeValuePair afterPair = this.calculateSucceedingPoint();
        if (beforePair.getValue() == null || beforePair.getTimestamp() == this.queryTime) {
            beforePair.setTimestamp(this.queryTime);
            return beforePair;
        }
        if (afterPair.getValue() == null || afterPair.getTimestamp() < this.queryTime || this.afterRange != -1L && afterPair.getTimestamp() > this.queryTime + this.afterRange) {
            return new TimeValuePair(this.queryTime, null);
        }
        return this.average(beforePair, afterPair);
    }

    protected TimeValuePair calculatePrecedingPoint() throws QueryProcessException, StorageEngineException, IOException {
        QueryDataSource dataSource = QueryResourceManager.getInstance().getQueryDataSource(this.seriesPath, this.context, this.beforeFilter);
        LastPointReader lastReader = new LastPointReader(this.seriesPath, this.dataType, this.deviceMeasurements, this.context, dataSource, this.queryTime, this.beforeFilter);
        return lastReader.readLastPoint();
    }

    protected TimeValuePair calculateSucceedingPoint() throws IOException, StorageEngineException, QueryProcessException {
        ArrayList<AggregateResult> aggregateResultList = new ArrayList<AggregateResult>();
        MinTimeAggrResult minTimeResult = new MinTimeAggrResult();
        FirstValueAggrResult firstValueResult = new FirstValueAggrResult(this.dataType);
        aggregateResultList.add(minTimeResult);
        aggregateResultList.add(firstValueResult);
        AggregationExecutor.aggregateOneSeries(this.seriesPath, this.deviceMeasurements, this.context, this.afterFilter, this.dataType, aggregateResultList, null, null);
        return this.convertToResult(minTimeResult, firstValueResult);
    }

    protected TimeValuePair convertToResult(AggregateResult minTimeResult, AggregateResult firstValueResult) {
        TimeValuePair result = new TimeValuePair(0L, null);
        if (minTimeResult.getResult() != null) {
            long timestamp = (Long)minTimeResult.getResult();
            result.setTimestamp(timestamp);
        }
        if (firstValueResult.getResult() != null) {
            Object value = firstValueResult.getResult();
            result.setValue(TsPrimitiveType.getByType((TSDataType)this.dataType, (Object)value));
        }
        return result;
    }

    private TimeValuePair average(TimeValuePair beforePair, TimeValuePair afterPair) throws UnSupportedFillTypeException {
        double totalTimeLength = (double)afterPair.getTimestamp() - (double)beforePair.getTimestamp();
        double beforeTimeLength = this.queryTime - beforePair.getTimestamp();
        switch (this.dataType) {
            case INT32: {
                int startIntValue = beforePair.getValue().getInt();
                int endIntValue = afterPair.getValue().getInt();
                int fillIntValue = startIntValue + (int)((double)(endIntValue - startIntValue) / totalTimeLength * beforeTimeLength);
                beforePair.setValue(TsPrimitiveType.getByType((TSDataType)TSDataType.INT32, (Object)fillIntValue));
                break;
            }
            case INT64: {
                long startLongValue = beforePair.getValue().getLong();
                long endLongValue = afterPair.getValue().getLong();
                long fillLongValue = startLongValue + (long)((double)(endLongValue - startLongValue) / totalTimeLength * beforeTimeLength);
                beforePair.setValue(TsPrimitiveType.getByType((TSDataType)TSDataType.INT64, (Object)fillLongValue));
                break;
            }
            case FLOAT: {
                float startFloatValue = beforePair.getValue().getFloat();
                float endFloatValue = afterPair.getValue().getFloat();
                float fillFloatValue = startFloatValue + (float)((double)(endFloatValue - startFloatValue) / totalTimeLength * beforeTimeLength);
                beforePair.setValue(TsPrimitiveType.getByType((TSDataType)TSDataType.FLOAT, (Object)Float.valueOf(fillFloatValue)));
                break;
            }
            case DOUBLE: {
                double startDoubleValue = beforePair.getValue().getDouble();
                double endDoubleValue = afterPair.getValue().getDouble();
                double fillDoubleValue = startDoubleValue + (endDoubleValue - startDoubleValue) / totalTimeLength * beforeTimeLength;
                beforePair.setValue(TsPrimitiveType.getByType((TSDataType)TSDataType.DOUBLE, (Object)fillDoubleValue));
                break;
            }
            default: {
                throw new UnSupportedFillTypeException(this.dataType);
            }
        }
        beforePair.setTimestamp(this.queryTime);
        return beforePair;
    }
}

