/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.DirectAlignByTimeDataSet;
import org.apache.iotdb.db.query.dataset.UDTFDataSet;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.db.query.udf.core.reader.LayerPointReader;
import org.apache.iotdb.db.tools.watermark.WatermarkEncoder;
import org.apache.iotdb.db.utils.datastructure.TimeSelector;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class UDTFAlignByTimeDataSet
extends UDTFDataSet
implements DirectAlignByTimeDataSet {
    protected TimeSelector timeHeap;

    public UDTFAlignByTimeDataSet(QueryContext context, UDTFPlan udtfPlan, List<PartialPath> deduplicatedPaths, List<TSDataType> deduplicatedDataTypes, TimeGenerator timestampGenerator, List<IReaderByTimestamp> readersOfSelectedSeries, List<Boolean> cached) throws IOException, QueryProcessException {
        super(context, udtfPlan, deduplicatedPaths, deduplicatedDataTypes, timestampGenerator, readersOfSelectedSeries, cached);
        this.initTimeHeap();
    }

    public UDTFAlignByTimeDataSet(QueryContext context, UDTFPlan udtfPlan, List<PartialPath> deduplicatedPaths, List<TSDataType> deduplicatedDataTypes, List<ManagedSeriesReader> readersOfSelectedSeries) throws QueryProcessException, IOException, InterruptedException {
        super(context, udtfPlan, deduplicatedPaths, deduplicatedDataTypes, readersOfSelectedSeries);
        this.initTimeHeap();
    }

    protected void initTimeHeap() throws IOException, QueryProcessException {
        this.timeHeap = new TimeSelector(this.transformers.length << 1, true);
        for (LayerPointReader reader : this.transformers) {
            if (!reader.next()) continue;
            this.timeHeap.add(reader.currentTime());
        }
    }

    @Override
    public TSQueryDataSet fillBuffer(int fetchSize, WatermarkEncoder encoder) throws IOException, QueryProcessException {
        int remaining;
        TSQueryDataSet tsQueryDataSet = new TSQueryDataSet();
        int columnsNum = this.transformers.length;
        PublicBAOS timeBAOS = new PublicBAOS();
        PublicBAOS[] valueBAOSList = new PublicBAOS[columnsNum];
        PublicBAOS[] bitmapBAOSList = new PublicBAOS[columnsNum];
        for (int i = 0; i < columnsNum; ++i) {
            valueBAOSList[i] = new PublicBAOS();
            bitmapBAOSList[i] = new PublicBAOS();
        }
        int[] currentBitmapList = new int[columnsNum];
        int rowCount = 0;
        while (!(rowCount >= fetchSize || this.rowLimit > 0 && this.alreadyReturnedRowNum >= this.rowLimit || this.timeHeap.isEmpty())) {
            int i;
            long minTime = this.timeHeap.pollFirst();
            if (this.rowOffset == 0) {
                timeBAOS.write(BytesUtils.longToBytes((long)minTime));
            }
            for (i = 0; i < columnsNum; ++i) {
                LayerPointReader reader = this.transformers[i];
                if (!reader.next() || reader.currentTime() != minTime) {
                    if (this.rowOffset != 0) continue;
                    currentBitmapList[i] = currentBitmapList[i] << 1;
                    continue;
                }
                if (this.rowOffset == 0) {
                    currentBitmapList[i] = currentBitmapList[i] << 1 | 1;
                    TSDataType type = reader.getDataType();
                    switch (type) {
                        case INT32: {
                            int intValue = reader.currentInt();
                            ReadWriteIOUtils.write((int)(encoder != null && encoder.needEncode(minTime) ? encoder.encodeInt(intValue, minTime) : intValue), (OutputStream)valueBAOSList[i]);
                            break;
                        }
                        case INT64: {
                            long longValue = reader.currentLong();
                            ReadWriteIOUtils.write((long)(encoder != null && encoder.needEncode(minTime) ? encoder.encodeLong(longValue, minTime) : longValue), (OutputStream)valueBAOSList[i]);
                            break;
                        }
                        case FLOAT: {
                            float floatValue = reader.currentFloat();
                            ReadWriteIOUtils.write((float)(encoder != null && encoder.needEncode(minTime) ? encoder.encodeFloat(floatValue, minTime) : floatValue), (OutputStream)valueBAOSList[i]);
                            break;
                        }
                        case DOUBLE: {
                            double doubleValue = reader.currentDouble();
                            ReadWriteIOUtils.write((double)(encoder != null && encoder.needEncode(minTime) ? encoder.encodeDouble(doubleValue, minTime) : doubleValue), (OutputStream)valueBAOSList[i]);
                            break;
                        }
                        case BOOLEAN: {
                            ReadWriteIOUtils.write((Boolean)reader.currentBoolean(), (OutputStream)valueBAOSList[i]);
                            break;
                        }
                        case TEXT: {
                            ReadWriteIOUtils.write((Binary)reader.currentBinary(), (OutputStream)valueBAOSList[i]);
                            break;
                        }
                        default: {
                            throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", type));
                        }
                    }
                }
                reader.readyForNext();
                if (!reader.next()) continue;
                this.timeHeap.add(reader.currentTime());
            }
            if (this.rowOffset == 0) {
                if (++rowCount % 8 == 0) {
                    for (i = 0; i < columnsNum; ++i) {
                        ReadWriteIOUtils.write((byte)((byte)currentBitmapList[i]), (OutputStream)bitmapBAOSList[i]);
                        currentBitmapList[i] = 0;
                    }
                }
                if (this.rowLimit > 0) {
                    ++this.alreadyReturnedRowNum;
                }
            } else {
                --this.rowOffset;
            }
            this.inputLayer.updateRowRecordListEvictionUpperBound();
        }
        if (rowCount > 0 && (remaining = rowCount % 8) != 0) {
            for (int i = 0; i < columnsNum; ++i) {
                ReadWriteIOUtils.write((byte)((byte)(currentBitmapList[i] << 8 - remaining)), (OutputStream)bitmapBAOSList[i]);
            }
        }
        return this.packBuffer(tsQueryDataSet, timeBAOS, valueBAOSList, bitmapBAOSList);
    }

    protected TSQueryDataSet packBuffer(TSQueryDataSet tsQueryDataSet, PublicBAOS timeBAOS, PublicBAOS[] valueBAOSList, PublicBAOS[] bitmapBAOSList) {
        int columnsNum = this.transformers.length;
        ByteBuffer timeBuffer = ByteBuffer.allocate(timeBAOS.size());
        timeBuffer.put(timeBAOS.getBuf(), 0, timeBAOS.size());
        timeBuffer.flip();
        tsQueryDataSet.setTime(timeBuffer);
        ArrayList<ByteBuffer> valueBufferList = new ArrayList<ByteBuffer>();
        ArrayList<ByteBuffer> bitmapBufferList = new ArrayList<ByteBuffer>();
        for (int i = 0; i < columnsNum; ++i) {
            this.putPBOSToBuffer(valueBAOSList, valueBufferList, i);
            this.putPBOSToBuffer(bitmapBAOSList, bitmapBufferList, i);
        }
        tsQueryDataSet.setValueList(valueBufferList);
        tsQueryDataSet.setBitmapList(bitmapBufferList);
        return tsQueryDataSet;
    }

    protected void putPBOSToBuffer(PublicBAOS[] bitmapBAOSList, List<ByteBuffer> bitmapBufferList, int tsIndex) {
        ByteBuffer bitmapBuffer = ByteBuffer.allocate(bitmapBAOSList[tsIndex].size());
        bitmapBuffer.put(bitmapBAOSList[tsIndex].getBuf(), 0, bitmapBAOSList[tsIndex].size());
        bitmapBuffer.flip();
        bitmapBufferList.add(bitmapBuffer);
    }

    public boolean hasNextWithoutConstraint() {
        return !this.timeHeap.isEmpty();
    }

    public RowRecord nextWithoutConstraint() throws IOException {
        long minTime = this.timeHeap.pollFirst();
        RowRecord rowRecord = new RowRecord(minTime);
        try {
            for (LayerPointReader reader : this.transformers) {
                Object value;
                if (!reader.next() || reader.currentTime() != minTime) {
                    rowRecord.addField(null);
                    continue;
                }
                switch (reader.getDataType()) {
                    case INT32: {
                        value = reader.currentInt();
                        break;
                    }
                    case INT64: {
                        value = reader.currentLong();
                        break;
                    }
                    case FLOAT: {
                        value = Float.valueOf(reader.currentFloat());
                        break;
                    }
                    case DOUBLE: {
                        value = reader.currentDouble();
                        break;
                    }
                    case BOOLEAN: {
                        value = reader.currentBoolean();
                        break;
                    }
                    case TEXT: {
                        value = reader.currentBinary();
                        break;
                    }
                    default: {
                        throw new UnSupportedDataTypeException("Unsupported data type.");
                    }
                }
                rowRecord.addField(value, reader.getDataType());
                reader.readyForNext();
                if (!reader.next()) continue;
                this.timeHeap.add(reader.currentTime());
            }
        }
        catch (QueryProcessException e) {
            throw new IOException(e.getMessage());
        }
        this.inputLayer.updateRowRecordListEvictionUpperBound();
        return rowRecord;
    }
}

