/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import org.apache.iotdb.db.query.aggregation.impl.MaxTimeAggrResult;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class MaxTimeDescAggrResult
extends MaxTimeAggrResult {
    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        if (this.hasFinalResult()) {
            return;
        }
        super.updateResultFromStatistics(statistics);
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage, long minBound, long maxBound) {
        if (this.hasFinalResult()) {
            return;
        }
        if (dataInThisPage.hasCurrent() && dataInThisPage.currentTime() < maxBound && dataInThisPage.currentTime() >= minBound) {
            this.updateMaxTimeResult(dataInThisPage.currentTime());
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        int timeLength;
        if (this.hasFinalResult()) {
            return;
        }
        long[] timesForFirstValue = new long[100];
        for (int currentPos = 0; currentPos < length; currentPos += timeLength) {
            timeLength = Math.min(length - currentPos, 100);
            System.arraycopy(timestamps, currentPos, timesForFirstValue, 0, timeLength);
            Object[] values = dataReader.getValuesInTimestamps(timesForFirstValue, timeLength);
            for (int i = 0; i < timeLength; ++i) {
                if (values[i] == null) continue;
                this.updateMaxTimeResult(timesForFirstValue[i]);
                return;
            }
        }
    }

    @Override
    public void updateResultUsingValues(long[] timestamps, int length, Object[] values) {
        if (this.hasFinalResult()) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            this.updateMaxTimeResult(timestamps[i]);
            return;
        }
    }

    @Override
    public boolean hasFinalResult() {
        return this.hasCandidateResult;
    }

    @Override
    public boolean isAscending() {
        return false;
    }
}

