/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.BatchPlan;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.service.rpc.thrift.TSStatus;

public class InsertMultiTabletPlan
extends InsertPlan
implements BatchPlan {
    List<Integer> parentInsertTabletPlanIndexList;
    List<InsertTabletPlan> insertTabletPlanList;
    private Map<Integer, TSStatus> results = new TreeMap<Integer, TSStatus>();
    boolean[] isExecuted;

    public InsertMultiTabletPlan() {
        super(Operator.OperatorType.MULTI_BATCH_INSERT);
        this.insertTabletPlanList = new ArrayList<InsertTabletPlan>();
        this.parentInsertTabletPlanIndexList = new ArrayList<Integer>();
    }

    public InsertMultiTabletPlan(List<InsertTabletPlan> insertTabletPlanList) {
        super(Operator.OperatorType.MULTI_BATCH_INSERT);
        this.insertTabletPlanList = insertTabletPlanList;
        this.parentInsertTabletPlanIndexList = new ArrayList<Integer>();
    }

    public InsertMultiTabletPlan(List<InsertTabletPlan> insertTabletPlanList, List<Integer> parentInsertTabletPlanIndexList) {
        super(Operator.OperatorType.MULTI_BATCH_INSERT);
        this.insertTabletPlanList = insertTabletPlanList;
        this.parentInsertTabletPlanIndexList = parentInsertTabletPlanIndexList;
    }

    public void addInsertTabletPlan(InsertTabletPlan plan, Integer parentIndex) {
        this.insertTabletPlanList.add(plan);
        this.parentInsertTabletPlanIndexList.add(parentIndex);
    }

    @Override
    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        for (InsertTabletPlan insertTabletPlan : this.insertTabletPlanList) {
            result.addAll(insertTabletPlan.getPaths());
        }
        return result;
    }

    @Override
    public long getMinTime() {
        long minTime = Long.MAX_VALUE;
        for (InsertTabletPlan insertTabletPlan : this.insertTabletPlanList) {
            if (minTime <= insertTabletPlan.getMinTime()) continue;
            minTime = insertTabletPlan.getMinTime();
        }
        return minTime;
    }

    public long getMaxTime() {
        long maxTime = Long.MIN_VALUE;
        for (InsertTabletPlan insertTabletPlan : this.insertTabletPlanList) {
            if (maxTime >= insertTabletPlan.getMaxTime()) continue;
            maxTime = insertTabletPlan.getMaxTime();
        }
        return maxTime;
    }

    public int getTabletsSize() {
        return this.insertTabletPlanList.size();
    }

    @Override
    public Map<Integer, TSStatus> getResults() {
        return this.results;
    }

    public int getTotalRowCount() {
        int rowCount = 0;
        for (InsertTabletPlan insertTabletPlan : this.insertTabletPlanList) {
            rowCount += insertTabletPlan.getRowCount();
        }
        return rowCount;
    }

    public int getRowCount(int index) {
        if (index >= this.insertTabletPlanList.size() || index < 0) {
            return 0;
        }
        return this.insertTabletPlanList.get(index).getRowCount();
    }

    public PartialPath getFirstDeviceId() {
        return this.insertTabletPlanList.get(0).getDeviceId();
    }

    public InsertTabletPlan getInsertTabletPlan(int index) {
        if (index >= this.insertTabletPlanList.size() || index < 0) {
            return null;
        }
        return this.insertTabletPlanList.get(index);
    }

    public int getParentIndex(int index) {
        if (index >= this.parentInsertTabletPlanIndexList.size() || index < 0) {
            return -1;
        }
        return this.parentInsertTabletPlanIndexList.get(index);
    }

    @Override
    public void checkIntegrity() throws QueryProcessException {
        if (this.insertTabletPlanList.isEmpty()) {
            throw new QueryProcessException("sub tablet is empty.");
        }
        for (InsertTabletPlan insertTabletPlan : this.insertTabletPlanList) {
            insertTabletPlan.checkIntegrity();
        }
    }

    public void setParentInsertTabletPlanIndexList(List<Integer> parentInsertTabletPlanIndexList) {
        this.parentInsertTabletPlanIndexList = parentInsertTabletPlanIndexList;
    }

    public List<Integer> getParentInsertTabletPlanIndexList() {
        return this.parentInsertTabletPlanIndexList;
    }

    public void setInsertTabletPlanList(List<InsertTabletPlan> insertTabletPlanList) {
        this.insertTabletPlanList = insertTabletPlanList;
    }

    public List<InsertTabletPlan> getInsertTabletPlanList() {
        return this.insertTabletPlanList;
    }

    public void setResults(Map<Integer, TSStatus> results) {
        this.results = results;
    }

    @Override
    public void recoverFromFailure() {
        for (InsertTabletPlan insertTabletPlan : this.insertTabletPlanList) {
            insertTabletPlan.recoverFromFailure();
        }
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.MULTI_BATCH_INSERT.ordinal();
        buffer.put((byte)type);
        buffer.putInt(this.insertTabletPlanList.size());
        for (InsertTabletPlan insertTabletPlan : this.insertTabletPlanList) {
            insertTabletPlan.subSerialize(buffer);
        }
        buffer.putInt(this.parentInsertTabletPlanIndexList.size());
        for (Integer index : this.parentInsertTabletPlanIndexList) {
            buffer.putInt(index);
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.MULTI_BATCH_INSERT.ordinal();
        stream.writeByte((byte)type);
        stream.writeInt(this.insertTabletPlanList.size());
        for (InsertTabletPlan insertTabletPlan : this.insertTabletPlanList) {
            insertTabletPlan.subSerialize(stream);
        }
        stream.writeInt(this.parentInsertTabletPlanIndexList.size());
        for (Integer index : this.parentInsertTabletPlanIndexList) {
            stream.writeInt(index);
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        int tmpInsertTabletPlanListSize = buffer.getInt();
        this.insertTabletPlanList = new ArrayList<InsertTabletPlan>(tmpInsertTabletPlanListSize);
        for (int i = 0; i < tmpInsertTabletPlanListSize; ++i) {
            InsertTabletPlan tmpPlan = new InsertTabletPlan();
            tmpPlan.deserialize(buffer);
            this.insertTabletPlanList.add(tmpPlan);
        }
        int tmpParentInsetTablePlanIndexListSize = buffer.getInt();
        this.parentInsertTabletPlanIndexList = new ArrayList<Integer>(tmpParentInsetTablePlanIndexListSize);
        for (int i = 0; i < tmpParentInsetTablePlanIndexListSize; ++i) {
            this.parentInsertTabletPlanIndexList.add(buffer.getInt());
        }
    }

    @Override
    public void setIndex(long index) {
        super.setIndex(index);
        for (InsertTabletPlan insertTabletPlan : this.insertTabletPlanList) {
            insertTabletPlan.setIndex(index);
        }
    }

    public String toString() {
        return "InsertMultiTabletPlan{ insertTabletPlanList=" + this.insertTabletPlanList + ", parentInsetTablePlanIndexList=" + this.parentInsertTabletPlanIndexList + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertMultiTabletPlan that = (InsertMultiTabletPlan)o;
        if (!Objects.equals(this.insertTabletPlanList, that.insertTabletPlanList)) {
            return false;
        }
        return Objects.equals(this.parentInsertTabletPlanIndexList, that.parentInsertTabletPlanIndexList);
    }

    public int hashCode() {
        int result = this.insertTabletPlanList != null ? this.insertTabletPlanList.hashCode() : 0;
        result = 31 * result + (this.parentInsertTabletPlanIndexList != null ? this.parentInsertTabletPlanIndexList.hashCode() : 0);
        return result;
    }

    @Override
    public void setIsExecuted(int i) {
        if (this.isExecuted == null) {
            this.isExecuted = new boolean[this.getBatchSize()];
        }
        this.isExecuted[i] = true;
    }

    @Override
    public boolean isExecuted(int i) {
        if (this.isExecuted == null) {
            this.isExecuted = new boolean[this.getBatchSize()];
        }
        return this.isExecuted[i];
    }

    @Override
    public int getBatchSize() {
        return this.insertTabletPlanList.size();
    }

    @Override
    public void unsetIsExecuted(int i) {
        if (this.isExecuted == null) {
            this.isExecuted = new boolean[this.getBatchSize()];
        }
        this.isExecuted[i] = false;
        if (this.parentInsertTabletPlanIndexList != null && !this.parentInsertTabletPlanIndexList.isEmpty()) {
            this.results.remove(this.getParentIndex(i));
        } else {
            this.results.remove(i);
        }
    }
}

