/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup.timeindex;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.timeindex.ITimeIndex;
import org.apache.iotdb.db.exception.PartitionViolationException;
import org.apache.iotdb.db.rescon.CachedStringPool;
import org.apache.iotdb.db.utils.FilePathUtils;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DeviceTimeIndex
implements ITimeIndex {
    public static final int INIT_ARRAY_SIZE = 64;
    protected static final Map<String, String> cachedDevicePool = CachedStringPool.getInstance().getCachedPool();
    protected long[] startTimes;
    protected long[] endTimes;
    protected Map<String, Integer> deviceToIndex;

    public DeviceTimeIndex() {
        this.deviceToIndex = new ConcurrentHashMap<String, Integer>();
        this.startTimes = new long[64];
        this.endTimes = new long[64];
        this.initTimes(this.startTimes, Long.MAX_VALUE);
        this.initTimes(this.endTimes, Long.MIN_VALUE);
    }

    public DeviceTimeIndex(int deviceNumInLastClosedTsFile) {
        this.deviceToIndex = new ConcurrentHashMap<String, Integer>();
        this.startTimes = new long[deviceNumInLastClosedTsFile];
        this.endTimes = new long[deviceNumInLastClosedTsFile];
        this.initTimes(this.startTimes, Long.MAX_VALUE);
        this.initTimes(this.endTimes, Long.MIN_VALUE);
    }

    public DeviceTimeIndex(Map<String, Integer> deviceToIndex, long[] startTimes, long[] endTimes) {
        this.startTimes = startTimes;
        this.endTimes = endTimes;
        this.deviceToIndex = deviceToIndex;
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        int deviceNum = this.deviceToIndex.size();
        ReadWriteIOUtils.write((int)deviceNum, (OutputStream)outputStream);
        for (int i = 0; i < deviceNum; ++i) {
            ReadWriteIOUtils.write((long)this.startTimes[i], (OutputStream)outputStream);
            ReadWriteIOUtils.write((long)this.endTimes[i], (OutputStream)outputStream);
        }
        ConcurrentHashMap<String, Integer> stringMemoryReducedMap = new ConcurrentHashMap<String, Integer>();
        for (Map.Entry<String, Integer> stringIntegerEntry : this.deviceToIndex.entrySet()) {
            String deviceName = stringIntegerEntry.getKey();
            int index = stringIntegerEntry.getValue();
            stringMemoryReducedMap.put(cachedDevicePool.computeIfAbsent(deviceName, k -> k), index);
            ReadWriteIOUtils.write((String)deviceName, (OutputStream)outputStream);
            ReadWriteIOUtils.write((int)index, (OutputStream)outputStream);
        }
        this.deviceToIndex = stringMemoryReducedMap;
    }

    @Override
    public DeviceTimeIndex deserialize(InputStream inputStream) throws IOException {
        int i;
        int deviceNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
        ConcurrentHashMap<String, Integer> deviceMap = new ConcurrentHashMap<String, Integer>();
        long[] startTimesArray = new long[deviceNum];
        long[] endTimesArray = new long[deviceNum];
        for (i = 0; i < deviceNum; ++i) {
            startTimesArray[i] = ReadWriteIOUtils.readLong((InputStream)inputStream);
            endTimesArray[i] = ReadWriteIOUtils.readLong((InputStream)inputStream);
        }
        for (i = 0; i < deviceNum; ++i) {
            String path = ReadWriteIOUtils.readString((InputStream)inputStream);
            String cachedPath = cachedDevicePool.computeIfAbsent(path, k -> k);
            int index = ReadWriteIOUtils.readInt((InputStream)inputStream);
            deviceMap.put(cachedPath, index);
        }
        return new DeviceTimeIndex(deviceMap, startTimesArray, endTimesArray);
    }

    @Override
    public DeviceTimeIndex deserialize(ByteBuffer buffer) {
        int i;
        int deviceNum = buffer.getInt();
        ConcurrentHashMap<String, Integer> deviceMap = new ConcurrentHashMap<String, Integer>(deviceNum);
        long[] startTimesArray = new long[deviceNum];
        long[] endTimesArray = new long[deviceNum];
        for (i = 0; i < deviceNum; ++i) {
            startTimesArray[i] = buffer.getLong();
            endTimesArray[i] = buffer.getLong();
        }
        for (i = 0; i < deviceNum; ++i) {
            String path = SerializeUtils.deserializeString(buffer);
            String cachedPath = cachedDevicePool.computeIfAbsent(path, k -> k);
            int index = buffer.getInt();
            deviceMap.put(cachedPath, index);
        }
        return new DeviceTimeIndex(deviceMap, startTimesArray, endTimesArray);
    }

    @Override
    public void close() {
        this.startTimes = Arrays.copyOfRange(this.startTimes, 0, this.deviceToIndex.size());
        this.endTimes = Arrays.copyOfRange(this.endTimes, 0, this.deviceToIndex.size());
    }

    @Override
    public Set<String> getDevices() {
        return this.deviceToIndex.keySet();
    }

    @Override
    public boolean endTimeEmpty() {
        for (long endTime : this.endTimes) {
            if (endTime == Long.MIN_VALUE) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean stillLives(long timeLowerBound) {
        if (timeLowerBound == Long.MAX_VALUE) {
            return true;
        }
        for (long endTime : this.endTimes) {
            if (endTime < timeLowerBound) continue;
            return true;
        }
        return false;
    }

    @Override
    public long calculateRamSize() {
        return RamUsageEstimator.sizeOf(this.deviceToIndex) + RamUsageEstimator.sizeOf((long[])this.startTimes) + RamUsageEstimator.sizeOf((long[])this.endTimes);
    }

    private int getDeviceIndex(String deviceId) {
        int index;
        if (this.deviceToIndex.containsKey(deviceId)) {
            index = this.deviceToIndex.get(deviceId);
        } else {
            index = this.deviceToIndex.size();
            this.deviceToIndex.put(deviceId, index);
            if (this.startTimes.length <= index) {
                this.startTimes = this.enLargeArray(this.startTimes, Long.MAX_VALUE);
                this.endTimes = this.enLargeArray(this.endTimes, Long.MIN_VALUE);
            }
        }
        return index;
    }

    private void initTimes(long[] times, long defaultTime) {
        Arrays.fill(times, defaultTime);
    }

    private long[] enLargeArray(long[] array, long defaultValue) {
        long[] tmp = new long[array.length * 2];
        this.initTimes(tmp, defaultValue);
        System.arraycopy(array, 0, tmp, 0, array.length);
        return tmp;
    }

    @Override
    public long getTimePartition(String tsFilePath) {
        try {
            if (this.deviceToIndex != null && !this.deviceToIndex.isEmpty()) {
                return StorageEngine.getTimePartition(this.startTimes[this.deviceToIndex.values().iterator().next()]);
            }
            String[] filePathSplits = FilePathUtils.splitTsFilePath(tsFilePath);
            return Long.parseLong(filePathSplits[filePathSplits.length - 2]);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private long getTimePartitionWithCheck() {
        long partitionId = -1L;
        for (int index : this.deviceToIndex.values()) {
            long p = StorageEngine.getTimePartition(this.startTimes[index]);
            if (partitionId == -1L) {
                partitionId = p;
            } else if (partitionId != p) {
                return -1L;
            }
            if (partitionId == (p = StorageEngine.getTimePartition(this.endTimes[index]))) continue;
            return -1L;
        }
        return partitionId;
    }

    @Override
    public long getTimePartitionWithCheck(String tsFilePath) throws PartitionViolationException {
        long partitionId = this.getTimePartitionWithCheck();
        if (partitionId == -1L) {
            throw new PartitionViolationException(tsFilePath);
        }
        return partitionId;
    }

    @Override
    public boolean isSpanMultiTimePartitions() {
        long partitionId = this.getTimePartitionWithCheck();
        return partitionId == -1L;
    }

    @Override
    public void updateStartTime(String deviceId, long time) {
        long startTime = this.getStartTime(deviceId);
        if (time < startTime) {
            int index = this.getDeviceIndex(deviceId);
            this.startTimes[index] = time;
        }
    }

    @Override
    public void updateEndTime(String deviceId, long time) {
        long endTime = this.getEndTime(deviceId);
        if (time > endTime) {
            int index = this.getDeviceIndex(deviceId);
            this.endTimes[index] = time;
        }
    }

    @Override
    public void putStartTime(String deviceId, long time) {
        int index = this.getDeviceIndex(deviceId);
        this.startTimes[index] = time;
    }

    @Override
    public void putEndTime(String deviceId, long time) {
        int index = this.getDeviceIndex(deviceId);
        this.endTimes[index] = time;
    }

    @Override
    public long getStartTime(String deviceId) {
        if (!this.deviceToIndex.containsKey(deviceId)) {
            return Long.MAX_VALUE;
        }
        return this.startTimes[this.deviceToIndex.get(deviceId)];
    }

    @Override
    public long getEndTime(String deviceId) {
        if (!this.deviceToIndex.containsKey(deviceId)) {
            return Long.MIN_VALUE;
        }
        return this.endTimes[this.deviceToIndex.get(deviceId)];
    }
}

