/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.modification;

import java.util.Objects;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.metadata.PartialPath;

public class Deletion
extends Modification {
    private long startTime;
    private long endTime;

    public Deletion(PartialPath path, long fileOffset, long endTime) {
        super(Modification.Type.DELETION, path, fileOffset);
        this.startTime = Long.MIN_VALUE;
        this.endTime = endTime;
    }

    public Deletion(PartialPath path, long fileOffset, long startTime, long endTime) {
        super(Modification.Type.DELETION, path, fileOffset);
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long timestamp) {
        this.startTime = timestamp;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long timestamp) {
        this.endTime = timestamp;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Deletion)) {
            return false;
        }
        Deletion del = (Deletion)obj;
        return super.equals(obj) && del.startTime == this.startTime && del.endTime == this.endTime;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.startTime, this.endTime);
    }

    public String toString() {
        return "Deletion{startTime=" + this.startTime + ", endTime=" + this.endTime + ", type=" + (Object)((Object)this.type) + ", path=" + this.path + ", fileOffset=" + this.fileOffset + '}';
    }
}

