/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.client;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.jcip.annotations.Immutable;

@Immutable
public class ClientReadRequest
extends ProtectedResourceRequest {
    public ClientReadRequest(URI uri, BearerAccessToken accessToken) {
        super(uri, accessToken);
        if (accessToken == null) {
            throw new IllegalArgumentException("The access token must not be null");
        }
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        URL endpointURL;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        try {
            endpointURL = this.getEndpointURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new SerializeException(e.getMessage(), e);
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.GET, endpointURL);
        httpRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        return httpRequest;
    }

    public static ClientReadRequest parse(HTTPRequest httpRequest) throws ParseException {
        URI endpointURI;
        httpRequest.ensureMethod(HTTPRequest.Method.GET);
        BearerAccessToken accessToken = BearerAccessToken.parse(httpRequest.getAuthorization());
        try {
            endpointURI = httpRequest.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), e);
        }
        return new ClientReadRequest(endpointURI, accessToken);
    }
}

