/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.concurrent.WrappedRunnable;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.metrics.server.MetricsSystem;
import org.apache.iotdb.db.metrics.server.ServerArgument;
import org.apache.iotdb.db.metrics.ui.MetricsWebUI;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.JMXService;
import org.apache.iotdb.db.service.MetricsServiceMBean;
import org.apache.iotdb.db.service.ServiceType;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsService
implements MetricsServiceMBean,
IService {
    private static final Logger logger = LoggerFactory.getLogger(MetricsService.class);
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", this.getID().getJmxName());
    private Server server;
    private ExecutorService executorService;

    private MetricsService() {
    }

    public static MetricsService getInstance() {
        return MetricsServiceHolder.INSTANCE;
    }

    @Override
    public ServiceType getID() {
        return ServiceType.METRICS_SERVICE;
    }

    @Override
    public int getMetricsPort() {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        return config.getMetricsPort();
    }

    @Override
    public void start() throws StartupException {
        try {
            JMXService.registerMBean(MetricsService.getInstance(), this.mbeanName);
            this.startService();
        }
        catch (Exception e) {
            logger.error("Failed to start {} because: ", (Object)this.getID().getName(), (Object)e);
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    @Override
    public void stop() {
        this.stopService();
        JMXService.deregisterMBean(this.mbeanName);
    }

    @Override
    public synchronized void startService() {
        if (!IoTDBDescriptor.getInstance().getConfig().isEnableMetricService()) {
            return;
        }
        logger.info("{}: start {}...", (Object)"IoTDB", (Object)this.getID().getName());
        this.executorService = IoTDBThreadPoolFactory.newSingleThreadExecutor("DeprecatedMetricsWeb");
        int port = this.getMetricsPort();
        MetricsSystem metricsSystem = new MetricsSystem(new ServerArgument(port));
        MetricsWebUI metricsWebUI = new MetricsWebUI(metricsSystem.getMetricRegistry());
        metricsWebUI.getHandlers().add(metricsSystem.getServletHandlers());
        metricsWebUI.initialize();
        this.server = metricsWebUI.getServer(port);
        this.server.setStopTimeout(10000L);
        metricsSystem.start();
        try {
            this.executorService.execute(new MetricsServiceThread(this.server));
            logger.info("{}: start {} successfully, listening on ip {} port {}", new Object[]{"IoTDB", this.getID().getName(), IoTDBDescriptor.getInstance().getConfig().getRpcAddress(), IoTDBDescriptor.getInstance().getConfig().getMetricsPort()});
        }
        catch (NullPointerException e) {
            logger.error("{}: start {} failed, listening on ip {} port {}", new Object[]{"IoTDB", this.getID().getName(), IoTDBDescriptor.getInstance().getConfig().getRpcAddress(), IoTDBDescriptor.getInstance().getConfig().getMetricsPort()});
            this.stopService();
        }
    }

    @Override
    public void restartService() {
        this.stopService();
        this.startService();
    }

    @Override
    public void stopService() {
        logger.info("{}: closing {}...", (Object)"IoTDB", (Object)this.getID().getName());
        try {
            if (this.server != null) {
                this.server.stop();
                this.server = null;
            }
            if (this.executorService != null) {
                this.executorService.shutdown();
                if (!this.executorService.awaitTermination(3000L, TimeUnit.MILLISECONDS)) {
                    this.executorService.shutdownNow();
                }
                this.executorService = null;
            }
        }
        catch (Exception e) {
            logger.error("{}: close {} failed because {}", new Object[]{"IoTDB", this.getID().getName(), e});
            this.executorService.shutdownNow();
        }
        this.checkAndWaitPortIsClosed();
        logger.info("{}: close {} successfully", (Object)"IoTDB", (Object)this.getID().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void checkAndWaitPortIsClosed() {
        InetSocketAddress socketAddress = new InetSocketAddress("localhost", this.getMetricsPort());
        Socket socket = new Socket();
        int timeout = 1;
        int count = 10000;
        while (count > 0) {
            socket.connect(socketAddress, timeout);
            --count;
            try {
                socket.close();
            }
            catch (IOException iOException) {}
            continue;
            catch (IOException e) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
                catch (Throwable throwable) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        logger.error("Port {} can not be closed.", (Object)this.getMetricsPort());
    }

    private class MetricsServiceThread
    extends WrappedRunnable {
        private Server server;

        public MetricsServiceThread(Server server) {
            this.server = server;
        }

        @Override
        public void runMayThrow() {
            try {
                Thread.currentThread().setName(ThreadName.METRICS_SERVICE.getName());
                this.server.start();
                this.server.join();
            }
            catch (InterruptedException e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
            }
            catch (Exception e) {
                logger.error("{}: failed to start {}, because ", new Object[]{"IoTDB", MetricsService.this.getID().getName(), e});
            }
        }
    }

    private static class MetricsServiceHolder {
        private static final MetricsService INSTANCE = new MetricsService();

        private MetricsServiceHolder() {
        }
    }
}

