/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.rescon;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimitiveArrayManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrimitiveArrayManager.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    public static final int ARRAY_SIZE = CONFIG.getPrimitiveArraySize();
    private static final double AMPLIFICATION_FACTOR = 1.5;
    private static final double POOLED_ARRAYS_MEMORY_THRESHOLD = (double)CONFIG.getAllocateMemoryForWrite() * CONFIG.getBufferedArraysMemoryProportion() / 1.5;
    private static final ArrayDeque[] POOLED_ARRAYS = new ArrayDeque[TSDataType.values().length];
    private static final int[] LIMITS = new int[TSDataType.values().length];
    private static long limitUpdateThreshold;
    private static final AtomicLong[] ALLOCATION_REQUEST_COUNTS;
    private static final AtomicLong TOTAL_ALLOCATION_REQUEST_COUNT;

    private static void init() {
        LOGGER.info("BufferedArraySizeThreshold is {}", (Object)POOLED_ARRAYS_MEMORY_THRESHOLD);
        int totalDataTypeSize = 0;
        for (TSDataType dataType : TSDataType.values()) {
            totalDataTypeSize += dataType.getDataTypeSize();
        }
        double limit = POOLED_ARRAYS_MEMORY_THRESHOLD / (double)ARRAY_SIZE / (double)totalDataTypeSize;
        Arrays.fill(LIMITS, (int)limit);
        limitUpdateThreshold = (long)((double)TSDataType.values().length * limit);
        for (int i = 0; i < POOLED_ARRAYS.length; ++i) {
            PrimitiveArrayManager.POOLED_ARRAYS[i] = new ArrayDeque((int)limit);
        }
        for (AtomicLong allocationRequestCount : ALLOCATION_REQUEST_COUNTS) {
            allocationRequestCount.set(0L);
        }
        TOTAL_ALLOCATION_REQUEST_COUNT.set(0L);
    }

    private PrimitiveArrayManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object allocate(TSDataType dataType) {
        Object array;
        if (TOTAL_ALLOCATION_REQUEST_COUNT.get() > limitUpdateThreshold) {
            AtomicLong atomicLong = TOTAL_ALLOCATION_REQUEST_COUNT;
            synchronized (atomicLong) {
                if (TOTAL_ALLOCATION_REQUEST_COUNT.get() > limitUpdateThreshold) {
                    PrimitiveArrayManager.updateLimits();
                }
            }
        }
        byte order = dataType.serialize();
        ALLOCATION_REQUEST_COUNTS[order].incrementAndGet();
        TOTAL_ALLOCATION_REQUEST_COUNT.incrementAndGet();
        ArrayDeque arrayDeque = POOLED_ARRAYS[order];
        synchronized (arrayDeque) {
            array = POOLED_ARRAYS[order].poll();
        }
        if (array == null) {
            array = PrimitiveArrayManager.createPrimitiveArray(dataType);
        }
        return array;
    }

    private static void updateLimits() {
        double[] ratios = new double[ALLOCATION_REQUEST_COUNTS.length];
        for (int i = 0; i < ALLOCATION_REQUEST_COUNTS.length; ++i) {
            ratios[i] = (double)ALLOCATION_REQUEST_COUNTS[i].get() / (double)TOTAL_ALLOCATION_REQUEST_COUNT.get();
        }
        double weightedSumOfRatios = 0.0;
        for (TSDataType dataType : TSDataType.values()) {
            weightedSumOfRatios += (double)dataType.getDataTypeSize() * ratios[dataType.serialize()];
        }
        double limitBase = POOLED_ARRAYS_MEMORY_THRESHOLD / (double)ARRAY_SIZE / weightedSumOfRatios;
        for (int i = 0; i < LIMITS.length; ++i) {
            int n;
            int oldLimit = LIMITS[i];
            PrimitiveArrayManager.LIMITS[i] = n = (int)(limitBase * ratios[i]);
            if (!LOGGER.isInfoEnabled() || oldLimit == n) continue;
            LOGGER.info("limit of {} array deque size updated: {} -> {}", new Object[]{TSDataType.deserialize((byte)((byte)i)).name(), oldLimit, n});
        }
        long oldLimitUpdateThreshold = limitUpdateThreshold;
        limitUpdateThreshold = 0L;
        for (int limit : LIMITS) {
            limitUpdateThreshold += (long)limit;
        }
        LOGGER.info("limitUpdateThreshold of PrimitiveArrayManager updated: {} -> {}", (Object)oldLimitUpdateThreshold, (Object)limitUpdateThreshold);
        for (AtomicLong allocationRequestCount : ALLOCATION_REQUEST_COUNTS) {
            allocationRequestCount.set(0L);
        }
        TOTAL_ALLOCATION_REQUEST_COUNT.set(0L);
    }

    private static Object createPrimitiveArray(TSDataType dataType) {
        Object[] dataArray;
        switch (dataType) {
            case BOOLEAN: {
                dataArray = new boolean[ARRAY_SIZE];
                break;
            }
            case INT32: {
                dataArray = new int[ARRAY_SIZE];
                break;
            }
            case INT64: {
                dataArray = new long[ARRAY_SIZE];
                break;
            }
            case FLOAT: {
                dataArray = new float[ARRAY_SIZE];
                break;
            }
            case DOUBLE: {
                dataArray = new double[ARRAY_SIZE];
                break;
            }
            case TEXT: {
                dataArray = new Binary[ARRAY_SIZE];
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(dataType.name());
            }
        }
        return dataArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(Object array) {
        byte order;
        if (array instanceof boolean[]) {
            order = TSDataType.BOOLEAN.serialize();
        } else if (array instanceof int[]) {
            order = TSDataType.INT32.serialize();
        } else if (array instanceof long[]) {
            order = TSDataType.INT64.serialize();
        } else if (array instanceof float[]) {
            order = TSDataType.FLOAT.serialize();
        } else if (array instanceof double[]) {
            order = TSDataType.DOUBLE.serialize();
        } else if (array instanceof Binary[]) {
            Arrays.fill((Binary[])array, null);
            order = TSDataType.TEXT.serialize();
        } else {
            throw new UnSupportedDataTypeException(array.getClass().toString());
        }
        ArrayDeque arrayDeque = POOLED_ARRAYS[order];
        synchronized (arrayDeque) {
            ArrayDeque arrays = POOLED_ARRAYS[order];
            if (arrays.size() < LIMITS[order]) {
                arrays.add(array);
            }
        }
    }

    public static void close() {
        PrimitiveArrayManager.init();
    }

    public static Object createDataListsByType(TSDataType dataType, int size) {
        int arrayNumber = (int)Math.ceil((float)size / (float)ARRAY_SIZE);
        switch (dataType) {
            case BOOLEAN: {
                boolean[][] booleans = new boolean[arrayNumber][];
                for (int i = 0; i < arrayNumber; ++i) {
                    booleans[i] = new boolean[ARRAY_SIZE];
                }
                return booleans;
            }
            case INT32: {
                int[][] ints = new int[arrayNumber][];
                for (int i = 0; i < arrayNumber; ++i) {
                    ints[i] = new int[ARRAY_SIZE];
                }
                return ints;
            }
            case INT64: {
                long[][] longs = new long[arrayNumber][];
                for (int i = 0; i < arrayNumber; ++i) {
                    longs[i] = new long[ARRAY_SIZE];
                }
                return longs;
            }
            case FLOAT: {
                float[][] floats = new float[arrayNumber][];
                for (int i = 0; i < arrayNumber; ++i) {
                    floats[i] = new float[ARRAY_SIZE];
                }
                return floats;
            }
            case DOUBLE: {
                double[][] doubles = new double[arrayNumber][];
                for (int i = 0; i < arrayNumber; ++i) {
                    doubles[i] = new double[ARRAY_SIZE];
                }
                return doubles;
            }
            case TEXT: {
                Binary[][] binaries = new Binary[arrayNumber][];
                for (int i = 0; i < arrayNumber; ++i) {
                    binaries[i] = new Binary[ARRAY_SIZE];
                }
                return binaries;
            }
        }
        throw new UnSupportedDataTypeException(dataType.name());
    }

    static {
        ALLOCATION_REQUEST_COUNTS = new AtomicLong[]{new AtomicLong(0L), new AtomicLong(0L), new AtomicLong(0L), new AtomicLong(0L), new AtomicLong(0L), new AtomicLong(0L)};
        TOTAL_ALLOCATION_REQUEST_COUNT = new AtomicLong(0L);
        PrimitiveArrayManager.init();
    }
}

