/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.service;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;

public class UDFClassLoader
extends URLClassLoader {
    private final String libRoot;
    private final AtomicLong activeQueriesCount;
    private volatile boolean deprecated;

    UDFClassLoader(String libRoot) throws IOException {
        super(new URL[0]);
        this.libRoot = libRoot;
        this.activeQueriesCount = new AtomicLong(0L);
        this.deprecated = false;
        this.addURLs();
    }

    private void addURLs() throws IOException {
        URL[] urls;
        HashSet fileSet = new HashSet(FileUtils.listFiles((File)SystemFileFactory.INSTANCE.getFile(this.libRoot), null, (boolean)true));
        for (URL url : urls = FileUtils.toURLs((File[])fileSet.toArray(new File[0]))) {
            super.addURL(url);
        }
    }

    public void acquire() {
        this.activeQueriesCount.incrementAndGet();
    }

    public void release() throws IOException {
        this.activeQueriesCount.decrementAndGet();
        this.closeIfPossible();
    }

    public void markAsDeprecated() throws IOException {
        this.deprecated = true;
        this.closeIfPossible();
    }

    public void closeIfPossible() throws IOException {
        if (this.deprecated && this.activeQueriesCount.get() == 0L) {
            this.close();
        }
    }
}

