/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.input;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.dataset.RawQueryDataSetWithValueFilter;
import org.apache.iotdb.db.query.dataset.RawQueryDataSetWithoutValueFilter;
import org.apache.iotdb.db.query.dataset.UDFInputDataSet;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.access.RowWindow;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.db.query.udf.core.access.RowImpl;
import org.apache.iotdb.db.query.udf.core.access.RowWindowImpl;
import org.apache.iotdb.db.query.udf.core.input.SafetyLine;
import org.apache.iotdb.db.query.udf.core.reader.LayerPointReader;
import org.apache.iotdb.db.query.udf.core.reader.LayerRowReader;
import org.apache.iotdb.db.query.udf.core.reader.LayerRowWindowReader;
import org.apache.iotdb.db.query.udf.datastructure.primitive.ElasticSerializableIntList;
import org.apache.iotdb.db.query.udf.datastructure.primitive.IntList;
import org.apache.iotdb.db.query.udf.datastructure.primitive.SerializableIntList;
import org.apache.iotdb.db.query.udf.datastructure.primitive.WrappedIntArray;
import org.apache.iotdb.db.query.udf.datastructure.row.ElasticSerializableRowRecordList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.iotdb.tsfile.utils.Binary;

public class InputLayer {
    private long queryId;
    private UDFInputDataSet queryDataSet;
    private TSDataType[] dataTypes;
    private int timestampIndex;
    private ElasticSerializableRowRecordList rowRecordList;
    private SafetyLine safetyLine;

    public InputLayer(long queryId, float memoryBudgetInMB, List<PartialPath> paths, List<TSDataType> dataTypes, List<ManagedSeriesReader> readers) throws QueryProcessException, IOException, InterruptedException {
        this.constructInputLayer(queryId, memoryBudgetInMB, new RawQueryDataSetWithoutValueFilter(queryId, paths, dataTypes, readers, true));
    }

    public InputLayer(long queryId, float memoryBudgetInMB, List<PartialPath> paths, List<TSDataType> dataTypes, TimeGenerator timeGenerator, List<IReaderByTimestamp> readers, List<Boolean> cached) throws QueryProcessException {
        this.constructInputLayer(queryId, memoryBudgetInMB, new RawQueryDataSetWithValueFilter(paths, dataTypes, timeGenerator, readers, cached, true));
    }

    private void constructInputLayer(long queryId, float memoryBudgetInMB, UDFInputDataSet queryDataSet) throws QueryProcessException {
        this.queryId = queryId;
        this.queryDataSet = queryDataSet;
        this.dataTypes = queryDataSet.getDataTypes().toArray(new TSDataType[0]);
        this.timestampIndex = this.dataTypes.length;
        this.rowRecordList = new ElasticSerializableRowRecordList(this.dataTypes, queryId, memoryBudgetInMB, 1 + this.dataTypes.length / 2);
        this.safetyLine = new SafetyLine();
    }

    public void updateRowRecordListEvictionUpperBound() {
        this.rowRecordList.setEvictionUpperBound(this.safetyLine.getSafetyLine());
    }

    public LayerPointReader constructPointReader(int columnIndex) {
        return new InputLayerPointReader(columnIndex);
    }

    public LayerRowReader constructRowReader(int[] columnIndexes) {
        return new InputLayerRowReader(columnIndexes);
    }

    public LayerRowWindowReader constructRowWindowReader(int[] columnIndexes, AccessStrategy strategy, float memoryBudgetInMB) throws QueryProcessException, IOException {
        switch (strategy.getAccessStrategyType()) {
            case SLIDING_TIME_WINDOW: {
                return new InputLayerRowSlidingTimeWindowReader(columnIndexes, (SlidingTimeWindowAccessStrategy)strategy, memoryBudgetInMB);
            }
            case SLIDING_SIZE_WINDOW: {
                return new InputLayerRowSlidingSizeWindowReader(columnIndexes, (SlidingSizeWindowAccessStrategy)strategy, memoryBudgetInMB);
            }
        }
        throw new IllegalStateException("Unexpected access strategy: " + (Object)((Object)strategy.getAccessStrategyType()));
    }

    private static boolean hasNotNullSelectedFields(Object[] rowRecordCandidate, int[] columnIndexes) {
        for (int columnIndex : columnIndexes) {
            if (rowRecordCandidate[columnIndex] == null) continue;
            return true;
        }
        return false;
    }

    private class InputLayerRowSlidingTimeWindowReader
    implements LayerRowWindowReader {
        private final SafetyLine.SafetyPile safetyPile;
        private final int[] columnIndexes;
        private final TSDataType[] columnDataTypes;
        private final long timeInterval;
        private final long slidingStep;
        private final long displayWindowEnd;
        private final IntList rowIndexes;
        private final RowWindowImpl rowWindow;
        private long nextWindowTimeBegin;
        private int nextIndexBegin;
        private final boolean hasAtLeastOneRow;

        private InputLayerRowSlidingTimeWindowReader(int[] columnIndexes, SlidingTimeWindowAccessStrategy accessStrategy, float memoryBudgetInMB) throws QueryProcessException, IOException {
            this.safetyPile = InputLayer.this.safetyLine.addSafetyPile();
            this.columnIndexes = columnIndexes;
            this.columnDataTypes = new TSDataType[columnIndexes.length];
            for (int i = 0; i < columnIndexes.length; ++i) {
                this.columnDataTypes[i] = InputLayer.this.dataTypes[columnIndexes[i]];
            }
            this.timeInterval = accessStrategy.getTimeInterval();
            this.slidingStep = accessStrategy.getSlidingStep();
            this.displayWindowEnd = accessStrategy.getDisplayWindowEnd();
            this.rowIndexes = new ElasticSerializableIntList(InputLayer.this.queryId, memoryBudgetInMB, 2);
            this.rowWindow = new RowWindowImpl(InputLayer.this.rowRecordList, columnIndexes, InputLayer.this.dataTypes, this.rowIndexes);
            this.nextWindowTimeBegin = accessStrategy.getDisplayWindowBegin();
            this.nextIndexBegin = 0;
            if (InputLayer.this.rowRecordList.size() == 0 && InputLayer.this.queryDataSet.hasNextRowInObjects()) {
                InputLayer.this.rowRecordList.put(InputLayer.this.queryDataSet.nextRowInObjects());
                if (this.nextWindowTimeBegin == Long.MIN_VALUE) {
                    this.nextWindowTimeBegin = InputLayer.this.rowRecordList.getTime(0);
                }
            }
            this.hasAtLeastOneRow = InputLayer.this.rowRecordList.size() != 0;
        }

        @Override
        public boolean next() throws IOException, QueryProcessException {
            Object[] rowRecordCandidate;
            int i;
            if (this.displayWindowEnd <= this.nextWindowTimeBegin) {
                return false;
            }
            if (!this.hasAtLeastOneRow || 0 < this.rowIndexes.size()) {
                return true;
            }
            long nextWindowTimeEnd = Math.min(this.nextWindowTimeBegin + this.timeInterval, this.displayWindowEnd);
            int oldRowRecordListSize = InputLayer.this.rowRecordList.size();
            while ((Long)InputLayer.this.rowRecordList.getRowRecord(InputLayer.this.rowRecordList.size() - 1)[InputLayer.this.timestampIndex] < nextWindowTimeEnd) {
                if (InputLayer.this.queryDataSet.hasNextRowInObjects()) {
                    InputLayer.this.rowRecordList.put(InputLayer.this.queryDataSet.nextRowInObjects());
                    continue;
                }
                if (this.displayWindowEnd != Long.MAX_VALUE || oldRowRecordListSize != InputLayer.this.rowRecordList.size()) break;
                return false;
            }
            for (i = this.nextIndexBegin; i < InputLayer.this.rowRecordList.size(); ++i) {
                if (this.nextWindowTimeBegin <= (Long)InputLayer.this.rowRecordList.getRowRecord(i)[InputLayer.this.timestampIndex]) {
                    this.nextIndexBegin = i;
                    break;
                }
                if (i != InputLayer.this.rowRecordList.size() - 1) continue;
                this.nextIndexBegin = InputLayer.this.rowRecordList.size();
            }
            for (i = this.nextIndexBegin; i < InputLayer.this.rowRecordList.size() && nextWindowTimeEnd > (Long)(rowRecordCandidate = InputLayer.this.rowRecordList.getRowRecord(i))[InputLayer.this.timestampIndex]; ++i) {
                if (!InputLayer.hasNotNullSelectedFields(rowRecordCandidate, this.columnIndexes)) continue;
                this.rowIndexes.put(i);
            }
            return true;
        }

        @Override
        public void readyForNext() {
            this.nextWindowTimeBegin += this.slidingStep;
            this.safetyPile.moveForwardTo(this.nextIndexBegin);
            this.rowIndexes.clear();
        }

        @Override
        public TSDataType[] getDataTypes() {
            return this.columnDataTypes;
        }

        @Override
        public RowWindow currentWindow() {
            return this.rowWindow;
        }
    }

    private class InputLayerRowSlidingSizeWindowReader
    implements LayerRowWindowReader {
        private final SafetyLine.SafetyPile safetyPile;
        private final int[] columnIndexes;
        private final TSDataType[] columnDataTypes;
        private final int windowSize;
        private final IntList rowIndexes;
        private final RowWindowImpl rowWindow;
        private final int slidingStep;
        private int maxIndexInLastWindow;

        private InputLayerRowSlidingSizeWindowReader(int[] columnIndexes, SlidingSizeWindowAccessStrategy accessStrategy, float memoryBudgetInMB) throws QueryProcessException {
            this.safetyPile = InputLayer.this.safetyLine.addSafetyPile();
            this.columnIndexes = columnIndexes;
            this.columnDataTypes = new TSDataType[columnIndexes.length];
            for (int i = 0; i < columnIndexes.length; ++i) {
                this.columnDataTypes[i] = InputLayer.this.dataTypes[columnIndexes[i]];
            }
            this.windowSize = accessStrategy.getWindowSize();
            this.rowIndexes = this.windowSize < SerializableIntList.calculateCapacity(memoryBudgetInMB) ? new WrappedIntArray(this.windowSize) : new ElasticSerializableIntList(InputLayer.this.queryId, memoryBudgetInMB, 2);
            this.rowWindow = new RowWindowImpl(InputLayer.this.rowRecordList, columnIndexes, InputLayer.this.dataTypes, this.rowIndexes);
            this.slidingStep = accessStrategy.getSlidingStep();
            this.maxIndexInLastWindow = -1;
        }

        @Override
        public boolean next() throws IOException, QueryProcessException {
            if (0 < this.rowIndexes.size()) {
                return true;
            }
            int count = 0;
            for (int i = this.maxIndexInLastWindow + 1; i < InputLayer.this.rowRecordList.size(); ++i) {
                if (!InputLayer.hasNotNullSelectedFields(InputLayer.this.rowRecordList.getRowRecord(i), this.columnIndexes)) continue;
                this.rowIndexes.put(i);
                if (++count != this.windowSize) continue;
                return true;
            }
            while (InputLayer.this.queryDataSet.hasNextRowInObjects()) {
                Object[] rowRecordCandidate = InputLayer.this.queryDataSet.nextRowInObjects();
                InputLayer.this.rowRecordList.put(rowRecordCandidate);
                if (!InputLayer.hasNotNullSelectedFields(rowRecordCandidate, this.columnIndexes)) continue;
                this.rowIndexes.put(InputLayer.this.rowRecordList.size() - 1);
                if (++count != this.windowSize) continue;
                return true;
            }
            return count != 0;
        }

        @Override
        public void readyForNext() throws IOException, QueryProcessException {
            this.updateMaxIndexForLastWindow();
            this.safetyPile.moveForwardTo(this.maxIndexInLastWindow + 1);
            this.rowIndexes.clear();
        }

        private void updateMaxIndexForLastWindow() throws IOException, QueryProcessException {
            if (this.rowIndexes.size() == 0) {
                return;
            }
            if (this.slidingStep <= this.rowIndexes.size()) {
                this.maxIndexInLastWindow = this.rowIndexes.get(this.slidingStep - 1);
                return;
            }
            int currentStep = this.rowIndexes.size() - 1;
            for (int i = this.rowIndexes.get(this.rowIndexes.size() - 1) + 1; i < InputLayer.this.rowRecordList.size(); ++i) {
                if (!InputLayer.hasNotNullSelectedFields(InputLayer.this.rowRecordList.getRowRecord(i), this.columnIndexes) || ++currentStep != this.slidingStep) continue;
                this.maxIndexInLastWindow = i - 1;
                return;
            }
            while (InputLayer.this.queryDataSet.hasNextRowInObjects()) {
                Object[] rowRecordCandidate = InputLayer.this.queryDataSet.nextRowInObjects();
                InputLayer.this.rowRecordList.put(rowRecordCandidate);
                if (!InputLayer.hasNotNullSelectedFields(rowRecordCandidate, this.columnIndexes) || ++currentStep != this.slidingStep) continue;
                this.maxIndexInLastWindow = InputLayer.this.rowRecordList.size() - 2;
                return;
            }
            this.maxIndexInLastWindow = InputLayer.this.rowRecordList.size() - 1;
        }

        @Override
        public TSDataType[] getDataTypes() {
            return this.columnDataTypes;
        }

        @Override
        public RowWindow currentWindow() {
            return this.rowWindow;
        }
    }

    private class InputLayerRowReader
    implements LayerRowReader {
        private final SafetyLine.SafetyPile safetyPile;
        private final int[] columnIndexes;
        private int currentRowIndex;
        private boolean hasCachedRowRecord;
        private Object[] cachedRowRecord;
        private final RowImpl row;

        public InputLayerRowReader(int[] columnIndexes) {
            this.safetyPile = InputLayer.this.safetyLine.addSafetyPile();
            this.columnIndexes = columnIndexes;
            this.currentRowIndex = -1;
            this.hasCachedRowRecord = false;
            this.cachedRowRecord = null;
            this.row = new RowImpl(columnIndexes, InputLayer.this.dataTypes);
        }

        @Override
        public boolean next() throws IOException, QueryProcessException {
            if (this.hasCachedRowRecord) {
                return true;
            }
            for (int i = this.currentRowIndex + 1; i < InputLayer.this.rowRecordList.size(); ++i) {
                Object[] rowRecordCandidate = InputLayer.this.rowRecordList.getRowRecord(i);
                if (!InputLayer.hasNotNullSelectedFields(rowRecordCandidate, this.columnIndexes)) continue;
                this.hasCachedRowRecord = true;
                this.cachedRowRecord = rowRecordCandidate;
                this.currentRowIndex = i;
                break;
            }
            if (!this.hasCachedRowRecord) {
                while (InputLayer.this.queryDataSet.hasNextRowInObjects()) {
                    Object[] rowRecordCandidate = InputLayer.this.queryDataSet.nextRowInObjects();
                    InputLayer.this.rowRecordList.put(rowRecordCandidate);
                    if (!InputLayer.hasNotNullSelectedFields(rowRecordCandidate, this.columnIndexes)) continue;
                    this.hasCachedRowRecord = true;
                    this.cachedRowRecord = rowRecordCandidate;
                    this.currentRowIndex = InputLayer.this.rowRecordList.size() - 1;
                    break;
                }
            }
            return this.hasCachedRowRecord;
        }

        @Override
        public void readyForNext() {
            this.hasCachedRowRecord = false;
            this.cachedRowRecord = null;
            this.safetyPile.moveForwardTo(this.currentRowIndex + 1);
        }

        @Override
        public TSDataType[] getDataTypes() {
            return InputLayer.this.dataTypes;
        }

        @Override
        public long currentTime() {
            return (Long)this.cachedRowRecord[InputLayer.this.timestampIndex];
        }

        @Override
        public Row currentRow() {
            return this.row.setRowRecord(this.cachedRowRecord);
        }
    }

    private class InputLayerPointReader
    implements LayerPointReader {
        private final SafetyLine.SafetyPile safetyPile;
        private final int columnIndex;
        private int currentRowIndex;
        private boolean hasCachedRowRecord;
        private Object[] cachedRowRecord;

        InputLayerPointReader(int columnIndex) {
            this.safetyPile = InputLayer.this.safetyLine.addSafetyPile();
            this.columnIndex = columnIndex;
            this.currentRowIndex = -1;
            this.hasCachedRowRecord = false;
            this.cachedRowRecord = null;
        }

        @Override
        public boolean next() throws IOException, QueryProcessException {
            if (this.hasCachedRowRecord) {
                return true;
            }
            for (int i = this.currentRowIndex + 1; i < InputLayer.this.rowRecordList.size(); ++i) {
                Object[] rowRecordCandidate = InputLayer.this.rowRecordList.getRowRecord(i);
                if (rowRecordCandidate[this.columnIndex] == null) continue;
                this.hasCachedRowRecord = true;
                this.cachedRowRecord = rowRecordCandidate;
                this.currentRowIndex = i;
                break;
            }
            if (!this.hasCachedRowRecord) {
                while (InputLayer.this.queryDataSet.hasNextRowInObjects()) {
                    Object[] rowRecordCandidate = InputLayer.this.queryDataSet.nextRowInObjects();
                    InputLayer.this.rowRecordList.put(rowRecordCandidate);
                    if (rowRecordCandidate[this.columnIndex] == null) continue;
                    this.hasCachedRowRecord = true;
                    this.cachedRowRecord = rowRecordCandidate;
                    this.currentRowIndex = InputLayer.this.rowRecordList.size() - 1;
                    break;
                }
            }
            return this.hasCachedRowRecord;
        }

        @Override
        public void readyForNext() {
            this.hasCachedRowRecord = false;
            this.cachedRowRecord = null;
            this.safetyPile.moveForwardTo(this.currentRowIndex + 1);
        }

        @Override
        public TSDataType getDataType() {
            return InputLayer.this.dataTypes[this.columnIndex];
        }

        @Override
        public long currentTime() {
            return (Long)this.cachedRowRecord[InputLayer.this.timestampIndex];
        }

        @Override
        public int currentInt() {
            return (Integer)this.cachedRowRecord[this.columnIndex];
        }

        @Override
        public long currentLong() {
            return (Long)this.cachedRowRecord[this.columnIndex];
        }

        @Override
        public float currentFloat() {
            return ((Float)this.cachedRowRecord[this.columnIndex]).floatValue();
        }

        @Override
        public double currentDouble() {
            return (Double)this.cachedRowRecord[this.columnIndex];
        }

        @Override
        public boolean currentBoolean() {
            return (Boolean)this.cachedRowRecord[this.columnIndex];
        }

        @Override
        public Binary currentBinary() {
            return (Binary)this.cachedRowRecord[this.columnIndex];
        }
    }
}

