/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class CountAggrResult
extends AggregateResult {
    public CountAggrResult() {
        super(TSDataType.INT64, AggregationType.COUNT);
        this.reset();
        this.setLongValue(0L);
    }

    @Override
    public Long getResult() {
        return this.getLongValue();
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        this.setLongValue(this.getLongValue() + statistics.getCount());
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage) {
        this.setLongValue(this.getLongValue() + (long)dataInThisPage.length());
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage, long minBound, long maxBound) {
        int cnt = 0;
        while (dataInThisPage.hasCurrent() && dataInThisPage.currentTime() < maxBound && dataInThisPage.currentTime() >= minBound) {
            ++cnt;
            dataInThisPage.next();
        }
        this.setLongValue(this.getLongValue() + (long)cnt);
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        int cnt = 0;
        Object[] values = dataReader.getValuesInTimestamps(timestamps, length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            ++cnt;
        }
        this.setLongValue(this.getLongValue() + (long)cnt);
    }

    @Override
    public void updateResultUsingValues(long[] timestamps, int length, Object[] values) {
        int cnt = 0;
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            ++cnt;
        }
        this.setLongValue(this.getLongValue() + (long)cnt);
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void merge(AggregateResult another) {
        CountAggrResult anotherCount = (CountAggrResult)another;
        this.setLongValue(anotherCount.getResult() + this.getResult());
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) {
    }
}

