/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.index.common.IndexType;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class DropIndexPlan
extends PhysicalPlan {
    protected List<PartialPath> paths;
    private IndexType indexType;

    public DropIndexPlan() {
        super(false, Operator.OperatorType.DROP_INDEX);
    }

    public DropIndexPlan(List<PartialPath> paths, IndexType indexType) {
        super(false, Operator.OperatorType.DROP_INDEX);
        this.paths = paths;
        this.indexType = indexType;
    }

    @Override
    public void setPaths(List<PartialPath> paths) {
        this.paths = paths;
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.paths;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public void setIndexType(IndexType indexType) {
        this.indexType = indexType;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.DROP_INDEX.ordinal());
        stream.write((byte)this.indexType.serialize());
        stream.writeInt(this.paths.size());
        for (PartialPath path : this.paths) {
            this.putString(stream, path.getFullPath());
        }
        stream.writeLong(this.index);
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.DROP_INDEX.ordinal();
        buffer.put((byte)type);
        buffer.put((byte)this.indexType.serialize());
        buffer.putInt(this.paths.size());
        for (PartialPath path : this.paths) {
            this.putString(buffer, path.getFullPath());
        }
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.indexType = IndexType.deserialize(buffer.get());
        int pathNum = buffer.getInt();
        this.paths = new ArrayList<PartialPath>();
        for (int i = 0; i < pathNum; ++i) {
            this.paths.add(new PartialPath(this.readString(buffer)));
        }
        this.index = buffer.getLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropIndexPlan that = (DropIndexPlan)o;
        return Objects.equals(this.paths, that.paths) && Objects.equals((Object)this.indexType, (Object)that.indexType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paths, this.indexType});
    }

    public String toString() {
        return String.format("paths: %s, index type: %s", new Object[]{this.paths, this.indexType});
    }
}

