/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.concurrent.threadpool;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.concurrent.IoTThreadFactory;
import org.apache.iotdb.db.concurrent.threadpool.WrappedThreadPoolExecutorMBean;
import org.apache.iotdb.db.service.JMXService;

public class WrappedThreadPoolExecutor
extends ThreadPoolExecutor
implements WrappedThreadPoolExecutorMBean {
    private final String mbeanName;

    public WrappedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, String mbeanName) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.threadpool", "type", mbeanName);
        JMXService.registerMBean(this, this.mbeanName);
    }

    public WrappedThreadPoolExecutor(int minWorkerThreads, int maxWorkerThreads, int stopTimeoutVal, TimeUnit stopTimeoutUnit, SynchronousQueue<Runnable> executorQueue, IoTThreadFactory ioTThreadFactory, String mbeanName) {
        super(minWorkerThreads, maxWorkerThreads, (long)stopTimeoutVal, stopTimeoutUnit, executorQueue, ioTThreadFactory);
        this.mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.threadpool", "type", mbeanName);
        JMXService.registerMBean(this, this.mbeanName);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        JMXService.deregisterMBean(this.mbeanName);
    }

    @Override
    public List<Runnable> shutdownNow() {
        JMXService.deregisterMBean(this.mbeanName);
        return super.shutdownNow();
    }

    @Override
    public int getQueueLength() {
        return this.getQueue().size();
    }
}

